/*
 * Decompiled with CFR 0.152.
 */
package neoe.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import neoe.util.Base64;
import neoe.util.Etc;
import neoe.util.FileUtil;
import neoe.util.Log;

public class UrlUtil {
    private boolean inline;
    public String enc = "UTF-8";
    String url;
    boolean useProxy;
    public boolean readContent = true;
    public byte[] ba;
    Proxy proxy;
    Map reqHeader = new LinkedHashMap();
    public Map respHeader;
    int retry;
    public int MAX_TRY = 10;
    public int code;
    private byte[] raw;
    public static final byte[] emptyBA = new byte[0];
    final String ENC = "UTF8";
    String RN = "\r\n";
    static final int M4 = 1679616;
    Map params = new HashMap();
    Map files = new HashMap();

    public static UrlUtil create() {
        return new UrlUtil();
    }

    public UrlUtil inline() {
        this.inline = true;
        return this;
    }

    public UrlUtil addHeader(Map map) {
        this.reqHeader.putAll(map);
        return this;
    }

    public void setProxy(String string, int n, String string2) {
        if (string == null) {
            this.useProxy = false;
            return;
        }
        this.useProxy = true;
        this.proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(string, n));
        if (string2 != null) {
            this.reqHeader.put("Proxy-Authorization", "Basic " + Base64.encodeBytes(string2.getBytes()));
        }
    }

    public UrlUtil setAgentFirefox() {
        this.reqHeader.put("User-Agent", "Mozilla/5.0 (X11; Linux x86_64; rv:125.0) Gecko/20100101 Firefox/125.0");
        return this;
    }

    public UrlUtil download(String string) throws Exception {
        this.url = string;
        this.run();
        return this;
    }

    public String getPage() throws Exception {
        if (this.ba == null) {
            return "not downloaded";
        }
        return new String(this.ba, this.enc);
    }

    public void savePage(String string) throws Exception {
        if (this.ba == null) {
            Log.log("[W]no content for url[" + this.url + "] to " + string);
            return;
        }
        FileUtil.save(this.ba, string);
        Log.log(String.format("[D]save %d bytes for url[%s] to %s", this.ba.length, this.url, string));
    }

    public UrlUtil setRaw(byte[] byArray) {
        this.raw = byArray;
        return this;
    }

    public void run() throws Exception {
        Object object;
        Object object22;
        HttpURLConnection httpURLConnection;
        this.ba = emptyBA;
        this.retry = 0;
        ++this.retry;
        if (this.retry > this.MAX_TRY) {
            return;
        }
        if (this.inline && this.params.size() > 0) {
            this.url = this.url + "?" + this.getDataUrlencode();
        }
        URL uRL = new URL(this.url);
        if (this.useProxy) {
            Log.log(String.format("[D]connect to %s via [%s]", this.url, this.proxy));
            httpURLConnection = (HttpURLConnection)uRL.openConnection(this.proxy);
        } else {
            Log.log(String.format("[D]connect to %s", this.url));
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        }
        if (this.hasPostData() || this.hasPostDataFile() || this.inline) {
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
        }
        for (Object object22 : this.reqHeader.keySet()) {
            httpURLConnection.setRequestProperty((String)object22, this.reqHeader.get(object22).toString());
        }
        if (this.hasPostDataFile()) {
            this.postDataMultipart(httpURLConnection);
        } else if (this.hasPostData()) {
            if (!this.inline && this.params.size() > 0) {
                this.postDataUrlencode(httpURLConnection.getOutputStream());
            } else if (this.raw != null) {
                httpURLConnection.getOutputStream().write(this.raw);
            }
        }
        boolean bl = false;
        object22 = null;
        try {
            this.code = httpURLConnection.getResponseCode();
            this.respHeader = httpURLConnection.getHeaderFields();
            if (this.readContent) {
                object = new ByteArrayOutputStream();
                FileUtil.copy(httpURLConnection.getInputStream(), (OutputStream)object);
                this.ba = ((ByteArrayOutputStream)object).toByteArray();
                int n = this.ba.length;
                Object v = this.respHeader.get("Content-Encoding");
                if (v == null) {
                    v = this.respHeader.get("content-encoding");
                }
                if (v != null && v.toString().toLowerCase().indexOf("gzip") >= 0) {
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(this.ba));
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    FileUtil.copy(gZIPInputStream, byteArrayOutputStream);
                    this.ba = byteArrayOutputStream.toByteArray();
                    int n2 = this.ba.length;
                    Log.log(String.format("[D]extract gzip %d bytes -> %d bytes", n, n2));
                }
                Log.log(String.format("[D]downloaded %s(%d bytes)", this.url, this.ba.length));
            }
        }
        catch (Exception exception) {
            bl = true;
            object22 = exception;
        }
        if (bl) {
            Log.log("found error:" + object22);
            object = "" + object22;
            if (((String)object).indexOf("java.io.FileNotFoundException") >= 0) {
                Log.log("should be 404, skip");
                return;
            }
            throw new RuntimeException("panic", (Throwable)object22);
        }
    }

    private String getDataUrlencode() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        this.params.forEach((object, object2) -> {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            try {
                stringBuilder.append(URLEncoder.encode(object.toString(), this.enc));
                stringBuilder.append("=");
                stringBuilder.append(URLEncoder.encode(object2.toString(), this.enc));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        });
        return stringBuilder.toString();
    }

    private void postDataUrlencode(OutputStream outputStream) throws IOException {
        String string = this.getDataUrlencode();
        Log.log(string);
        outputStream.write(string.getBytes(this.enc));
    }

    private void postDataMultipart(URLConnection uRLConnection) throws IOException {
        String string = null;
        for (int i = 0; i < 5 && (this.foundBoundaryInParams(string = UrlUtil.genBoundary()) || this.foundBoundaryInFiles(string)); ++i) {
            string = null;
        }
        if (string == null) {
            Etc.panic("failed to generate boundary");
        }
        uRLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string);
        OutputStream outputStream = uRLConnection.getOutputStream();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string;
        this.params.forEach((object, object2) -> {
            stringBuilder.append("--").append(string2).append(this.RN);
            stringBuilder.append("Content-Disposition: form-data; name=\"").append(object).append("\"").append(this.RN).append(this.RN);
            stringBuilder.append(object2).append(this.RN);
        });
        this.output(outputStream, stringBuilder);
        this.files.forEach((object, object2) -> {
            Object[] objectArray = (Object[])object2;
            stringBuilder.append("--").append(string2).append(this.RN);
            stringBuilder.append("Content-Disposition: form-data; name=\"").append(object).append("\"; filename=\"").append(objectArray[0]).append("\"").append(this.RN).append(this.RN);
            try {
                this.output(outputStream, stringBuilder);
                outputStream.write((byte[])objectArray[1]);
                outputStream.write(this.RN.getBytes());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        });
        stringBuilder.append("--").append(string2).append("--").append(this.RN);
        this.output(outputStream, stringBuilder);
    }

    private void output(OutputStream outputStream, StringBuilder stringBuilder) {
        try {
            outputStream.write(stringBuilder.toString().getBytes("UTF8"));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        stringBuilder.setLength(0);
    }

    private boolean foundBoundaryInFiles(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF8");
        for (Object k : this.files.keySet()) {
            Object[] objectArray = (Object[])this.files.get(k);
            byte[] byArray2 = (byte[])objectArray[1];
            if (UrlUtil.indexOf(byArray2, byArray) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean foundBoundaryInParams(String string) {
        for (Object k : this.params.keySet()) {
            String string2 = (String)this.params.get(k);
            if (string2.indexOf(string) < 0) continue;
            return true;
        }
        return false;
    }

    private static String genBoundary() {
        return Integer.toString((int)(System.currentTimeMillis() % 1679616L), 36) + "_" + Integer.toString(Etc.rand.nextInt(1679616), 36);
    }

    private boolean hasPostDataFile() {
        return !this.files.isEmpty();
    }

    private boolean hasPostData() {
        return !this.params.isEmpty() || !this.files.isEmpty() || this.raw != null;
    }

    public UrlUtil addFile(String string, String string2, byte[] byArray) {
        this.files.put(string, new Object[]{string2, byArray});
        return this;
    }

    public UrlUtil addParam(String string, String string2) {
        this.params.put(string, string2);
        return this;
    }

    public UrlUtil addParams(Map map) {
        this.params.putAll(map);
        return this;
    }

    public static int indexOf(byte[] byArray, byte[] byArray2) {
        if (byArray2.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < byArray.length - byArray2.length + 1; ++i) {
            for (int j = 0; j < byArray2.length; ++j) {
                if (byArray[i + j] != byArray2[j]) continue block0;
            }
            return i;
        }
        return -1;
    }
}

