/*
 * Decompiled with CFR 0.152.
 */
package neoe.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import neoe.util.Log;

public class Template3naz {
    static Map<String, Compiled> cache = new HashMap<String, Compiled>();

    private static Compiled initCache(String string, ByteBuffer byteBuffer) throws IOException {
        String string2 = StandardCharsets.UTF_8.decode(byteBuffer).toString();
        Compiled compiled = Compiled.compile(string2);
        compiled.lastModified = -1L;
        cache.put(string, compiled);
        return compiled;
    }

    private static Compiled findInCache(String string) {
        Compiled compiled = cache.get(string);
        return compiled;
    }

    public static String render(String string, ByteBuffer byteBuffer, Map map) {
        Compiled compiled = Template3naz.findInCache(string);
        if (compiled == null) {
            try {
                compiled = Template3naz.initCache(string, byteBuffer);
            }
            catch (IOException iOException) {
                Log.log("Template3.render():" + iOException);
            }
        }
        if (compiled == null) {
            return null;
        }
        return compiled.resolve(map);
    }

    public static class Compiled {
        public long lastModified;
        List<Part> list = new ArrayList<Part>();

        public static Compiled compile(String string) {
            Compiled compiled = new Compiled();
            int n = 0;
            int n2 = string.indexOf("${", n);
            while (true) {
                if (n2 < 0) break;
                String string2 = Compiled.readName(string, n2 + 2);
                compiled.addText(string.substring(n, n2));
                compiled.addValue(string2);
                n = n2 + 3 + string2.length();
                n2 = string.indexOf("${", n);
            }
            compiled.addText(string.substring(n));
            n = string.length();
            return compiled;
        }

        private static String readName(String string, int n) {
            int n2 = string.indexOf(125, n);
            if (n2 < 0) {
                throw new RuntimeException("template2 error");
            }
            return string.substring(n, n2);
        }

        public String resolve(Map<Object, Object> map) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Part part : this.list) {
                Object object;
                if (part.type == Part.Type.TEXT) {
                    stringBuilder.append(part.v);
                    continue;
                }
                if (part.type != Part.Type.VALUE || map == null || (object = map.get(part.v)) == null) continue;
                stringBuilder.append(object.toString());
            }
            return stringBuilder.toString();
        }

        private void addText(String string) {
            if (string == null || string.isEmpty()) {
                return;
            }
            Part part = new Part();
            part.type = Part.Type.TEXT;
            part.v = string;
            this.list.add(part);
        }

        private void addValue(String string) {
            if (string == null || string.isEmpty()) {
                return;
            }
            Part part = new Part();
            part.type = Part.Type.VALUE;
            part.v = string;
            this.list.add(part);
        }

        static class Part {
            Type type;
            String v;

            Part() {
            }

            static enum Type {
                TEXT,
                VALUE;

            }
        }
    }
}

