/*
 * Decompiled with CFR 0.152.
 */
package neoe.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import neoe.util.FileUtil;
import neoe.util.Log;

public class Template2 {
    static Map<String, Compiled> cache = new HashMap<String, Compiled>();

    private static Compiled initCache(String string) throws IOException {
        String string2 = "Page Not Found";
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            string2 = FileUtil.readString(fileInputStream, "utf8");
            ((InputStream)fileInputStream).close();
            Compiled compiled = Compiled.compile(string2);
            compiled.lastModified = file.lastModified();
            cache.put(string, compiled);
            return compiled;
        }
        InputStream inputStream = Template2.class.getClassLoader().getResourceAsStream(string);
        if (inputStream != null) {
            string2 = FileUtil.readString(inputStream, "utf8");
            inputStream.close();
        }
        Compiled compiled = Compiled.compile(string2);
        compiled.lastModified = -1L;
        cache.put(string, compiled);
        return compiled;
    }

    private static Compiled findInCache(final String string) {
        final Compiled compiled = cache.get(string);
        if (compiled != null) {
            if (compiled.lastModified >= 0L) {
                new Thread(){

                    @Override
                    public void run() {
                        File file = new File(string);
                        if (file.exists() && file.isFile() && compiled.lastModified < file.lastModified() - 100L) {
                            cache.remove(string);
                            Log.log("reload template " + string);
                        }
                    }
                }.start();
            }
            return compiled;
        }
        return compiled;
    }

    public static String render(String string, Map<Object, Object> map) {
        Compiled compiled = Template2.findInCache(string);
        if (compiled == null) {
            try {
                compiled = Template2.initCache(string);
            }
            catch (IOException iOException) {
                Log.log("Template2.render():" + iOException);
            }
        }
        if (compiled == null) {
            return null;
        }
        return compiled.resolve(map);
    }

    public static class Compiled {
        public long lastModified;
        List<Part> list = new ArrayList<Part>();

        public static Compiled compile(String string) {
            Compiled compiled = new Compiled();
            Compiled.replace1(compiled, string);
            return compiled;
        }

        private static void replaceLast(Compiled compiled, String string) {
            String string2 = "$ {";
            int n = 0;
            int n2 = string.indexOf(string2, n);
            while (true) {
                if (n2 < 0) break;
                int[] nArray = new int[1];
                String string3 = Compiled.readName(string, n2 + string2.length(), nArray);
                compiled.addText(string.substring(n, n2));
                compiled.addValue(string3);
                n = nArray[0] + 1;
                n2 = string.indexOf(string2, n);
            }
            compiled.addText(string.substring(n));
            n = string.length();
        }

        private static void replace1(Compiled compiled, String string) {
            String string2 = "${";
            int n = 0;
            int n2 = string.indexOf(string2, n);
            while (true) {
                if (n2 < 0) break;
                int[] nArray = new int[1];
                String string3 = Compiled.readName(string, n2 + string2.length(), nArray);
                Compiled.replaceLast(compiled, string.substring(n, n2));
                compiled.addValue(string3);
                n = nArray[0] + 1;
                n2 = string.indexOf(string2, n);
            }
            Compiled.replaceLast(compiled, string.substring(n));
            n = string.length();
        }

        private static String readName(String string, int n, int[] nArray) {
            int n2 = string.indexOf(125, n);
            if (n2 < 0) {
                throw new RuntimeException("template2 error");
            }
            nArray[0] = n2;
            return string.substring(n, n2).trim();
        }

        public String resolve(Map<Object, Object> map) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Part part : this.list) {
                Object object;
                if (part.type == Part.Type.TEXT) {
                    stringBuilder.append(part.v);
                    continue;
                }
                if (part.type != Part.Type.VALUE || map == null || (object = map.get(part.v)) == null) continue;
                stringBuilder.append(object.toString());
            }
            return stringBuilder.toString();
        }

        private void addText(String string) {
            if (string == null || string.isEmpty()) {
                return;
            }
            Part part = new Part();
            part.type = Part.Type.TEXT;
            part.v = string;
            this.list.add(part);
        }

        private void addValue(String string) {
            if (string == null || string.isEmpty()) {
                return;
            }
            Part part = new Part();
            part.type = Part.Type.VALUE;
            part.v = string;
            this.list.add(part);
        }

        static class Part {
            Type type;
            String v;

            Part() {
            }

            static enum Type {
                TEXT,
                VALUE;

            }
        }
    }
}

