/*
 * Decompiled with CFR 0.152.
 */
package neoe.util;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import neoe.util.Etc;

public class NeoeScriptRunner {
    Env env = new Env();
    Object client;
    Class clientClass;
    private Method[] clientMethods;

    public void runOn(List list, Object object, Class clazz) throws Exception {
        this.client = object;
        this.clientClass = clazz;
        this.clientMethods = this.clientClass.getDeclaredMethods();
        for (Object e : list) {
            this.env.put("_", this.eval((List)e));
        }
    }

    private Object eval(Object object) throws Exception {
        if (object instanceof DataList) {
            return object;
        }
        if (!(object instanceof List)) {
            return object;
        }
        List list = (List)object;
        Object object2 = this.eval(list.get(0));
        if (!(object2 instanceof String)) {
            Etc.panic(String.format("stat_0 should be string, but get %s(class:%s)", object2, object2.getClass()));
            return null;
        }
        String string = (String)object2;
        DataList dataList = new DataList(list.subList(1, list.size()));
        if ("list".equals(string)) {
            return dataList;
        }
        return this.invoke(string, dataList);
    }

    private Object invoke(String string, List list) throws Exception {
        try {
            Method method = this.findMethod(string);
            if (method == null) {
                Etc.panic("cannot find implement method of " + string);
                return null;
            }
            Parameter[] parameterArray = method.getParameters();
            int n = 0;
            int n2 = 0;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (parameterArray.length > 0 && parameterArray[0].getType().equals(Env.class)) {
                arrayList.add(this.env);
                n = 1;
            }
            int n3 = parameterArray.length - n;
            int n4 = list.size();
            if (n4 > n3) {
                Etc.panic(String.format("too many params for %s, expect %s, got %s", string, n3, n4));
                return null;
            }
            for (int i = n; i < parameterArray.length; ++i) {
                if (n2 >= n4) {
                    arrayList.add(NeoeScriptRunner.defValue(parameterArray[i].getType()));
                    continue;
                }
                arrayList.add(this.mapping(parameterArray[i].getType(), this.eval(list.get(n2++))));
            }
            System.out.println("[d]invoke " + string + " with " + arrayList + ", type:" + this.dumpTypes(arrayList));
            return method.invoke(this.client, arrayList.toArray());
        }
        catch (Exception exception) {
            throw new RuntimeException("err when call " + string, exception);
        }
    }

    private String dumpTypes(List list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object e : list) {
            stringBuilder.append(e == null ? "NULL" : e.getClass().getSimpleName()).append(",");
        }
        return stringBuilder.toString();
    }

    private Object mapping(Class clazz, Object object) {
        if (this.isNumberType(clazz)) {
            Number number = this.toNumber(object);
            if (clazz == Integer.TYPE) {
                return number.intValue();
            }
            if (clazz == Float.TYPE) {
                return Float.valueOf(number.floatValue());
            }
            return number;
        }
        return object;
    }

    private boolean isNumberType(Class clazz) {
        return Number.class.isAssignableFrom(clazz) || clazz == Integer.TYPE || clazz == Float.TYPE;
    }

    private Number toNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        return new BigDecimal(object.toString());
    }

    private static Object defValue(Class clazz) {
        if (Number.class.isAssignableFrom(clazz)) {
            return 0;
        }
        return null;
    }

    private Method findMethod(String string) {
        for (Method method : this.clientMethods) {
            if (!method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }

    public static class Env
    extends HashMap {
    }

    public static class DataList
    extends ArrayList {
        public DataList() {
        }

        public DataList(List list) {
            super(list);
        }
    }
}

