/*
 * Decompiled with CFR 0.152.
 */
package neoe.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import neoe.util.SideQueue;

public class Log {
    public static String DEFAULT = "neoe";
    public static final Map<String, Log> cache = new HashMap<String, Log>();
    public boolean stdout = false;
    public boolean addTime = true;
    public boolean debug = true;
    private Date now = new Date();
    public File f;
    private SideQueue sq;
    private long ts0;
    public boolean ts;
    public static String defaultLogDir = "/tmp";
    private boolean failed;

    public static synchronized Log getLog(String string) {
        return cache.computeIfAbsent(string, string2 -> new Log(string, "log-" + string + ".log", defaultLogDir));
    }

    public static synchronized Log getLog(String string, String string2) {
        return cache.computeIfAbsent(string, string3 -> new Log(string, "log-" + string + ".log", string2));
    }

    public void close() {
        if (this.sq != null) {
            this.sq.close();
            this.sq = null;
        }
    }

    public void criticalMode() {
        this.sq.intervalMs = 1;
    }

    private Log(final String string, String string2, String string3) {
        try {
            new File(string3).mkdirs();
            this.f = new File(string3, string2);
            System.err.println("Log " + string + ":" + this.f.getAbsolutePath());
            final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd HH:mm:ss:SSS");
            this.sq = new SideQueue(10, new SideQueue.Batch(){

                @Override
                public Object run(List list) throws Exception {
                    PrintWriter printWriter;
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Object e : list) {
                        char c;
                        Object[] objectArray = (Object[])e;
                        Throwable throwable = (Throwable)objectArray[1];
                        String string3 = objectArray[0].toString();
                        long l = (Long)objectArray[2];
                        Log.this.now.setTime(l);
                        if (!Log.this.debug && (string3.startsWith("[d]") || string3.startsWith("[D]"))) continue;
                        if (Log.this.addTime) {
                            stringBuilder.append(simpleDateFormat.format(Log.this.now)).append(" ");
                        }
                        stringBuilder.append(string3);
                        while (stringBuilder.length() > 0 && ((c = stringBuilder.charAt(stringBuilder.length() - 1)) == '\r' || c == '\n')) {
                            stringBuilder.setLength(stringBuilder.length() - 1);
                        }
                        if (throwable == null) {
                            stringBuilder.append("\r\n");
                        } else {
                            stringBuilder.append(", Error:\r\n");
                        }
                        if (throwable == null) continue;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        PrintStream printStream = new PrintStream(byteArrayOutputStream);
                        throwable.printStackTrace(printStream);
                        printStream.close();
                        String string2 = byteArrayOutputStream.toString("utf8");
                        if (!Log.this.stdout) {
                            System.err.println(string2);
                        }
                        stringBuilder.append(string2);
                    }
                    try {
                        printWriter = Log.getPrintWriter(Log.this.f);
                    }
                    catch (Exception exception) {
                        Log.this.failed = true;
                        System.out.println("Log failed, disable it: " + string);
                        return null;
                    }
                    printWriter.write(stringBuilder.toString());
                    printWriter.close();
                    if (Log.this.stdout) {
                        System.out.print(stringBuilder.toString());
                    }
                    return null;
                }
            }, false);
        }
        catch (Exception exception) {
            System.err.println("cannot init log file:" + exception);
        }
    }

    private static synchronized PrintWriter getPrintWriter(File file) throws IOException {
        return new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "utf8"), true);
    }

    public static void logTo(String string, Object object) {
        Log.getLog(string).log0(object);
    }

    public static void logTo(String string, Object object, Throwable throwable) {
        Log.getLog(string).log0(object, throwable);
    }

    public static void log(Object object) {
        Log.getLog(DEFAULT).log0(object);
    }

    public static void log(Object object, Throwable throwable) {
        Log.getLog(DEFAULT).log0(object, throwable);
    }

    public static Log getLog() {
        return Log.getLog(DEFAULT);
    }

    public synchronized void log0(Object object, Throwable throwable) {
        this.logerr(object, throwable);
    }

    public synchronized void logerr(Object object, Throwable throwable) {
        if (this.sq == null || object == null || this.failed) {
            return;
        }
        long l = System.currentTimeMillis();
        if (this.ts) {
            object = String.format("+%,d %s", l - this.ts0, object);
        }
        this.sq.add(new Object[]{object, throwable, l});
    }

    public synchronized void log0(Object object) {
        this.log0(object, null);
    }

    public synchronized void logs0(String string, Object ... objectArray) {
        this.log0(String.format(string, objectArray));
    }

    public static void logs(String string, Object ... objectArray) {
        Log.log(String.format(string, objectArray));
    }

    public static void flush() {
        SideQueue sideQueue = Log.getLog((String)Log.DEFAULT).sq;
        if (sideQueue != null) {
            sideQueue.oneTurn();
        }
    }

    public void flush0() {
        if (this.sq != null) {
            this.sq.oneTurn();
        }
    }

    public static String addrStr(Number number) {
        Object object = String.format("%x", number);
        if (((String)object).length() > 2) {
            object = ((String)object).substring(0, 2) + "xxx";
        }
        return object;
    }

    public void clear() throws IOException {
        new FileOutputStream(this.f).close();
    }

    public static void closeAll() {
        SideQueue.allClosed = true;
    }

    public void begin() {
        this.ts0 = System.currentTimeMillis();
    }
}

