/*
 * Decompiled with CFR 0.152.
 */
package neoe.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import neoe.util.Etc;

public class FileUtil {
    public static void copy(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileUtil.copy(fileInputStream, fileOutputStream);
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray)) > 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        bufferedOutputStream.close();
    }

    public static void copy2(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray)) > 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.flush();
    }

    public static BufferedReader getBufferedReader(String string, String string2) throws IOException {
        InputStream inputStream = FileUtil.getFileInputStream(string);
        return new BufferedReader(new InputStreamReader(inputStream, string2));
    }

    public static InputStream getFileInputStream(String string) {
        System.out.println("getFileInputStream:in " + FileUtil.class.getClassLoader() + ":" + string);
        InputStream inputStream = FileUtil.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            inputStream = string.startsWith("/") ? FileUtil.class.getClassLoader().getResourceAsStream(string.substring(1)) : FileUtil.class.getClassLoader().getResourceAsStream("/" + string);
        }
        return inputStream;
    }

    public static BufferedReader getRawBufferedReader(String string, String string2) throws UnsupportedEncodingException, FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(string);
        return new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string2));
    }

    public static void pass(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    public static void pass(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        int n;
        if (l < 0L) {
            Etc.panic("pass length %d <0", l);
        }
        if (l == 0L) {
            return;
        }
        int n2 = (int)Math.min(1024L, l);
        byte[] byArray = new byte[n2];
        long l2 = 0L;
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
            if ((l2 += (long)n) < l) continue;
        }
        outputStream.flush();
    }

    public static String readString(InputStream inputStream, String string) throws IOException {
        int n;
        if (string == null) {
            string = "UTF-8";
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        char[] cArray = new char[1000];
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = bufferedReader.read(cArray)) > 0) {
            stringBuilder.append(cArray, 0, n);
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    public static List<String> readStringBig(File file, String string) throws IOException {
        String string2;
        if (string == null) {
            string = "UTF-8";
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            arrayList.add(string2);
        }
        bufferedReader.close();
        return arrayList;
    }

    public static byte[] read(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void save(byte[] byArray, String string) throws IOException {
        File file = new File(string);
        file.getAbsoluteFile().getParentFile().mkdirs();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        bufferedOutputStream.write(byArray);
        bufferedOutputStream.close();
    }

    public static Iterable<CharSequence> split(final CharSequence charSequence, final char c) {
        return new Iterable<CharSequence>(){

            @Override
            public Iterator<CharSequence> iterator() {
                return new Iterator<CharSequence>(){
                    int p1;

                    @Override
                    public CharSequence next() {
                        int n = -1;
                        for (int i = this.p1; i < charSequence.length(); ++i) {
                            if (charSequence.charAt(i) != c) continue;
                            n = i;
                            break;
                        }
                        if (n == -1) {
                            CharSequence charSequence = charSequence.subSequence(this.p1, charSequence.length());
                            this.p1 = charSequence.length();
                            return charSequence;
                        }
                        CharSequence charSequence = charSequence.subSequence(this.p1, n);
                        this.p1 = n + 1;
                        return charSequence;
                    }

                    @Override
                    public boolean hasNext() {
                        if (charSequence == null) {
                            return false;
                        }
                        return this.p1 < charSequence.length();
                    }
                };
            }
        };
    }

    public static byte[] readBs(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(byArray, n3 + i, n - i);
            if (n2 >= 0) continue;
            throw new EOFException();
        }
        return byArray;
    }
}

