/*
 * Decompiled with CFR 0.152.
 */
package neoe.util;

import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class FileIterator
implements Iterable<File> {
    List<Object[]> buf;
    private boolean sortByName;
    private int maxlevel = 0;
    private boolean followLink = true;
    private Filter filter;

    public FileIterator(String string, Filter filter, boolean bl, boolean bl2, int n) {
        this.sortByName = bl;
        this.maxlevel = n;
        this.followLink = bl2;
        this.filter = filter;
        this.buf = new ArrayList<Object[]>();
        File file = new File(string);
        if (file.isFile()) {
            boolean bl3 = false;
            if (filter != null) {
                if (filter.run(file)) {
                    bl3 = true;
                }
            } else {
                bl3 = true;
            }
            if (bl3) {
                this.buf.add(new Object[]{file, 0});
            }
        } else {
            this.expend(file, 0);
        }
    }

    public FileIterator(String string) {
        this(string, null, false, false, 0);
    }

    public FileIterator(String string, boolean bl, boolean bl2) {
        this(string, null, bl, bl2, 0);
    }

    public FileIterator(String string, boolean bl, int n) {
        this(string, bl, n, null);
    }

    public FileIterator(String string, boolean bl, int n, Filter filter) {
        this(string, filter, bl, false, n);
    }

    public FileIterator(String string, boolean bl, boolean bl2, int n, Filter filter) {
        this(string, filter, bl, bl2, n);
    }

    @Override
    public Iterator<File> iterator() {
        return new Iterator<File>(){

            @Override
            public boolean hasNext() {
                return FileIterator.this.buf.size() > 0;
            }

            @Override
            public File next() {
                Object[] objectArray = FileIterator.this.buf.remove(0);
                File file = (File)objectArray[0];
                int n = (Integer)objectArray[1];
                FileIterator.this.expend(file, n);
                return file;
            }

            @Override
            public void remove() {
            }
        };
    }

    private void expend(File file2, int n) {
        if (!(!file2.isDirectory() || this.maxlevel > 0 && n >= this.maxlevel || !this.followLink && Files.isSymbolicLink(file2.toPath()))) {
            if (this.filter != null && !this.filter.run(file2)) {
                return;
            }
            File[] fileArray = file2.listFiles();
            if (fileArray != null) {
                if (this.sortByName) {
                    FileIterator.sortFiles(fileArray);
                }
                Arrays.stream(fileArray).forEach(file -> {
                    if (this.filter != null && !this.filter.run((File)file)) {
                        return;
                    }
                    this.buf.add(new Object[]{file, n + 1});
                });
            }
        }
    }

    public static void sortFiles(File[] fileArray) {
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return file.getName().compareTo(file2.getName());
            }
        });
    }

    public static interface Filter {
        public boolean run(File var1);
    }
}

