/*
 * Decompiled with CFR 0.152.
 */
package neoe.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Exec {
    public List<String> sb = new ArrayList<String>();
    public boolean verbose = false;
    private String name;
    private static final boolean DEBUG = false;

    public Exec() {
    }

    public Exec(String string) {
        this();
        this.name = string;
    }

    public void setCmd(String string) {
        this.sb.add(string);
    }

    public void addArg(String string) {
        this.sb.add(string);
    }

    public void addArg(String string, String string2) {
        this.sb.add(string);
        this.sb.add(string2);
    }

    public String toCmdString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.sb) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            if (string.indexOf(32) >= 0) {
                stringBuilder.append('\"').append(string).append('\"');
                continue;
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public int execute(OutputStream outputStream, OutputStream outputStream2, InputStream inputStream, Map map, File file) throws Exception {
        return this.execute(outputStream, outputStream2, inputStream, map, file, false);
    }

    public int execute(OutputStream outputStream, OutputStream outputStream2, InputStream inputStream, Map map, File file, boolean bl) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(this.sb);
        if (file != null) {
            processBuilder.directory(file);
        }
        processBuilder.environment().put("neoe", "hello");
        if (map != null) {
            processBuilder.environment().putAll(map);
        }
        Process process = processBuilder.start();
        Thread thread = null;
        Thread thread2 = null;
        Thread thread3 = null;
        if (outputStream2 != null) {
            thread2 = new StreamGobbler(bl ? process.getInputStream() : new BufferedInputStream(process.getInputStream()), "stdout", outputStream2, bl);
        }
        if (outputStream != null) {
            thread = new StreamGobbler(bl ? process.getErrorStream() : new BufferedInputStream(process.getErrorStream()), "stderr", outputStream, bl);
        }
        if (inputStream != null) {
            thread3 = new StreamGobbler(inputStream, "stdin", process.getOutputStream(), bl);
        }
        if (outputStream != null) {
            thread.start();
        }
        if (outputStream2 != null) {
            thread2.start();
        }
        if (inputStream != null) {
            thread3.start();
        }
        if (outputStream != null) {
            thread.join();
        }
        if (outputStream2 != null) {
            thread2.join();
        }
        if (inputStream != null) {
            thread3.join();
        }
        int n = process.waitFor();
        return n;
    }

    private class StreamGobbler
    extends Thread {
        InputStream in;
        String type;
        private OutputStream out;
        private boolean realtime;

        private StreamGobbler(InputStream inputStream, String string, OutputStream outputStream, boolean bl) {
            this.in = inputStream;
            this.type = string;
            this.out = outputStream;
            this.realtime = bl;
        }

        @Override
        public void run() {
            if (this.realtime) {
                this.run1();
            } else {
                this.runBuf();
            }
        }

        private void runBuf() {
            byte[] byArray = new byte[8192];
            try {
                int n;
                while ((n = this.in.read(byArray)) >= 0) {
                    this.out.write(byArray, 0, n);
                    this.out.flush();
                }
                this.in.close();
                this.out.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private void run1() {
            try {
                int n;
                while ((n = this.in.read()) != -1) {
                    this.out.write(n);
                }
                this.in.close();
                this.out.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

