/*
 * Decompiled with CFR 0.152.
 */
package neoe.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class BAOS
extends OutputStream {
    public byte[] buf;
    protected int count;
    private int MAX_SIZE = 0x7FFFFFF7;
    private int maxCount;
    private final byte[] writeBuffer = new byte[8];

    public BAOS(int n, int n2) {
        if (n <= 0) {
            n = 4096;
        }
        if (n2 > 0) {
            this.MAX_SIZE = n2;
        }
        this.buf = new byte[n];
    }

    private void ensureCapacity(int n) {
        if (n > this.buf.length) {
            this.grow(n);
        }
    }

    private void grow(int n) {
        if (n > this.MAX_SIZE) {
            throw new RuntimeException("overflow max_size:" + this.MAX_SIZE);
        }
        int n2 = this.buf.length;
        int n3 = 0x1000000;
        int n4 = Math.max(n, n2 > n3 ? n2 + n3 : n2 + n2);
        if (n4 > this.MAX_SIZE) {
            n4 = this.MAX_SIZE;
        }
        this.buf = Arrays.copyOf(this.buf, n4);
    }

    @Override
    public void write(int n) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = (byte)n;
        ++this.count;
    }

    public void writeByte(int n) {
        this.write(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 - byArray.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + n2);
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    public void writeBytes(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public final void writeInt(int n) throws IOException {
        this.writeBuffer[0] = (byte)(n >>> 24);
        this.writeBuffer[1] = (byte)(n >>> 16);
        this.writeBuffer[2] = (byte)(n >>> 8);
        this.writeBuffer[3] = (byte)(n >>> 0);
        this.write(this.writeBuffer, 0, 4);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, Math.max(this.maxCount, this.count));
    }

    public void writeToFile(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(this.buf, 0, Math.max(this.maxCount, this.count));
        fileOutputStream.close();
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public int size() {
        return Math.max(this.maxCount, this.count);
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return new String(this.buf, 0, Math.max(this.maxCount, this.count));
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buf, 0, Math.max(this.maxCount, this.count), string);
    }

    public void writeNBytes(int n) {
        this.ensureCapacity(this.count + n);
        this.count += n;
    }

    public int pos() {
        return this.count;
    }

    public void setSize(int n) {
        this.ensureCapacity(n);
        this.maxCount = n;
    }

    public void seek(int n) {
        if (n > this.count) {
            this.writeNBytes(n - this.count);
        } else {
            this.maxCount = Math.max(this.maxCount, this.count);
            this.count = n;
        }
    }
}

