/*
 * Decompiled with CFR 0.152.
 */
package neoe.token;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import neoe.token.SourceType;
import neoe.token.Token;
import neoe.token.TokenType;
import neoe.token.U;
import neoe.util.Etc;

public class Tokens {
    public static final String pair_a = "{[(";
    public static final String pair_b = "}])";
    public static final List<String> lineCommentCAndJava = Arrays.asList("//");
    public static final List<String> longOperatersC___ = Arrays.asList("<=", ">=", "!=", "&&", "||", "++", "--", "==", "<<", ">>", "+=", "-=", "*=", "/=", "%=", "&=", "^=", "|=", "->", "..", "##", ">>=", "<<=", ">>>", "<<<", ">>>=", "<<<=", "::", "=>", "...", "%%", ".*", "->*", "===", "!==", ":=", "..<");
    public static final List<String> longOperatersJava = Arrays.asList("<=", ">=", "!=", "&&", "||", "++", "--", "==", "<<", ">>", "+=", "-=", "*=", "/=", "%=", "&=", "^=", "|=", "->", "..", "##", ">>=", "<<=", ">>>", "<<<", ">>>=", "<<<=", "::", "=>", "...", "%%", "===", "!==", ":=", "./", "..<");
    public static final List<String[]> regionCommentCAndJava = Arrays.asList(new String[][]{{"/*", "*/"}});
    public String fn;
    public CheckChar isIdentifier;
    List<String> lineComment;
    List<String> longOperaters;
    public Object ext;
    public int p;
    private LinkedList<Token> pushedBack = new LinkedList();
    List<String[]> regionComment;
    String[] regionEnd = new String[1];
    StringBuilder sb = new StringBuilder();
    private SourceType sourceType;
    private String txt;
    private TokenType type;
    List<Token> lastTokenCannotIgnore = new ArrayList<Token>();
    public boolean allowSingleQuote = true;
    public boolean isSwift;

    public static Tokens getCTokens(String string) {
        Tokens tokens = new Tokens(string);
        tokens.sourceType = SourceType.C;
        tokens.longOperaters = longOperatersC___;
        tokens.lineComment = lineCommentCAndJava;
        tokens.regionComment = regionCommentCAndJava;
        tokens.isIdentifier = Tokens::isIdentifierC;
        return tokens;
    }

    public static Tokens getJavaTokens(String string) {
        Tokens tokens = new Tokens(string);
        tokens.sourceType = SourceType.Java;
        tokens.longOperaters = longOperatersJava;
        tokens.lineComment = lineCommentCAndJava;
        tokens.regionComment = regionCommentCAndJava;
        tokens.isIdentifier = Tokens::isIdentifierJava;
        return tokens;
    }

    public static Tokens getMiniXMLTokens(String string) {
        Tokens tokens = new Tokens(string);
        tokens.sourceType = SourceType.Html;
        tokens.longOperaters = Arrays.asList("/>", "<!", "]]", "]]>", "</");
        tokens.lineComment = Collections.emptyList();
        tokens.regionComment = Arrays.asList({"<!--", "-->"}, {"<?", "?>"});
        tokens.isIdentifier = Tokens::isIdentifierJava;
        return tokens;
    }

    public static Tokens getOtherTokens(String string, String string2, List<String> list, List<String> list2, List<String[]> list3, CheckChar checkChar) {
        Tokens tokens = new Tokens(string2);
        tokens.fn = string;
        tokens.sourceType = SourceType.Others;
        if (list == null) {
            list = Collections.emptyList();
        }
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        if (list3 == null) {
            list3 = Collections.emptyList();
        }
        if (checkChar == null) {
            checkChar = Tokens::isIdentifierJava;
        }
        tokens.longOperaters = list;
        tokens.lineComment = list2;
        tokens.regionComment = list3;
        tokens.isIdentifier = checkChar;
        return tokens;
    }

    public static Tokens getSpacedTokens(String string) {
        Tokens tokens = new Tokens(string);
        tokens.sourceType = SourceType.Others;
        List list = Collections.emptyList();
        tokens.longOperaters = list;
        tokens.lineComment = list;
        tokens.regionComment = Collections.emptyList();
        tokens.isIdentifier = Tokens::isIdentifierSpace;
        return tokens;
    }

    public static boolean isIdentifierC(char c) {
        return Character.isDigit(c) || Character.isLetter(c) || c == '_' || c == '@' || c == '$';
    }

    public static boolean isIdentifierJava(char c) {
        return Character.isDigit(c) || Character.isLetter(c) || c == '_' || c == '$';
    }

    public static boolean isIdentifierSpace(char c) {
        return c != '\t' && c != ' ' && c != '\n';
    }

    public Tokens() {
    }

    private Tokens(String string) {
        this.txt = string;
        this.p = 0;
    }

    private boolean isLineComment(char c) {
        for (String string : this.lineComment) {
            if (!this.peekMatch(c, string)) continue;
            return true;
        }
        return false;
    }

    private boolean isRegionComment(char c, String[] stringArray) {
        for (String[] stringArray2 : this.regionComment) {
            String string = stringArray2[0];
            String string2 = stringArray2[1];
            if (!this.peekMatch(c, string)) continue;
            stringArray[0] = string2;
            return true;
        }
        return false;
    }

    private boolean isSpace(char c) {
        return Character.isWhitespace(c);
    }

    public boolean lastTokenCannotIgnoreIs(String string, int n) {
        if (this.lastTokenCannotIgnore.size() < n + 1) {
            return false;
        }
        return this.lastTokenCannotIgnore.get(this.lastTokenCannotIgnore.size() - 1 - n).equalsString(string);
    }

    public Token getLastTokenCannotIgnore(int n) {
        if (this.lastTokenCannotIgnore.size() < n + 1) {
            return null;
        }
        return this.lastTokenCannotIgnore.get(this.lastTokenCannotIgnore.size() - 1 - n);
    }

    public Token next() {
        if (!this.pushedBack.isEmpty()) {
            return this.lastTokenCannotIgnoreAdd(this.pushedBack.removeLast());
        }
        if (this.p >= this.txt.length()) {
            return null;
        }
        this.sb.setLength(0);
        char c = this.txt.charAt(this.p);
        if (this.isSpace(c)) {
            char c2;
            this.type = TokenType.SPACE;
            this.sb.append(c);
            ++this.p;
            while (this.p < this.txt.length() && this.isSpace(c2 = this.txt.charAt(this.p))) {
                this.sb.append(c2);
                ++this.p;
            }
            return this.submit(this.type, this.sb);
        }
        if (this.isSwift && c == '\\' && (this.peek(1) == '.' || this.isIdentifier.run(this.peek(1)))) {
            char c3;
            this.type = TokenType.IDENTIFIER;
            this.sb.append('\\').append(this.peek(1));
            this.p += 2;
            while (this.p < this.txt.length() && (this.isIdentifier.run(c3 = this.txt.charAt(this.p)) || Character.isDigit(c3))) {
                this.sb.append(c3);
                ++this.p;
            }
            return this.submit(this.type, this.sb);
        }
        if (this.isSwift && (c == '#' || c == '!' || c == '&') && this.isIdentifier.run(this.peek(1))) {
            char c4;
            this.type = TokenType.IDENTIFIER;
            this.sb.append(c);
            ++this.p;
            while (this.p < this.txt.length() && (this.isIdentifier.run(c4 = this.txt.charAt(this.p)) || Character.isDigit(c4))) {
                this.sb.append(c4);
                ++this.p;
            }
            return this.submit(this.type, this.sb);
        }
        if (this.isSwift && c == '.' && this.getLastTokenCannotIgnore(0).isOPERATOR() && !this.lastTokenCannotIgnoreIs(")", 0) && !this.lastTokenCannotIgnoreIs("]", 0) && !this.lastTokenCannotIgnoreIs("}", 0)) {
            char c5;
            this.type = TokenType.IDENTIFIER;
            this.sb.append(c);
            ++this.p;
            while (this.p < this.txt.length() && (this.isIdentifier.run(c5 = this.txt.charAt(this.p)) || Character.isDigit(c5))) {
                this.sb.append(c5);
                ++this.p;
            }
            return this.submit(this.type, this.sb);
        }
        if (this.isIdentifier.run(c) || c == '-' && Character.isDigit(this.peek(1)) || c == '.' && Character.isDigit(this.peek(1))) {
            this.type = TokenType.IDENTIFIER;
            this.sb.append(c);
            ++this.p;
            while (this.p < this.txt.length()) {
                char c6 = this.txt.charAt(this.p);
                String string = "";
                String string2 = "";
                string = this.sb.toString();
                if (this.sb.length() > 1) {
                    string2 = this.sb.toString().substring(0, this.sb.length() - 1);
                }
                if (!this.isIdentifier.run(c6) && (c6 != '.' || !U.isNumber(string)) && (c6 != '-' && c6 != '+' || this.sb.length() <= 1 || this.sb.charAt(this.sb.length() - 1) != 'E' && this.sb.charAt(this.sb.length() - 1) != 'e' || !U.isNumber(string2)) && (!this.isSwift || "?!".indexOf(c6) < 0)) break;
                this.sb.append(c6);
                ++this.p;
            }
            return this.submit(this.type, this.sb);
        }
        if (this.isLineComment(c)) {
            this.type = TokenType.COMMENT;
            this._readUntil("\n");
            return this.submit(this.type, this.sb);
        }
        if (this.isRegionComment(c, this.regionEnd)) {
            this.type = TokenType.COMMENT;
            this._readUntil(this.regionEnd[0]);
            return this.submit(this.type, this.sb);
        }
        if (this.allowSingleQuote && c == '\'' || c == '\"' || c == '`') {
            this.type = TokenType.STRING;
            this.sb.append(c);
            int n = this.p++;
            boolean bl = true;
            while (true) {
                if (this.p >= this.txt.length()) {
                    bl = false;
                    break;
                }
                char c7 = this.txt.charAt(this.p++);
                this.sb.append(c7);
                if (c7 == c) break;
                if (c7 != '\\') continue;
                this.sb.append(this.txt.charAt(this.p++));
            }
            if (!bl) {
                this.p = n;
                U.panic(String.format("string %s not finished from %s", Character.valueOf(c), this.pos()));
            }
            return this.submit(this.type, this.sb);
        }
        if (this.sourceType.equals((Object)SourceType.C) && c == '<' && (this.lastTokenCannotIgnoreIs("include", 0) || this.lastTokenCannotIgnoreIs("include_next", 0))) {
            this.type = TokenType.STRING;
            this.sb.append(c);
            ++this.p;
            this._readUntil(">");
            return this.submit(this.type, this.sb);
        }
        this.type = TokenType.OPERATOR;
        this.sb.append(c);
        ++this.p;
        while (this.p < this.txt.length()) {
            char c8 = this.txt.charAt(this.p);
            String string = this.sb.toString() + c8;
            if (!this.longOperaters.contains(string) && (!this.isSwift || "?!".indexOf(c8) < 0)) break;
            this.sb.append(c8);
            ++this.p;
        }
        return this.submit(this.type, this.sb);
    }

    private Token lastTokenCannotIgnoreAdd(Token token) {
        if (!token.isSpaceOrComment()) {
            this.lastTokenCannotIgnore.add(token);
        }
        return token;
    }

    public Token nextNoSpace() {
        this.skipSpace();
        return this.next();
    }

    public Token next2() {
        return this.nextNoSpaceNoComment();
    }

    public String ns() {
        Token token = this.nextNoSpaceNoComment();
        if (token == null) {
            return null;
        }
        return token.token;
    }

    public Token nextNoSpaceNoComment() {
        this.skipSpaceComment();
        Token token = this.next();
        return token;
    }

    private char peek(int n) {
        if (this.p + n >= this.txt.length()) {
            return '\u0000';
        }
        return this.txt.charAt(this.p + n);
    }

    private boolean peekMatch(char c, String string) {
        if (c != string.charAt(0)) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (string.charAt(i) == this.peek(i)) continue;
            return false;
        }
        return true;
    }

    public String pos() {
        int n;
        String string = this.txt.substring(0, this.p);
        int n2 = 1;
        int n3 = 0;
        while (n3 < string.length() && (n = string.indexOf(10, n3)) >= 0) {
            ++n2;
            n3 = n + 1;
        }
        return String.format("%s%d:%d", this.fn == null ? "" : this.fn + ":", n2, string.length() - n3 + 1);
    }

    public void pushBack(Token token) {
        this.pushedBack.add(token);
    }

    private void _readUntil(String string) {
        int n = this.txt.indexOf(string, this.p);
        if (n < 0) {
            this.sb.append(this.txt.substring(this.p));
            this.p = this.txt.length();
        } else {
            this.sb.append(this.txt.substring(this.p, n + string.length()));
            this.p = n + string.length();
        }
    }

    public void rawBack(int n) {
        this.p -= n;
    }

    public Token readUntil(String string) {
        int n = 0;
        for (Token token : this.pushedBack) {
            n += token.token.length();
        }
        this.p -= n;
        this.pushedBack.clear();
        this._readUntil(string);
        return this.submit(TokenType.STRING, this.sb);
    }

    public String readRemain() {
        int n = 0;
        for (Token token : this.pushedBack) {
            n += token.token.length();
        }
        this.p -= n;
        this.pushedBack.clear();
        String string = this.txt.substring(this.p);
        this.p = this.txt.length();
        return string;
    }

    public void skipSpace() {
        Token token;
        while ((token = this.next()) != null) {
            TokenType tokenType = token.type;
            if (TokenType.SPACE.equals((Object)tokenType)) continue;
            this.pushBack(token);
            break;
        }
    }

    public void skipSpaceComment() {
        Token token;
        while ((token = this.next()) != null) {
            TokenType tokenType = token.type;
            if (TokenType.SPACE.equals((Object)tokenType) || TokenType.COMMENT.equals((Object)tokenType)) continue;
            this.pushBack(token);
            break;
        }
    }

    private Token submit(TokenType tokenType, StringBuilder stringBuilder) {
        Token token = new Token(tokenType, stringBuilder.toString());
        stringBuilder.setLength(0);
        return this.lastTokenCannotIgnoreAdd(token);
    }

    public Token peek2() {
        return this.peekNoSpaceNoComment();
    }

    public Token peekNoSpaceNoComment() {
        Token token = this.nextNoSpaceNoComment();
        if (token == null) {
            return new Token(TokenType.SPACE, null);
        }
        this.pushBack(token);
        return token;
    }

    public void confirmNext(String string, String string2) {
        Token token = this.nextNoSpaceNoComment();
        if (!token.equalsString(string)) {
            Tokens.error(String.format("expect '%s' got '%s'%s", string, token.token, string2 == null ? "" : ", " + string2), this.pos());
        }
    }

    public void confirmNext(String string) {
        this.confirmNext(string, null);
    }

    public static void error(String string, String string2) {
        Etc.panic(String.format("[e]%s at %s", string, string2));
    }

    public boolean isLineEndComment(Token token) {
        if (token == null || !token.type.equals((Object)TokenType.COMMENT)) {
            return false;
        }
        for (String string : this.lineComment) {
            if (!token.token.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public boolean ignoreNext(String string) {
        Token token = this.nextNoSpaceNoComment();
        if (!token.equalsString(string)) {
            this.pushBack(token);
            return false;
        }
        return true;
    }

    public static interface CheckChar {
        public boolean run(char var1);
    }
}

