/*
 * Decompiled with CFR 0.152.
 */
package neoe.token;

import neoe.token.TokenType;

public class Token {
    public TokenType type;
    public String token;
    public int indent;

    public Token(TokenType tokenType, String string) {
        this.type = tokenType;
        this.token = string;
    }

    public static Token makeSpace(String string, int n) {
        Token token = new Token(TokenType.SPACE, string);
        token.indent = n;
        return token;
    }

    public boolean equalsString(String string) {
        return this.token != null && this.token.equals(string);
    }

    public boolean es(String string) {
        return this.equalsString(string);
    }

    public String toString() {
        return "Token [type=" + this.type + ", token=" + this.token + "]";
    }

    public boolean str(String string) {
        return !this.isSpaceOrComment() && this.token.equals(string);
    }

    public boolean isSpaceOrComment() {
        return this.type.equals((Object)TokenType.SPACE) || this.type.equals((Object)TokenType.COMMENT);
    }

    public boolean isSpace() {
        return this.type.equals((Object)TokenType.SPACE);
    }

    public boolean isComment() {
        return this.type.equals((Object)TokenType.COMMENT);
    }

    public boolean isOPERATOR() {
        return this.type.equals((Object)TokenType.OPERATOR);
    }

    public boolean isOp() {
        return this.type.equals((Object)TokenType.OPERATOR);
    }

    public boolean isString() {
        return this.type.equals((Object)TokenType.STRING);
    }

    public boolean isIdentifier() {
        return this.type.equals((Object)TokenType.IDENTIFIER);
    }
}

