/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import neoe.formatter.c.CFormatter;
import neoe.formatter.java.JavaFormatter;
import neoe.formatter.lua.LuaFormatter;
import neoe.formatter.pydata.MyFormatter;
import neoe.formatter.textfrog.TextFrogFormatter;
import neoe.util.FileIterator;
import neoe.util.FileUtil;

public class FormatterApp {
    private String encoding = "utf8";
    AtomicInteger formatted = new AtomicInteger(0);
    AtomicInteger skip = new AtomicInteger(0);
    AtomicInteger error = new AtomicInteger(0);
    String[] ext_c = new String[]{".cs", ".c", ".h", ".cpp", ".hpp"};
    String[] ext_java = new String[]{".java"};
    String[] ext_lua = new String[]{".lua"};
    String[] ext_tfg = new String[]{".tfg", ".tc2"};
    String[] ext_pydata = new String[]{"mybuild", ".conf"};
    String[][] exts = new String[][]{this.ext_c, this.ext_java, this.ext_lua, this.ext_pydata, this.ext_tfg};
    List<String> fs = new ArrayList<String>();
    Get[] gets = new Get[]{() -> new CFormatter(), () -> new JavaFormatter(), () -> new LuaFormatter(), () -> new MyFormatter(), () -> new TextFrogFormatter()};
    String[] langs = new String[]{"c", "java", "lua", "pydata", "textfrog"};
    boolean optChangeLine;
    private boolean overwritesource = false;
    int pall;

    private static boolean endsWith(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (string.endsWith(string2)) {
                return true;
            }
            if (string2.startsWith(".") || !string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    private static String formatSource(Object object, String string) throws Exception {
        Method method = object.getClass().getMethod("formatSource", String.class);
        return (String)method.invoke(object, string);
    }

    public static void main(String[] stringArray) throws Exception {
        new FormatterApp().run(stringArray);
    }

    public static void usage() {
        System.out.println("FormatterApp: args:\n -o  == overwrite source\n -e<ENCODING> == use ENCODING\n -d == debug\n--changeline == changeline after ';'\n  input-files\n");
    }

    private void addFile(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            for (File file2 : new FileIterator(string)) {
                String string2 = file2.getName();
                if (!string2.endsWith(".java") && !string2.endsWith(".c") && !string2.endsWith(".h") && !string2.endsWith(".cs") && !string2.endsWith(".cpp") && !string2.endsWith(".hpp") && (!string2.endsWith(".lua") || string2.endsWith(".fmt_c") || string2.endsWith(".fmt-err_c"))) continue;
                this.fs.add(file2.getAbsolutePath());
            }
        } else if (file.isFile()) {
            this.fs.add(string);
        }
    }

    private void doOpt(String string) {
        if (string.startsWith("-e")) {
            this.encoding = string.substring(2);
        } else if (string.startsWith("-o")) {
            this.overwritesource = true;
        } else if (string.startsWith("--changeline")) {
            this.optChangeLine = true;
        } else if (string.startsWith("-d")) {
            this.overwritesource = false;
        } else if (string.startsWith("-j")) {
            this.pall = Integer.parseInt(string.substring(2));
        }
    }

    private void format(String string, String string2, Object object, String string3) {
        try {
            String string4 = FormatterApp.formatSource(object, string2);
            if (!string4.equals(string2)) {
                File file = new File(string + (this.overwritesource ? "" : ".log"));
                FileUtil.save(string4.getBytes(this.encoding), file.getAbsolutePath());
                System.out.println("wrote to " + file.getAbsolutePath());
                this.formatted.incrementAndGet();
            } else {
                this.skip.incrementAndGet();
            }
        }
        catch (Exception exception) {
            this.error.incrementAndGet();
            exception.printStackTrace();
            System.out.printf("error formatting %s [%s] %s\n", string3, string, exception.getCause());
        }
    }

    public void formatSource(String string) throws Exception {
        int n;
        String string2 = string.toLowerCase();
        String string3 = null;
        for (n = 0; n < this.langs.length; ++n) {
            if (!FormatterApp.endsWith(string2, this.exts[n])) continue;
            string3 = this.langs[n];
            break;
        }
        if (string3 != null) {
            for (n = 0; n < this.langs.length; ++n) {
                if (!this.langs[n].equals(string3)) continue;
                String string4 = FileUtil.readString(new FileInputStream(string), this.encoding);
                this.format(string, string4, this.gets[n].get(), this.langs[n]);
            }
        }
    }

    public void run(String[] stringArray) throws Exception {
        for (String string : stringArray) {
            if (string.startsWith("-")) {
                this.doOpt(string);
                continue;
            }
            this.addFile(string);
        }
        if (this.fs.isEmpty()) {
            System.out.println("no input files");
        } else {
            if (this.pall > 1) {
                System.out.println("parallel=" + this.pall);
                ExecutorService executorService = Executors.newFixedThreadPool(this.pall);
                for (String string : this.fs) {
                    executorService.submit(() -> {
                        try {
                            this.formatSource(string);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            executorService.shutdown();
                        }
                    });
                }
                executorService.shutdown();
                executorService.awaitTermination(1L, TimeUnit.DAYS);
            } else {
                for (String string : this.fs) {
                    this.formatSource(string);
                }
            }
            System.out.printf("done. formatted=%s, no change=%s, error=%s\n", this.formatted, this.skip, this.error);
        }
    }

    static interface Get {
        public Object get();
    }
}

