/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne.plugin;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import neoe.formatter.c.CFormatter;
import neoe.formatter.html.HtmlFormatter;
import neoe.formatter.java.JavaFormatter;
import neoe.formatter.json.JsonFormatter;
import neoe.formatter.lua.LuaFormatter;
import neoe.formatter.pydata.MyFormatter;
import neoe.formatter.swift.SwiftFormatter;
import neoe.formatter.textfrog.TextFrogFormatter;
import neoe.ne.PlainPage;
import neoe.ne.Plugin;

public class FormatAction
implements Plugin.PluginAction {
    String[] ext_c = new String[]{".cs", ".c", ".h", ".cpp", ".hpp", ".vert", ".frag"};
    String[] ext_java = new String[]{".java", ".js"};
    String[] ext_lua = new String[]{".lua"};
    String[] ext_tfg = new String[]{".tfg", ".tc2"};
    String[] ext_json = new String[]{".json"};
    String[] ext_pydata = new String[]{"mybuild", ".conf"};
    String[] ext_html = new String[]{".html", ".xml", ".css"};
    String[] ext_swift = new String[]{".swift"};
    String[] langs = new String[]{"C", "Java", "Lua", "json", "pydata", "TextFrog", "xhtml", "swift"};
    String[][] exts = new String[][]{this.ext_c, this.ext_java, this.ext_lua, this.ext_json, this.ext_pydata, this.ext_tfg, this.ext_html, this.ext_swift};
    Get[] gets = new Get[]{() -> new CFormatter(), () -> new JavaFormatter(), () -> new LuaFormatter(), () -> new JsonFormatter(), () -> new MyFormatter(), () -> new TextFrogFormatter(), () -> new HtmlFormatter(), () -> new SwiftFormatter()};

    public void run(PlainPage plainPage) throws Exception {
        int n;
        String string = plainPage.pageData.title;
        String string2 = null;
        if (string == null) {
            string2 = this.selectFormatter();
        } else {
            string = string.toLowerCase();
            for (n = 0; n < this.langs.length; ++n) {
                if (!FormatAction.endsWith(string, this.exts[n])) continue;
                string2 = this.langs[n];
                break;
            }
            if (string2 == null) {
                string2 = this.selectFormatter();
            }
        }
        if (string2 != null) {
            for (n = 0; n < this.langs.length; ++n) {
                if (!this.langs[n].equals(string2)) continue;
                FormatAction.format(plainPage, this.gets[n].get(), this.langs[n]);
            }
        }
    }

    private static void format(PlainPage plainPage, Object object, String string) throws Exception {
        String string2 = FormatAction.formatSource(object, String.join((CharSequence)"\n", plainPage.pageData.lines));
        if (!string2.equals(FormatAction.getString(plainPage))) {
            int n = plainPage.cx;
            int n2 = plainPage.cy;
            plainPage.ptSelection.selectAll();
            plainPage.ptEdit.append(string2);
            plainPage.cx = n;
            plainPage.cy = n2;
            plainPage.adjustCursor();
            plainPage.ui.message("formatted[" + string + "]");
        } else {
            plainPage.ui.message("formatter[" + string + "]: no changes");
        }
    }

    private static String getString(PlainPage plainPage) {
        return String.join((CharSequence)"\n", plainPage.pageData.lines);
    }

    private static String formatSource(Object object, String string) throws Exception {
        Method method = object.getClass().getMethod("formatSource", String.class);
        return (String)method.invoke(object, string);
    }

    private static boolean endsWith(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (string.endsWith(string2)) {
                return true;
            }
            if (string2.startsWith(".") || !string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    private String selectFormatter() {
        final String[] stringArray = new String[1];
        List<String> list = Arrays.asList(this.langs);
        if (list.size() == 1) {
            return list.get(0);
        }
        final JList<Object> jList = new JList<Object>(list.toArray());
        jList.setSelectionMode(0);
        final JDialog jDialog = this.wrapFrame(new JScrollPane(jList), "Cannot auto detect the formatter to be used, please select one:");
        jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    String string;
                    stringArray[0] = string = (String)jList.getSelectedValue();
                    jDialog.dispose();
                }
            }
        });
        jList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 27) {
                    jDialog.dispose();
                } else if (n == 10) {
                    String string;
                    stringArray[0] = string = (String)jList.getSelectedValue();
                    jDialog.dispose();
                }
            }
        });
        jDialog.setVisible(true);
        jDialog.requestFocus();
        return stringArray[0];
    }

    private JDialog wrapFrame(JComponent jComponent, String string) {
        JDialog jDialog = new JDialog();
        jDialog.setTitle(string);
        jDialog.setModal(true);
        jDialog.add(jComponent);
        jDialog.setDefaultCloseOperation(2);
        jDialog.setSize(400, 600);
        jDialog.setLocationRelativeTo(null);
        return jDialog;
    }

    static interface Get {
        public Object get();
    }
}

