/*
 * Decompiled with CFR 0.152.
 */
package neoe.formatter.pydata;

import java.util.Arrays;
import java.util.List;
import neoe.formatter.pydata.MyTokenType;

public class MyTokens {
    private String txt;
    private int p;
    private MyTokenType type;
    StringBuilder sb = new StringBuilder();
    static final List<String> longOperaters = Arrays.asList(new String[0]);

    public MyTokens(String string) {
        this.txt = string;
        this.p = 0;
    }

    public Object[] next() {
        String string;
        if (this.p >= this.txt.length()) {
            return null;
        }
        this.sb.setLength(0);
        char c = this.txt.charAt(this.p);
        if (this.isSpace(c)) {
            char c2;
            this.type = MyTokenType.SPACE;
            this.sb.append(c);
            ++this.p;
            while (this.p < this.txt.length() && this.isSpace(c2 = this.txt.charAt(this.p))) {
                this.sb.append(c2);
                ++this.p;
            }
            return this.submit(this.type, this.sb.toString());
        }
        if (c == '/' && this.peek(1) == '*') {
            this.type = MyTokenType.COMMENT;
            this.sb.append("/*");
            this.p += 2;
            this.readUntil("*/");
            return this.submit(this.type, this.sb.toString());
        }
        if (c == '\'' || c == '\"' || c == '`') {
            if (this.peek(1) == c && this.peek(2) == c) {
                this.type = MyTokenType.STRING;
                String string2 = "" + c + c + c;
                this.sb.append(string2);
                this.p += 3;
                this.readUntil(string2);
                return this.submit(this.type, this.sb.toString());
            }
            this.type = MyTokenType.STRING;
            this.sb.append(c);
            ++this.p;
            while (this.p < this.txt.length()) {
                char c3 = this.txt.charAt(this.p++);
                this.sb.append(c3);
                if (c3 == c) break;
                if (c3 != '\\') continue;
                this.sb.append(this.txt.charAt(this.p++));
            }
            return this.submit(this.type, this.sb.toString());
        }
        if (MyTokens.isIdentifier(c) || c == '-' && Character.isDigit(this.peek(1))) {
            char c4;
            this.type = MyTokenType.IDENTIFIER;
            this.sb.append(c);
            ++this.p;
            while (this.p < this.txt.length() && MyTokens.isIdentifier(c4 = this.txt.charAt(this.p))) {
                this.sb.append(c4);
                ++this.p;
            }
            return this.submit(this.type, this.sb.toString());
        }
        this.type = MyTokenType.OPERATOR;
        this.sb.append(c);
        ++this.p;
        while (longOperaters.contains(string = this.sb.toString() + this.peek(0))) {
            this.sb.append(this.txt.charAt(this.p++));
        }
        return this.submit(this.type, this.sb.toString());
    }

    private Object[] submit(MyTokenType myTokenType, String string) {
        return new Object[]{myTokenType, string};
    }

    private void readUntil(String string) {
        int n = this.txt.indexOf(string, this.p);
        if (n < 0) {
            this.sb.append(this.txt.substring(this.p));
            this.p = this.txt.length();
        } else {
            this.sb.append(this.txt.substring(this.p, n + string.length()));
            this.p = n + string.length();
        }
    }

    private char peek(int n) {
        if (this.p + n >= this.txt.length()) {
            return '\u0000';
        }
        return this.txt.charAt(this.p + n);
    }

    static boolean isIdentifier(char c) {
        return c != '\uffffffff' && " \n\r\t,[]{}():".indexOf(c) < 0;
    }

    private boolean isSpace(char c) {
        return Character.isWhitespace(c);
    }
}

