/*
 * Decompiled with CFR 0.152.
 */
package neoe.formatter.pydata;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import neoe.formatter.pydata.MyTokenType;
import neoe.formatter.pydata.MyTokens;
import neoe.util.FileIterator;
import neoe.util.FileUtil;
import neoe.util.PyData;

public class MyFormatter {
    private static boolean TESTING_LEVEL = false;
    private static boolean DEBUG = false;
    List<String> fs = new ArrayList<String>();
    private String encoding = "utf8";
    private boolean overwritesource = false;
    private boolean bold;
    private Writer debug;
    StringBuilder sb;
    MyTokens tokens;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            MyFormatter.usage();
        } else {
            new MyFormatter().run(stringArray);
        }
    }

    private static void usage() {
        System.out.println("formatter: args:\n -o  --overwrite source\n -e<ENCODING> --use ENCODING\n -d --debug\n --bold replace all files in-place if no error\n input-file\n");
    }

    public void run(String[] stringArray) throws Exception {
        for (String string : stringArray) {
            if (string.startsWith("-")) {
                this.doOpt(string);
                continue;
            }
            this.addFile(string);
        }
        if (this.fs.isEmpty()) {
            System.out.println("no input files");
        } else {
            for (String string : this.fs) {
                this.formatFile(string);
            }
        }
    }

    private void addFile(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            for (File file2 : new FileIterator(string)) {
                String string2 = file2.getName();
                if (!this.bold && !string2.endsWith(".pl") && !string2.endsWith(".cfg") || !file2.isFile()) continue;
                this.fs.add(file2.getAbsolutePath());
            }
        } else if (file.isFile()) {
            this.fs.add(string);
        }
    }

    private void doOpt(String string) {
        if (string.startsWith("-e")) {
            this.encoding = string.substring(2);
        } else if (string.startsWith("-o")) {
            this.overwritesource = true;
        } else if (string.startsWith("-d")) {
            DEBUG = true;
            TESTING_LEVEL = true;
            this.overwritesource = false;
        } else if (string.equals("--bold")) {
            this.overwritesource = true;
            this.bold = true;
        }
    }

    public void formatFile(String string) {
        try {
            Object object;
            Env env = new Env();
            if (DEBUG) {
                this.debug = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("debug.log"), "utf8"));
            }
            if (DEBUG) {
                this.debug.write("read " + string + "\n");
            }
            String string2 = FileUtil.readString(new FileInputStream(string), this.encoding);
            try {
                object = (Map)PyData.parseAll(string2);
            }
            catch (Exception exception) {
                System.out.println("[w]" + string + " seems is not a pydata file, skip, with " + exception);
                return;
            }
            try {
                object = this.format(string2, env);
                if (env.indent != 0) {
                    env.indent = 0;
                    throw new RuntimeException("indent not correct:" + string);
                }
                File file = new File(string + (this.overwritesource ? "" : ".fmt"));
                FileUtil.save(((String)object).getBytes(this.encoding), file.getAbsolutePath());
                System.out.println("wrote to " + file.getAbsolutePath());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                File file = new File(string + ".fmt.err");
                FileUtil.save(this.sb.toString().getBytes(this.encoding), file.getAbsolutePath());
                System.out.println("wrote to " + file.getAbsolutePath());
            }
            if (DEBUG) {
                this.debug.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.printf("when formatting [%s]\n", string);
        }
    }

    public String formatSource(String string) throws Exception {
        Env env = new Env();
        String string2 = this.format(string, env);
        if (env.indent != 0) {
            throw new RuntimeException("indent not correct");
        }
        return string2;
    }

    public String format(String string, Env env) throws Exception {
        this.sb = new StringBuilder();
        this.tokens = new MyTokens(string);
        this.loop(MyTokenType.SPACE, null, null, env);
        return this.sb.toString();
    }

    private void loop(MyTokenType myTokenType, String string, MyTokenType myTokenType2, Env env) throws Exception {
        Object[] objectArray;
        env.lastType = myTokenType;
        this.addSpaceOnNeed(env);
        while ((objectArray = this.tokens.next()) != null) {
            MyTokenType myTokenType3 = (MyTokenType)((Object)objectArray[0]);
            String string2 = (String)objectArray[1];
            if (string2 == null) break;
            if (DEBUG) {
                this.debug.write(String.format("t:%s,v:%s\n", new Object[]{myTokenType3, string2}));
                this.debug.flush();
            }
            this.addToken(myTokenType3, string2, env);
            if ((!MyTokenType.OPERATOR.equals((Object)myTokenType2) || string2.indexOf(string) < 0) && (string == null || !string2.equals(string))) continue;
            break;
        }
    }

    private void addToken(MyTokenType myTokenType, String string, Env env) throws Exception {
        MyTokenType myTokenType2 = null;
        if (myTokenType.equals((Object)MyTokenType.COMMENT)) {
            this.printToken(env, string);
        } else if (myTokenType.equals((Object)MyTokenType.SPACE)) {
            int n = this.printSpaceLines(env, string);
            if (n <= 0) {
                this.addSpaceOnNeed(env);
            } else {
                env.changedLine = n;
            }
        } else if (myTokenType.equals((Object)MyTokenType.IDENTIFIER)) {
            this.printToken(env, string);
        } else if (myTokenType.equals((Object)MyTokenType.OPERATOR)) {
            if ("(".equals(string)) {
                if (env.changedLine > 0) {
                    this.printIndent(env);
                    env.changedLine = 0;
                }
                this.sb.append(string);
                this.incIndent(env, string);
            } else if ("}])".indexOf(string) >= 0) {
                this.decIndent(env);
                this.printToken(env, string);
            } else if ("{[(".indexOf(string) >= 0) {
                this.printToken(env, string);
                this.incIndent(env, string);
            } else if (string.equals(",")) {
                if (env.needComma) {
                    this.sb.append(",");
                }
                if (!env.lastType.equals((Object)MyTokenType.SPACE)) {
                    this.sb.append(" ");
                }
                myTokenType2 = MyTokenType.SPACE;
            } else {
                this.printToken(env, string);
            }
        } else if (myTokenType.equals((Object)MyTokenType.STRING)) {
            this.printToken(env, MyFormatter.dequote(string));
        } else {
            this.printToken(env, string);
        }
        env.lastType = myTokenType2 == null ? myTokenType : myTokenType2;
        env.lastToken = string;
    }

    static String dequote(String string) {
        String string2 = null;
        if (string.startsWith("'''") && string.endsWith("'''")) {
            string2 = string.substring(3, string.length() - 3);
        } else if (string.startsWith("\"\"\"") && string.endsWith("\"\"\"")) {
            string2 = string.substring(3, string.length() - 3);
        } else if (string.startsWith("\"") && string.endsWith("\"")) {
            string2 = string.substring(1, string.length() - 1);
        } else if (string.startsWith("'") && string.endsWith("'")) {
            string2 = string.substring(1, string.length() - 1);
        }
        if (string2 == null) {
            return string;
        }
        int n = string2.length();
        if (n == 0) {
            return string;
        }
        for (int i = 0; i < n; ++i) {
            if (MyTokens.isIdentifier(string2.charAt(i))) continue;
            return string;
        }
        return string2;
    }

    private void printToken(Env env, String string) {
        this.pre(env);
        this.sb.append(string);
    }

    private int printSpaceLines(Env env, String string) {
        int n = 0;
        for (char c : string.toCharArray()) {
            if (c != '\n') continue;
            if (n >= env.changedLine) {
                this.newline();
            }
            ++n;
        }
        return n;
    }

    private void pre(Env env) {
        if (env.changedLine > 0) {
            this.printIndent(env);
            env.changedLine = 0;
        } else {
            this.addSpaceOnNeed(env);
        }
    }

    private void printIndent(Env env) {
        if (TESTING_LEVEL) {
            this.sb.append("[" + env.indent + "]");
        }
        for (int i = 0; i < env.indent; ++i) {
            this.sb.append("\t");
        }
    }

    private void incIndent(Env env, String string) {
        ++env.indent;
        if (env.forcedChangeLine) {
            this.sb.append("\n");
            this.printIndent(env);
        }
        env.stack.push(string);
    }

    private void newline() {
        char c;
        int n = this.sb.length();
        while (n > 0 && ((c = this.sb.charAt(n - 1)) == ' ' || c == '\t')) {
            this.sb.setLength(--n);
        }
        this.sb.append("\n");
    }

    private String decIndent(Env env) {
        --env.indent;
        if (env.forcedChangeLine) {
            this.sb.append("\n");
            this.printIndent(env);
        }
        return (String)env.stack.pop();
    }

    private void addSpaceOnNeed(Env env) {
        if (!env.lastType.equals((Object)MyTokenType.SPACE) && env.changedLine <= 0) {
            this.sb.append(" ");
            env.lastType = MyTokenType.SPACE;
            env.changedLine = 0;
        }
    }

    static class Env {
        MyTokenType lastType = MyTokenType.SPACE;
        int indent;
        int changedLine;
        String lastToken;
        boolean forcedChangeLine;
        Stack stack = new Stack();
        public boolean needComma;

        Env() {
        }
    }
}

