/*
 * Decompiled with CFR 0.152.
 */
package neoe.formatter.lua;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import neoe.formatter.lua.LuaTokenType;

public class LuaTokens {
    private String txt;
    private int p;
    private LuaTokenType type;
    StringBuilder sb = new StringBuilder();
    LinkedList<Object[]> buffer = new LinkedList();
    static final List<String> longOperaters = Arrays.asList("<=", ">=", "==", "~=", "//", ">>", "<<");

    public LuaTokens(String string) {
        this.txt = string;
        this.p = 0;
    }

    public Object[] next() {
        if (!this.buffer.isEmpty()) {
            return this.buffer.removeFirst();
        }
        if (this.p >= this.txt.length()) {
            return null;
        }
        this.sb.setLength(0);
        char c = this.txt.charAt(this.p);
        if (this.isSpace(c)) {
            char c2;
            this.type = LuaTokenType.SPACE;
            this.sb.append(c);
            ++this.p;
            while (this.p < this.txt.length() && this.isSpace(c2 = this.txt.charAt(this.p))) {
                this.sb.append(c2);
                ++this.p;
            }
            return this.submit(this.type, this.sb.toString());
        }
        if (this.isIdentifier(c) || c == '-' && Character.isDigit(this.peek(1))) {
            char c3;
            this.type = LuaTokenType.IDENTIFIER;
            this.sb.append(c);
            ++this.p;
            while (this.p < this.txt.length() && this.isIdentifier(c3 = this.txt.charAt(this.p))) {
                this.sb.append(c3);
                ++this.p;
            }
            return this.submit(this.type, this.sb.toString());
        }
        if (c == '-' && this.peek(1) == '-') {
            this.type = LuaTokenType.COMMENT;
            this.sb.append("--");
            this.p += 2;
            int n = this.peekLongBrackets();
            if (n < 0) {
                this.readUntil("\n");
                if (this.p < this.txt.length()) {
                    this.sb.setLength(this.sb.length() - 1);
                    --this.p;
                }
            } else {
                this.readUntilLongBrackets(n);
            }
            return this.submit(this.type, this.sb.toString());
        }
        if (c == '\'' || c == '\"') {
            this.type = LuaTokenType.STRING;
            this.sb.append(c);
            ++this.p;
            while (this.p < this.txt.length()) {
                char c4 = this.txt.charAt(this.p++);
                this.sb.append(c4);
                if (c4 == c) break;
                if (c4 != '\\') continue;
                this.sb.append(this.txt.charAt(this.p++));
            }
            return this.submit(this.type, this.sb.toString());
        }
        int n = this.peekLongBrackets();
        if (n < 0) {
            String string;
            this.type = LuaTokenType.OPERATOR;
            this.sb.append(c);
            ++this.p;
            while (longOperaters.contains(string = this.sb.toString() + this.peek(0))) {
                this.sb.append(this.txt.charAt(this.p++));
            }
            return this.submit(this.type, this.sb.toString());
        }
        this.type = LuaTokenType.STRING;
        this.readUntilLongBrackets(n);
        return this.submit(this.type, this.sb.toString());
    }

    private Object[] submit(LuaTokenType luaTokenType, String string) {
        return new Object[]{luaTokenType, string};
    }

    private void readUntilLongBrackets(int n) {
        StringBuilder stringBuilder = new StringBuilder("]");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('=');
        }
        stringBuilder.append(']');
        this.readUntil(stringBuilder.toString());
    }

    private int peekLongBrackets() {
        if (this.peek(0) == '[') {
            int n = 0;
            while (this.peek(n + 1) == '=') {
                ++n;
            }
            if (this.peek(1 + n) == '[') {
                return n;
            }
        }
        return -1;
    }

    private void readUntil(String string) {
        int n = this.txt.indexOf(string, this.p);
        if (n < 0) {
            this.sb.append(this.txt.substring(this.p));
            this.p = this.txt.length();
        } else {
            this.sb.append(this.txt.substring(this.p, n + string.length()));
            this.p = n + string.length();
        }
    }

    private char peek(int n) {
        if (this.p + n >= this.txt.length()) {
            return '\u0000';
        }
        return this.txt.charAt(this.p + n);
    }

    private boolean isIdentifier(char c) {
        return Character.isDigit(c) || Character.isLetter(c) || c == '_';
    }

    private boolean isSpace(char c) {
        return Character.isWhitespace(c);
    }
}

