/*
 * Decompiled with CFR 0.152.
 */
package neoe.formatter.lua;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import neoe.formatter.lua.LuaTokenType;
import neoe.formatter.lua.LuaTokens;
import neoe.util.Etc;
import neoe.util.FileIterator;
import neoe.util.FileUtil;

public class LuaFormatterReleasePack {
    private static boolean TESTING_LEVEL = false;
    private static boolean DEBUG = false;
    public boolean sortFunctions = true;
    List<String> fs = new ArrayList<String>();
    private String encoding = "utf8";
    private boolean overwritesource = false;
    final boolean releasePack = true;
    private Writer debug;
    private int err;
    private int ok;
    private int skip;
    StringBuilder sb;
    StringBuilder sbPrint;
    boolean inPrint = false;
    LuaTokens tokens;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            LuaFormatterReleasePack.usage();
        } else {
            new LuaFormatterReleasePack().run(stringArray);
        }
    }

    private static void usage() {
        System.out.println("luaformatter: args:\n -o  -- overwrite source\n -e<ENCODING> -- use ENCODING\n -d -- debug\n  input-files\n");
    }

    public void releasePack(String string, String string2) throws Exception {
        File file = new File(string);
        File file2 = new File(string2);
        Object object = file.getAbsolutePath().replace('\\', '/');
        Object object2 = file2.getAbsolutePath().replace('\\', '/');
        if (!((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        if (!((String)object2).endsWith("/")) {
            object2 = (String)object2 + "/";
        }
        if (((String)object).startsWith((String)object2) || ((String)object2).startsWith((String)object)) {
            throw new RuntimeException("input and output dir cannot equals or in one's subdir");
        }
        file2.mkdirs();
        System.out.println("you're response for output dir's clean, because this tool will not delete any file not related to a lua output file.");
        int n = 0;
        for (File file3 : new FileIterator((String)object)) {
            String string3;
            if (!file3.isFile() || !file3.getName().endsWith(".lua")) continue;
            String string4 = FileUtil.readString(new FileInputStream(file3), null);
            String[] stringArray = new String[2];
            String string5 = this.formatSource(string4, stringArray);
            if (stringArray[0] != null) {
                string3 = String.format("error '%s' [%s]", file3.getAbsoluteFile(), stringArray[0]);
                System.out.println(string3);
                throw new RuntimeException(string3);
            }
            string3 = file3.getAbsolutePath().substring(((String)object).length()).replace('\\', '/');
            String string6 = (String)object2 + string3;
            System.out.printf("write [%s]->[%s]\n", string3, string6);
            FileUtil.save(string5.getBytes("utf8"), string6);
            ++n;
            System.out.printf("[%s\n%s]\n", string3, this.sbPrint.toString());
        }
        System.out.printf("done %d lua files\n", n);
    }

    public void run(String[] stringArray) throws Exception {
        for (String string : stringArray) {
            if (string.startsWith("-")) {
                this.doOpt(string);
                continue;
            }
            this.addFile(string);
        }
        if (this.fs.isEmpty()) {
            System.out.println("no input files");
        } else {
            for (String string : this.fs) {
                this.formatFile(string);
            }
        }
        System.out.printf("OK: %d, Error:%d, skip: %d\n", this.ok, this.err, this.skip);
    }

    private void addFile(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            for (File file2 : new FileIterator(string)) {
                String string2 = file2.getName();
                if (!string2.endsWith(".lua") || string2.endsWith(".fmt.lua") || string2.endsWith(".fmt-err.lua")) continue;
                this.fs.add(file2.getAbsolutePath());
            }
        } else if (file.isFile()) {
            this.fs.add(string);
        }
    }

    private void doOpt(String string) {
        if (string.startsWith("-e")) {
            this.encoding = string.substring(2);
        } else if (string.startsWith("-o")) {
            this.overwritesource = true;
        } else if (string.startsWith("-d")) {
            DEBUG = true;
            TESTING_LEVEL = true;
            this.overwritesource = false;
        }
    }

    public String formatSource(String string, String[] stringArray) {
        String string2;
        Env env = new Env();
        try {
            string2 = this.format(string, env);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            stringArray[0] = "format error:" + exception;
            return this.cs().toString();
        }
        stringArray[0] = env.indent != 0 ? "indent not correct" : null;
        return string2;
    }

    public void formatFile(String string) {
        try {
            Env env = new Env();
            if (DEBUG) {
                this.debug = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("debug.log"), "utf8"));
            }
            if (DEBUG) {
                this.debug.write("read " + string + "\n");
            }
            String string2 = FileUtil.readString(new FileInputStream(string), this.encoding);
            try {
                byte[] byArray;
                String string3 = this.format(string2, env);
                if (env.indent != 0) {
                    env.indent = 0;
                    throw new RuntimeException("indent not correct:" + string);
                }
                Object object = this.format(string3, new Env());
                byte[] byArray2 = string3.getBytes(this.encoding);
                if (byArray2.length != (byArray = ((String)object).getBytes(this.encoding)).length) {
                    FileUtil.save(byArray2, string + ".fmt-err1.lua");
                    FileUtil.save(byArray, string + ".fmt-err2.lua");
                    byte[] byArray3 = FileUtil.read(new FileInputStream(string + ".fmt-err1.lua"));
                    System.out.printf("bs1 vs bs3(after wrote),len %d vs %d\n", byArray2.length, byArray3.length);
                    int n = Math.min(byArray2.length, byArray.length);
                    for (int i = 0; i < n; ++i) {
                        if (byArray2[i] == byArray[i]) continue;
                        System.out.printf("pos %,d not match:%x vs %x, '%s' vs '%s'\n", i, byArray2[i], byArray[i], new String(byArray2, i, 10), new String(byArray, i, 10));
                        break;
                    }
                    Etc.panic(String.format("reformat not test ok, size  %,d -> %,d , fn:%s, debug[%x %x %x %x]", byArray2.length, byArray.length, string, byArray2[0], byArray[0], byArray2[byArray2.length - 1], byArray[byArray.length - 1]));
                }
                if (string2.equals(string3)) {
                    ++this.skip;
                } else {
                    object = new File(string + (this.overwritesource ? "" : ".fmt.lua"));
                    FileUtil.save(string3.getBytes(this.encoding), ((File)object).getAbsolutePath());
                    if (DEBUG) {
                        System.out.println("wrote to " + ((File)object).getAbsolutePath());
                    }
                    ++this.ok;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                File file = new File(string + ".fmt-err.lua");
                FileUtil.save(this.cs().toString().getBytes(this.encoding), file.getAbsolutePath());
                System.out.println("wrote to " + file.getAbsolutePath());
                ++this.err;
            }
            if (DEBUG) {
                this.debug.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.printf("when formatting [%s]\n", string);
        }
    }

    StringBuilder cs() {
        if (this.inPrint) {
            return this.sbPrint;
        }
        return this.sb;
    }

    public String format(String string, Env env) throws Exception {
        this.sb = new StringBuilder();
        this.sbPrint = new StringBuilder();
        this.tokens = new LuaTokens(string);
        this.loop(null, null, null, env, 0);
        return this.cs().toString();
    }

    private void loop(LuaTokenType luaTokenType, String string, LuaTokenType luaTokenType2, Env env, int n) throws Exception {
        Object[] objectArray;
        env.lastType = luaTokenType;
        while ((objectArray = this.tokens.next()) != null) {
            LuaTokenType luaTokenType3 = (LuaTokenType)((Object)objectArray[0]);
            String string2 = (String)objectArray[1];
            if (string2 == null) break;
            if (luaTokenType3.equals((Object)LuaTokenType.COMMENT)) continue;
            if (luaTokenType3.equals((Object)LuaTokenType.SPACE)) {
                string2 = " ";
            }
            this.addToken(luaTokenType3, string2, env);
            boolean bl = LuaTokenType.OPERATOR.equals((Object)luaTokenType2);
            if (string != null) {
                if (string.equals(")")) {
                    if (bl && string2.equals("(")) {
                        ++n;
                    } else if (bl && string2.equals(")")) {
                        --n;
                    }
                } else if (string.equals("until")) {
                    if (bl && string2.equals("repeat")) {
                        ++n;
                    } else if (bl && string2.equals("until")) {
                        --n;
                    }
                } else {
                    throw new RuntimeException("unknown 'until word':" + string);
                }
            }
            if (n != 0 || !bl || !string2.equals(string)) continue;
            break;
        }
    }

    private void addToken(LuaTokenType luaTokenType, String string, Env env) throws Exception {
        env.forcedChangeLine = false;
        if (luaTokenType.equals((Object)LuaTokenType.COMMENT)) {
            return;
        }
        if (luaTokenType.equals((Object)LuaTokenType.SPACE)) {
            return;
        }
        if (luaTokenType.equals((Object)LuaTokenType.IDENTIFIER)) {
            if ("end".equals(string)) {
                String string2 = this.decIndent(env);
                this.printToken(env, string, luaTokenType);
            } else if ("else".equals(string)) {
                String string3 = this.decIndent(env);
                this.printToken(env, string, luaTokenType);
                this.incIndent(env, string3);
            } else if ("elseif".equals(string)) {
                String string4 = this.decIndent(env);
                this.printToken(env, string, luaTokenType);
            } else if ("until".equals(string)) {
                this.decIndent(env);
                this.printToken(env, string, luaTokenType);
            } else if ("do".equals(string)) {
                this.printToken(env, string, luaTokenType);
                this.incIndent(env, string);
            } else if ("local".equals(string)) {
                this.printToken(env, string, luaTokenType);
            } else if ("if".equals(string)) {
                this.printToken(env, string, luaTokenType);
            } else if ("then".equals(string)) {
                this.printToken(env, string, luaTokenType);
                this.incIndent(env, string);
            } else if ("function".equals(string)) {
                this.printToken(env, string, luaTokenType);
                env.changedLine = 0;
                this.loop(luaTokenType, ")", LuaTokenType.OPERATOR, env, 0);
                this.incIndent(env, string);
            } else if ("while".equals(string)) {
                this.printToken(env, string, luaTokenType);
            } else if ("for".equals(string)) {
                this.printToken(env, string, luaTokenType);
            } else if ("print".equals(string)) {
                this.inPrint = true;
                this.printToken(env, string, luaTokenType);
                this.loop(luaTokenType, ")", LuaTokenType.OPERATOR, env, 0);
                this.inPrint = false;
            } else if ("repeat".equals(string)) {
                this.printToken(env, string, luaTokenType);
                this.incIndent(env, string);
                this.loop(luaTokenType, "until", LuaTokenType.IDENTIFIER, env, 1);
            } else {
                this.printToken(env, string, luaTokenType);
            }
        } else if (luaTokenType.equals((Object)LuaTokenType.OPERATOR)) {
            if (string.equals(".")) {
                this.cs().append(string);
            } else if ("}])".indexOf(string) >= 0) {
                this.decIndent(env);
                this.printToken(env, string, luaTokenType);
            } else if ("{[(".indexOf(string) >= 0) {
                this.printToken(env, string, luaTokenType);
                this.incIndent(env, string);
            } else {
                if (string.equals(";")) {
                    return;
                }
                this.printToken(env, string, luaTokenType);
            }
        } else if (luaTokenType.equals((Object)LuaTokenType.STRING)) {
            this.printToken(env, string, luaTokenType);
        } else {
            throw new RuntimeException("unknow type:" + luaTokenType);
        }
        env.lastType = luaTokenType;
        env.lastToken = string;
    }

    private void printToken(Env env, String string, LuaTokenType luaTokenType) {
        if (LuaTokenType.IDENTIFIER.equals((Object)luaTokenType) && LuaTokenType.IDENTIFIER.equals((Object)env.lastType)) {
            this.addSpace(env);
        }
        this.cs().append(string);
    }

    private void incIndent(Env env, String string) {
        ++env.indent;
        env.stack.push(string);
    }

    private void addSpace(Env env) {
        char c;
        int n = this.cs().length();
        while (n > 0 && ((c = this.cs().charAt(n - 1)) == ' ' || c == '\t' || c == '\n')) {
            this.cs().setLength(--n);
        }
        this.cs().append(" ");
        env.lastType = LuaTokenType.SPACE;
    }

    private String decIndent(Env env) {
        --env.indent;
        return (String)env.stack.pop();
    }

    static class Env {
        LuaTokenType lastType = LuaTokenType.SPACE;
        int indent;
        int changedLine;
        String lastToken;
        boolean forcedChangeLine;
        Stack stack = new Stack();

        Env() {
        }
    }
}

