/*
 * Decompiled with CFR 0.152.
 */
package neoe.formatter.lua;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import neoe.formatter.lua.LuaTokenType;
import neoe.formatter.lua.LuaTokens;
import neoe.util.Etc;
import neoe.util.FileIterator;
import neoe.util.FileUtil;

@Deprecated
public class LuaFormatter3 {
    private static final String FIRST = "!";
    private static boolean TESTING_LEVEL = false;
    private static boolean DEBUG = false;
    List<String> fs = new ArrayList<String>();
    private String encoding = "utf8";
    private boolean overwritesource = false;
    boolean sortFunctions = true;
    private Writer debug;
    private int err;
    private int ok;
    private int skip;
    LuaTokens tokens;
    Map<String, StringBuilder> sections;
    String sect;
    LinkedList<Object[]> peekBuf = new LinkedList();

    public static void main(String[] stringArray) throws Exception {
        throw new RuntimeException("implement fail: (1) local function need order, (2) return xxx in first scope should be last one. so don't sort functions currently");
    }

    private static void usage() {
        System.out.println("luaformatter: args:\n -o  -- overwrite source\n -e<ENCODING> -- use ENCODING\n -d -- debug\n  input-files\n");
    }

    StringBuilder cs() {
        StringBuilder stringBuilder = this.sections.get(this.sect);
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
            this.sections.put(this.sect, stringBuilder);
        }
        return stringBuilder;
    }

    public void run(String[] stringArray) throws Exception {
        for (String string : stringArray) {
            if (string.startsWith("-")) {
                this.doOpt(string);
                continue;
            }
            this.addFile(string);
        }
        if (this.fs.isEmpty()) {
            System.out.println("no input files");
        } else {
            for (String string : this.fs) {
                this.formatFile(string);
            }
        }
        System.out.printf("OK: %d, Error:%d, skip: %d\n", this.ok, this.err, this.skip);
    }

    private void addFile(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            for (File file2 : new FileIterator(string)) {
                String string2 = file2.getName();
                if (!string2.endsWith(".lua") || string2.endsWith(".fmt.lua") || string2.endsWith(".fmt-err.lua")) continue;
                this.fs.add(file2.getAbsolutePath());
            }
        } else if (file.isFile()) {
            this.fs.add(string);
        }
    }

    private void doOpt(String string) {
        if (string.startsWith("-e")) {
            this.encoding = string.substring(2);
        } else if (string.startsWith("-o")) {
            this.overwritesource = true;
        } else if (string.startsWith("-d")) {
            DEBUG = true;
            TESTING_LEVEL = true;
            this.overwritesource = false;
        }
    }

    public String formatSource(String string, String[] stringArray) {
        String string2;
        Env env = new Env();
        try {
            string2 = this.format(string, env);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            stringArray[0] = "format error:" + exception;
            return this.cs().toString();
        }
        stringArray[0] = env.indent != 0 ? "indent not correct" : null;
        return string2;
    }

    public void formatFile(String string) {
        try {
            Env env = new Env();
            if (DEBUG) {
                this.debug = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("debug.log"), "utf8"));
            }
            if (DEBUG) {
                this.debug.write("read " + string + "\n");
            }
            String string2 = FileUtil.readString(new FileInputStream(string), this.encoding);
            try {
                byte[] byArray;
                String string3 = this.format(string2, env);
                if (env.indent != 0) {
                    env.indent = 0;
                    throw new RuntimeException("indent not correct:" + string);
                }
                Object object = this.format(string3, new Env());
                byte[] byArray2 = string3.getBytes(this.encoding);
                if (byArray2.length != (byArray = ((String)object).getBytes(this.encoding)).length) {
                    FileUtil.save(byArray2, string + ".fmt-err1.lua");
                    FileUtil.save(byArray, string + ".fmt-err2.lua");
                    byte[] byArray3 = FileUtil.read(new FileInputStream(string + ".fmt-err1.lua"));
                    System.out.printf("bs1 vs bs3(after wrote),len %d vs %d\n", byArray2.length, byArray3.length);
                    int n = Math.min(byArray2.length, byArray.length);
                    for (int i = 0; i < n; ++i) {
                        if (byArray2[i] == byArray[i]) continue;
                        System.out.printf("pos %,d not match:%x vs %x, '%s' vs '%s'\n", i, byArray2[i], byArray[i], new String(byArray2, i, 10), new String(byArray, i, 10));
                        break;
                    }
                    Etc.panic(String.format("reformat not test ok, size  %,d -> %,d , fn:%s, debug[%x %x %x %x]", byArray2.length, byArray.length, string, byArray2[0], byArray[0], byArray2[byArray2.length - 1], byArray[byArray.length - 1]));
                }
                if (string2.equals(string3)) {
                    ++this.skip;
                } else {
                    object = new File(string + (this.overwritesource ? "" : ".fmt.lua"));
                    FileUtil.save(string3.getBytes(this.encoding), ((File)object).getAbsolutePath());
                    if (DEBUG) {
                        System.out.println("wrote to " + ((File)object).getAbsolutePath());
                    }
                    ++this.ok;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                File file = new File(string + ".fmt-err.lua");
                FileUtil.save((this.sect + "\n" + this.cs().toString()).getBytes(this.encoding), file.getAbsolutePath());
                System.out.println("wrote to " + file.getAbsolutePath());
                ++this.err;
            }
            if (DEBUG) {
                this.debug.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.printf("when formatting [%s]\n", string);
        }
    }

    public String format(String string, Env env) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        this.tokens = new LuaTokens(string);
        this.sect = FIRST;
        this.sections = new HashMap<String, StringBuilder>();
        this.loop(null, null, null, env);
        this.merge(stringBuilder);
        return stringBuilder.toString();
    }

    private void merge(StringBuilder stringBuilder) {
        ArrayList<String> arrayList = new ArrayList<String>(this.sections.keySet());
        Collections.sort(arrayList);
        System.out.println("[");
        for (Object e : arrayList) {
            System.out.println("add " + e);
            stringBuilder.append((CharSequence)this.sections.get(e));
        }
        System.out.println("]");
    }

    private void loop(LuaTokenType luaTokenType, String string, LuaTokenType luaTokenType2, Env env) throws Exception {
        Object[] objectArray;
        env.lastType = luaTokenType;
        this.addSpaceOnNeed(env);
        while ((objectArray = this.tokens.next()) != null) {
            LuaTokenType luaTokenType3 = (LuaTokenType)((Object)objectArray[0]);
            String string2 = (String)objectArray[1];
            if (string2 == null) break;
            if (DEBUG) {
                this.debug.write(String.format("t:%s,v:%s\n", new Object[]{luaTokenType3, string2}));
                this.debug.flush();
            }
            this.addToken(luaTokenType3, string2, env);
            if ((!LuaTokenType.OPERATOR.equals((Object)luaTokenType2) || string2.indexOf(string) < 0) && (string == null || !string2.equals(string))) continue;
            break;
        }
    }

    private void addToken(LuaTokenType luaTokenType, String string, Env env) throws Exception {
        env.forcedChangeLine = false;
        if (luaTokenType.equals((Object)LuaTokenType.COMMENT)) {
            this.pre(env);
            if (this.isMultiLineToken(string)) {
                this.cs().append(string);
            } else {
                this.cs().append(this.normalComment(string.trim()));
            }
        } else if (luaTokenType.equals((Object)LuaTokenType.SPACE)) {
            int n = this.printSpaceLines(env, string);
            if (n <= 0) {
                this.addSpaceOnNeed(env);
            } else {
                env.changedLine = n;
            }
        } else if (luaTokenType.equals((Object)LuaTokenType.IDENTIFIER)) {
            if ("end".equals(string)) {
                String string2 = this.decIndent(env);
                this.changeLineOnNeed(env);
                this.printToken(env, string);
                this.changeLineOnNeed(env);
                if ("function".equals(string2)) {
                    this.cs().append("\n");
                    ++env.changedLine;
                    if (env.stack.isEmpty()) {
                        this.sect = FIRST;
                    }
                }
            } else if ("else".equals(string)) {
                String string3 = this.decIndent(env);
                this.changeLineOnNeed(env);
                this.printToken(env, string);
                this.incIndent(env, string3);
                this.changeLineOnNeed(env);
            } else if ("elseif".equals(string)) {
                this.changeLineOnNeed(env);
                String string4 = this.decIndent(env);
                this.printToken(env, string);
            } else if ("until".equals(string)) {
                this.decIndent(env);
                this.printToken(env, string);
            } else if ("do".equals(string)) {
                this.printToken(env, string);
                this.incIndent(env, string);
                this.changeLineOnNeed(env);
            } else if ("local".equals(string)) {
                if (env.stack.isEmpty()) {
                    if (this.isFunction(this.peekNext())) {
                        this.sect = "@" + this.peekFunctionName();
                    }
                    this.unPeek();
                }
                this.changeLineOnNeed(env);
                this.printToken(env, string);
            } else if ("if".equals(string)) {
                this.changeLineOnNeed(env);
                this.printToken(env, string);
            } else if ("then".equals(string)) {
                this.printToken(env, string);
                this.forceChangeLine(env);
                this.incIndent(env, string);
            } else if ("function".equals(string)) {
                if (env.stack.isEmpty()) {
                    if (this.sect.equals(FIRST)) {
                        this.sect = this.peekFunctionName();
                    } else if (!this.sect.startsWith("@")) {
                        throw new RuntimeException("bug");
                    }
                    this.unPeek();
                }
                this.printToken(env, string);
                env.changedLine = 0;
                this.loop(luaTokenType, ")", LuaTokenType.OPERATOR, env);
                this.forceChangeLine(env);
                this.incIndent(env, string);
            } else if ("while".equals(string)) {
                this.changeLineOnNeed(env);
                this.printToken(env, string);
            } else if ("for".equals(string)) {
                this.changeLineOnNeed(env);
                this.printToken(env, string);
            } else if ("print".equals(string)) {
                this.changeLineOnNeed(env);
                this.printToken(env, string);
            } else if ("repeat".equals(string)) {
                this.changeLineOnNeed(env);
                this.printToken(env, string);
                this.forceChangeLine(env);
                this.incIndent(env, string);
                this.loop(luaTokenType, "until", null, env);
            } else {
                this.printToken(env, string);
            }
        } else if (luaTokenType.equals((Object)LuaTokenType.OPERATOR)) {
            if (string.equals(".")) {
                this.cs().append(string);
            } else if ("}])".indexOf(string) >= 0) {
                this.decIndent(env);
                this.printToken(env, string);
            } else if ("{[(".indexOf(string) >= 0) {
                this.printToken(env, string);
                this.incIndent(env, string);
            } else if (string.equals(";")) {
                if (env.changedLine <= 0) {
                    this.newline();
                    env.forcedChangeLine = true;
                    env.changedLine = 1;
                } else if (!env.lastType.equals((Object)LuaTokenType.SPACE)) {
                    if (env.changedLine <= 0) {
                        this.cs().append(" ");
                    }
                    luaTokenType = LuaTokenType.SPACE;
                }
            } else {
                this.printToken(env, string);
            }
        } else {
            this.printToken(env, string);
        }
        env.lastType = luaTokenType;
        env.lastToken = string;
    }

    private void unPeek() {
        this.tokens.buffer.addAll(this.peekBuf);
        this.peekBuf.clear();
    }

    private String peekFunctionName() {
        Object[] objectArray = this.peekNext();
        this.confirmIdentifier(objectArray);
        Object[] objectArray2 = this.peekNext();
        if (this.isMaohao(objectArray2)) {
            Object[] objectArray3 = this.peekNext();
            this.confirmIdentifier(objectArray3);
            return objectArray[1] + ":" + objectArray3[1];
        }
        return (String)objectArray[1];
    }

    private boolean isMaohao(Object[] objectArray) {
        LuaTokenType luaTokenType = (LuaTokenType)((Object)objectArray[0]);
        String string = (String)objectArray[1];
        return luaTokenType.equals((Object)LuaTokenType.OPERATOR) && ":".equals(string);
    }

    private void confirmIdentifier(Object[] objectArray) {
        LuaTokenType luaTokenType = (LuaTokenType)((Object)objectArray[0]);
        if (!luaTokenType.equals((Object)LuaTokenType.IDENTIFIER)) {
            throw new RuntimeException("Unexpected Identifier:" + objectArray[0] + "," + objectArray[1]);
        }
    }

    private boolean isFunction(Object[] objectArray) {
        LuaTokenType luaTokenType = (LuaTokenType)((Object)objectArray[0]);
        String string = (String)objectArray[1];
        return luaTokenType.equals((Object)LuaTokenType.IDENTIFIER) && "function".equals(string);
    }

    private Object[] peekNext() {
        Object[] objectArray;
        LuaTokenType luaTokenType;
        do {
            if ((objectArray = this.tokens.next()) == null) {
                return null;
            }
            this.peekBuf.add(objectArray);
        } while ((luaTokenType = (LuaTokenType)((Object)objectArray[0])).equals((Object)LuaTokenType.COMMENT) || luaTokenType.equals((Object)LuaTokenType.SPACE));
        return objectArray;
    }

    private void printToken(Env env, String string) {
        this.pre(env);
        this.cs().append(string);
    }

    private int printSpaceLines(Env env, String string) {
        int n = 0;
        for (char c : string.toCharArray()) {
            if (c != '\n') continue;
            if (n >= env.changedLine) {
                this.newline();
            }
            ++n;
        }
        return n;
    }

    private void pre(Env env) {
        if (env.changedLine > 0) {
            this.printIndent(env);
            env.changedLine = 0;
        } else {
            this.addSpaceOnNeed(env);
        }
    }

    private String normalComment(String object) {
        if (((String)object).startsWith("--") && ((String)object).length() > 2 && ((String)object).charAt(2) != ' ' && ((String)object).charAt(2) != '-') {
            object = "-- " + ((String)object).substring(2);
        }
        return object;
    }

    private boolean isMultiLineToken(String string) {
        return string.startsWith("--[") && string.endsWith("]");
    }

    private void printIndent(Env env) {
        if (TESTING_LEVEL) {
            this.cs().append("[" + env.indent + "]");
        }
        for (int i = 0; i < env.indent; ++i) {
            this.cs().append("\t");
        }
    }

    private void incIndent(Env env, String string) {
        ++env.indent;
        env.stack.push(string);
    }

    private void changeLineOnNeed(Env env) {
        if (env.changedLine <= 0) {
            this.newline();
            env.forcedChangeLine = true;
            env.changedLine = 1;
        }
    }

    private void newline() {
        char c;
        int n = this.cs().length();
        while (n > 0 && ((c = this.cs().charAt(n - 1)) == ' ' || c == '\t')) {
            this.cs().setLength(--n);
        }
        this.cs().append("\n");
    }

    private void forceChangeLine(Env env) {
        this.newline();
        env.forcedChangeLine = true;
        env.changedLine = 1;
    }

    private String decIndent(Env env) {
        --env.indent;
        return (String)env.stack.pop();
    }

    private void addSpaceOnNeed(Env env) {
        if (env.lastType != null && !LuaTokenType.SPACE.equals((Object)env.lastType) && !".".equals(env.lastToken) && env.changedLine <= 0) {
            this.cs().append(" ");
            env.lastType = LuaTokenType.SPACE;
            env.changedLine = 0;
        }
    }

    static class Env {
        LuaTokenType lastType = LuaTokenType.SPACE;
        int indent;
        int changedLine;
        String lastToken;
        boolean forcedChangeLine;
        Stack stack = new Stack();

        Env() {
        }
    }
}

