/*
 * Decompiled with CFR 0.152.
 */
package neoe.formatter.lua;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import neoe.formatter.lua.LuaTokenType;
import neoe.formatter.lua.LuaTokens;
import neoe.util.Etc;
import neoe.util.FileIterator;
import neoe.util.FileUtil;

public class LuaFormatter {
    private static boolean TESTING_LEVEL = false;
    private static boolean DEBUG = false;
    List<String> fs = new ArrayList<String>();
    private String encoding = "utf8";
    private boolean overwritesource = false;
    private Writer debug;
    private int err;
    private int ok;
    private int skip;
    StringBuilder sb;
    LuaTokens tokens;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            LuaFormatter.usage();
        } else {
            new LuaFormatter().run(stringArray);
        }
    }

    private static void usage() {
        System.out.println("luaformatter: args:\n -o  -- overwrite source\n -e<ENCODING> -- use ENCODING\n -d -- debug\n  input-files\n");
    }

    public void run(String[] stringArray) throws Exception {
        for (String string : stringArray) {
            if (string.startsWith("-")) {
                this.doOpt(string);
                continue;
            }
            this.addFile(string);
        }
        if (this.fs.isEmpty()) {
            System.out.println("no input files");
        } else {
            for (String string : this.fs) {
                this.formatFile(string);
            }
        }
        System.out.printf("OK: %d, Error:%d, skip: %d\n", this.ok, this.err, this.skip);
    }

    private void addFile(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            for (File file2 : new FileIterator(string)) {
                String string2 = file2.getName();
                if (!string2.endsWith(".lua") || string2.endsWith(".fmt.lua") || string2.endsWith(".fmt-err.lua")) continue;
                this.fs.add(file2.getAbsolutePath());
            }
        } else if (file.isFile()) {
            this.fs.add(string);
        }
    }

    private void doOpt(String string) {
        if (string.startsWith("-e")) {
            this.encoding = string.substring(2);
        } else if (string.startsWith("-o")) {
            this.overwritesource = true;
        } else if (string.startsWith("-d")) {
            DEBUG = true;
            TESTING_LEVEL = true;
            this.overwritesource = false;
        }
    }

    public String formatSource(String string) throws Exception {
        Env env = new Env();
        String string2 = this.format(string, env);
        if (env.indent != 0) {
            throw new RuntimeException("indent not correct");
        }
        return string2;
    }

    public void formatFile(String string) {
        try {
            Env env = new Env();
            if (DEBUG) {
                this.debug = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("debug.log"), "utf8"));
            }
            if (DEBUG) {
                this.debug.write("read " + string + "\n");
            }
            String string2 = FileUtil.readString(new FileInputStream(string), this.encoding);
            try {
                byte[] byArray;
                String string3 = this.format(string2, env);
                if (env.indent != 0) {
                    env.indent = 0;
                    throw new RuntimeException("indent not correct:" + string);
                }
                Object object = this.format(string3, new Env());
                byte[] byArray2 = string3.getBytes(this.encoding);
                if (byArray2.length != (byArray = ((String)object).getBytes(this.encoding)).length) {
                    FileUtil.save(byArray2, string + ".fmt-err1.lua");
                    FileUtil.save(byArray, string + ".fmt-err2.lua");
                    byte[] byArray3 = FileUtil.read(new FileInputStream(string + ".fmt-err1.lua"));
                    System.out.printf("bs1 vs bs3(after wrote),len %d vs %d\n", byArray2.length, byArray3.length);
                    int n = Math.min(byArray2.length, byArray.length);
                    for (int i = 0; i < n; ++i) {
                        if (byArray2[i] == byArray[i]) continue;
                        System.out.printf("pos %,d not match:%x vs %x, '%s' vs '%s'\n", i, byArray2[i], byArray[i], new String(byArray2, i, 10), new String(byArray, i, 10));
                        break;
                    }
                    Etc.panic(String.format("reformat not test ok, size  %,d -> %,d , fn:%s, debug[%x %x %x %x]", byArray2.length, byArray.length, string, byArray2[0], byArray[0], byArray2[byArray2.length - 1], byArray[byArray.length - 1]));
                }
                if (string2.equals(string3)) {
                    ++this.skip;
                } else {
                    object = new File(string + (this.overwritesource ? "" : ".fmt.lua"));
                    FileUtil.save(string3.getBytes(this.encoding), ((File)object).getAbsolutePath());
                    if (DEBUG) {
                        System.out.println("wrote to " + ((File)object).getAbsolutePath());
                    }
                    ++this.ok;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                File file = new File(string + ".fmt-err.lua");
                FileUtil.save(this.sb.toString().getBytes(this.encoding), file.getAbsolutePath());
                System.out.println("wrote to " + file.getAbsolutePath());
                ++this.err;
            }
            if (DEBUG) {
                this.debug.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.printf("when formatting [%s]\n", string);
        }
    }

    public String format(String string, Env env) throws Exception {
        this.sb = new StringBuilder();
        this.tokens = new LuaTokens(string);
        this.loop(null, null, null, env);
        return this.sb.toString();
    }

    private void loop(LuaTokenType luaTokenType, String string, LuaTokenType luaTokenType2, Env env) throws Exception {
        Object[] objectArray;
        env.lastType = luaTokenType;
        this.addSpaceOnNeed(env);
        while ((objectArray = this.tokens.next()) != null) {
            LuaTokenType luaTokenType3 = (LuaTokenType)((Object)objectArray[0]);
            String string2 = (String)objectArray[1];
            if (string2 == null) break;
            if (DEBUG) {
                this.debug.write(String.format("t:%s,v:%s\n", new Object[]{luaTokenType3, string2}));
                this.debug.flush();
            }
            this.addToken(luaTokenType3, string2, env);
            if ((!LuaTokenType.OPERATOR.equals((Object)luaTokenType2) || string2.indexOf(string) < 0) && (string == null || !string2.equals(string))) continue;
            break;
        }
    }

    private void addToken(LuaTokenType luaTokenType, String string, Env env) throws Exception {
        env.forcedChangeLine = false;
        if (luaTokenType.equals((Object)LuaTokenType.COMMENT)) {
            this.pre(env);
            if (this.isMultiLineToken(string)) {
                this.sb.append(string);
            } else {
                this.sb.append(this.normalComment(string.trim()));
            }
        } else if (luaTokenType.equals((Object)LuaTokenType.SPACE)) {
            int n = this.printSpaceLines(env, string);
            if (n <= 0) {
                this.addSpaceOnNeed(env);
            } else {
                env.changedLine = n;
            }
        } else if (luaTokenType.equals((Object)LuaTokenType.IDENTIFIER)) {
            if ("end".equals(string)) {
                String string2 = this.decIndent(env);
                this.changeLineOnNeed(env);
                this.printToken(env, string);
                this.changeLineOnNeed(env);
                if ("function".equals(string2)) {
                    this.sb.append("\n");
                    ++env.changedLine;
                }
            } else if ("else".equals(string)) {
                String string3 = this.decIndent(env);
                this.changeLineOnNeed(env);
                this.printToken(env, string);
                this.incIndent(env, string3);
                this.changeLineOnNeed(env);
            } else if ("elseif".equals(string)) {
                this.changeLineOnNeed(env);
                String string4 = this.decIndent(env);
                this.printToken(env, string);
            } else if ("until".equals(string)) {
                this.decIndent(env);
                this.printToken(env, string);
            } else if ("do".equals(string)) {
                this.printToken(env, string);
                this.incIndent(env, string);
                this.changeLineOnNeed(env);
            } else if ("local".equals(string)) {
                this.changeLineOnNeed(env);
                this.printToken(env, string);
            } else if ("if".equals(string)) {
                this.changeLineOnNeed(env);
                this.printToken(env, string);
            } else if ("then".equals(string)) {
                this.printToken(env, string);
                this.forceChangeLine(env);
                this.incIndent(env, string);
            } else if ("function".equals(string)) {
                this.printToken(env, string);
                env.changedLine = 0;
                this.loop(luaTokenType, ")", LuaTokenType.OPERATOR, env);
                this.forceChangeLine(env);
                this.incIndent(env, string);
            } else if ("while".equals(string)) {
                this.changeLineOnNeed(env);
                this.printToken(env, string);
            } else if ("for".equals(string)) {
                this.changeLineOnNeed(env);
                this.printToken(env, string);
            } else if ("print".equals(string)) {
                this.changeLineOnNeed(env);
                this.printToken(env, string);
            } else if ("repeat".equals(string)) {
                this.changeLineOnNeed(env);
                this.printToken(env, string);
                this.forceChangeLine(env);
                this.incIndent(env, string);
                this.loop(luaTokenType, "until", LuaTokenType.IDENTIFIER, env);
            } else {
                if (this.lastClosePair() && "or".equals(string) && "and".equals(string)) {
                    this.forceChangeLine(env);
                }
                this.printToken(env, string);
            }
        } else if (luaTokenType.equals((Object)LuaTokenType.OPERATOR)) {
            if (string.equals(".")) {
                this.sb.append(string);
            } else if ("}])".indexOf(string) >= 0) {
                this.decIndent(env);
                this.printToken(env, string);
            } else if ("{[(".indexOf(string) >= 0) {
                this.printToken(env, string);
                this.incIndent(env, string);
            } else if (string.equals(";")) {
                if (env.changedLine <= 0) {
                    this.newline();
                    env.forcedChangeLine = true;
                    env.changedLine = 1;
                } else if (!env.lastType.equals((Object)LuaTokenType.SPACE)) {
                    if (env.changedLine <= 0) {
                        this.sb.append(" ");
                    }
                    luaTokenType = LuaTokenType.SPACE;
                }
            } else {
                this.printToken(env, string);
            }
        } else {
            this.printToken(env, string);
        }
        env.lastType = luaTokenType;
        env.lastToken = string;
    }

    private boolean lastClosePair() {
        char c;
        int n = this.sb.length();
        while (true) {
            if (n <= 0) {
                return false;
            }
            c = this.sb.charAt(n - 1);
            if (c != ' ' && c != '\t') break;
            --n;
        }
        return c == ')';
    }

    private void printToken(Env env, String string) {
        this.pre(env);
        this.sb.append(string);
    }

    private int printSpaceLines(Env env, String string) {
        int n = 0;
        for (char c : string.toCharArray()) {
            if (c != '\n') continue;
            if (n >= env.changedLine) {
                this.newline();
            }
            ++n;
        }
        return n;
    }

    private void pre(Env env) {
        if (env.changedLine > 0) {
            this.printIndent(env);
            env.changedLine = 0;
        } else {
            this.addSpaceOnNeed(env);
        }
    }

    private String normalComment(String object) {
        if (((String)object).startsWith("--") && ((String)object).length() > 2 && ((String)object).charAt(2) != ' ' && ((String)object).charAt(2) != '-') {
            object = "-- " + ((String)object).substring(2);
        }
        return object;
    }

    private boolean isMultiLineToken(String string) {
        return string.startsWith("--[") && string.endsWith("]");
    }

    private void printIndent(Env env) {
        if (TESTING_LEVEL) {
            this.sb.append("[" + env.indent + "]");
        }
        for (int i = 0; i < env.indent; ++i) {
            this.sb.append("\t");
        }
    }

    private void incIndent(Env env, String string) {
        ++env.indent;
        env.stack.push(string);
    }

    private void changeLineOnNeed(Env env) {
        if (env.changedLine <= 0) {
            this.newline();
            env.forcedChangeLine = true;
            env.changedLine = 1;
        }
    }

    private void newline() {
        int n = this.sb.length();
        while (n > 0) {
            char c = this.sb.charAt(n - 1);
            if (c == ' ' || c == '\t') {
                this.sb.setLength(--n);
                continue;
            }
            if (c != '\n') break;
            return;
        }
        this.sb.append("\n");
    }

    private void forceChangeLine(Env env) {
        this.newline();
        env.forcedChangeLine = true;
        env.changedLine = 1;
    }

    private String decIndent(Env env) {
        --env.indent;
        return (String)env.stack.pop();
    }

    private void addSpaceOnNeed(Env env) {
        if (env.lastType != null && !LuaTokenType.SPACE.equals((Object)env.lastType) && !".".equals(env.lastToken) && env.changedLine <= 0) {
            this.sb.append(" ");
            env.lastType = LuaTokenType.SPACE;
            env.changedLine = 0;
        }
    }

    static class Env {
        LuaTokenType lastType = LuaTokenType.SPACE;
        int indent;
        int changedLine;
        String lastToken;
        boolean forcedChangeLine;
        Stack stack = new Stack();

        Env() {
        }
    }
}

