/*
 * Decompiled with CFR 0.152.
 */
package neoe.formatter.json;

import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Collections;
import neoe.formatter.common.CFormatter;
import neoe.token.Token;
import neoe.token.TokenType;
import neoe.token.Tokens;
import neoe.util.FileUtil;

public class JsonFormatter
extends CFormatter {
    public JsonFormatter() {
        super(false);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = new JsonFormatter().formatSource(FileUtil.readString(new FileInputStream("/home/neoe/Downloads/model.gltf"), null));
        System.out.println(string);
    }

    @Override
    protected Tokens getCTokens(String string) {
        return Tokens.getOtherTokens(null, string, Collections.emptyList(), Arrays.asList("//"), Tokens.regionCommentCAndJava, Tokens::isIdentifierJava);
    }

    @Override
    public String formatSource(String string) throws Exception {
        String string2 = this.format(string);
        if (this.indent != 0) {
            throw new RuntimeException("bug:indent not correct");
        }
        if (this.debugChange) {
            String string3;
            int n = Math.min(string2.length(), string.length());
            for (int i = 0; i < n; ++i) {
                if (string2.charAt(i) == string.charAt(i)) continue;
                this.tokens.p = i;
                break;
            }
            if (!(string3 = new JsonFormatter().format(string2)).equals(string2)) {
                System.out.println("formatter is buggy failed: format a formatted source must have no change.");
            }
        }
        return string2;
    }

    @Override
    protected void addToken(Token token) throws Exception {
        TokenType tokenType = token.type;
        String string = token.token;
        if (tokenType.equals((Object)TokenType.COMMENT)) {
            this.printToken(string);
            if (this.isLineEndComment(token)) {
                this.changedLine = 1;
            }
        } else if (tokenType.equals((Object)TokenType.SPACE)) {
            this.sb.append(" ");
        } else if (tokenType.equals((Object)TokenType.IDENTIFIER)) {
            this.printToken(string);
        } else if (tokenType.equals((Object)TokenType.OPERATOR)) {
            if ("}])".indexOf(string) >= 0) {
                --this.indent;
                this.printToken(string);
            } else if ("{[(".indexOf(string) >= 0) {
                this.printToken(string);
                ++this.indent;
            } else if (string.equals(",")) {
                this.printToken(string);
                this.sb.append('\n');
                this.changedLine = 1;
            } else {
                this.printToken(string);
            }
        } else {
            this.printToken(string);
        }
    }
}

