/*
 * Decompiled with CFR 0.152.
 */
package neoe.formatter.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import neoe.token.Token;
import neoe.token.TokenType;
import neoe.token.Tokens;
import neoe.token.U;

public class CFormatter {
    public int changedLine;
    protected boolean debugChange = true;
    protected boolean inDefineMode = false;
    public int indent;
    protected int inKaku = 0;
    public final boolean isC;
    protected boolean optChangeLine = true;
    protected StringBuilder sb;
    protected int ti = 0;
    protected Tokens tokens;
    List<Token> thetokens;
    Stack<StrWithPos> stack = new Stack();

    public CFormatter() {
        this(true);
    }

    public CFormatter(boolean bl) {
        this.isC = bl;
    }

    String pos() {
        return this.tokens.pos();
    }

    protected void addSpaceOnNeed() {
        if (this.ti == 0) {
            return;
        }
        Token token = this.thetokens.get(this.ti - 1);
        if (token.type.equals((Object)TokenType.SPACE)) {
            return;
        }
        this.sb.append(' ');
        this.changedLine = 0;
    }

    protected void addToken(Token token) throws Exception {
        TokenType tokenType = token.type;
        String string = token.token;
        if (tokenType.equals((Object)TokenType.COMMENT)) {
            this.printToken(string);
            if (this.isLineEndComment(token)) {
                if (this.inDefineMode) {
                    this.inDefineMode = false;
                }
                this.changedLine = 1;
            }
        } else if (tokenType.equals((Object)TokenType.SPACE)) {
            String string2;
            Token token2 = this.nextToken(this.ti);
            if (token2 != null && token2.token.equals("{") && (string2 = this.lastToken()) != null && !this.isLineEndComment(this.lastTokenB()) && !this.inDefineMode) {
                this.sb.append(" {");
                ++this.ti;
                ++this.indent;
                this.changedLine = 0;
                return;
            }
            int n = this.printSpaceLines(string);
            if (this.isC && n > 0 && this.inDefineMode) {
                if (n > 1) {
                    this.inDefineMode = false;
                } else if (n == 1) {
                    this.inDefineMode = this.lastTokenIs("\\");
                }
            }
        } else if (tokenType.equals((Object)TokenType.IDENTIFIER)) {
            if (this.isC && U.isNumber(string) && this.lastTokenIs("%")) {
                this.sb.append(string);
            } else {
                this.printToken(string);
            }
            if (this.isC && "define".equals(string) && this.tokens.lastTokenCannotIgnoreIs("#", 0)) {
                this.inDefineMode = true;
            }
        } else if (tokenType.equals((Object)TokenType.OPERATOR)) {
            if (string.equals(".")) {
                if (U.isNumber(this.lastToken())) {
                    this.sb.append(string);
                } else {
                    this.printToken(string);
                }
            } else if ("(".equals(string) && this.inDefineMode) {
                this.sb.append(string);
                ++this.inKaku;
                ++this.indent;
            } else if ("}])".indexOf(string.substring(0, 1)) >= 0) {
                --this.indent;
                this.printToken(string);
                if (")".equals(string.substring(0, 1))) {
                    --this.inKaku;
                    int n = this.nextTokenNotSpaceIs("{");
                    if (n >= 0 && !this.inDefineMode) {
                        this.sb.append(" {");
                        ++this.indent;
                        this.ti = n;
                        this.changedLine = 0;
                        Token token3 = this.nextToken(this.ti);
                        if (token3 != null) {
                            Token token4;
                            if (token3.isSpace() && !token3.token.contains("\n") && this.isLineEndComment(token4 = this.nextToken(this.ti + 1))) {
                                this.sb.append(' ').append(token4.token);
                                this.ti += 2;
                                this.changedLine = 1;
                                return;
                            }
                            if (this.isLineEndComment(token3)) {
                                this.sb.append(' ').append(token3.token);
                                ++this.ti;
                                this.changedLine = 1;
                                return;
                            }
                        }
                    }
                }
            } else if ("{[(".indexOf(string) >= 0) {
                this.printToken(string);
                ++this.indent;
                if ("(".equals(string)) {
                    ++this.inKaku;
                }
            } else if (string.equals(";")) {
                this.printToken(string);
                if (this.inDefineMode || this.inKaku > 0) {
                    return;
                }
                if (!this.optChangeLine) {
                    return;
                }
                Token token5 = this.nextToken(this.ti);
                if (this.isLineEndComment(token5)) {
                    this.sb.append(' ').append(token5.token);
                    this.changedLine = 1;
                    ++this.ti;
                    return;
                }
                Token token6 = this.nextToken(this.ti + 1);
                if (token5 != null && token5.type.equals((Object)TokenType.SPACE) && !token5.token.contains("\n") && this.isLineEndComment(token6)) {
                    this.ti += 2;
                    this.sb.append(' ').append(token6.token);
                    this.changedLine = 1;
                    return;
                }
                if (token5 != null && token5.type.equals((Object)TokenType.SPACE) && token5.token.contains("\n")) {
                    ++this.ti;
                    this.printSpaceLines(token5.token);
                    return;
                }
                this.sb.append('\n');
                this.changedLine = 1;
            } else if (string.equals("#")) {
                this.printToken(string);
                this.inDefineMode = true;
            } else {
                this.printToken(string);
            }
        } else if (this.isC && tokenType.equals((Object)TokenType.STRING) && this.sb.charAt(this.sb.length() - 1) == 'L') {
            this.sb.append(string);
        } else {
            this.printToken(string);
        }
    }

    public void parseTokens(Tokens tokens) {
        Token token;
        if (this.thetokens != null) {
            System.out.println("dont call tokens parse twice");
            return;
        }
        this.thetokens = new ArrayList<Token>();
        while ((token = tokens.next()) != null) {
            this.thetokens.add(token);
            this.pairCheck(token);
        }
        this.pairCheckEnd();
    }

    void pairCheck(Token token) {
        if (token.type.equals((Object)TokenType.OPERATOR)) {
            String string = token.token;
            String string2 = string.substring(0, 1);
            if ("{[(".contains(string)) {
                this.stack.push(new StrWithPos(string, this.pos()));
            } else if ("}])".contains(string2)) {
                if (this.stack.isEmpty()) {
                    U.panic(String.format("pair '%s' fail to find pre at %s", string, this.pos()));
                }
                StrWithPos strWithPos = this.stack.pop();
                if ("{[(".indexOf(strWithPos.s) != "}])".indexOf(string2)) {
                    String string3 = String.format("not pair '%s' at %s with '%s' at %s", strWithPos.s, strWithPos.pos, string, this.pos());
                    U.panic(string3);
                }
            }
        }
    }

    void pairCheckEnd() {
        if (!this.stack.isEmpty()) {
            StrWithPos strWithPos = this.stack.pop();
            U.panic(String.format("pair not closed:%s at %s", strWithPos.s, strWithPos.pos));
        }
    }

    public String format(String string) throws Exception {
        this.sb = new StringBuilder();
        this.tokens = this.getCTokens(string);
        this.parseTokens(this.tokens);
        this.ti = 0;
        int n = this.thetokens.size();
        while (this.ti < n) {
            Token token = this.thetokens.get(this.ti);
            this.addToken(token);
            ++this.ti;
        }
        return this.sb.toString();
    }

    public String formatSource(String string) throws Exception {
        String string2 = this.format(string);
        if (this.indent != 0) {
            throw new RuntimeException("bug:indent not correct");
        }
        if (this.debugChange) {
            String string3;
            int n = Math.min(string2.length(), string.length());
            for (int i = 0; i < n; ++i) {
                if (string2.charAt(i) == string.charAt(i)) continue;
                this.tokens.p = i;
                break;
            }
            if (!(string3 = new CFormatter(this.isC).format(string2)).equals(string2)) {
                System.out.println("formatter is buggy failed: format a formatted source must have no change.");
            }
        }
        return string2;
    }

    protected Tokens getCTokens(String string) {
        if (this.isC) {
            return Tokens.getCTokens(string);
        }
        return Tokens.getJavaTokens(string);
    }

    protected boolean isLineEndComment(Token token) {
        return this.tokens.isLineEndComment(token);
    }

    protected String lastToken() {
        if (this.ti == 0) {
            return null;
        }
        return this.thetokens.get((int)(this.ti - 1)).token;
    }

    protected Token lastTokenB() {
        if (this.ti == 0) {
            return null;
        }
        return this.thetokens.get(this.ti - 1);
    }

    protected boolean lastTokenIs(String string) {
        return string.equals(this.lastToken());
    }

    protected Token nextToken(int n) {
        if (n < this.thetokens.size() - 1) {
            return this.thetokens.get(n + 1);
        }
        return null;
    }

    protected boolean nextTokenIs(String string) {
        Token token = this.nextToken(this.ti);
        if (token == null) {
            return false;
        }
        return token.token.equals(string);
    }

    protected int nextTokenNotSpace() {
        int n = this.ti + 1;
        int n2 = this.thetokens.size();
        if (n >= n2) {
            return -1;
        }
        while (n < n2) {
            Token token = this.thetokens.get(n);
            if (token.type.equals((Object)TokenType.SPACE)) {
                ++n;
                continue;
            }
            return n;
        }
        return -1;
    }

    protected int nextTokenNotSpaceIs(String string) {
        int n = this.ti + 1;
        int n2 = this.thetokens.size();
        if (n >= n2) {
            return -1;
        }
        while (n < n2) {
            Token token = this.thetokens.get(n);
            if (token.type.equals((Object)TokenType.SPACE)) {
                ++n;
                continue;
            }
            if (token.token.equals(string)) {
                return n;
            }
            return -1;
        }
        return -1;
    }

    protected void printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.sb.append("\t");
        }
    }

    protected int printSpaceLines(String string) {
        int n = 2;
        if (this.lastTokenIs("{")) {
            n = 1;
        }
        if (this.nextTokenIs("}")) {
            n = 1;
        }
        if (this.changedLine >= n) {
            return this.changedLine;
        }
        int n2 = 0;
        for (char c : string.toCharArray()) {
            if (c != '\n') continue;
            if (++n2 > this.changedLine) {
                this.sb.append(c);
            }
            if (n2 < n) continue;
            this.changedLine = n2;
            return n2;
        }
        if (this.changedLine == 0 && n2 == 0) {
            this.sb.append(' ');
            return 0;
        }
        if (n2 > 0) {
            this.changedLine = n2;
        }
        return n2;
    }

    protected void printToken(String string) {
        if (this.changedLine > 0) {
            this.printIndent();
            this.changedLine = 0;
        } else {
            this.addSpaceOnNeed();
        }
        this.sb.append(string);
    }

    public static class StrWithPos {
        String pos;
        String s;

        public StrWithPos(String string, String string2) {
            this.s = string;
            this.pos = string2;
        }
    }
}

