/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import neoe.ne.util.FileUtil;

public class PyData {
    static final String VER = "11h22";
    static char EOF = (char)65535;
    private boolean sepByComma;
    private boolean lastIsRN;
    StringBuffer buf = new StringBuffer();
    int lno = 1;
    int pos;
    private boolean useEscape = false;

    public PyData() {
        this.lastIsRN = false;
    }

    public void dump(Object object, Writer writer, String string, boolean bl) throws IOException {
        if (object == null) {
            return;
        }
        if (object instanceof List) {
            if (this.lastIsRN) {
                writer.write(string);
            }
            writer.write("[\n");
            this.lastIsRN = true;
            List list = (List)object;
            int n = 0;
            boolean bl2 = true;
            for (Object e : list) {
                if (this.sepByComma) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        writer.write(" , ");
                    }
                }
                if (bl) {
                    writer.write(String.format(" /*%s*/ ", n++));
                }
                this.dump(e, writer, string + "  ", bl);
            }
            if (!this.lastIsRN) {
                writer.write("\n");
            }
            writer.write(string);
            writer.write("]\n");
            this.lastIsRN = true;
        } else if (object instanceof Map) {
            if (this.lastIsRN) {
                writer.write(string);
            }
            writer.write("{\n");
            this.lastIsRN = true;
            Map map = (Map)object;
            String string2 = string + "  ";
            boolean bl3 = true;
            for (Object k : map.keySet()) {
                writer.write(string2);
                if (this.sepByComma) {
                    if (bl3) {
                        bl3 = false;
                    } else {
                        writer.write(" , ");
                    }
                }
                if (this.sepByComma) {
                    writer.write("\"");
                }
                writer.write(k.toString());
                if (this.sepByComma) {
                    writer.write("\"");
                }
                writer.write(":");
                this.lastIsRN = false;
                this.dump(map.get(k), writer, string2, bl);
                writer.write("\n");
            }
            if (!this.lastIsRN) {
                writer.write("\n");
            }
            writer.write(string);
            writer.write("}\n");
            this.lastIsRN = true;
        } else {
            if (this.lastIsRN) {
                writer.write(string);
            }
            if (this.sepByComma) {
                writer.write("\"");
            } else {
                writer.write("`");
            }
            writer.write(object.toString());
            if (this.sepByComma) {
                writer.write("\"");
            } else {
                writer.write("`");
            }
            writer.write("\t");
            this.lastIsRN = false;
        }
    }

    public PyData(boolean bl, boolean bl2) {
        this.sepByComma = bl;
        this.useEscape = bl2;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("reading file:" + new File(stringArray[0]).getAbsolutePath());
        Object object = PyData.parseAll(FileUtil.readString(new FileInputStream(stringArray[0]), "utf8"), false);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(stringArray[0] + ".format"), "utf8");
        new PyData(true, true).dump(object, outputStreamWriter, "\t", false);
        ((Writer)outputStreamWriter).close();
        System.out.println("saved " + stringArray[0] + ".format");
    }

    public static Object parseAll(String string, boolean bl, boolean bl2) throws Exception {
        Object object = new PyData(bl, bl2).parseAll(new StringReader(string));
        return object;
    }

    public static Object parseAll(String string, boolean bl) throws Exception {
        return PyData.parseAll(string, bl, false);
    }

    String at() {
        return " at line:" + this.lno + " pos:" + this.pos;
    }

    void confirm(char c, char c2) throws Exception {
        if (c2 == ',' && !this.sepByComma) {
            if (c != c2) {
                this.pushBack(c);
            }
        } else if (c != c2) {
            throw new Exception("Expected to read `" + c2 + "` but `" + c + "`(" + c + ") found" + this.at() + ", sep=" + this.sepByComma);
        }
    }

    void confirm(Reader reader, char c) throws Exception {
        char c2 = this.readA(reader);
        this.confirm(c2, c);
    }

    Object parse(Reader reader) throws Exception {
        char c = this.readA(reader);
        if (c == '/') {
            char c2 = this.xread(reader);
            if (c2 == '*') {
                this.skipUtil(reader, "*/");
                c = this.readA(reader);
            } else {
                this.pushBack(c2);
            }
        }
        if (c == EOF) {
            return null;
        }
        if (c == '{') {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            this.readMap(reader, linkedHashMap, '}');
            return linkedHashMap;
        }
        if (c == '[') {
            ArrayList arrayList = new ArrayList();
            this.readList(reader, arrayList, ']');
            return arrayList;
        }
        if (c == '(') {
            ArrayList arrayList = new ArrayList();
            this.readList(reader, arrayList, ')');
            return arrayList;
        }
        if (c == '\"') {
            String string = this.readString(reader, '\"');
            return string;
        }
        if (c == '\'') {
            String string = this.readString(reader, '\'');
            return string;
        }
        if (c == '`') {
            String string = this.readString(reader, '`');
            return string;
        }
        return this.readToken(reader, c);
    }

    public Object parseAll(Reader reader) throws Exception {
        Object object = this.parse(reader);
        char c = this.readA(reader);
        if (c == EOF) {
            reader.close();
            return object;
        }
        reader.close();
        System.err.println("drop char after " + c);
        return object;
    }

    void pushBack(char c) {
        this.buf.append(c);
    }

    char read(Reader reader) throws Exception {
        char c = (char)reader.read();
        if (c == '\n') {
            ++this.lno;
            this.pos = 0;
        } else {
            ++this.pos;
        }
        return c;
    }

    char readA(Reader reader) throws Exception {
        char c;
        block2: {
            char c2;
            c = this.xread(reader);
            while (true) {
                if (c == '\n' || c == '\r' || c == ' ' || c == '\t') {
                    c = this.xread(reader);
                    continue;
                }
                if (c != '/') break block2;
                c2 = this.xread(reader);
                if (c2 != '*') break;
                this.skipUtil(reader, "*/");
                c = this.xread(reader);
            }
            this.pushBack(c2);
            return c;
        }
        return c;
    }

    Object readToken(Reader reader, char c) throws Exception {
        char c2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        while (true) {
            if ((c2 = this.xread(reader)) == EOF || c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == ',' || c2 == '}' || c2 == ')' || c2 == ']' || c2 == ':') break;
            stringBuffer.append(c2);
        }
        this.pushBack(c2);
        return stringBuffer.toString();
    }

    void readList(Reader reader, List list, char c) throws Exception {
        while (true) {
            char c2;
            if ((c2 = this.readA(reader)) == EOF) {
                throw new Exception("Expected to read " + c + " but EOF found" + this.at());
            }
            if (c2 == c) {
                return;
            }
            this.pushBack(c2);
            Object object = this.parse(reader);
            list.add(object);
            c2 = this.readA(reader);
            if (c2 == c) {
                return;
            }
            this.confirm(c2, ',');
        }
    }

    void readMap(Reader reader, Map map, char c) throws Exception {
        while (true) {
            char c2;
            if ((c2 = this.readA(reader)) == EOF) {
                throw new Exception("Expected to read " + c + " but EOF found" + this.at());
            }
            if (c2 == c) {
                return;
            }
            this.pushBack(c2);
            Object object = this.parse(reader);
            this.confirm(reader, ':');
            Object object2 = this.parse(reader);
            map.put(object, object2);
            c2 = this.readA(reader);
            if (c2 == c) {
                return;
            }
            this.confirm(c2, ',');
        }
    }

    String readString(Reader reader, char c) throws Exception {
        char c2;
        StringBuffer stringBuffer = new StringBuffer();
        char c3 = this.xread(reader);
        while (true) {
            if (c3 == c) {
                c2 = this.xread(reader);
                if (c2 == c && (c2 == '\"' || c2 == '\'')) {
                    stringBuffer.append(c2);
                    c3 = this.xread(reader);
                    continue;
                }
                break;
            }
            if (c3 == '\\' && this.useEscape) {
                c3 = this.xread(reader);
                if (c3 == 'n') {
                    c3 = '\n';
                } else if (c3 == 'r') {
                    c3 = '\r';
                } else if (c3 == 't') {
                    c3 = '\t';
                }
            }
            if (c3 == EOF) {
                throw new Exception("Expected to read " + c + " but EOF found" + this.at());
            }
            stringBuffer.append(c3);
            c3 = this.xread(reader);
        }
        this.pushBack(c2);
        return stringBuffer.toString();
    }

    char xread(Reader reader) throws Exception {
        int n = this.buf.length();
        if (n > 0) {
            char c = this.buf.charAt(n - 1);
            this.buf.setLength(n - 1);
            return c;
        }
        return this.read(reader);
    }

    private void skipUtil(Reader reader, String string) throws Exception {
        LoopStringBuffer loopStringBuffer = new LoopStringBuffer(string.length());
        do {
            char c;
            if ((c = this.xread(reader)) == EOF) {
                return;
            }
            loopStringBuffer.add(c);
        } while (!loopStringBuffer.get().equals(string));
    }

    public static Object parseAll(String string) throws Exception {
        return PyData.parseAll(string, false, false);
    }

    public static Object parseFile(String string) throws Exception {
        return PyData.parseAll(FileUtil.readString(new FileInputStream(string), null), false);
    }

    public static class LoopStringBuffer {
        private int[] cs;
        private int p;
        private int size;

        LoopStringBuffer(int n) {
            this.size = n;
            this.p = 0;
            this.cs = new int[n];
        }

        void add(int n) {
            this.cs[this.p++] = (char)n;
            if (this.p >= this.size) {
                this.p = 0;
            }
        }

        public String get() {
            int n = this.p;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.size; ++i) {
                stringBuffer.append((char)this.cs[n++]);
                if (n < this.size) continue;
                n = 0;
            }
            return stringBuffer.toString();
        }
    }
}

