/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne.util;

import java.io.File;
import java.io.IOException;

public class FindJDK {
    private static final boolean DEBUG = false;
    static String osname = System.getProperty("os.name");
    static String osarch;
    public static boolean isWindows;
    public static boolean isMac;
    public static boolean isLinux;
    static boolean isX86;
    private boolean jdk;

    public static void main(String[] stringArray) throws IOException {
        System.out.println("JDK64=" + new FindJDK().find(64, true));
        System.out.println("JRE64=" + new FindJDK().find(64, false));
        System.out.println("JDK32=" + new FindJDK().find(32, true));
        System.out.println("JRE32=" + new FindJDK().find(32, false));
        System.out.println("JDK0=" + new FindJDK().find(0, true));
        System.out.println("JRE0=" + new FindJDK().find(0, false));
    }

    public String find(int n, boolean bl) throws IOException {
        String string = "";
        this.jdk = bl;
        if (isWindows) {
            if (isX86) {
                if (n == 64) {
                    System.out.println("This is Win32 but you need 64bit JDK");
                    return "";
                }
                string = this.searchPath(new String[]{"Program Files/Java/"});
            } else {
                string = n == 32 ? this.searchPath(new String[]{"Program Files (x86)/Java/"}) : (n == 0 ? this.searchPath(new String[]{"Program Files/Java/", "Program Files (x86)/Java/"}) : this.searchPath(new String[]{"Program Files/Java/"}));
            }
        } else {
            string = isMac ? this.searchPath(new String[]{"/Library/Java/JavaVirtualMachines/"}) : this.searchPath(new String[]{"/opt/", "/usr/lib/jvm/", "/usr/java/", "/usr/local/java/"});
        }
        if (string == null || string.isEmpty()) {
            string = System.getenv("JAVA_HOME");
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String searchPath(String[] stringArray) throws IOException {
        Object object = "";
        if (isWindows) {
            object = System.getenv("SystemDrive") + "/";
        }
        String string = "";
        Object object2 = "";
        for (String string2 : stringArray) {
            void object3;
            if (isWindows) {
                String string3 = (String)object + string2;
            }
            FindJDK.debug("search " + (String)object3);
            File file = new File((String)object3);
            if (!file.exists() || !file.isDirectory()) continue;
            for (File file2 : file.listFiles()) {
                String string4;
                boolean bl;
                if (!file2.isDirectory()) continue;
                String string5 = file2.getName().toLowerCase();
                boolean bl2 = this.jdk ? string5.indexOf("jdk") >= 0 || string5.indexOf("java") >= 0 : (bl = string5.indexOf("jdk") >= 0 || string5.indexOf("jre") >= 0 || string5.indexOf("java") >= 0);
                if (!bl) continue;
                FindJDK.debug("check java dir:" + file2.getCanonicalPath());
                boolean bl3 = false;
                bl3 = this.jdk ? (isWindows ? new File(file2, "bin/javac.exe").exists() : (isMac ? new File(file2, "Contents/Home/bin/javac").exists() : new File(file2, "bin/javac").exists())) : (isWindows ? new File(file2, "bin/java.exe").exists() : (isMac ? new File(file2, "Contents/Home/bin/java").exists() : new File(file2, "bin/java").exists()));
                if (!bl3 || (string4 = this.getVersion(file2.getName())).compareTo(string) <= 0) continue;
                string = string4;
                object2 = file2.getCanonicalPath();
                if (!isMac) continue;
                object2 = (String)object2 + "/Contents/Home";
            }
        }
        return object2;
    }

    private static void debug(String string) {
    }

    private String getVersion(String string) {
        int n = -1;
        int n2 = string.length();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || c == '.' || c == '_') {
                if (n != -1) continue;
                n = i;
                continue;
            }
            if (n < 0) continue;
            n2 = i;
            break;
        }
        if (n >= 0 && n2 > n) {
            String string2 = string.substring(n, n2).replace('_', '.');
            String[] stringArray = string2.split("\\.");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < 4; ++i) {
                String string3 = i < stringArray.length ? stringArray[i] : "0";
                stringBuilder.append(String.format("%03d", Integer.parseInt(string3)));
                stringBuilder.append('.');
            }
            String string4 = stringBuilder.toString();
            FindJDK.debug("find version:" + string4 + " on " + string);
            return string4;
        }
        FindJDK.debug("cannot find version on:" + string);
        return "";
    }

    static {
        FindJDK.debug(osname);
        osarch = System.getProperty("os.arch");
        FindJDK.debug(osarch);
        isWindows = osname.indexOf("Windows") >= 0;
        isMac = osname.startsWith("Mac");
        isX86 = osarch.indexOf("x86") >= 0 && System.getenv("ProgramW6432") == null;
        isLinux = !isWindows && !isMac;
    }
}

