/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileUtil {
    private static final String UTF8 = "UTF8";

    public static void copy(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileUtil.copy(fileInputStream, fileOutputStream);
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray)) > 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        bufferedOutputStream.close();
    }

    public static void copy2(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray)) > 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.flush();
    }

    public static BufferedReader getBufferedReader(String string, String string2) throws IOException {
        InputStream inputStream = FileUtil.getFileInputStream(string);
        return new BufferedReader(new InputStreamReader(inputStream, string2));
    }

    public static InputStream getFileInputStream(String string) {
        System.out.println("getFileInputStream:in " + String.valueOf(FileUtil.class.getClassLoader()) + ":" + string);
        InputStream inputStream = FileUtil.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            inputStream = string.startsWith("/") ? FileUtil.class.getClassLoader().getResourceAsStream(string.substring(1)) : FileUtil.class.getClassLoader().getResourceAsStream("/" + string);
        }
        return inputStream;
    }

    public static BufferedReader getRawBufferedReader(String string, String string2) throws UnsupportedEncodingException, FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(string);
        return new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string2));
    }

    public static void pass(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    public static void pass(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        int n;
        byte[] byArray = new byte[16384];
        long l2 = 0L;
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
            if ((l2 += (long)n) < l) continue;
        }
        outputStream.flush();
    }

    public static String readString(InputStream inputStream, String string) throws IOException {
        int n;
        if (string == null) {
            string = UTF8;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        char[] cArray = new char[1000];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = bufferedReader.read(cArray)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static List<String> readStringBig(File file, String string) throws IOException {
        String string2;
        if (string == null) {
            string = UTF8;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            arrayList.add(string2);
        }
        bufferedReader.close();
        return arrayList;
    }

    public static List<String> readStringBig(byte[] byArray, String string) throws IOException {
        String string2;
        if (string == null) {
            string = UTF8;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), string));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            arrayList.add(string2);
        }
        bufferedReader.close();
        return arrayList;
    }

    public static byte[] read(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void save(byte[] byArray, String string) throws IOException {
        File file = new File(string);
        file.getAbsoluteFile().getParentFile().mkdirs();
        File file2 = new File(string + "." + System.currentTimeMillis());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        bufferedOutputStream.write(byArray);
        bufferedOutputStream.close();
        if (file.exists()) {
            file.delete();
        }
        Files.move(file2.toPath(), file.toPath(), new CopyOption[0]);
    }

    public static Iterable<CharSequence> split(final CharSequence charSequence, final char c) {
        return new Iterable<CharSequence>(){

            @Override
            public Iterator<CharSequence> iterator() {
                return new Iterator<CharSequence>(){
                    int p1;

                    @Override
                    public CharSequence next() {
                        int n = -1;
                        for (int i = this.p1; i < charSequence.length(); ++i) {
                            if (charSequence.charAt(i) != c) continue;
                            n = i;
                            break;
                        }
                        if (n == -1) {
                            CharSequence charSequence = charSequence.subSequence(this.p1, charSequence.length());
                            this.p1 = charSequence.length();
                            return charSequence;
                        }
                        CharSequence charSequence = charSequence.subSequence(this.p1, n);
                        this.p1 = n + 1;
                        return charSequence;
                    }

                    @Override
                    public boolean hasNext() {
                        if (charSequence == null) {
                            return false;
                        }
                        return this.p1 < charSequence.length();
                    }
                };
            }
        };
    }

    public static byte[] readBs(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(byArray, n3 + i, n - i);
            if (n2 >= 0) continue;
            throw new EOFException();
        }
        return byArray;
    }
}

