/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import neoe.ne.U;

public class Xcd {
    private String[] selection = new String[1];

    public static String getUserHomeDir() {
        return U.getUserHome();
    }

    public static String readString(InputStream inputStream, String string) throws IOException {
        int n;
        if (string == null) {
            string = "UTF8";
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        char[] cArray = new char[1000];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = bufferedReader.read(cArray)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public String run(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            this.readFromBashHistory(hashSet, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.readFromNeoeeditHistory(hashSet, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hashSet.isEmpty()) {
            System.err.println("no cd entry, quit");
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(hashSet);
        Collections.sort(arrayList);
        System.setProperty("awt.useSystemAAFontSettings", "on");
        String string2 = this.selectFromList(arrayList);
        if (string2 == null) {
            System.err.println("not selected, quit");
            return null;
        }
        return this.doCd(string2);
    }

    private void readFromNeoeeditHistory(Set<String> set, String string) throws IOException {
        String[] stringArray;
        File file = new File(Xcd.getUserHomeDir(), ".neoeedit/dh.txt");
        if (!file.exists()) {
            System.out.println("~/.neoeedit/dh.txt not exists");
            return;
        }
        for (String string2 : stringArray = Xcd.readString(new FileInputStream(file), null).split("\n")) {
            File file2;
            if (!(string2 = string2.trim()).startsWith("/") && !string2.startsWith("~/") || string != null && !string2.toLowerCase().contains(string) || !(file2 = new File(string2)).isDirectory()) continue;
            string2 = file2.getAbsolutePath();
            set.add(string2);
        }
    }

    private void readFromBashHistory(Set<String> set, String string) throws IOException {
        String[] stringArray;
        File file = new File(Xcd.getUserHomeDir(), ".bash_history");
        if (!file.exists()) {
            System.out.println(".bash_history not exists");
            return;
        }
        for (String string2 : stringArray = Xcd.readString(new FileInputStream(file), null).split("\n")) {
            File file2;
            if (!(string2 = string2.trim()).startsWith("cd ") || !(string2 = string2.substring(3).trim()).startsWith("/") && !string2.startsWith("~/") || string != null && !string2.toLowerCase().contains(string) || !(file2 = new File(string2)).isDirectory()) continue;
            string2 = file2.getAbsolutePath();
            set.add(string2);
        }
    }

    private String doCd(String string) {
        System.out.println(string);
        return string;
    }

    private String selectFromList(List<String> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        final JList<Object> jList = new JList<Object>(list.toArray());
        jList.setSelectionMode(0);
        final JDialog jDialog = this.wrapFrame(new JScrollPane(jList), "select dir to cd");
        jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    String string;
                    ((Xcd)Xcd.this).selection[0] = string = (String)jList.getSelectedValue();
                    jDialog.dispose();
                }
            }
        });
        jList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 27) {
                    jDialog.dispose();
                } else if (n == 10) {
                    String string;
                    ((Xcd)Xcd.this).selection[0] = string = (String)jList.getSelectedValue();
                    jDialog.dispose();
                }
            }
        });
        jDialog.setVisible(true);
        jDialog.requestFocus();
        return this.selection[0];
    }

    private JDialog wrapFrame(JComponent jComponent, String string) {
        JDialog jDialog = new JDialog();
        jDialog.setTitle(string);
        jDialog.setModal(true);
        jDialog.add(jComponent);
        jDialog.setDefaultCloseOperation(2);
        jDialog.setSize(400, 600);
        jDialog.setLocationRelativeTo(null);
        return jDialog;
    }
}

