/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import neoe.ne.Commands;
import neoe.ne.Conf;
import neoe.ne.Console;
import neoe.ne.EditorPanel;
import neoe.ne.FontList;
import neoe.ne.MathExprParser;
import neoe.ne.PageData;
import neoe.ne.PlainPage;
import neoe.ne.Plugin;
import neoe.ne.ReadonlyLines;
import neoe.ne.ScriptUtil;
import neoe.ne.Version;
import neoe.ne.Xcd;
import neoe.ne.util.FileUtil;

public class U {
    static final CharSequence EMPTY = "empty";
    static final String NE_ADDTIME = "ne_addtime";
    static float shrinkRate = 0.0f;
    static int shrinkWordLen;
    static int TAB_WIDTH;
    static final Object[][] BOMS;
    static Map<String, Commands> keys;
    static Map<String, Plugin.PluginAction> pluginKeys;
    public static List originKeys;
    static Random random;
    public static Image tabImg;
    public static Image tabImgPrint;
    static final String UTF8 = "UTF8";
    public static final char N = '\n';
    static boolean addTime;
    public static String[] KWS;
    static int idIndex;
    static final int IDRANGE = 46656;
    static String SPACES;
    public static final String e_png = "e.jpg";
    public static final String e2_png = "e2.jpg";
    public static final String e3_png = "e3.jpg";
    public static String TitleName;
    static Map<String, Image> appIcons;
    public static boolean shrinkWord;
    private static Map<Integer, Long> keystime;
    public static int keymintime;

    static Font getFont(String string, float f) throws Exception {
        Font font;
        if (new File(string).isFile()) {
            font = Font.createFont(0, new File(string));
            font = font.deriveFont(f);
        } else {
            font = new Font(string, 0, (int)f);
        }
        return font;
    }

    static void checkChangedOutside(PlainPage plainPage) {
        if (U.changedOutside(plainPage.pageData) && !plainPage.pageData.changedOutside) {
            plainPage.pageData.changedOutside = true;
            if (plainPage.pageData.history.size() == 0) {
                plainPage.pageData.reloadFile();
                U.showSelfDispMessage(plainPage, "File changed outside.(reloaded)", 4000);
                plainPage.pageData.changedOutside = false;
            } else {
                U.showSelfDispMessage(plainPage, "File changed outside.", 4000);
            }
        }
    }

    static EditorPanel newWindow(PlainPage plainPage) throws Exception {
        EditorPanel editorPanel = plainPage.uiComp;
        EditorPanel editorPanel2 = new EditorPanel(editorPanel.config);
        if (editorPanel.desktopPane == null) {
            editorPanel2.openWindow();
        } else {
            JInternalFrame jInternalFrame = new JInternalFrame("ne", true, true, true, true);
            editorPanel2.openWindow(e_png, jInternalFrame, editorPanel.realJFrame, editorPanel.desktopPane);
            editorPanel.desktopPane.add(jInternalFrame);
            jInternalFrame.setVisible(true);
            int n = editorPanel.desktopPane.getAllFrames().length;
            JInternalFrame jInternalFrame2 = (JInternalFrame)editorPanel.frame;
            jInternalFrame.setLocation(jInternalFrame2.getLocation().x + 5 * n, jInternalFrame2.getLocation().y + 5 * n);
            jInternalFrame.setLayer(jInternalFrame2.getLayer());
            jInternalFrame.setSize(jInternalFrame2.getSize());
            jInternalFrame.setSelected(true);
            editorPanel2.userfunc = editorPanel.userfunc;
            if (editorPanel2.userfunc != null) {
                editorPanel2.userfunc.run(jInternalFrame, editorPanel2);
            }
        }
        editorPanel2.page.workPath = plainPage.workPath;
        return editorPanel2;
    }

    public static void save(List<String> list, String string, String string2) throws IOException {
        String string3 = string2 + "." + U.randomID();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string3), 131072);
        boolean bl = false;
        for (String string4 : list) {
            if (bl) {
                ((OutputStream)bufferedOutputStream).write(10);
            } else {
                bl = true;
            }
            ((OutputStream)bufferedOutputStream).write(string4.getBytes(string));
        }
        ((OutputStream)bufferedOutputStream).close();
        File file = new File(string2);
        file.delete();
        new File(string3).renameTo(file);
    }

    public static void setEnv(PlainPage plainPage, String string, String string2) {
        if (plainPage.env == null) {
            plainPage.env = new LinkedHashMap<String, String>(System.getenv());
        }
        Map<String, String> map = plainPage.env;
        if (string2.isEmpty()) {
            map.remove(string);
        } else {
            map.put(string, string2);
        }
        plainPage.envs = null;
    }

    static void drawStringShrink(Graphics2D graphics2D, FontList fontList, String string, int n, int n2, float f) {
        int n3 = Math.round(f);
        int n4 = U.stringWidth(graphics2D, fontList, string, n3);
        if (n4 <= n3) {
            U.drawString(graphics2D, fontList, string, n, n2, n3);
        } else {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.scale((f - 3.0f) / (float)n4, 1.0);
            U.drawString(graphics2D2, fontList, string, n, n2, n3);
            graphics2D2.dispose();
        }
    }

    static String suNotice() {
        String string = System.getProperty("user.name");
        if ("root".equals(string) || "administrator".equalsIgnoreCase(string)) {
            return " [su]";
        }
        return "";
    }

    public static int drawString(Graphics2D graphics2D, FontList fontList, String string, int n, int n2) {
        return U.drawString(graphics2D, fontList, string, n, n2, 8000);
    }

    public static int stringWidth(Graphics2D graphics2D, FontList fontList, String string) {
        return U.stringWidth(graphics2D, fontList, string, 8000);
    }

    public static int drawString(Graphics2D graphics2D, FontList fontList, String string, int n, int n2, int n3) {
        return U.drawString(graphics2D, fontList, string, n, n2, n3, true);
    }

    public static int drawString(Graphics2D graphics2D, FontList fontList, String string, int n, int n2, int n3, boolean bl) {
        if (string == null || string.length() <= 0) {
            return 0;
        }
        int n4 = 0;
        Font font = fontList.font[0];
        StringBuilder stringBuilder = new StringBuilder();
        int n5 = 0;
        Font[] fontArray = new Font[1];
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n6 = U.charWidth(graphics2D, fontList, c, fontArray);
            if (font.equals(fontArray[0])) {
                stringBuilder.append(c);
                n5 += n6;
                continue;
            }
            n5 = U.submitStr(graphics2D, font, stringBuilder.toString(), n, n2, bl);
            n += n5;
            n4 += n5;
            n5 = n6;
            stringBuilder.setLength(0);
            stringBuilder.append(c);
            font = fontArray[0];
            if (n4 <= n3) continue;
            break;
        }
        if (stringBuilder.length() > 0) {
            n5 = U.submitStr(graphics2D, font, stringBuilder.toString(), n, n2, bl);
            n4 += n5;
        }
        return n4;
    }

    public static int exactRemainChar(Graphics2D graphics2D, FontList fontList, String string, int n) {
        if (string == null || string.length() <= 0) {
            return 0;
        }
        n = (int)((float)n / U.getShrinkRate(string));
        int[] nArray = new int[1];
        int n2 = 0;
        Font font = fontList.font[0];
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        int n4 = 0;
        Font[] fontArray = new Font[1];
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n5 = U.charWidth(graphics2D, fontList, c, fontArray);
            if (font.equals(fontArray[0])) {
                stringBuilder.append(c);
                n3 += n5;
                continue;
            }
            n3 = U.submitStrNoDraw(graphics2D, font, stringBuilder.toString(), n - n4, nArray);
            n4 += n3;
            n2 += n3;
            n3 = n5;
            stringBuilder.setLength(0);
            stringBuilder.append(c);
            font = fontArray[0];
            if (n2 <= n) continue;
            break;
        }
        if (stringBuilder.length() > 0) {
            n3 = U.submitStrNoDraw(graphics2D, font, stringBuilder.toString(), n - n4, nArray);
            n2 += n3;
        }
        return nArray[0];
    }

    public static int exactRemainCharWidth(Graphics2D graphics2D, FontList fontList, String string, int n) {
        if (string == null || string.length() <= 0) {
            return 0;
        }
        float f = U.getShrinkRate(string);
        string = string.substring(0, n);
        int[] nArray = new int[1];
        int n2 = 0;
        Font font = fontList.font[0];
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        int n4 = 0;
        Font[] fontArray = new Font[1];
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n5 = U.charWidth(graphics2D, fontList, c, fontArray);
            if (font.equals(fontArray[0])) {
                stringBuilder.append(c);
                n3 += n5;
                continue;
            }
            n3 = U.submitStrNoDraw(graphics2D, font, stringBuilder.toString(), 10000, nArray);
            n4 += n3;
            n2 += n3;
            n3 = n5;
            stringBuilder.setLength(0);
            stringBuilder.append(c);
            font = fontArray[0];
        }
        if (stringBuilder.length() > 0) {
            n3 = U.submitStrNoDraw(graphics2D, font, stringBuilder.toString(), 10000, nArray);
            n2 += n3;
        }
        return Math.round((float)n2 * f);
    }

    static int tryStrWidth(FontMetrics fontMetrics, String string, int n, int n2, int n3, int n4, int n5) {
        if (n2 <= n3) {
            return n3;
        }
        if (n2 >= n4) {
            return n4;
        }
        if (n5 > 32) {
            System.out.println("bug in tryStrWidth()!");
            return n2;
        }
        int n6 = fontMetrics.stringWidth(string.substring(0, n2));
        if (n6 < n) {
            return U.tryStrWidth(fontMetrics, string, n, (n2 + n4) / 2, n2, n4, n5 + 1);
        }
        if (n6 > n) {
            return U.tryStrWidth(fontMetrics, string, n, (n2 + n3) / 2, n3, n2, n5 + 1);
        }
        return n2;
    }

    private static int shrinked(FontMetrics fontMetrics, String string) {
        if (string == null || string.isEmpty()) {
            return 0;
        }
        return Math.round(U.getShrinkRate(string) * (float)fontMetrics.stringWidth(string));
    }

    private static float getShrinkRate(String string) {
        if (string == null || string.isEmpty()) {
            return 1.0f;
        }
        if (!shrinkWord || string.length() < shrinkWordLen) {
            return 1.0f;
        }
        return shrinkRate;
    }

    public static void initShrink() {
        if (shrinkRate <= 0.0f) {
            try {
                shrinkRate = Float.parseFloat(Conf.get("shrinkWordRate", (Object)"0.5").toString());
                shrinkWordLen = Integer.parseInt(Conf.get("shrinkWordLen", (Object)"7").toString());
            }
            catch (Exception exception) {
                shrinkRate = 0.5f;
                shrinkWordLen = 7;
            }
        }
    }

    private static int submitStr(Graphics2D graphics2D, Font font, String string, int n, int n2, boolean bl) {
        if (string.isEmpty()) {
            return 0;
        }
        graphics2D.setFont(font);
        if (bl) {
            U.shrinkDraw(graphics2D, string, n, n2);
        }
        return U.shrinked(graphics2D.getFontMetrics(), string);
    }

    private static void shrinkDraw(Graphics2D graphics2D, String string, int n, int n2) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (!shrinkWord || string.length() < shrinkWordLen) {
            graphics2D.drawString(string, n, n2);
        } else {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.translate(n, n2);
            graphics2D2.scale(shrinkRate, 1.0);
            graphics2D2.drawString(string, 0, 0);
            graphics2D2.dispose();
        }
    }

    private static int submitStrNoDraw(Graphics2D graphics2D, Font font, String string, int n, int[] nArray) {
        if (string.isEmpty()) {
            return 0;
        }
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.stringWidth(string);
        nArray[0] = n2 <= n ? nArray[0] + string.length() : nArray[0] + U.tryStrWidth(fontMetrics, string, n, string.length() / 2, 0, string.length(), 0);
        return n2;
    }

    public static int stringWidth(Graphics2D graphics2D, FontList fontList, String string, int n) {
        int n2 = 0;
        List<CharSequence> list = U.splitToken(string);
        for (CharSequence charSequence : list) {
            String string2 = charSequence.toString();
            n2 = string2.equals("\t") ? (n2 += TAB_WIDTH) : (n2 += U.stringWidthSection(graphics2D, fontList, string2, n));
            if (n2 <= n) continue;
            break;
        }
        return n2;
    }

    public static int stringWidthSection(Graphics2D graphics2D, FontList fontList, String string, int n) {
        if (string == null || string.length() <= 0) {
            return 0;
        }
        int n2 = 0;
        Font font = fontList.font[0];
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        Font[] fontArray = new Font[1];
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n4 = U.charWidth(graphics2D, fontList, c, fontArray);
            if (font.equals(fontArray[0])) {
                stringBuilder.append(c);
                n3 += n4;
                continue;
            }
            n3 = graphics2D.getFontMetrics(font).stringWidth(stringBuilder.toString());
            n2 += n3;
            n3 = n4;
            stringBuilder.setLength(0);
            stringBuilder.append(c);
            font = fontArray[0];
        }
        if (stringBuilder.length() > 0) {
            n3 = graphics2D.getFontMetrics(font).stringWidth(stringBuilder.toString());
            n2 += n3;
        }
        return n2;
    }

    public static int charWidth(Graphics2D graphics2D, FontList fontList, char c) {
        return U.charWidth(graphics2D, fontList, c, null);
    }

    public static int charWidth(Graphics2D graphics2D, FontList fontList, char c, Font[] fontArray) {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = c < '\u0100' ? fontList.charWidthCaches256[c] : fontList.charWidthCaches.get(Character.valueOf(c));
        if (objectArray == null) {
            objectArray = U.genCharWidthCaches(graphics2D, c, fontList);
            if (c < '\u0100') {
                fontList.charWidthCaches256[c] = objectArray;
            } else {
                fontList.charWidthCaches.put(Character.valueOf(c), objectArray);
            }
        }
        if (fontArray != null) {
            fontArray[0] = (Font)objectArray[0];
        }
        return (Integer)objectArray[1];
    }

    private static Object[] genCharWidthCaches(Graphics2D graphics2D, char c, FontList fontList) {
        Font[] fontArray = fontList.font;
        Font font = fontArray[0];
        for (Font font2 : fontArray) {
            if (!font2.canDisplay(c)) continue;
            font = font2;
            break;
        }
        return new Object[]{font, graphics2D.getFontMetrics(font).charWidth(c)};
    }

    static void addKey(Map<String, Commands> map, String string, String string2) throws Exception {
        Commands commands;
        String string3 = U.getKeyNameFromTextName(string);
        try {
            commands = Commands.valueOf(string2);
        }
        catch (Exception exception) {
            System.out.println("undefined command:" + string2);
            return;
        }
        try {
            if (map.containsKey(string3)) {
                System.err.println("duplicated key:" + string3);
            } else {
                map.put(string3, commands);
            }
        }
        catch (Exception exception) {
            System.err.println("Error: unknow key:" + string);
        }
    }

    public static String getKeyNameFromTextName(String string) throws Exception {
        Object object = string.toUpperCase();
        Object object2 = "";
        int n = ((String)object).indexOf("SHIFT-");
        if (n >= 0) {
            object = ((String)object).substring(0, n) + ((String)object).substring(n + 6);
            object2 = (String)object2 + "S";
        }
        if ((n = ((String)object).indexOf("CTRL-")) >= 0) {
            object = ((String)object).substring(0, n) + ((String)object).substring(n + 5);
            object2 = (String)object2 + "C";
        }
        if ((n = ((String)object).indexOf("ALT-")) >= 0) {
            object = ((String)object).substring(0, n) + ((String)object).substring(n + 4);
            object2 = (String)object2 + "A";
        }
        Field field = KeyEvent.class.getField("VK_" + (String)object);
        int n2 = field.getInt(null);
        String string2 = KeyEvent.getKeyText(n2);
        object2 = (String)object2 + string2;
        return object2;
    }

    public static void startDaemonThread(Thread thread) {
        thread.setDaemon(true);
        thread.start();
    }

    static void attach(final PlainPage plainPage, final InputStream inputStream, final String string) {
        U.startDaemonThread(new Thread(){
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMdd HH:mm:ss:SSS\t");

            @Override
            public void run() {
                try {
                    int n;
                    String string2 = plainPage.pageData.encoding;
                    if (string2 == null) {
                        string2 = U.UTF8;
                    }
                    InputStream inputStream2 = inputStream;
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream2, string2);
                    long l = System.currentTimeMillis();
                    Object object = "<begin " + string + ">";
                    if (addTime) {
                        object = this.sdf1.format(new Date()) + (String)object;
                    }
                    plainPage.pageData.editRec.appendLine((CharSequence)object);
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = false;
                    while ((n = inputStreamReader.read()) != -1) {
                        long l2;
                        if (n == 13) {
                            bl = true;
                        } else if (n == 10) {
                            bl = false;
                            object = stringBuilder.toString();
                            if (addTime) {
                                object = this.sdf1.format(new Date()) + (String)object;
                            }
                            stringBuilder.setLength(0);
                            plainPage.pageData.editRec.appendLine((CharSequence)object);
                            if (plainPage.console != null && plainPage.console.follow) {
                                int n2 = plainPage.pageData.roLines.getLinesize() - 1;
                                plainPage.cursor.setSafePos(0, n2);
                                plainPage.focusCursor();
                            }
                        } else {
                            if (bl) {
                                bl = false;
                                object = stringBuilder.toString();
                                if (addTime) {
                                    object = this.sdf1.format(new Date()) + (String)object;
                                }
                                stringBuilder.setLength(0);
                                plainPage.pageData.lines.set(plainPage.pageData.roLines.getLinesize() - 1, (CharSequence)object);
                            }
                            stringBuilder.append((char)n);
                        }
                        if ((l2 = System.currentTimeMillis()) - l <= 100L) continue;
                        l = l2;
                        plainPage.uiComp.repaint();
                    }
                    if (stringBuilder.length() > 0) {
                        object = stringBuilder.toString();
                        plainPage.pageData.editRec.appendLine((CharSequence)object);
                        if (plainPage.console != null && plainPage.console.follow) {
                            n = plainPage.pageData.roLines.getLinesize() - 1;
                            plainPage.cursor.setSafePos(0, n);
                            plainPage.focusCursor();
                        }
                    }
                    object = "<end " + string + ">";
                    if (addTime) {
                        object = this.sdf1.format(new Date()) + (String)object;
                    }
                    Object object2 = object;
                    new Thread(() -> 1.lambda$run$0(plainPage, (String)object2)).start();
                }
                catch (Throwable throwable) {
                    plainPage.ptEdit.append("error:" + String.valueOf(throwable) + "\n");
                }
            }

            private static /* synthetic */ void lambda$run$0(PlainPage plainPage2, String string2) {
                try {
                    Thread.sleep(50L);
                    plainPage2.pageData.editRec.appendLine(string2);
                    plainPage2.uiComp.repaint();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    static boolean changedOutside(PageData pageData) {
        long l;
        return pageData.fileLoaded && (l = new File(pageData.title).lastModified()) > pageData.fileLastModified + 100L;
    }

    static void closePage(PlainPage plainPage) throws Exception {
        EditorPanel editorPanel = plainPage.uiComp;
        int n = 0;
        if (plainPage.console == null && plainPage.pageData.history.size() != 0) {
            n = JOptionPane.showConfirmDialog(editorPanel, "Are you sure to SAVE and close?", "Changes made", 1, 3);
            if (n == 2 || n == -1) {
                return;
            }
            if (n == 0 && !U.saveFile(plainPage)) {
                return;
            }
        }
        if (plainPage.pageData.fileLoaded) {
            U.saveFileHistory(plainPage.pageData.title, plainPage.cy);
        }
        plainPage.close();
    }

    static int drawTwoColor(Graphics2D graphics2D, FontList fontList, String string, int n, int n2, Color color, Color color2, int n3, int n4, boolean bl) {
        graphics2D.setColor(color2);
        int n5 = U.drawString(graphics2D, fontList, string, n + n3, n2 + n3, n4, bl);
        graphics2D.setColor(color);
        U.drawString(graphics2D, fontList, string, n, n2, n4, bl);
        return n5;
    }

    public static void exec(PlainPage plainPage, String string) throws Exception {
        File file;
        Object object;
        if ((string = string.trim()).length() <= 0) {
            return;
        }
        if (U.isCmdCd(string, plainPage)) {
            return;
        }
        if (U.isCmdExport(string, plainPage)) {
            return;
        }
        int n = string.indexOf(93);
        if (n > 0) {
            object = string.substring(0, n).trim();
            int n2 = ((String)object).indexOf(91);
            if (n2 >= 0) {
                object = ((String)object).substring(n2 + 1).trim();
            }
            if (((String)object).isEmpty()) {
                object = "/tmp";
            }
            file = new File((String)object);
            string = string.substring(n + 1).trim();
        } else {
            file = plainPage.workPath != null ? new File(plainPage.workPath) : new File(".");
        }
        U.addCmdHistory(string, file.getAbsolutePath());
        object = Runtime.getRuntime().exec(U.splitCommand(string), U.getEnv(plainPage), file);
        OutputStream outputStream = null;
        InputStream inputStream = ((Process)object).getInputStream();
        InputStream inputStream2 = ((Process)object).getErrorStream();
        PlainPage plainPage2 = new PlainPage(plainPage.uiComp, PageData.fromTitle(String.format("[cmd][%s] %s #%s", file.getAbsolutePath(), string, U.randomID())), plainPage);
        plainPage2.workPath = file.getAbsolutePath();
        plainPage2.ptSelection.selectAll();
        new Console(string, outputStream, inputStream, inputStream2, (Process)object, plainPage.uiComp, file, plainPage.follow).start();
    }

    private static void addCmdHistory(String string, String string2) throws IOException {
        String string3 = String.format("[%s] %s", string2, string);
        File file = U.getCmdHistoryName();
        String string4 = FileUtil.readString(new FileInputStream(file), null);
        List<String> list = Arrays.asList(string4.split("\n"));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF8));
        if (!list.contains(string3)) {
            bufferedWriter.write(string3);
            bufferedWriter.write("\n");
            bufferedWriter.write(string4);
        } else {
            bufferedWriter.write(string3);
            bufferedWriter.write("\n");
            ArrayList<String> arrayList = new ArrayList<String>(list);
            arrayList.remove(string3);
            for (String string5 : arrayList) {
                bufferedWriter.write(string5);
                bufferedWriter.write("\n");
            }
        }
        bufferedWriter.close();
    }

    private static String[] getEnv(PlainPage plainPage) {
        if (plainPage.envs != null) {
            return plainPage.envs;
        }
        if (plainPage.env == null) {
            return null;
        }
        int n = plainPage.env.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        for (Map.Entry<String, String> entry : plainPage.env.entrySet()) {
            stringArray[n2++] = entry.getKey() + "=" + entry.getValue();
        }
        plainPage.envs = stringArray;
        return stringArray;
    }

    private static String[] splitCommand(String string) {
        if (string.contains("*") || string.contains("~") || string.contains("|") || string.contains("&") || string.contains(">")) {
            return new String[]{"bash", "-c", string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3;
            int n4;
            int n5 = string.charAt(n);
            if (n5 == 34 || n5 == 39) {
                n4 = n5;
                n3 = string.indexOf(n4, n + 1);
                if (n3 < 0) {
                    n3 = n2;
                }
                arrayList.add(string.substring(n + 1, n3));
                n = n3 + 1;
                continue;
            }
            if (n5 == 32 || n5 == 9) {
                ++n;
                continue;
            }
            n4 = -1;
            for (n3 = n + 1; n3 < string.length(); ++n3) {
                char c = string.charAt(n3);
                if (c != ' ' && c != '\t') continue;
                n4 = n3;
                break;
            }
            if (n4 < 0) {
                n4 = n2;
            }
            arrayList.add(string.substring(n, n4).trim());
            n = n4 + 1;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static boolean isCmdCd(String string, PlainPage plainPage) {
        if ("cd".equals(string)) {
            string = "cd ";
        }
        if (!string.startsWith("cd ")) {
            return false;
        }
        String string2 = string.substring(3).trim();
        if (string2.isEmpty()) {
            string2 = U.getUserHome();
        } else {
            File file = new File(string2 = U.dequote(string2));
            if (!file.exists()) {
                String string3 = new Xcd().run(string2);
                if (string3 == null) {
                    plainPage.ui.message("path not exist:" + string2);
                    return true;
                }
                string2 = string3;
            } else if (file.isFile()) {
                string2 = file.getParent();
            }
        }
        plainPage.workPath = string2;
        plainPage.ui.message("CWD=" + string2);
        return true;
    }

    private static String dequote(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static boolean isCmdExport(String string, PlainPage plainPage) {
        if (!string.startsWith("export ")) {
            return false;
        }
        String string2 = string.substring(7).trim();
        int n = string2.indexOf(61);
        if (n <= 0) {
            return false;
        }
        String string3 = string2.substring(0, n).trim();
        String string4 = string2.substring(n + 1).trim();
        string4 = U.dequote(string4);
        U.setEnv(plainPage, string3, string4);
        plainPage.ui.message(String.format("ENV[%s]=%s", string3, string4));
        return true;
    }

    static void gc() {
        new Thread(() -> {
            U.sleep(50);
            System.gc();
        }).start();
    }

    private static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static String getClipBoard() {
        try {
            Object object;
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor) && (object = clipboard.getData(DataFlavor.stringFlavor)) != null) {
                return object.toString();
            }
            if (clipboard.isDataFlavorAvailable(DataFlavor.javaFileListFlavor) && (object = clipboard.getData(DataFlavor.javaFileListFlavor)) != null) {
                List list = (List)object;
                StringBuffer stringBuffer = new StringBuffer();
                for (File file : list) {
                    stringBuffer.append(file.getAbsolutePath()).append('\n');
                }
                return stringBuffer.toString();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    public static File getFileHistoryName() throws IOException {
        File file = new File(U.getMyDir(), "fh.txt");
        if (!file.exists()) {
            new FileOutputStream(file).close();
        }
        return file;
    }

    public static File getSearchHistoryName() throws IOException {
        File file = new File(U.getMyDir(), "sh.txt");
        if (!file.exists()) {
            new FileOutputStream(file).close();
        }
        return file;
    }

    static File getDirHistoryName() throws IOException {
        File file = new File(U.getMyDir(), "dh.txt");
        if (!file.exists()) {
            new FileOutputStream(file).close();
        }
        return file;
    }

    static File getCmdHistoryName() throws IOException {
        File file = new File(U.getMyDir(), "ch.txt");
        if (!file.exists()) {
            new FileOutputStream(file).close();
        }
        return file;
    }

    static int getHighLightID(String string, Graphics2D graphics2D, Color color, Color color2, Color color3) {
        try {
            U.initKeyWords();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (Arrays.binarySearch(KWS, string) >= 0 || Arrays.binarySearch(KWS, string.toLowerCase()) >= 0) {
            graphics2D.setColor(color);
        } else if (U.isAllDigital(string)) {
            graphics2D.setColor(color2);
        } else {
            graphics2D.setColor(color3);
        }
        return 0;
    }

    private static void initKeyWords() throws IOException {
        if (KWS != null) {
            return;
        }
        ArrayList arrayList = (ArrayList)Conf.get("KWS", null);
        if (arrayList == null) {
            KWS = new String[0];
            return;
        }
        arrayList = new ArrayList(new HashSet(arrayList));
        Collections.sort(arrayList);
        KWS = arrayList.toArray(new String[arrayList.size()]);
    }

    public static Reader getInstalledReader(String string) throws IOException {
        File file = new File(U.getMyDir(), string);
        if (!file.exists()) {
            try {
                FileUtil.copy(U.class.getResourceAsStream(string), new FileOutputStream(file));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return U.getResourceReader(string);
            }
        }
        return new InputStreamReader((InputStream)new FileInputStream(file), UTF8);
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static File getMyDir() {
        String string = U.getUserHome();
        File file = new File(string, ".neoeedit");
        file.mkdirs();
        return file;
    }

    public static List<CharSequence> getPageListStrings(EditorPanel editorPanel) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        Collections.sort(editorPanel.pageSet, (plainPage, plainPage2) -> plainPage.pageData.title.compareTo(plainPage2.pageData.title));
        for (PlainPage plainPage3 : editorPanel.pageSet) {
            arrayList.add(plainPage3.pageData.title + "|" + (plainPage3.cy + 1) + ": Edited:" + plainPage3.pageData.history.size() + (String)(plainPage3.pageData.encoding == null ? "" : " " + plainPage3.pageData.encoding) + (U.changedOutside(plainPage3.pageData) ? " [Changed Outside!!]" : ""));
        }
        return arrayList;
    }

    public static List<CharSequence> getDocListStrings() {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        PageData.dataPool.keySet().forEach(string -> arrayList.add(string + "|0:"));
        Collections.sort(arrayList, (charSequence, charSequence2) -> charSequence.toString().compareTo(charSequence2.toString()));
        return arrayList;
    }

    static String getLocString(PlainPage plainPage) {
        if (plainPage == null) {
            return null;
        }
        return plainPage.pageData.title + "|" + (plainPage.cy + 1) + ":";
    }

    public static Reader getResourceReader(String string) throws IOException {
        return new InputStreamReader(U.class.getResourceAsStream(string), UTF8);
    }

    public static String getStr(List list, int n) {
        if (n < 0 || n >= list.size()) {
            return "";
        }
        return String.valueOf(list.get(n));
    }

    private static String guessByBOM(byte[] byArray) {
        for (Object[] objectArray : BOMS) {
            int[] nArray = (int[])objectArray[0];
            if (nArray.length > byArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < nArray.length; ++i) {
                if ((byte)nArray[i] == byArray[i]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return (String)objectArray[1];
        }
        return null;
    }

    static void guessComment(PlainPage plainPage) {
        int n;
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new String[]{"/*", "<!--", "#", "%", "//", "! ", "; ", "--"};
        int[] nArray = new int[stringArray.length];
        int n3 = Math.min(1000, plainPage.pageData.roLines.getLinesize());
        for (n2 = 0; n2 < n3; ++n2) {
            CharSequence charSequence = plainPage.pageData.roLines.getline(n2);
            CharSequence charSequence2 = U.trimLeft(charSequence);
            String string = charSequence2.subSequence(0, Math.min(40, charSequence2.length())).toString();
            for (int i = 0; i < nArray.length; ++i) {
                String string2 = stringArray[i];
                if (!string.startsWith(string2) && string.indexOf(string2) < 0) continue;
                int n4 = i;
                nArray[n4] = nArray[n4] + string2.length();
            }
        }
        n2 = 0;
        int n5 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] <= 0) continue;
            ++n2;
            n5 = Math.max(n5, nArray[n]);
        }
        if (n2 == 1) {
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] <= 0) continue;
                arrayList.add(stringArray[n]);
                break;
            }
        } else {
            n = Math.max(5, n5 / 10);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= n) continue;
                arrayList.add(stringArray[i]);
            }
        }
        if (arrayList.isEmpty()) {
            arrayList = null;
        }
        plainPage.pageData.comment = arrayList == null ? null : arrayList.toArray(new String[arrayList.size()]);
        plainPage.repaint();
    }

    static String guessEncoding(String string, PageData pageData) throws Exception {
        Object object;
        byte[] byArray;
        String[] stringArray = new String[]{UTF8, "gbk", "sjis", "unicode", "euc-jp", "big5"};
        int n = pageData != null && pageData.gzip ? pageData.bs.length : (int)new File(string).length();
        int n2 = Math.min(0x200000, n);
        if (n2 < 0) {
            n2 = 0x200000;
        }
        if (pageData != null && pageData.gzip) {
            byArray = pageData.bs;
        } else {
            byArray = new byte[n2];
            object = new FileInputStream(string);
            n2 = ((FileInputStream)object).read(byArray);
            ((FileInputStream)object).close();
        }
        object = U.guessByBOM(byArray);
        if (object != null) {
            return object;
        }
        for (String string2 : stringArray) {
            String string3 = new String(byArray, 0, n2, string2);
            if (string3.toLowerCase().indexOf(string2.toLowerCase()) >= 0) {
                return string2;
            }
            if (string3.length() <= 3) {
                return UTF8;
            }
            string3 = string3.substring(0, string3.length() - 3);
            byte[] byArray2 = string3.getBytes(string2);
            if (!U.bsCompare(byArray, byArray2, byArray2.length)) continue;
            return string2;
        }
        return null;
    }

    private static boolean bsCompare(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    static String guessEncodingForEditor(String string, PageData pageData) {
        try {
            String string2 = U.guessEncoding(string, pageData);
            if (string2 == null) {
                return UTF8;
            }
            return string2;
        }
        catch (Exception exception) {
            return UTF8;
        }
    }

    static String guessLineSepForEditor(String string, PageData pageData) {
        try {
            byte[] byArray;
            int n = pageData.gzip ? pageData.bs.length : (int)new File(string).length();
            int n2 = Math.min(4096, n);
            if (pageData.gzip) {
                byArray = pageData.bs;
            } else {
                byArray = new byte[n2];
                FileInputStream fileInputStream = new FileInputStream(string);
                n2 = fileInputStream.read(byArray);
                fileInputStream.close();
            }
            return new String(byArray, 0, n2, "iso8859-1").indexOf("\r\n") >= 0 ? "\r\n" : "\n";
        }
        catch (Exception exception) {
            return "\n";
        }
    }

    static boolean isAllDigital(String string) {
        for (char c : string.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isImageFile(File file) {
        String string = file.getName().toLowerCase();
        return string.endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".png") || string.endsWith(".bmp") || string.endsWith(".jpeg") || string.endsWith(".tga") || string.endsWith(".webp");
    }

    static boolean isSkipChar(char c, char c2) {
        if (U.isSpaceChar(c2)) {
            return U.isSpaceChar(c);
        }
        return Character.isJavaIdentifierPart(c);
    }

    static String km(long l) {
        float f = 1048576.0f;
        if ((float)l > f) {
            return String.format("%.1fMB", Float.valueOf((float)l / f));
        }
        if (l > 1024L) {
            return String.format("%.1fKB", Float.valueOf((float)l / 1024.0f));
        }
        return "" + l;
    }

    public static boolean launch(String string) throws Exception {
        string = string.trim();
        String string2 = string.toLowerCase();
        Desktop desktop = Desktop.getDesktop();
        if (string2.startsWith("mailto:")) {
            desktop.mail(new URI(string));
        } else if (string2.startsWith("http://") || string2.startsWith("https://")) {
            desktop.browse(new URI(string));
        } else if (new File(string).exists()) {
            desktop.open(new File(string));
        } else {
            return false;
        }
        return true;
    }

    static boolean listDirOrOpenFile(PlainPage plainPage, int n) throws Exception {
        File file;
        String string = plainPage.pageData.roLines.getline(n).toString();
        Object object = string;
        if (((String)object).startsWith("~/")) {
            object = U.getUserHome() + ((String)object).substring(1);
        }
        if ((file = U.findFile(plainPage.workPath, (String)object)) == null) {
            return false;
        }
        if ((file = file.getCanonicalFile()).isFile() && file.exists()) {
            return plainPage.uiComp.findAndShowPage(file.getCanonicalPath(), -1, true);
        }
        if (file.isDirectory()) {
            Object[] objectArray = file.listFiles();
            plainPage.cx = string.length();
            plainPage.ptEdit.insertString("\n{-----");
            Arrays.sort(objectArray);
            for (Object object2 : objectArray) {
                if (((File)object2).isDirectory()) {
                    plainPage.ptEdit.insertString("\n" + ((File)object2).getAbsolutePath() + " | <DIR>");
                    continue;
                }
                plainPage.ptEdit.insertString("\n" + ((File)object2).getAbsolutePath());
            }
            plainPage.ptEdit.insertString("\n-----}");
            return true;
        }
        return false;
    }

    private static File findFile(String string, String string2) {
        File file;
        String string3;
        File file2;
        String string4;
        int n;
        if (string == null) {
            string = ".";
        }
        if ((n = (string4 = string2.trim()).indexOf(124)) >= 0) {
            string4 = string4.substring(0, n).trim();
        }
        if ((n = string4.indexOf(9)) >= 0) {
            string4 = string4.substring(0, n).trim();
        }
        if ((file2 = new File(string4)).exists()) {
            return file2;
        }
        file2 = new File(string, string4);
        if (file2.exists()) {
            return file2;
        }
        int n2 = string4.indexOf(32);
        if (n2 >= 0) {
            string3 = string4.substring(0, n2).trim();
            file = new File(string3);
            if (file.exists()) {
                return file;
            }
            file = new File(string, string3);
            if (file.exists()) {
                return file;
            }
        }
        if ((n2 = string4.lastIndexOf(58)) >= 0) {
            string3 = string4.substring(0, n2).trim();
            file = new File(string3);
            if (file.exists()) {
                return file;
            }
            file = new File(string, string3);
            if (file.exists()) {
                return file;
            }
        }
        return null;
    }

    public static void listFonts(PlainPage plainPage) throws Exception {
        String[] stringArray;
        PlainPage plainPage2 = new PlainPage(plainPage.uiComp, PageData.fromTitle("[Fonts]"), plainPage);
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        for (String string : stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            arrayList.add("set-font:" + string);
        }
        plainPage2.pageData.resetLines(arrayList);
    }

    static void loadTabImage() throws Exception {
        BufferedImage bufferedImage = ImageIO.read(U.class.getResourceAsStream("/icontab.png"));
        tabImg = bufferedImage.getScaledInstance(TAB_WIDTH, 8, 4);
        tabImgPrint = bufferedImage.getScaledInstance(TAB_WIDTH, 8, 4);
        U.initShrink();
    }

    public static Commands mappingToCommand(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 16 || n == 17 || n == 18) {
            return null;
        }
        String string = U.getKeyName(keyEvent);
        Commands commands = keys.get(string);
        return commands;
    }

    static String getKeyName(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        String string = KeyEvent.getKeyText(n);
        Object object = string;
        boolean bl = false;
        if (keyEvent.isAltDown()) {
            object = "A" + (String)object;
            bl = true;
        }
        if (keyEvent.isControlDown() || keyEvent.isMetaDown()) {
            object = "C" + (String)object;
            bl = true;
        }
        if (!bl || string.length() != 1 || keyEvent.isShiftDown()) {
            // empty if block
        }
        return object;
    }

    public static int maxWidth(List<Object[]> list, Graphics2D graphics2D, FontList fontList, int n) {
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            Object[] objectArray = list.get(i);
            int n3 = (Integer)objectArray[2];
            if (n3 == -1) {
                n3 = U.stringWidth(graphics2D, fontList, objectArray[0].toString(), n);
                objectArray[2] = n3;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    static void listDirToNewPage(PlainPage plainPage) throws Exception {
        String string;
        String string2 = plainPage.workPath;
        if (string2 == null) {
            string2 = new File(".").getAbsolutePath();
        }
        if (plainPage.uiComp.findAndShowPage(string = "[Dir]" + string2 + "#" + U.randomID(), -1, true)) {
            return;
        }
        PageData pageData = PageData.fromTitle(string);
        pageData.setText(string2);
        PlainPage plainPage2 = new PlainPage(plainPage.uiComp, pageData, plainPage);
        U.listDirOrOpenFile(plainPage2, 0);
    }

    static void openFileHistory(EditorPanel editorPanel) throws Exception {
        File file = U.getFileHistoryName();
        if (editorPanel.findAndShowPage(file.getAbsolutePath(), -1, true)) {
            PlainPage plainPage = editorPanel.page;
            plainPage.cursor.setSafePos(0, plainPage.pageData.lines.size());
            plainPage.focusCursor();
        }
    }

    static void openCmdHistory(EditorPanel editorPanel) throws Exception {
        File file = U.getCmdHistoryName();
        editorPanel.findAndShowPage(file.getAbsolutePath(), -1, true);
    }

    static void paintNoise(Graphics2D graphics2D, Dimension dimension) {
        int n = 1000;
        int n2 = dimension.width;
        int n3 = dimension.height;
        int n4 = 0xFFFFFF;
        for (int i = 0; i < n; ++i) {
            int n5 = random.nextInt(n2);
            int n6 = random.nextInt(n3);
            graphics2D.setColor(new Color(random.nextInt(n4)));
            graphics2D.drawLine(n5, n6, n5 + 1, n6);
        }
    }

    public static int parseInt(Object object) {
        if (object == null) {
            throw new RuntimeException("expect int but get null");
        }
        String string = object.toString();
        int n = string.startsWith("0x") ? Integer.parseInt(string.substring(2), 16) : (string.startsWith("0b") ? Integer.parseInt(string.substring(2), 2) : Integer.parseInt(string));
        return n;
    }

    public static String randomID() {
        return idIndex++ + "_" + Integer.toString(random.nextInt(46656), 36);
    }

    public static boolean tryGzip(String string, PageData pageData) {
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(string));
            try {
                pageData.bs = FileUtil.read(gZIPInputStream);
                gZIPInputStream.close();
                return true;
            }
            catch (ZipException zipException) {
                System.err.println("seems not gzip:" + String.valueOf(zipException));
                return false;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            return false;
        }
    }

    static List<CharSequence> readFileForEditor(String string, String string2, PageData pageData) {
        try {
            List<String> list;
            if (pageData.gzip) {
                list = FileUtil.readStringBig(pageData.bs, string2);
                pageData.bs = null;
            } else {
                list = FileUtil.readStringBig(new File(string), string2);
            }
            return U.removeTailR(list);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
            arrayList.add(throwable.toString());
            return arrayList;
        }
    }

    static void reloadWithEncodingByUser(PlainPage plainPage) {
        if (!plainPage.pageData.fileLoaded) {
            plainPage.ui.message("file not saved.");
            return;
        }
        if (U.setEncodingByUser(plainPage, "Reload with Encoding:")) {
            plainPage.pageData.reloadFile();
        }
    }

    static String removeAsciiZero(String string) {
        int n = 0;
        char c = '\u0000';
        int n2 = string.indexOf(c);
        if (n2 < 0) {
            return string;
        }
        String string2 = "" + c;
        StringBuilder stringBuilder = new StringBuilder(string);
        while (n2 >= 0) {
            stringBuilder.deleteCharAt(n2);
            ++n;
            n2 = stringBuilder.indexOf(string2, n2);
        }
        System.out.println("removed " + n + " NULL char");
        return stringBuilder.toString();
    }

    static CharSequence removeTailR(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return charSequence;
        }
        if (charSequence.charAt(charSequence.length() - 1) == '\r') {
            charSequence = charSequence.subSequence(0, charSequence.length() - 1);
        }
        return charSequence;
    }

    static void removeTrailingSpace(PageData pageData) {
        for (int i = 0; i < pageData.roLines.getLinesize(); ++i) {
            int n;
            CharSequence charSequence = pageData.roLines.getline(i);
            for (n = charSequence.length() - 1; n >= 0 && "\r\n\t ".indexOf(charSequence.charAt(n)) >= 0; --n) {
            }
            if (n >= charSequence.length() - 1) continue;
            pageData.editRec.deleteInLine(i, n + 1, charSequence.length());
        }
    }

    static void repaintAfter(long l, JComponent jComponent) {
        U.startDaemonThread(new Thread(() -> {
            try {
                Thread.sleep(l);
                jComponent.repaint();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }));
    }

    static void runScript(final PlainPage plainPage) throws Exception {
        JFrame jFrame = new JFrame("Script for " + plainPage.pageData.title);
        JPanel jPanel = new JPanel(new BorderLayout());
        final EditorPanel editorPanel = new EditorPanel();
        File file = new File(U.getMyDir(), "scripts");
        file.mkdirs();
        editorPanel.page.workPath = file.getAbsolutePath();
        editorPanel.frame = jFrame;
        U.listDirToNewPage(editorPanel.page);
        jPanel.add((Component)editorPanel, "Center");
        JButton jButton = new JButton("Run!");
        jPanel.add((Component)jButton, "South");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    U.runScript(plainPage, U.exportString(editorPanel.page.pageData.lines, "\n"));
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    StringWriter stringWriter = new StringWriter();
                    exception.printStackTrace(new PrintWriter(stringWriter));
                    editorPanel.page.ptEdit.append("\n/*\n" + stringWriter.toString() + "\n*/\n");
                }
            }
        });
        jFrame.setDefaultCloseOperation(2);
        jFrame.getContentPane().add(jPanel);
        jFrame.setSize(600, 400);
        jFrame.setLocationRelativeTo(plainPage.uiComp);
        jFrame.setVisible(true);
    }

    static void runScript(PlainPage plainPage, String string) throws Exception {
        ReadonlyLines readonlyLines = plainPage.pageData.roLines;
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        int n = readonlyLines.getLinesize();
        for (int i = 0; i < n; ++i) {
            arrayList.add(readonlyLines.getline(i));
        }
        new ScriptUtil().runSingleScript(plainPage, string, arrayList);
    }

    static void saveAs(PlainPage plainPage) throws Exception {
        JFileChooser jFileChooser = new JFileChooser(plainPage.workPath);
        EditorPanel editorPanel = plainPage.uiComp;
        int n = jFileChooser.showSaveDialog(editorPanel);
        if (n == 0) {
            String string = U.trimFileName(jFileChooser.getSelectedFile());
            if (new File(string).exists() && 0 != JOptionPane.showConfirmDialog(editorPanel, "file exists, are you sure to overwrite?", "save as...", 0)) {
                plainPage.ui.message("not renamed");
                return;
            }
            plainPage.pageData.renameTo(string);
            U.saveFileHistory(string, plainPage.cy);
            editorPanel.changeTitle();
            plainPage.ui.message("file renamed");
            U.savePageToFile(plainPage);
        }
    }

    static boolean saveFile(PlainPage plainPage) throws Exception {
        if (plainPage.pageData.fileLoaded) {
            String string = plainPage.pageData.title;
            if (!plainPage.pageData.changedOutside && new File(string).lastModified() > plainPage.pageData.fileLastModified) {
                plainPage.pageData.changedOutside = true;
            }
            if (plainPage.pageData.changedOutside && 0 != JOptionPane.showConfirmDialog(plainPage.uiComp, "File Changed Outside!! Do you really want to overwrite it?", "File Changed Outside!!", 0)) {
                plainPage.ui.message("saved canceled");
                return false;
            }
            return U.savePageToFile(plainPage);
        }
        JFileChooser jFileChooser = new JFileChooser(plainPage.workPath);
        int n = jFileChooser.showSaveDialog(plainPage.uiComp);
        if (n != 0) {
            return false;
        }
        String string = U.trimFileName(jFileChooser.getSelectedFile());
        if (new File(string).exists() && 0 != JOptionPane.showConfirmDialog(plainPage.uiComp, "Are you sure to overwrite?", "File exists", 0)) {
            plainPage.ui.message("saved canceled");
            return false;
        }
        PageData pageData = plainPage.pageData;
        pageData.renameTo(string);
        U.saveFileHistory(string, plainPage.cy);
        plainPage.uiComp.changeTitle();
        return U.savePageToFile(plainPage);
    }

    private static String trimFileName(File file) {
        File file2 = file.getParentFile();
        if (file2 == null) {
            return file.getAbsolutePath().trim();
        }
        return file2.getAbsolutePath().trim() + "/" + file.getName().trim();
    }

    static void saveFileHistory(String string, int n) throws IOException {
        File file = U.getFileHistoryName();
        if (string.equals(file.getAbsolutePath())) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file, true);
        if (n <= 0) {
            ((OutputStream)fileOutputStream).write(String.format("\n%s", string).getBytes(UTF8));
        } else {
            ((OutputStream)fileOutputStream).write(String.format("\n%s|%s:", string, n + 1).getBytes(UTF8));
        }
        ((OutputStream)fileOutputStream).close();
        U.saveDirHistory(string);
    }

    private static void saveDirHistory(String string) throws IOException {
        File file = new File(string).getParentFile();
        if (file == null) {
            return;
        }
        String string2 = file.getAbsolutePath();
        String string3 = FileUtil.readString(new FileInputStream(U.getDirHistoryName()), null);
        List<String> list = Arrays.asList(string3.split("\n"));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(U.getDirHistoryName()), UTF8));
        if (!list.contains(string2)) {
            bufferedWriter.write(string2);
            bufferedWriter.write("\n");
            bufferedWriter.write(string3);
        } else {
            bufferedWriter.write(string2);
            bufferedWriter.write("\n");
            ArrayList<String> arrayList = new ArrayList<String>(list);
            arrayList.remove(string2);
            for (String string4 : arrayList) {
                bufferedWriter.write(string4);
                bufferedWriter.write("\n");
            }
        }
        bufferedWriter.close();
    }

    static boolean savePageToFile(PlainPage plainPage) throws Exception {
        try {
            String string = plainPage.pageData.title;
            System.out.println("save " + string);
            File file = new File(string);
            if (plainPage.pageData.encoding == null) {
                plainPage.pageData.encoding = UTF8;
            }
            if (string.endsWith(".gz")) {
                plainPage.pageData.gzip = true;
            }
            String string2 = plainPage.pageData.encoding;
            BufferedOutputStream bufferedOutputStream = !plainPage.pageData.gzip ? new BufferedOutputStream(new FileOutputStream(string), 131072) : new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(string)), 131072);
            byte[] byArray = plainPage.pageData.lineSep.getBytes(string2);
            for (int i = 0; i < plainPage.pageData.lines.size(); ++i) {
                ((OutputStream)bufferedOutputStream).write(plainPage.pageData.lines.get(i).toString().getBytes(string2));
                ((OutputStream)bufferedOutputStream).write(byArray);
            }
            ((OutputStream)bufferedOutputStream).close();
            plainPage.pageData.fileLastModified = file.lastModified();
            plainPage.pageData.changedOutside = false;
            plainPage.pageData.fileLoaded = true;
            plainPage.pageData.isCommentChecked = false;
            plainPage.workPath = file.getParent();
            return true;
        }
        catch (Throwable throwable) {
            U.showSelfDispMessage(plainPage, "error when save file:" + String.valueOf(throwable), 8000);
            throwable.printStackTrace();
            return false;
        }
    }

    static void scale(int n, PlainPage.Paint paint) {
        if (n > 0) {
            paint.scalev *= 1.1f;
        } else if (n < 0) {
            paint.scalev *= 0.9f;
        }
    }

    static void setClipBoard(String string) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
    }

    static boolean setEncodingByUser(PlainPage plainPage, String string) {
        String string2 = JOptionPane.showInputDialog(plainPage.uiComp, string, plainPage.pageData.encoding);
        if (string2 == null) {
            return false;
        }
        try {
            "a".getBytes(string2);
        }
        catch (Exception exception) {
            plainPage.ui.message("bad encoding:" + string2);
            return false;
        }
        plainPage.pageData.encoding = string2;
        return true;
    }

    public static void setFont(EditorPanel editorPanel, Font font) throws Exception {
        ArrayList<Font> arrayList = new ArrayList<Font>(Arrays.asList(Conf.defaultFontList.font));
        arrayList.add(0, font);
        FontList fontList = new FontList(arrayList.toArray(new Font[arrayList.size()]));
        for (PlainPage plainPage : editorPanel.pageSet) {
            plainPage.fontList = fontList;
        }
    }

    static void setFrameSize(JFrame jFrame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = Conf.readFrameSize();
        jFrame.setSize(Math.min(dimension.width, dimension2.width), Math.min(dimension2.height, dimension.height));
    }

    static void showHelp(final PlainPage.Paint paint, final EditorPanel editorPanel) {
        if (paint.aboutImg != null) {
            return;
        }
        U.startDaemonThread(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int n = editorPanel.getWidth();
                    int n2 = 60;
                    paint.aboutImg = new BufferedImage(n, n2, 2);
                    Graphics2D graphics2D = paint.aboutImg.createGraphics();
                    graphics2D.setColor(Color.BLUE);
                    graphics2D.fillRect(0, 0, n, n2);
                    graphics2D.setColor(Color.CYAN);
                    graphics2D.setFont(new Font("Arial", 1, 40));
                    graphics2D.drawString("NeoeEdit", 6, n2 - 20);
                    graphics2D.setFont(new Font("Arial", 0, 16));
                    graphics2D.setColor(Color.ORANGE);
                    graphics2D.drawString("ver:" + Version.REV, 220, n2 - 22);
                    graphics2D.setColor(Color.YELLOW);
                    graphics2D.drawString("press F1 key to see all commands", 6, n2 - 6);
                    graphics2D.dispose();
                    paint.aboutY = -n2;
                    paint.aboutOn = true;
                    int n3 = -n2;
                    while (n3 <= 0) {
                        paint.aboutY = n3++;
                        editorPanel.repaint();
                        Thread.sleep(500 / n2);
                    }
                    Thread.sleep(2000L);
                    n3 = 0;
                    while (n3 >= -n2) {
                        paint.aboutY = n3--;
                        editorPanel.repaint();
                        Thread.sleep(500 / n2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    paint.aboutOn = false;
                    paint.aboutImg = null;
                }
            }
        });
    }

    public static PlainPage getPP(EditorPanel editorPanel, PageData pageData, PlainPage plainPage) throws Exception {
        PlainPage plainPage2 = U.findPageByData(editorPanel.pageSet, pageData);
        if (plainPage2 != null) {
            editorPanel.setPage(plainPage2, true);
            return plainPage2;
        }
        return new PlainPage(editorPanel, pageData, plainPage);
    }

    public static void showHexOfString(String string, PlainPage plainPage) throws Exception {
        PlainPage plainPage2 = new PlainPage(plainPage.uiComp, PageData.fromTitle(String.format("Hex for String #%s", U.randomID())), plainPage);
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        arrayList.add(new StringBuilder(String.format("Hex for '%s'", string)));
        for (char c : string.toCharArray()) {
            arrayList.add(c + ":" + UnicodeFormatter.charToHex(c));
        }
        plainPage2.pageData.resetLines(arrayList);
    }

    public static void showPageListPage(EditorPanel editorPanel) throws Exception {
        PageData pageData;
        String string = U.titleOfPages(editorPanel);
        if (editorPanel.findAndShowPage(string, 0, true)) {
            pageData = editorPanel.page.pageData;
        } else {
            pageData = PageData.fromTitle(string);
            new PlainPage(editorPanel, pageData, editorPanel.page);
        }
        pageData.resetLines(U.getPageListStrings(editorPanel));
        editorPanel.repaint();
    }

    public static void listDoc(EditorPanel editorPanel) throws Exception {
        String string = "[DOC]";
        if (editorPanel.findAndShowPage(string, 0, true)) {
            editorPanel.page.pageData.resetLines(U.getDocListStrings());
            editorPanel.repaint();
            return;
        }
        PageData pageData = PageData.fromTitle(string);
        new PlainPage(editorPanel, pageData, editorPanel.page);
        pageData.resetLines(U.getDocListStrings());
        editorPanel.repaint();
    }

    public static void showSelfDispMessage(PlainPage plainPage, String string, int n) {
        long l = System.currentTimeMillis();
        plainPage.ui.msgs.add(new Object[]{string, l + (long)n, -1});
        U.repaintAfter(4000L, plainPage.uiComp);
    }

    static String spaces(int n) {
        if (n <= 0) {
            return "";
        }
        if (n <= SPACES.length()) {
            return SPACES.substring(0, n);
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.setLength(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.setCharAt(i, ' ');
        }
        return stringBuilder.toString();
    }

    static List<CharSequence> splitToken(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                if (stringBuilder.length() > 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
                arrayList.add("" + c);
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        return arrayList;
    }

    static List<String> split(String string, char c) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(c, n)) < 0) break;
            string2 = (String)string.subSequence(n, n2);
            arrayList.add(string2);
            n = n2 + 1;
        }
        string2 = (String)string.subSequence(n, string.length());
        arrayList.add(string2);
        return arrayList;
    }

    static void startNoiseThread(final PlainPage.Paint paint, final EditorPanel editorPanel) {
        U.startDaemonThread(new Thread(){

            @Override
            public void run() {
                try {
                    while (paint.noise && !paint.closed) {
                        editorPanel.repaint();
                        Thread.sleep(paint.noisesleep);
                    }
                    System.out.println("noise stopped");
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        });
    }

    static CharSequence subs(CharSequence charSequence, int n, int n2) {
        if (n >= n2) {
            return "";
        }
        if (n >= charSequence.length()) {
            return "";
        }
        if (n < 0 || n2 < 0) {
            return "";
        }
        if (n2 > charSequence.length()) {
            n2 = charSequence.length();
        }
        return charSequence.subSequence(n, n2);
    }

    static String titleOfPages(EditorPanel editorPanel) {
        return "[PAGES]#" + Integer.toString(editorPanel.hashCode(), 36);
    }

    static CharSequence trimLeft(CharSequence charSequence) {
        int n;
        for (n = 0; n < charSequence.length() && (charSequence.charAt(n) == ' ' || charSequence.charAt(n) == '\t'); ++n) {
        }
        return n > 0 ? charSequence.subSequence(n, charSequence.length()) : charSequence;
    }

    public static String exportString(List<CharSequence> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (CharSequence charSequence : list) {
            if (bl) {
                stringBuilder.append(string);
            } else {
                bl = true;
            }
            stringBuilder.append(charSequence);
        }
        return stringBuilder.toString();
    }

    public static List<CharSequence> removeTailR(List<String> list) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        for (String string : list) {
            if ((string = U.removeTailR(string).toString()).startsWith("\r")) {
                string = string.substring(1);
            }
            if (string.contains("\r")) {
                String[] stringArray;
                for (String string2 : stringArray = string.split("\\r")) {
                    arrayList.add(string2);
                }
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public static int between(int n, int n2, int n3) {
        return Math.min(n3, Math.max(n2, n));
    }

    public static Image getAppIcon(String string) throws IOException {
        Image image = appIcons.get(string);
        if (image != null) {
            return image;
        }
        image = ImageIO.read(EditorPanel.class.getResourceAsStream("/" + string));
        appIcons.put(string, image);
        return image;
    }

    public static boolean isSpaceChar(char c) {
        return Character.isSpaceChar(c) || c == '\t';
    }

    public static void changePathSep(PageData pageData, int n) {
        if (n >= pageData.lines.size()) {
            return;
        }
        String string = pageData.lines.get(n).toString();
        int n2 = string.indexOf(47);
        String string2 = null;
        if (n2 >= 0) {
            string2 = string.replace('/', '\\');
        } else {
            int n3 = string.indexOf(92);
            if (n3 >= 0) {
                string2 = string.replace('\\', '/');
            }
        }
        if (string2 != null) {
            pageData.editRec.deleteInLine(n, 0, string.length());
            pageData.editRec.insertInLine(n, 0, string2);
        }
    }

    public static String evalMath(String string) {
        System.out.println("eval:" + string);
        return U.addComma(new MathExprParser(string).parse().stripTrailingZeros().toPlainString());
    }

    private static String addComma(String string) {
        int n = string.indexOf(46);
        Object object = "";
        String string2 = "";
        if (n >= 0) {
            object = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            object = string;
        }
        if (((String)object).length() > 6) {
            object = U.addCommaInt((String)object);
        }
        if (string2.length() > 0) {
            object = (String)object + "." + string2;
        }
        return object;
    }

    private static String addCommaInt(String string) {
        int n = (string.length() - 1) / 3;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length() % 3;
        int n3 = n2;
        if (n3 > 0) {
            stringBuilder.append(string.substring(0, n3));
            stringBuilder.append(',');
            --n;
        }
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string.substring(n3, n3 + 3));
            stringBuilder.append(',');
            n3 += 3;
        }
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    public static String getMathExprTail(String string) {
        int n;
        for (n = string.length(); n > 0 && U.isMathExprChar(string.charAt(n - 1)); --n) {
        }
        string = string.substring(n);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("+-/*^xb".indexOf(c) < 0) continue;
            return string;
        }
        return "";
    }

    static boolean isMathExprChar(char c) {
        return U.isMathExprNumberChar(c) || "+-/*^() ".indexOf(c) >= 0;
    }

    static boolean isMathExprNumberChar(int n) {
        return n >= 48 && n <= 57 || n >= 97 && n <= 102 || n >= 65 && n <= 70 || n == 46 || n == 44 || n == 69 || n == 120;
    }

    public static char charAtWhenMove(CharSequence charSequence, int n) {
        if (charSequence.length() == 0) {
            return ' ';
        }
        if (n >= charSequence.length()) {
            return ' ';
        }
        return charSequence.charAt(n);
    }

    public static boolean getBool(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String string = object.toString().toLowerCase();
        if ("y".equals(string) || "1".equals(string) || "true".equals(string)) {
            return true;
        }
        if ("n".equals(string) || "0".equals(string) || "false".equals(string)) {
            return false;
        }
        return false;
    }

    public static int getInt(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return (int)Float.parseFloat(object.toString());
    }

    public static float getFloat(Object object) {
        if (object == null) {
            return 0.0f;
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        return Float.parseFloat(object.toString());
    }

    public static void openFileSelector(String string, PlainPage plainPage) {
        File file = U.findFile(plainPage.workPath, string);
        if (file == null) {
            plainPage.ui.message("cannot find filename in current line");
            return;
        }
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setDialogTitle("browse and copy file name");
        jFileChooser.setPreferredSize(new Dimension(800, 600));
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            U.setClipBoard(string2);
            plainPage.ui.message("filename copied");
        }
    }

    public static PlainPage findPageByData(List<PlainPage> list, PageData pageData) {
        for (PlainPage plainPage : list) {
            if (!plainPage.pageData.equals(pageData)) continue;
            return plainPage;
        }
        return null;
    }

    public static void optimizeFileHistory() throws IOException {
        File file = U.getFileHistoryName();
        List<String> list = FileUtil.readStringBig(file, UTF8);
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = list.size() - 1; i >= 0; --i) {
            String string = list.get(i).trim();
            if (string.endsWith("|0:") || string.endsWith("|1:")) {
                string = string.substring(0, string.length() - 3).trim();
            }
            if (string.isEmpty()) continue;
            String string2 = string;
            int n = string2.lastIndexOf(124);
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
            if (hashSet.contains(string2)) continue;
            hashSet.add(string2);
            arrayList.add(string);
        }
        Collections.reverse(arrayList);
        U.save(arrayList, UTF8, file.getAbsolutePath());
        System.out.printf("file history optimized (%d->%d)\n", list.size(), arrayList.size());
    }

    public static void appendSearchResultHistory(String string) throws IOException {
        File file = U.getSearchHistoryName();
        FileOutputStream fileOutputStream = new FileOutputStream(file, true);
        fileOutputStream.write(string.getBytes(UTF8));
        fileOutputStream.write(10);
        fileOutputStream.close();
    }

    public static boolean hardwareFailWorkaroundFilterOut(KeyEvent keyEvent) {
        long l;
        Long l2;
        char c;
        if (keymintime <= 0) {
            return false;
        }
        long l3 = System.currentTimeMillis();
        boolean bl = false;
        if (bl) {
            c = '\u0000';
            l2 = keystime.get(c);
            if (l2 == null) {
                l2 = 0L;
            }
            keystime.put(Integer.valueOf(c), l3);
            l = l3 - l2;
            System.out.printf("KC0 e=%d M=%d\n", l, keymintime);
        }
        if ((l2 = keystime.get(c = keyEvent.getKeyChar())) == null) {
            l2 = 0L;
        }
        keystime.put(Integer.valueOf(c), l3);
        l = l3 - l2;
        if (bl) {
            System.out.printf("kc=%d e=%d M=%d\n", c, l, keymintime);
        }
        return l2 != null && l < (long)keymintime;
    }

    public static void appendAllFileHistory() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (EditorPanel editorPanel : EditorPanel.insts) {
            U.addFileHis(arrayList, hashSet, editorPanel);
        }
        if (!arrayList.isEmpty()) {
            U.saveFileHistory("\n" + String.join((CharSequence)"\n", arrayList), 0);
            System.out.printf("saved %,d file history at last chance.\n", arrayList.size());
        }
    }

    public static void appendEpFileHistory(EditorPanel editorPanel) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        U.addFileHis(arrayList, hashSet, editorPanel);
        if (!arrayList.isEmpty()) {
            U.saveFileHistory("\n" + String.join((CharSequence)"\n", arrayList), 0);
            System.out.printf("saved %,d file history when close EP.\n", arrayList.size());
        }
    }

    private static void addFileHis(List<String> list, Set<String> set, EditorPanel editorPanel) {
        for (PlainPage plainPage : editorPanel.pageSet) {
            PageData pageData = plainPage.pageData;
            String string = null;
            if (pageData.fileLoaded) {
                string = pageData.title;
            }
            if (string == null || set.contains(string)) continue;
            set.add(string);
            int n = plainPage.cy;
            if (n > 0) {
                list.add(String.format("%s|%d:", string, n + 1));
                continue;
            }
            list.add(string);
        }
    }

    static {
        TAB_WIDTH = 20;
        BOMS = new Object[][]{{new int[]{239, 187, 191}, "UTF-8"}, {new int[]{254, 255}, "UTF-16BE"}, {new int[]{255, 254}, "UTF-16LE"}, {new int[]{0, 0, 254, 255}, "UTF-32BE"}, {new int[]{255, 254, 0, 0}, "UTF-32LE"}};
        random = new Random();
        addTime = true;
        SPACES = "                                                                                         ";
        TitleName = "/ne/ ";
        appIcons = new HashMap<String, Image>();
        keystime = new HashMap<Integer, Long>();
    }

    public static class UnicodeFormatter {
        public static String byteToHex(byte by) {
            char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            char[] cArray2 = new char[]{cArray[by >> 4 & 0xF], cArray[by & 0xF]};
            return new String(cArray2);
        }

        public static String charToHex(char c) {
            byte by = (byte)(c >> 8);
            byte by2 = (byte)(c & 0xFF);
            return UnicodeFormatter.byteToHex(by) + UnicodeFormatter.byteToHex(by2);
        }
    }

    static class TH
    extends TransferHandler {
        private final EditorPanel ep;

        TH(EditorPanel editorPanel) {
            this.ep = editorPanel;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            return transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            if (!this.canImport(transferSupport)) {
                return false;
            }
            Transferable transferable = transferSupport.getTransferable();
            try {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : list) {
                    if (!file.isFile()) continue;
                    try {
                        this.ep.findAndShowPage(file.getAbsolutePath(), -1, true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            this.ep.repaint();
            return true;
        }
    }

    public static class SimpleLayout {
        JPanel curr;
        JPanel p;

        public SimpleLayout(JPanel jPanel) {
            this.p = jPanel;
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            this.newCurrent();
        }

        public void add(JComponent jComponent) {
            this.curr.add(jComponent);
        }

        void newCurrent() {
            this.curr = new JPanel();
            this.curr.setLayout(new BoxLayout(this.curr, 2));
        }

        public void newline() {
            this.p.add(this.curr);
            this.newCurrent();
        }
    }

    public static class LocationHistory<E> {
        LinkedList<E> his = new LinkedList();
        int pos = 0;

        public E back(E e) {
            if (this.pos > 0) {
                this.his.set(this.pos, e);
                --this.pos;
                return this.his.get(this.pos);
            }
            return null;
        }

        public E forward(E e) {
            if (this.pos < this.his.size() - 1) {
                this.his.set(this.pos, e);
                ++this.pos;
                return this.his.get(this.pos);
            }
            return null;
        }

        public void add(E e, E e2) {
            if (this.his.size() > this.pos + 1) {
                this.removeLastN(this.his.size() - this.pos - 1);
            }
            if (!this.his.isEmpty()) {
                this.his.set(this.his.size() - 1, e2);
            }
            this.his.add(e);
            this.pos = this.his.size() - 1;
        }

        private void removeLastN(int n) {
            for (int i = 0; i < n; ++i) {
                this.his.removeLast();
            }
        }
    }
}

