/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.Date;
import java.util.List;
import neoe.ne.EditorPanel;
import neoe.ne.FontList;
import neoe.ne.PlainPage;
import neoe.ne.ReadonlyLines;
import neoe.ne.U;

public class Print
implements Printable {
    Color colorLineNumber = new Color(3195392);
    Color colorGutterLine = new Color(3195392);
    Color colorNormal = Color.BLACK;
    Color colorDigit = new Color(11010090);
    Color colorKeyword = new Color(39372);
    Color colorHeaderFooter = new Color(9044152);
    Color colorComment = new Color(200, 80, 50);
    Dimension dim;
    String fn;
    FontList fonts;
    int lineGap = 3;
    int lineHeight = 8;
    int headerHeight = 20;
    int footerHeight = 20;
    int gutterWidth = 24;
    int linePerPage;
    private final PlainPage pp;
    ReadonlyLines roLines;
    String title;
    int totalPage;
    PlainPage.Paint ui;
    EditorPanel uiComp;

    public Print(PlainPage plainPage) {
        this.pp = plainPage;
        this.ui = plainPage.ui;
        this.uiComp = plainPage.uiComp;
        this.roLines = plainPage.pageData.roLines;
        this.fn = plainPage.pageData.title;
        this.title = plainPage.pageData.title;
        this.fonts = plainPage.fontList;
        this.lineHeight = this.fonts.getlineHeight();
    }

    void drawReturn(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setColor(Color.red);
        graphics2D.drawLine(n, n2 - this.lineHeight + this.fonts.getlineHeight(), n + 3, n2 - this.lineHeight + this.fonts.getlineHeight());
    }

    int drawStringLine(Graphics2D graphics2D, FontList fontList, String string, int n, int n2) {
        int n3 = 0;
        int n4 = this.getCommentPos(string);
        if (n4 >= 0) {
            String string2 = string.substring(0, n4);
            String string3 = string.substring(n4);
            int n5 = this.drawText(graphics2D, fontList, string2, n, n2, false);
            n3 = n5 + this.drawText(graphics2D, fontList, string3, n + n5, n2, true);
        } else {
            n3 = this.drawText(graphics2D, fontList, string, n, n2, false);
        }
        return n3;
    }

    int drawText(Graphics2D graphics2D, FontList fontList, String string, int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = this.dim.width - this.gutterWidth;
        List<CharSequence> list = U.splitToken(string);
        for (CharSequence charSequence : list) {
            String string2 = charSequence.toString();
            if (string2.equals("\t")) {
                graphics2D.drawImage(U.tabImgPrint, n + n3, n2 - this.lineHeight, null);
                n3 += U.TAB_WIDTH;
            } else if (bl) {
                graphics2D.setColor(this.colorComment);
                n3 += U.drawString(graphics2D, fontList, string2, n + n3, n2, n4);
                if (n3 > this.dim.width - this.gutterWidth) {
                    break;
                }
            } else {
                U.getHighLightID(string2, graphics2D, this.colorKeyword, this.colorDigit, this.colorNormal);
                n3 += U.drawString(graphics2D, fontList, string2, n + n3, n2, n4);
            }
            if (n3 <= n4) continue;
            break;
        }
        return n3;
    }

    private int getCommentPos(String string) {
        String[] stringArray = this.pp.pageData.comment;
        if (stringArray == null) {
            return -1;
        }
        for (String string2 : stringArray) {
            int n = string.indexOf(string2);
            if (n < 0) continue;
            return n;
        }
        return -1;
    }

    int getTotalPage(PageFormat pageFormat) {
        this.linePerPage = ((int)pageFormat.getImageableHeight() - this.footerHeight - this.headerHeight) / (this.lineGap + this.lineHeight);
        System.out.printf("page[%fx%f] linePerPage=%d", pageFormat.getImageableHeight(), pageFormat.getImageableWidth(), this.linePerPage);
        if (this.linePerPage <= 0) {
            this.linePerPage = 1;
            return 1;
        }
        int n = this.roLines.getLinesize();
        int n2 = n % this.linePerPage == 0 ? n / this.linePerPage : n / this.linePerPage + 1;
        return n2;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > this.totalPage) {
            return 1;
        }
        this.ui.message("printing " + (n + 1) + "/" + this.totalPage);
        this.uiComp.repaint();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        if (this.ui.noise) {
            U.paintNoise(graphics2D, new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight()));
        }
        int n2 = (int)pageFormat.getImageableWidth();
        graphics2D.setColor(this.colorHeaderFooter);
        U.drawString(graphics2D, this.fonts, this.fn == null ? this.title : new File(this.fn).getName(), 0, this.lineGap + this.lineHeight, n2);
        String string = n + 1 + "/" + this.totalPage;
        U.drawString(graphics2D, this.fonts, string, (int)pageFormat.getImageableWidth() - U.stringWidth(graphics2D, this.fonts, string, n2) - 2, this.lineGap + this.lineHeight, n2);
        string = new Date().toString() + " - NeoeEdit";
        U.drawString(graphics2D, this.fonts, string, (int)pageFormat.getImageableWidth() - U.stringWidth(graphics2D, this.fonts, string, n2) - 2, (int)pageFormat.getImageableHeight() - 2, n2);
        graphics2D.setColor(this.colorGutterLine);
        graphics2D.drawLine(this.gutterWidth - 4, this.headerHeight, this.gutterWidth - 4, (int)pageFormat.getImageableHeight() - this.footerHeight);
        int n3 = this.linePerPage * n;
        int n4 = (int)pageFormat.getImageableWidth() / 5 + 5;
        for (int i = 0; i < this.linePerPage && n3 < this.roLines.getLinesize(); ++i) {
            int n5 = this.headerHeight + (this.lineGap + this.lineHeight) * (i + 1);
            graphics2D.setColor(this.colorLineNumber);
            U.drawString(graphics2D, this.fonts, "" + (n3 + 1), 0, n5, n2);
            graphics2D.setColor(this.colorNormal);
            String string2 = this.roLines.getline(n3++).toString();
            if (string2.length() > n4) {
                string2 = string2.substring(0, n4);
            }
            int n6 = this.drawStringLine(graphics2D, this.fonts, string2, this.gutterWidth, n5);
            this.drawReturn(graphics2D, n6 + this.gutterWidth + 2, n5);
        }
        return 0;
    }

    void printPages() {
        U.startDaemonThread(new Thread(){

            @Override
            public void run() {
                try {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    PageFormat pageFormat = printerJob.pageDialog(printerJob.defaultPage());
                    Print.this.totalPage = Print.this.getTotalPage(pageFormat);
                    if (Print.this.totalPage <= 0) {
                        return;
                    }
                    Print.this.dim = new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
                    Book book = new Book();
                    book.append(Print.this, pageFormat, Print.this.totalPage);
                    printerJob.setPageable(book);
                    if (printerJob.printDialog()) {
                        Print.this.ui.message("printing...");
                        Print.this.uiComp.repaint();
                        printerJob.print();
                        Print.this.ui.message("print ok");
                        Print.this.uiComp.repaint();
                    }
                }
                catch (Exception exception) {
                    Print.this.ui.message("err:" + String.valueOf(exception));
                    Print.this.uiComp.repaint();
                    exception.printStackTrace();
                }
            }
        });
    }
}

