/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import neoe.ne.PlainPage;
import neoe.ne.U;

public class Plugin {
    public static boolean loaded = false;
    static Map<String, PluginCall> calls = new HashMap<String, PluginCall>();
    static List<KeyHandle> keyHandles = new ArrayList<KeyHandle>();
    public static List<GoHandle> goHandles = new ArrayList<GoHandle>();

    public static void load() throws Exception {
        if (loaded) {
            System.out.println("plugin seems already loaded, pass");
            return;
        }
        loaded = true;
        String string = String.valueOf(U.getMyDir()) + "/plugins";
        new File(string).mkdirs();
        File file = new File(string).getAbsoluteFile();
        File[] fileArray = file.listFiles();
        int n = 0;
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                if (!Plugin.addDirPlugin(file2)) continue;
                ++n;
                continue;
            }
            if (!file2.getName().toLowerCase().endsWith(".jar") || !Plugin.addJarPlugin(file2)) continue;
            ++n;
        }
        System.out.println("added plugin count:" + n);
    }

    private static boolean addDirPlugin(File file) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        System.out.println("add plugin in dir:" + file.getAbsolutePath());
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (File file2 : file.listFiles()) {
            if (!file2.isFile() || !file2.getName().endsWith(".jar")) continue;
            arrayList.add(file2.toURI().toURL());
            System.out.println("\tadd: " + file2.getName() + " \t " + simpleDateFormat.format(new Date(file2.lastModified())));
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), Plugin.class.getClassLoader());
        return Plugin.initPlugin(uRLClassLoader);
    }

    private static boolean addJarPlugin(File file) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        System.out.println("add plugin " + file.getAbsolutePath() + " \t " + simpleDateFormat.format(new Date(file.lastModified())));
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.add(file.toURI().toURL());
        URLClassLoader uRLClassLoader = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), Plugin.class.getClassLoader());
        return Plugin.initPlugin(uRLClassLoader);
    }

    private static boolean initPlugin(ClassLoader classLoader) throws Exception {
        try {
            Class<?> clazz = classLoader.loadClass("neoe.ne.plugin.PluginInit");
            Method method = clazz.getMethod("run", new Class[0]);
            method.invoke(null, new Object[0]);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static Object call(String string, Object object) throws Exception {
        PluginCall pluginCall = calls.get(string);
        if (pluginCall == null) {
            return null;
        }
        return pluginCall.run(object);
    }

    public static void registerCall(String string, PluginCall pluginCall) {
        calls.put(string, pluginCall);
    }

    public static void registerKeyHandle(KeyHandle keyHandle) {
        if (keyHandle != null) {
            keyHandles.add(keyHandle);
        }
    }

    public static String registerCmd(String string, PluginAction pluginAction) {
        String string2;
        try {
            string2 = U.getKeyNameFromTextName(string);
        }
        catch (Exception exception) {
            return String.format("Key '%s' is not correct:%s", string, exception);
        }
        if (U.keys.containsKey(string2)) {
            return String.format("Key '%s[%s]' is already in use by build-in function '%s'.", string, string2, U.keys.get(string2).name());
        }
        if (U.pluginKeys.containsKey(string2)) {
            return String.format("Key '%s[%s]' is already in use by other plugin '%s'.", string, string2, U.pluginKeys.get(string2).getClass().getName());
        }
        U.pluginKeys.put(string2, pluginAction);
        return null;
    }

    public static boolean goHandle(String string, PlainPage plainPage) {
        for (GoHandle goHandle : goHandles) {
            if (!goHandle.run(string, plainPage)) continue;
            return true;
        }
        return false;
    }

    public static PluginAction2 findAction(String string) throws Exception {
        for (KeyHandle keyHandle : keyHandles) {
            PluginAction2 pluginAction2 = keyHandle.findAction(string);
            if (pluginAction2 == null) continue;
            return pluginAction2;
        }
        return null;
    }

    public static interface PluginCall {
        public Object run(Object var1) throws Exception;
    }

    public static interface PluginAction {
        public void run(PlainPage var1) throws Exception;
    }

    public static interface GoHandle {
        public boolean run(String var1, PlainPage var2);
    }

    public static interface KeyHandle {
        public PluginAction2 findAction(String var1) throws Exception;
    }

    public static interface PluginAction2 {
        public void run(PlainPage var1, String var2) throws Exception;
    }
}

