/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import neoe.ne.CommandPanel;
import neoe.ne.Commands;
import neoe.ne.Conf;
import neoe.ne.Console;
import neoe.ne.EditorPanel;
import neoe.ne.EditorPanelConfig;
import neoe.ne.FindAndReplace;
import neoe.ne.FontList;
import neoe.ne.Ime;
import neoe.ne.PageData;
import neoe.ne.Plugin;
import neoe.ne.Print;
import neoe.ne.ReadonlyLines;
import neoe.ne.U;
import neoe.ne.util.FindJDK;

public class PlainPage {
    public Console console;
    Cursor cursor = new Cursor();
    public int cx;
    public int cy;
    public Map<String, String> env;
    public String[] envs;
    FontList fontList;
    boolean ignoreCase = true;
    public int keepx = -1;
    Dimension lastSize = new Dimension();
    int mcount;
    String msg;
    long msgtime;
    boolean mshift;
    int mx;
    int my;
    public String workPath = ".";
    public PageData pageData;
    private String preeditText;
    public EasyEdit ptEdit = new EasyEdit();
    public FindAndReplace ptFind = new FindAndReplace(this);
    public Selection ptSelection = new Selection();
    public boolean readonly = false;
    boolean rectSelectMode = false;
    boolean savingFromSelectionCancel;
    int selectstartx;
    int selectstarty;
    int selectstopx;
    int selectstopy;
    int showLineCnt;
    int showLineCnt2;
    int sx;
    int sy;
    int toolbarHeight = 25;
    public Paint ui = new Paint();
    public EditorPanel uiComp;
    boolean follow;

    private static boolean isButtonDown(int n, MouseEvent mouseEvent) {
        int n2 = InputEvent.getMaskForButton(n);
        int n3 = mouseEvent.getModifiersEx();
        return (n3 & n2) != 0;
    }

    private PlainPage() {
    }

    public PlainPage(EditorPanel editorPanel, PageData pageData, PlainPage plainPage) throws Exception {
        this.uiComp = editorPanel;
        this.pageData = pageData;
        if (plainPage != null) {
            this.ui.applyColorMode(plainPage.ui.colorMode);
            this.ui.scalev = plainPage.ui.scalev;
            this.ui.shrinkWord = plainPage.ui.shrinkWord;
            this.fontList = plainPage.fontList;
            if (this.fontList == Conf.defaultConsoleFonts) {
                this.fontList = Conf.defaultFontList;
            }
            this.workPath = plainPage.workPath;
            this.showLineCnt = plainPage.showLineCnt;
            this.follow = plainPage.follow;
            if (plainPage.env != null) {
                this.env = new LinkedHashMap<String, String>(plainPage.env);
            }
        } else {
            this.fontList = Conf.defaultFontList;
        }
        if (pageData.fileLoaded) {
            this.workPath = new File(pageData.title).getParent();
        }
        editorPanel.pageSet.add(this);
        editorPanel.setPage(this, true);
        ++pageData.ref;
    }

    public void close() throws Exception {
        String string = this.uiComp.pageHis.back(U.getLocString(this));
        this.uiComp.page = null;
        this.uiComp.pageSet.remove(this);
        --this.pageData.ref;
        if (this.pageData.ref <= 0) {
            this.pageData.close();
        }
        this.pageData = null;
        if (this.uiComp.pageSet.size() <= 0) {
            if (this.uiComp.frame != null) {
                if (this.uiComp.frame instanceof JFrame) {
                    ((JFrame)this.uiComp.frame).dispose();
                } else if (this.uiComp.frame instanceof JFrame) {
                    ((JInternalFrame)this.uiComp.frame).dispose();
                } else {
                    System.out.println("cannot close frame, bug");
                }
            }
        } else {
            PlainPage.gotoFileLine(string, this.uiComp, false);
        }
        if (this.uiComp.page == null && !this.uiComp.pageSet.isEmpty()) {
            PlainPage plainPage = this.uiComp.pageSet.get(0);
            this.uiComp.setPage(plainPage, false);
        }
    }

    public void go(String object, boolean bl) throws Exception {
        if (object == null) {
            return;
        }
        if (((String)(object = ((String)object).trim())).isEmpty()) {
            return;
        }
        if (((String)object).startsWith("set-font:")) {
            String string = ((String)object).substring("set-font:".length()).trim();
            Font font = U.getFont(string, this.fontList.getlineHeight());
            U.setFont(this.uiComp, font);
        } else {
            if (((String)object).startsWith("~/")) {
                object = U.getUserHome() + ((String)object).substring(1);
            }
            this.uiComp.newWindow = bl;
            if (!(this.pageData.searchResultOf != null && PlainPage.gotoFileLineSearchResult(this.uiComp, (String)object, this.pageData.searchResultOf) || PlainPage.gotoFileLine((String)object, this.uiComp, true) || U.listDirOrOpenFile(this, this.cy) || Plugin.goHandle((String)object, this))) {
                U.launch((String)object);
            }
            this.uiComp.newWindow = false;
        }
    }

    private static boolean gotoFileLine(String string, EditorPanel editorPanel, boolean bl) throws Exception {
        if (string == null) {
            return false;
        }
        String string2 = string;
        int n = string.indexOf(124);
        if (n >= 0) {
            string2 = string.substring(0, n).trim();
            int n2 = string.indexOf(58, n);
            if (n2 >= 0) {
                int n3 = -1;
                try {
                    String string3 = string.substring(n + 1, n2);
                    n3 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n3 >= 0) {
                    editorPanel.findAndShowPage(string2, n3, bl);
                    return true;
                }
            }
        } else {
            n = string.indexOf(58, 2);
            if (n > 0) {
                int n4 = 0;
                try {
                    string2 = string.substring(0, n).trim();
                    int n5 = string.indexOf(58, n + 1);
                    String string4 = n5 > 0 ? string.substring(n + 1, n5).trim() : string.substring(n + 1).trim();
                    n4 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return editorPanel.findAndShowPage(string2, n4, bl);
            }
        }
        return false;
    }

    private static boolean gotoFileLineSearchResult(EditorPanel editorPanel, String string, String string2) throws Exception {
        int n = string.indexOf(":");
        if (n >= 0) {
            try {
                int n2 = Integer.parseInt(string.substring(0, n));
                return editorPanel.findAndShowPage(string2, n2, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void doMoveViewDown() {
        this.sy = Math.min(this.sy + 1, this.pageData.roLines.getLinesize() - 1);
    }

    public void doMoveViewUp() {
        this.sy = Math.max(0, this.sy - 1);
    }

    public void doMoveViewPageDown() {
        this.sy = Math.min(this.sy + this.showLineCnt2, this.pageData.roLines.getLinesize() - 1);
    }

    public void doMoveViewPageUp() {
        this.sy = Math.max(0, this.sy - this.showLineCnt2);
    }

    public void focusCursor() {
        this.sy = U.between(U.between(this.sy, this.cy - this.showLineCnt + 3, this.cy - 3), 0, this.pageData.roLines.getLinesize() - 1);
    }

    public void adjustCursor() {
        if (this.showLineCnt == 0) {
            this.showLineCnt = (int)Math.ceil((float)(this.uiComp.getSize().height - this.toolbarHeight) / ((float)(this.ui.lineHeight + this.ui.lineGap) * this.ui.scalev));
            this.showLineCnt2 = (int)Math.floor((float)(this.uiComp.getSize().height - this.toolbarHeight) / ((float)(this.ui.lineHeight + this.ui.lineGap) * this.ui.scalev));
            if (this.showLineCnt2 <= 0) {
                this.showLineCnt2 = 1;
            }
        }
        int n = Math.max(5, this.showLineCnt);
        this.sy = Math.max(0, this.cy - n / 2 + 1);
        int n2 = this.pageData.roLines.getLinesize();
        int n3 = n - (n2 - this.sy);
        if (n3 > 0) {
            this.sy = Math.max(0, this.sy - n3 + 1);
        }
    }

    private boolean isButtonBack(MouseEvent mouseEvent) {
        return !FindJDK.isLinux ? PlainPage.isButtonDown(4, mouseEvent) : PlainPage.isButtonDown(6, mouseEvent);
    }

    private boolean isButtonForward(MouseEvent mouseEvent) {
        return !FindJDK.isLinux ? PlainPage.isButtonDown(5, mouseEvent) : PlainPage.isButtonDown(7, mouseEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(KeyEvent keyEvent) {
        Ime.ImeInterface imeInterface = Ime.getCurrentIme();
        if (imeInterface != null && keyEvent.getKeyCode() != 9) {
            Ime.Out out = new Ime.Out();
            if (!keyEvent.isControlDown() && !keyEvent.isAltDown()) {
                imeInterface.keyPressed(keyEvent.getKeyCode(), out);
            }
            if (out.yield != null) {
                this.ptEdit.insertString(out.yield);
            }
            this.preeditText = out.preedit;
            if (out.consumed) {
                this.repaint();
                return;
            }
        }
        if (keyEvent.getKeyCode() == 27 && this.ui.cp.showCommandPanel) {
            this.ui.cp.showCommandPanel = false;
            keyEvent.consume();
            this.repaint();
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n == 16 || n == 17 || n == 18) {
            return;
        }
        this.pageData.history.beginAtom();
        try {
            boolean bl;
            this.mshift = keyEvent.isShiftDown();
            int n2 = this.cx;
            int n3 = this.cy;
            String string = U.getKeyName(keyEvent);
            Plugin.PluginAction2 pluginAction2 = Plugin.findAction(string);
            if (pluginAction2 != null) {
                try {
                    pluginAction2.run(this, string);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable.printStackTrace();
                    if (throwable.getCause() != null) {
                        throwable2 = throwable.getCause();
                    }
                    this.ui.message("plugin:" + throwable2.getMessage());
                }
                keyEvent.consume();
                this.repaint();
                return;
            }
            Plugin.PluginAction pluginAction = U.pluginKeys.get(string);
            if (pluginAction != null) {
                try {
                    pluginAction.run(this);
                }
                catch (Throwable throwable) {
                    Throwable throwable3;
                    throwable.printStackTrace();
                    if (throwable.getCause() != null) {
                        throwable3 = throwable.getCause();
                    }
                    this.ui.message("plugin:" + throwable3.getMessage());
                }
                keyEvent.consume();
                this.repaint();
                return;
            }
            Commands commands = U.mappingToCommand(keyEvent);
            if (commands != null) {
                this.processCommand(commands);
                keyEvent.consume();
            } else if (keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isActionKey()) {
                this.unknownCommand(keyEvent);
            }
            boolean bl2 = bl = n2 != this.cx || n3 != this.cy;
            if (bl) {
                if (keyEvent.isShiftDown()) {
                    this.selectstopx = this.cx;
                    this.selectstopy = this.cy;
                } else if (this.savingFromSelectionCancel) {
                    this.savingFromSelectionCancel = false;
                } else {
                    this.ptSelection.cancelSelect();
                }
            }
            this.repaint();
        }
        catch (Throwable throwable) {
            this.ui.message("err:" + String.valueOf(throwable));
            throwable.printStackTrace();
        }
        finally {
            if (this.pageData != null) {
                this.pageData.history.endAtom();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyTyped(KeyEvent keyEvent) {
        block17: {
            if (this.readonly) {
                return;
            }
            if (!keyEvent.isControlDown() && !keyEvent.isAltDown()) {
                this.pageData.history.beginAtom();
                try {
                    String string;
                    char c = keyEvent.getKeyChar();
                    if (c == '\t' && keyEvent.isShiftDown()) {
                        Rectangle rectangle = this.ptSelection.getSelectRect();
                        if (rectangle.y < rectangle.height) {
                            this.ptEdit.moveRectLeft(rectangle.y, rectangle.height);
                        } else {
                            this.ptEdit.moveLineLeft(this.cy);
                        }
                        break block17;
                    }
                    if (c == '\t' && !keyEvent.isShiftDown() && this.selectstarty != this.selectstopy && !this.rectSelectMode) {
                        Rectangle rectangle = this.ptSelection.getSelectRect();
                        this.ptEdit.moveRectRight(rectangle.y, rectangle.height);
                        break block17;
                    }
                    Ime.ImeInterface imeInterface = Ime.getCurrentIme();
                    if (imeInterface != null && c != '\t') {
                        Ime.Out out = new Ime.Out();
                        if (!keyEvent.isControlDown() && !keyEvent.isAltDown()) {
                            imeInterface.keyTyped(keyEvent.getKeyChar(), out);
                        }
                        if (out.yield != null) {
                            this.ptEdit.insertString(out.yield);
                        }
                        this.preeditText = out.preedit;
                        if (!out.consumed) {
                            this.ptEdit.insert(c);
                        }
                        break block17;
                    }
                    this.ptEdit.insert(c);
                    if (c != '=' || this.cx > (string = this.pageData.roLines.getline(this.cy).toString()).length() || this.cx < 3) break block17;
                    try {
                        string = string.substring(0, this.cx);
                        if (string.endsWith("=")) {
                            string = string.substring(0, string.length() - 1);
                        }
                        if (!(string = U.getMathExprTail(string)).isEmpty()) {
                            this.ptEdit.insertString(" " + U.evalMath(string));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    this.pageData.history.endAtom();
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.ui.cp.showCommandPanel) {
            this.ui.cp.mouseClicked(mouseEvent);
            if (this.ui.cp.clickedName != null) {
                try {
                    this.processCommand(Commands.valueOf(this.ui.cp.clickedName));
                    this.repaint();
                    this.mx = 0;
                    this.my = 0;
                    this.ui.cp.showCommandPanel = false;
                }
                catch (Throwable throwable) {
                    this.ui.message("err:" + String.valueOf(throwable));
                    throwable.printStackTrace();
                }
                this.ui.cp.clickedName = null;
            }
            return;
        }
        if (PlainPage.isButtonDown(4, mouseEvent) || PlainPage.isButtonDown(5, mouseEvent) || PlainPage.isButtonDown(6, mouseEvent) || PlainPage.isButtonDown(7, mouseEvent)) {
            return;
        }
        int n = mouseEvent.getY();
        if (n > 0 && n < this.toolbarHeight) {
            if (this.pageData.fileLoaded) {
                U.setClipBoard(this.pageData.title);
                this.ui.message("filename copied");
                n = 0;
            } else if (this.workPath != null) {
                U.setClipBoard(this.workPath);
                this.ui.message("work path copied");
                n = 0;
            } else {
                try {
                    if (U.saveFile(this)) {
                        this.ui.message("saved");
                    }
                }
                catch (Throwable throwable) {
                    this.ui.message("err:" + String.valueOf(throwable));
                    throwable.printStackTrace();
                }
            }
        } else {
            int n2 = mouseEvent.getX();
            if (n2 > 0 && n2 < this.ui.gutterWidth) {
                this.cursor.gotoLine();
                this.repaint();
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (PlainPage.isButtonDown(4, mouseEvent) || PlainPage.isButtonDown(5, mouseEvent) || PlainPage.isButtonDown(6, mouseEvent) || PlainPage.isButtonDown(7, mouseEvent)) {
            return;
        }
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
        this.mshift = true;
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.ui.cp.showCommandPanel) {
            this.ui.cp.mouseMoved(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) throws Exception {
        if (this.isButtonBack(mouseEvent)) {
            PlainPage.gotoFileLine(this.uiComp.pageHis.back(U.getLocString(this)), this.uiComp, false);
        } else if (this.isButtonForward(mouseEvent)) {
            PlainPage.gotoFileLine(this.uiComp.pageHis.forward(U.getLocString(this)), this.uiComp, false);
        } else {
            this.mx = mouseEvent.getX();
            this.my = mouseEvent.getY();
            this.mshift = mouseEvent.isShiftDown();
            this.mcount = mouseEvent.getClickCount();
            this.repaint();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation() * mouseWheelEvent.getScrollAmount();
        if (mouseWheelEvent.isControlDown()) {
            U.scale(n, this.ui);
            this.repaint();
        } else if (mouseWheelEvent.isAltDown()) {
            this.cursor.scrollHorizon(n);
        } else {
            this.cursor.scroll(n);
        }
    }

    public void preedit(String string, int n) {
        if (n > 0) {
            String string2 = string.substring(0, n);
            string = string.substring(n);
            this.ptEdit.insertString(string2);
        }
        this.preeditText = string;
        this.repaint();
    }

    void processCommand(Commands commands) throws Exception {
        switch (commands) {
            case showHelp: {
                U.showHelp(this.ui, this.uiComp);
                break;
            }
            case saveAs: {
                U.saveAs(this);
                break;
            }
            case toggleTimeExec: {
                U.addTime = !U.addTime;
                U.setEnv(this, "ne_addTime", "" + U.addTime);
                this.ui.message("timestamp in console:" + U.addTime);
                break;
            }
            case toggleFollowExec: {
                if (this.console == null) break;
                this.follow = this.console.follow = !this.console.follow;
                this.ui.message("follow the console:" + this.console.follow);
                break;
            }
            case toggleShrinkWord: {
                U.shrinkWord = !U.shrinkWord;
                this.ui.message("shrinkWord:" + U.shrinkWord);
                break;
            }
            case changePathSep: {
                U.changePathSep(this.pageData, this.cy);
                break;
            }
            case findNext: {
                if (this.ptFind.back) {
                    this.ptFind.findPrev(this.ptFind.word);
                    break;
                }
                this.ptFind.findNext(this.ptFind.word);
                break;
            }
            case findPrev: {
                if (!this.ptFind.back) {
                    this.ptFind.findPrev(this.ptFind.word);
                    break;
                }
                this.ptFind.findNext(this.ptFind.word);
                break;
            }
            case commandPanel: {
                this.ui.cp.showCommandPanel = true;
                break;
            }
            case reloadWithEncoding: {
                U.reloadWithEncodingByUser(this);
                break;
            }
            case moveLeft: {
                if (this.readonly) {
                    this.doMoveViewPageUp();
                    break;
                }
                this.cursor.moveLeft();
                this.focusCursor();
                break;
            }
            case moveRight: {
                if (this.readonly) {
                    this.doMoveViewPageDown();
                    break;
                }
                this.cursor.moveRight();
                this.focusCursor();
                break;
            }
            case moveUp: {
                if (this.readonly) {
                    this.doMoveViewUp();
                    break;
                }
                this.cursor.moveUp();
                this.focusCursor();
                break;
            }
            case moveDown: {
                if (this.readonly) {
                    this.doMoveViewDown();
                    break;
                }
                this.cursor.moveDown();
                this.focusCursor();
                break;
            }
            case moveHome: {
                this.cursor.moveHome();
                this.focusCursor();
                break;
            }
            case moveEnd: {
                this.cursor.moveEnd();
                this.focusCursor();
                break;
            }
            case movePageUp: {
                if (this.readonly) {
                    this.doMoveViewPageUp();
                    break;
                }
                this.cursor.movePageUp();
                this.focusCursor();
                break;
            }
            case movePageDown: {
                if (this.readonly) {
                    this.doMoveViewPageDown();
                    break;
                }
                this.cursor.movePageDown();
                this.focusCursor();
                break;
            }
            case indentLeft: {
                this.ptEdit.moveLineLeft(this.cy);
                this.focusCursor();
                break;
            }
            case indentRight: {
                this.ptEdit.moveLineRight(this.cy);
                this.focusCursor();
                break;
            }
            case rectangleMode: {
                this.rectSelectMode = !this.rectSelectMode;
                break;
            }
            case makeNoise: {
                boolean bl = this.ui.noise = !this.ui.noise;
                if (!this.ui.noise) break;
                U.startNoiseThread(this.ui, this.uiComp);
                break;
            }
            case toggleFps: {
                this.ui.fpsOn = !this.ui.fpsOn;
                break;
            }
            case switchLineSeperator: {
                if (this.pageData.lineSep.equals("\n")) {
                    this.pageData.lineSep = "\r\n";
                    break;
                }
                this.pageData.lineSep = "\n";
                break;
            }
            case wrapLines: {
                this.ptEdit.wrapLines(this.cx);
                this.focusCursor();
                break;
            }
            case Javascript: {
                U.runScript(this);
                break;
            }
            case moveLeftBig: {
                this.cx = Math.max(0, this.cx - this.uiComp.getWidth() / 10);
                this.focusCursor();
                break;
            }
            case moveRightBig: {
                this.cx += this.uiComp.getWidth() / 10;
                this.focusCursor();
                break;
            }
            case switchColorMode: {
                this.ui.setNextColorMode();
                this.ui.applyColorMode(this.ui.colorMode);
                break;
            }
            case moveBetweenPair: {
                this.cursor.moveToPair();
                break;
            }
            case execute: {
                if (this.cy >= this.pageData.roLines.getLinesize()) break;
                U.exec(this, this.pageData.roLines.getline(this.cy).toString());
                break;
            }
            case hex: {
                String string = U.exportString(this.ptSelection.getSelected(), this.pageData.lineSep);
                if (string == null || string.length() <= 0) break;
                U.showHexOfString(string, this);
                break;
            }
            case listFonts: {
                U.listFonts(this);
                break;
            }
            case listDoc: {
                U.listDoc(this.uiComp);
                break;
            }
            case copySelected: {
                this.ptSelection.copySelected();
                break;
            }
            case paste: {
                if (this.keepx == -1) {
                    this.keepx = this.cx;
                }
                this.ptEdit.insertString(U.getClipBoard(), true);
                break;
            }
            case cut: {
                this.ptSelection.cutSelected();
                break;
            }
            case selectLine: {
                this.ptSelection.selectLine();
                break;
            }
            case selectAll: {
                this.ptSelection.selectAll();
                break;
            }
            case deleteLine: {
                if (this.ptSelection.isSelected()) {
                    this.ptEdit.deleteRect(this.ptSelection.getSelectRect());
                } else {
                    this.ptEdit.deleteLine(this.cy);
                }
                this.focusCursor();
                break;
            }
            case openFile: {
                U.listDirToNewPage(this);
                break;
            }
            case newPage: {
                PlainPage plainPage = new PlainPage(this.uiComp, PageData.newUntitled(), this);
                plainPage.ptSelection.selectAll();
                break;
            }
            case newWindow: {
                U.newWindow(this);
                break;
            }
            case save: {
                if (!U.saveFile(this)) break;
                this.ui.message("saved");
                break;
            }
            case gotoLine: {
                this.cursor.gotoLine();
                break;
            }
            case gotoX: {
                this.cursor.gotoX();
                break;
            }
            case undo: {
                this.pageData.history.undo(this);
                break;
            }
            case find: {
                this.ptFind.showFindDialog();
                break;
            }
            case redo: {
                this.pageData.history.redo(this);
                break;
            }
            case closePage: {
                U.closePage(this);
                break;
            }
            case setEncoding: {
                U.setEncodingByUser(this, "Set Encoding:");
                break;
            }
            case moveToHead: {
                this.cy = 0;
                this.cx = 0;
                this.focusCursor();
                break;
            }
            case moveToTail: {
                this.cy = this.pageData.roLines.getLinesize() - 1;
                this.cx = 0;
                this.focusCursor();
                break;
            }
            case removeTralingSpace: {
                U.removeTrailingSpace(this.pageData);
                break;
            }
            case moveLeftWord: {
                this.cursor.moveLeftWord();
                this.focusCursor();
                break;
            }
            case deleteWord: {
                this.ptEdit.deleteSpace();
                this.focusCursor();
                break;
            }
            case deleteWordBack: {
                this.ptEdit.deleteSpaceBack();
                this.focusCursor();
                break;
            }
            case moveRightWord: {
                this.cursor.moveRightWord();
                this.focusCursor();
                break;
            }
            case moveViewUp: {
                this.doMoveViewUp();
                break;
            }
            case moveViewDown: {
                this.doMoveViewDown();
                break;
            }
            case moveUpLangLevel: {
                this.cursor.doMoveUpLangLevel();
                break;
            }
            case resetScale: {
                this.ui.scalev = 1.0f;
                break;
            }
            case go: {
                if (this.cy >= this.pageData.roLines.getLinesize()) break;
                String string = this.pageData.roLines.getline(this.cy).toString();
                this.go(string, false);
                break;
            }
            case goInNewWindow: {
                if (this.cy >= this.pageData.roLines.getLinesize()) break;
                String string = this.pageData.roLines.getline(this.cy).toString();
                this.go(string, true);
                break;
            }
            case launch: {
                if (this.cy >= this.pageData.roLines.getLinesize()) break;
                String string = this.pageData.roLines.getline(this.cy).toString();
                U.launch(string);
                break;
            }
            case readonlyMode: {
                this.readonly = !this.readonly;
                break;
            }
            case fileHistory: {
                U.openFileHistory(this.uiComp);
                break;
            }
            case dirHistory: {
                U.openCmdHistory(this.uiComp);
                break;
            }
            case openFileSelector: {
                if (this.cy >= this.pageData.roLines.getLinesize()) break;
                String string = this.pageData.roLines.getline(this.cy).toString();
                U.openFileSelector(string, this);
                break;
            }
            case print: {
                new Print(this).printPages();
                break;
            }
            case pageList: {
                U.showPageListPage(this.uiComp);
                break;
            }
            case quickSwitchPage: {
                PlainPage.gotoFileLine(this.uiComp.pageHis.back(U.getLocString(this)), this.uiComp, true);
                break;
            }
            case resetIME: {
                Ime.resetIme();
                break;
            }
            case toggleIME: {
                Ime.nextIme();
                Ime.ImeInterface imeInterface = Ime.getCurrentIme();
                if (imeInterface == null) break;
                imeInterface.setEnabled(true);
                break;
            }
            case reloadIME: {
                Ime.ImeInterface imeInterface = Ime.getCurrentIme();
                if (imeInterface == null) break;
                imeInterface.reloadDict();
                break;
            }
            case pageForward: {
                PlainPage.gotoFileLine(this.uiComp.pageHis.forward(U.getLocString(this)), this.uiComp, false);
                break;
            }
            case pageBack: {
                PlainPage.gotoFileLine(this.uiComp.pageHis.back(U.getLocString(this)), this.uiComp, false);
                break;
            }
            default: {
                this.ui.message("unprocessed Command:" + String.valueOf((Object)commands));
            }
        }
    }

    public void repaint() {
        new Thread(() -> this.uiComp.repaint()).start();
    }

    private void unknownCommand(KeyEvent keyEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        if (keyEvent.isControlDown()) {
            stringBuilder.append("Ctrl");
        }
        if (keyEvent.isAltDown()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("-");
            }
            stringBuilder.append("Alt");
        }
        if (keyEvent.isShiftDown()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("-");
            }
            stringBuilder.append("Shift");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("-");
        }
        stringBuilder.append(KeyEvent.getKeyText(keyEvent.getKeyCode()));
        this.ui.message("Unknow Command:" + String.valueOf(stringBuilder));
    }

    public void xpaint(Graphics graphics, Dimension dimension) {
        if (!this.lastSize.equals(dimension)) {
            this.lastSize = dimension;
            this.ui.cp.inited = false;
        }
        this.ui.xpaint(graphics, dimension);
    }

    static /* synthetic */ String access$100(PlainPage plainPage) {
        return plainPage.preeditText;
    }

    class Cursor {
        Cursor() {
        }

        void gotoLine() {
            String string = JOptionPane.showInputDialog(PlainPage.this.uiComp, (Object)"Goto Line");
            int n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = -1;
            }
            if (n > PlainPage.this.pageData.roLines.getLinesize()) {
                n = -1;
            }
            if (n > 0) {
                PlainPage.this.sy = Math.max(0, --n - PlainPage.this.showLineCnt / 2 + 1);
                PlainPage.this.cy = n;
                PlainPage.this.cx = 0;
                PlainPage.this.adjustCursor();
            }
        }

        void gotoX() {
            String string = JOptionPane.showInputDialog(PlainPage.this.uiComp, (Object)"Goto X");
            int n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = -1;
            }
            if (n > 0) {
                this.setSafePos(n, PlainPage.this.cy);
                PlainPage.this.adjustCursor();
            }
        }

        void moveDown() {
            ++PlainPage.this.cy;
            if (PlainPage.this.cy >= PlainPage.this.pageData.roLines.getLinesize()) {
                if (PlainPage.this.rectSelectMode) {
                    PlainPage.this.pageData.editRec.insertEmptyLine(PlainPage.this.cy);
                    if (PlainPage.this.cx > 0) {
                        PlainPage.this.pageData.editRec.insertInLine(PlainPage.this.cy, 0, U.spaces(PlainPage.this.cx));
                    }
                } else {
                    PlainPage.this.cy = PlainPage.this.pageData.roLines.getLinesize() - 1;
                }
            }
            this.keepX();
        }

        void moveEnd() {
            int n;
            PlainPage.this.keepx = -1;
            CharSequence charSequence = PlainPage.this.pageData.roLines.getline(PlainPage.this.cy);
            for (n = charSequence.length(); n > 0 && U.isSpaceChar(charSequence.charAt(n - 1)); --n) {
            }
            PlainPage.this.cx = PlainPage.this.cx < n || PlainPage.this.cx >= charSequence.length() ? n : Integer.MAX_VALUE;
        }

        void moveHome() {
            int n;
            PlainPage.this.keepx = -1;
            CharSequence charSequence = PlainPage.this.pageData.roLines.getline(PlainPage.this.cy);
            int n2 = charSequence.length();
            for (n = 0; n < n2 - 1 && U.isSpaceChar(charSequence.charAt(n)); ++n) {
            }
            PlainPage.this.cx = PlainPage.this.cx > n || PlainPage.this.cx == 0 ? n : 0;
        }

        void moveLeft() {
            PlainPage.this.keepx = -1;
            --PlainPage.this.cx;
            if (PlainPage.this.cx < 0) {
                if (PlainPage.this.cy > 0 && !PlainPage.this.ptSelection.isRectSelecting()) {
                    --PlainPage.this.cy;
                    PlainPage.this.cx = PlainPage.this.pageData.roLines.getline(PlainPage.this.cy).length();
                } else {
                    PlainPage.this.cx = 0;
                }
            }
        }

        void moveLeftWord() {
            block3: {
                PlainPage.this.keepx = -1;
                CharSequence charSequence = PlainPage.this.pageData.roLines.getline(PlainPage.this.cy);
                PlainPage.this.cx = Math.max(0, PlainPage.this.cx - 1);
                char c = U.charAtWhenMove(charSequence, PlainPage.this.cx);
                while (true) {
                    if (PlainPage.this.cx <= 0) {
                        if (PlainPage.this.cy > 0) {
                            --PlainPage.this.cy;
                            charSequence = PlainPage.this.pageData.roLines.getline(PlainPage.this.cy);
                            PlainPage.this.cx = Math.max(0, charSequence.length() - 1);
                            continue;
                        }
                        break block3;
                    }
                    --PlainPage.this.cx;
                    if (!U.isSkipChar(charSequence.charAt(PlainPage.this.cx), c)) break;
                }
                ++PlainPage.this.cx;
            }
        }

        void movePageDown() {
            PlainPage.this.cy += PlainPage.this.showLineCnt;
            if (PlainPage.this.cy >= PlainPage.this.pageData.roLines.getLinesize()) {
                if (PlainPage.this.rectSelectMode) {
                    String string = U.spaces(PlainPage.this.cx);
                    int n = PlainPage.this.cy - PlainPage.this.pageData.roLines.getLinesize() + 1;
                    int n2 = PlainPage.this.pageData.roLines.getLinesize();
                    for (int i = 0; i < n; ++i) {
                        PlainPage.this.pageData.editRec.insertEmptyLine(n2);
                        if (PlainPage.this.cx <= 0) continue;
                        PlainPage.this.pageData.editRec.insertInLine(n2, 0, string);
                    }
                } else {
                    PlainPage.this.cy = PlainPage.this.pageData.roLines.getLinesize() - 1;
                }
            }
            this.keepX();
        }

        void keepX() {
            if (PlainPage.this.rectSelectMode) {
                return;
            }
            if (PlainPage.this.keepx == -1) {
                PlainPage.this.keepx = PlainPage.this.cx;
            } else {
                PlainPage.this.cx = Math.min(PlainPage.this.keepx, PlainPage.this.pageData.roLines.getline(PlainPage.this.cy).length());
            }
        }

        void movePageUp() {
            PlainPage.this.cy -= PlainPage.this.showLineCnt;
            if (PlainPage.this.cy < 0) {
                PlainPage.this.cy = 0;
            }
            this.keepX();
        }

        void moveRight() {
            PlainPage.this.keepx = -1;
            ++PlainPage.this.cx;
            if (PlainPage.this.ptSelection.isRectSelecting()) {
                if (PlainPage.this.cx > PlainPage.this.pageData.roLines.getline(PlainPage.this.cy).length()) {
                    PlainPage.this.ptEdit.setLength(PlainPage.this.cy, PlainPage.this.cx);
                }
            } else if (PlainPage.this.cx > PlainPage.this.pageData.roLines.getline(PlainPage.this.cy).length() && PlainPage.this.cy < PlainPage.this.pageData.roLines.getLinesize() - 1) {
                ++PlainPage.this.cy;
                PlainPage.this.cx = 0;
            }
        }

        void moveRightWord() {
            PlainPage.this.keepx = -1;
            CharSequence charSequence = PlainPage.this.pageData.roLines.getline(PlainPage.this.cy);
            char c = U.charAtWhenMove(charSequence, PlainPage.this.cx);
            PlainPage.this.cx = Math.min(charSequence.length(), PlainPage.this.cx + 1);
            while (U.isSkipChar(U.charAtWhenMove(charSequence, PlainPage.this.cx), c)) {
                PlainPage.this.cx = Math.min(charSequence.length(), PlainPage.this.cx + 1);
                if (PlainPage.this.cx < charSequence.length()) continue;
                if (PlainPage.this.cy >= PlainPage.this.pageData.roLines.getLinesize() - 1) break;
                ++PlainPage.this.cy;
                charSequence = PlainPage.this.pageData.roLines.getline(PlainPage.this.cy);
                PlainPage.this.cx = 0;
            }
        }

        void moveToPair() {
            char c;
            String string;
            int n;
            PlainPage.this.keepx = -1;
            if (PlainPage.this.cx - 1 < PlainPage.this.pageData.roLines.getline(PlainPage.this.cy).length() && PlainPage.this.cx - 1 >= 0 && (n = (string = "(){}[]<>").indexOf(c = PlainPage.this.pageData.roLines.getline(PlainPage.this.cy).charAt(PlainPage.this.cx - 1))) >= 0) {
                if (n % 2 == 0) {
                    PlainPage.this.ui.pairMarker.moveToPairMark(PlainPage.this.cx - 1, PlainPage.this.cy, string.charAt(n + 1), c, 1);
                } else {
                    PlainPage.this.ui.pairMarker.moveToPairMark(PlainPage.this.cx - 1, PlainPage.this.cy, string.charAt(n - 1), c, -1);
                }
            }
        }

        void moveUp() {
            --PlainPage.this.cy;
            if (PlainPage.this.cy < 0) {
                PlainPage.this.cy = 0;
            }
            this.keepX();
        }

        void scroll(int n) {
            PlainPage.this.sy += n;
            if (PlainPage.this.sy >= PlainPage.this.pageData.roLines.getLinesize()) {
                PlainPage.this.sy = PlainPage.this.pageData.roLines.getLinesize() - 1;
            }
            if (PlainPage.this.sy < 0) {
                PlainPage.this.sy = 0;
            }
            PlainPage.this.repaint();
        }

        void scrollHorizon(int n) {
            PlainPage.this.sx += n;
            if (PlainPage.this.sx < 0) {
                PlainPage.this.sx = 0;
            }
            PlainPage.this.repaint();
        }

        void setSafePos(int n, int n2) {
            PlainPage.this.cy = U.between(n2, 0, PlainPage.this.pageData.roLines.getLinesize() - 1);
            PlainPage.this.cx = U.between(n, 0, PlainPage.this.pageData.roLines.getline(PlainPage.this.cy).length());
        }

        public void doMoveUpLangLevel() {
            PlainPage.this.ui.pairMarker.moveToPairMark(PlainPage.this.cx - 1, PlainPage.this.cy, '{', '}', -1);
        }
    }

    public class EasyEdit {
        public synchronized void append(String string) {
            PlainPage.this.cy = PlainPage.this.pageData.roLines.getLinesize() - 1;
            PlainPage.this.cx = PlainPage.this.pageData.roLines.getline(PlainPage.this.cy).length();
            this.insertString(string);
        }

        public void deleteLine(int n) {
            this.deleteLineRange(n, n + 1);
        }

        public void deleteLineRange(int n, int n2) {
            PlainPage.this.pageData.editRec.deleteLines(n, n2);
        }

        public void deleteRect(Rectangle rectangle) {
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = rectangle.width;
            int n4 = rectangle.height;
            if (n == n3 && n2 == n4) {
                return;
            }
            if (PlainPage.this.rectSelectMode) {
                for (int i = n2; i <= n4; ++i) {
                    PlainPage.this.pageData.editRec.deleteInLine(i, n, n3);
                }
                PlainPage.this.selectstartx = n;
                PlainPage.this.selectstopx = n;
            } else if (n2 == n4 && n < n3) {
                PlainPage.this.pageData.editRec.deleteInLine(n2, n, n3);
            } else if (n2 < n4) {
                PlainPage.this.pageData.editRec.deleteInLine(n2, n, Integer.MAX_VALUE);
                PlainPage.this.pageData.editRec.deleteInLine(n4, 0, n3);
                this.deleteLineRange(n2 + 1, n4);
                PlainPage.this.pageData.editRec.mergeLine(n2);
            }
            PlainPage.this.cx = n;
            PlainPage.this.cy = n2;
            if (n4 - n2 > 400) {
                U.gc();
            }
            PlainPage.this.adjustCursor();
        }

        public void deleteSpace() {
            int n = PlainPage.this.cx;
            int n2 = PlainPage.this.cy;
            PlainPage.this.cursor.moveRightWord();
            int n3 = PlainPage.this.cx;
            int n4 = PlainPage.this.cy;
            this.deleteRect(new Rectangle(n, n2, n3, n4));
        }

        public void deleteSpaceBack() {
            int n = PlainPage.this.cx;
            int n2 = PlainPage.this.cy;
            PlainPage.this.cursor.moveLeftWord();
            int n3 = PlainPage.this.cx;
            int n4 = PlainPage.this.cy;
            this.deleteRect(new Rectangle(n3, n4, n, n2));
        }

        String getIndent(String string) {
            int n;
            for (n = 0; n < string.length() && (string.charAt(n) == ' ' || string.charAt(n) == '\t'); ++n) {
            }
            return string.substring(0, n);
        }

        public void insert(char c) {
            if (PlainPage.this.cy < 0) {
                PlainPage.this.cy = 0;
            }
            if (c == '\n') {
                if (PlainPage.this.ptSelection.isSelected()) {
                    this.deleteRect(PlainPage.this.ptSelection.getSelectRect());
                }
                CharSequence charSequence = PlainPage.this.pageData.roLines.getline(PlainPage.this.cy);
                String string = this.getIndent(charSequence.toString());
                CharSequence charSequence2 = charSequence.subSequence(PlainPage.this.cx, charSequence.length());
                PlainPage.this.pageData.editRec.insertEmptyLine(PlainPage.this.cy + 1);
                PlainPage.this.pageData.editRec.insertInLine(PlainPage.this.cy + 1, 0, string + String.valueOf(U.trimLeft(charSequence2)));
                PlainPage.this.pageData.editRec.deleteInLine(PlainPage.this.cy, PlainPage.this.cx, Integer.MAX_VALUE);
                ++PlainPage.this.cy;
                PlainPage.this.cx = string.length();
            } else if (c == '\b') {
                if (PlainPage.this.ptSelection.isSelected()) {
                    this.deleteRect(PlainPage.this.ptSelection.getSelectRect());
                } else if (PlainPage.this.rectSelectMode) {
                    if (PlainPage.this.cx > 0) {
                        Rectangle rectangle = PlainPage.this.ptSelection.getSelectRect();
                        for (int i = rectangle.y; i <= rectangle.height; ++i) {
                            PlainPage.this.pageData.editRec.deleteInLine(i, PlainPage.this.cx - 1, PlainPage.this.cx);
                        }
                        --PlainPage.this.cx;
                        PlainPage.this.selectstartx = PlainPage.this.cx;
                        PlainPage.this.selectstopx = PlainPage.this.cx;
                    }
                } else if (PlainPage.this.cx > 0) {
                    PlainPage.this.pageData.editRec.deleteInLine(PlainPage.this.cy, PlainPage.this.cx - 1, PlainPage.this.cx);
                    --PlainPage.this.cx;
                } else if (PlainPage.this.cy > 0) {
                    PlainPage.this.cx = PlainPage.this.pageData.roLines.getline(PlainPage.this.cy - 1).length();
                    PlainPage.this.pageData.editRec.mergeLine(PlainPage.this.cy - 1);
                    --PlainPage.this.cy;
                }
            } else if (c == '\u007f') {
                if (PlainPage.this.ptSelection.isSelected()) {
                    this.deleteRect(PlainPage.this.ptSelection.getSelectRect());
                } else if (PlainPage.this.rectSelectMode) {
                    Rectangle rectangle = PlainPage.this.ptSelection.getSelectRect();
                    for (int i = rectangle.y; i <= rectangle.height; ++i) {
                        PlainPage.this.pageData.editRec.deleteInLine(i, PlainPage.this.cx, PlainPage.this.cx + 1);
                    }
                    PlainPage.this.selectstartx = PlainPage.this.cx;
                    PlainPage.this.selectstopx = PlainPage.this.cx;
                } else if (PlainPage.this.cx < PlainPage.this.pageData.roLines.getline(PlainPage.this.cy).length()) {
                    PlainPage.this.pageData.editRec.deleteInLine(PlainPage.this.cy, PlainPage.this.cx, PlainPage.this.cx + 1);
                } else if (PlainPage.this.cy < PlainPage.this.pageData.roLines.getLinesize() - 1) {
                    PlainPage.this.pageData.editRec.mergeLine(PlainPage.this.cy);
                }
            } else if (c == '\u001b') {
                PlainPage.this.ptSelection.cancelSelect();
            } else {
                if (PlainPage.this.ptSelection.isSelected()) {
                    this.deleteRect(PlainPage.this.ptSelection.getSelectRect());
                }
                if (PlainPage.this.rectSelectMode) {
                    Rectangle rectangle = PlainPage.this.ptSelection.getSelectRect();
                    for (int i = rectangle.y; i <= rectangle.height; ++i) {
                        PlainPage.this.pageData.editRec.insertInLine(i, PlainPage.this.cx, "" + c);
                    }
                    ++PlainPage.this.cx;
                    PlainPage.this.selectstartx = PlainPage.this.cx;
                    PlainPage.this.selectstopx = PlainPage.this.cx;
                } else {
                    PlainPage.this.pageData.editRec.insertInLine(PlainPage.this.cy, PlainPage.this.cx, "" + c);
                    ++PlainPage.this.cx;
                }
            }
            PlainPage.this.focusCursor();
            if (!PlainPage.this.rectSelectMode) {
                PlainPage.this.ptSelection.cancelSelect();
            }
            PlainPage.this.repaint();
        }

        public void insertString(List<CharSequence> list, boolean bl) {
            if (PlainPage.this.cy < 0) {
                PlainPage.this.cy = 0;
            }
            if (PlainPage.this.ptSelection.isSelected()) {
                PlainPage.this.ptEdit.deleteRect(PlainPage.this.ptSelection.getSelectRect());
            }
            int n = list.size();
            if (PlainPage.this.rectSelectMode) {
                Rectangle rectangle = PlainPage.this.ptSelection.getSelectRect();
                int n2 = 0;
                for (int i = rectangle.y; i <= rectangle.height; ++i) {
                    CharSequence charSequence = list.get(n2);
                    PlainPage.this.pageData.editRec.insertInLine(i, PlainPage.this.cx, charSequence);
                    if (++n2 < n) continue;
                    n2 = 0;
                }
                if (n == 1) {
                    PlainPage.this.selectstartx += list.get(0).length();
                    PlainPage.this.selectstopx += list.get(0).length();
                    PlainPage.this.cx += list.get(0).length();
                    PlainPage.this.savingFromSelectionCancel = true;
                }
            } else {
                if (n == 1) {
                    PlainPage.this.pageData.editRec.insertInLine(PlainPage.this.cy, PlainPage.this.cx, list.get(0));
                    PlainPage.this.cx += list.get(0).length();
                } else {
                    CharSequence charSequence = PlainPage.this.pageData.roLines.getInLine(PlainPage.this.cy, PlainPage.this.cx, Integer.MAX_VALUE);
                    PlainPage.this.pageData.editRec.deleteInLine(PlainPage.this.cy, PlainPage.this.cx, Integer.MAX_VALUE);
                    PlainPage.this.pageData.editRec.insertInLine(PlainPage.this.cy, PlainPage.this.cx, list.get(0));
                    for (int i = 1; i < n; ++i) {
                        PlainPage.this.pageData.editRec.insertEmptyLine(PlainPage.this.cy + i);
                        PlainPage.this.pageData.editRec.insertInLine(PlainPage.this.cy + i, 0, list.get(i));
                    }
                    PlainPage.this.cy += n - 1;
                    PlainPage.this.cx = list.get(n - 1).length();
                    PlainPage.this.pageData.editRec.insertInLine(PlainPage.this.cy, PlainPage.this.cx, charSequence);
                }
                PlainPage.this.ptSelection.cancelSelect();
            }
            if (n >= 5 && PlainPage.this.pageData.comment == null) {
                PlainPage.this.pageData.isCommentChecked = true;
                U.startDaemonThread(new Thread(){

                    @Override
                    public void run() {
                        U.guessComment(PlainPage.this);
                    }
                });
            }
            PlainPage.this.focusCursor();
        }

        public void insertString(String string) {
            this.insertString(string, false);
        }

        public void insertString(String string, boolean bl) {
            this.insertString(U.removeTailR(U.split(string, '\n')), bl);
        }

        public void moveLineLeft(int n) {
            String string = PlainPage.this.pageData.roLines.getline(n).toString();
            if (string.length() > 0 && (string.charAt(0) == '\t' || string.charAt(0) == ' ')) {
                PlainPage.this.pageData.editRec.deleteInLine(n, 0, 1);
            }
            --PlainPage.this.cx;
            if (PlainPage.this.cx < 0) {
                PlainPage.this.cx = 0;
            }
        }

        public void moveLineRight(int n) {
            PlainPage.this.pageData.editRec.insertInLine(n, 0, "\t");
            ++PlainPage.this.cx;
        }

        public void moveRectLeft(int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                this.moveLineLeft(i);
            }
        }

        public void moveRectRight(int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                this.moveLineRight(i);
            }
        }

        public void setLength(int n, int n2) {
            int n3 = PlainPage.this.pageData.roLines.getline(n).length();
            if (n2 - n3 > 0) {
                PlainPage.this.pageData.editRec.insertInLine(n, n3, U.spaces(n2 - n3));
            }
        }

        public void wrapLines(int n) throws Exception {
            int n2;
            int n3 = 0;
            int n4 = 0;
            CharSequence charSequence = PlainPage.this.pageData.roLines.getInLine(PlainPage.this.cy, 0, n);
            for (n2 = 0; n2 < charSequence.length(); ++n2) {
                n4 += charSequence.charAt(n2) > '\u00ff' ? 2 : 1;
            }
            n3 = Math.max(10, n4);
            PlainPage.this.ui.message("wrapLine at " + n3);
            if (PlainPage.this.ptSelection.isSelected()) {
                PlainPage.this.ptSelection.cancelSelect();
            }
            ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
            for (int i = 0; i < PlainPage.this.pageData.roLines.getLinesize(); ++i) {
                if (PlainPage.this.pageData.lines.get(i).length() * 2 > n3) {
                    n2 = 0;
                    CharSequence charSequence2 = PlainPage.this.pageData.roLines.getline(i);
                    int n5 = 0;
                    for (int j = 0; j < charSequence2.length(); ++j) {
                        if ((n2 += charSequence2.charAt(j) > '\u00ff' ? 2 : 1) < n3) continue;
                        arrayList.add(charSequence2.subSequence(n5, j + 1).toString());
                        n5 = j + 1;
                        n2 = 0;
                    }
                    if (n5 >= charSequence2.length()) continue;
                    arrayList.add(charSequence2.subSequence(n5, charSequence2.length()).toString());
                    continue;
                }
                arrayList.add(PlainPage.this.pageData.lines.get(i).toString());
            }
            String string = "wrapped " + PlainPage.this.pageData.title + " #" + U.randomID();
            PlainPage plainPage = new PlainPage(PlainPage.this.uiComp, PageData.fromTitle(string), PlainPage.this);
            plainPage.pageData.resetLines(arrayList);
        }
    }

    public class Selection {
        public void cancelSelect() {
            PlainPage.this.selectstartx = PlainPage.this.cx;
            PlainPage.this.selectstarty = PlainPage.this.cy;
            PlainPage.this.selectstopx = PlainPage.this.cx;
            PlainPage.this.selectstopy = PlainPage.this.cy;
        }

        public void copySelected() {
            String string = U.exportString(this.getSelected(), PlainPage.this.pageData.lineSep);
            string = U.removeAsciiZero(string);
            U.setClipBoard(string);
            PlainPage.this.ui.message("copied " + string.length());
        }

        public void cutSelected() {
            this.copySelected();
            PlainPage.this.ptEdit.deleteRect(this.getSelectRect());
            this.cancelSelect();
        }

        public List<CharSequence> getSelected() {
            return PlainPage.this.pageData.roLines.getTextInRect(this.getSelectRect(), PlainPage.this.rectSelectMode);
        }

        public Rectangle getSelectRect() {
            int n;
            int n2;
            int n3;
            int n4;
            if (PlainPage.this.rectSelectMode) {
                int n5;
                n4 = PlainPage.this.selectstopy;
                n3 = PlainPage.this.selectstarty;
                n2 = PlainPage.this.selectstopx;
                n = PlainPage.this.selectstartx;
                if (n4 > n3) {
                    n5 = n4;
                    n4 = n3;
                    n3 = n5;
                }
                if (n2 > n) {
                    n5 = n2;
                    n2 = n;
                    n = n5;
                }
            } else if (PlainPage.this.selectstopy < PlainPage.this.selectstarty) {
                n4 = PlainPage.this.selectstopy;
                n3 = PlainPage.this.selectstarty;
                n2 = PlainPage.this.selectstopx;
                n = PlainPage.this.selectstartx;
            } else {
                n3 = PlainPage.this.selectstopy;
                n4 = PlainPage.this.selectstarty;
                n2 = PlainPage.this.selectstartx;
                n = PlainPage.this.selectstopx;
                if (n2 > n && n4 == n3) {
                    n2 = PlainPage.this.selectstopx;
                    n = PlainPage.this.selectstartx;
                }
            }
            return new Rectangle(n2, n4, n, n3);
        }

        public boolean isRectSelecting() {
            return PlainPage.this.mshift && PlainPage.this.rectSelectMode;
        }

        public boolean isSelected() {
            Rectangle rectangle = this.getSelectRect();
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = rectangle.width;
            int n4 = rectangle.height;
            if (PlainPage.this.rectSelectMode) {
                return n < n3;
            }
            if (n2 == n4 && n < n3) {
                return true;
            }
            return n2 < n4;
        }

        public boolean mouseSelection(CharSequence charSequence) {
            if (PlainPage.this.mcount == 2) {
                int n;
                int n2 = PlainPage.this.cx;
                if (charSequence.length() > n && Character.isJavaIdentifierPart(charSequence.charAt(n))) {
                    for (n = PlainPage.this.cx; n > 0 && Character.isJavaIdentifierPart(charSequence.charAt(n - 1)); --n) {
                    }
                }
                if (charSequence.length() > n2 && Character.isJavaIdentifierPart(charSequence.charAt(n2))) {
                    while (n2 < charSequence.length() - 1 && Character.isJavaIdentifierPart(charSequence.charAt(n2 + 1))) {
                        ++n2;
                    }
                }
                PlainPage.this.selectstartx = n;
                PlainPage.this.selectstarty = PlainPage.this.cy;
                PlainPage.this.selectstopx = n2 + 1;
                PlainPage.this.selectstopy = PlainPage.this.cy;
            } else if (PlainPage.this.mcount == 3) {
                PlainPage.this.selectstartx = 0;
                PlainPage.this.selectstarty = PlainPage.this.cy;
                PlainPage.this.selectstopx = charSequence.length();
                PlainPage.this.selectstopy = PlainPage.this.cy;
            } else if (PlainPage.this.mshift) {
                PlainPage.this.selectstopx = PlainPage.this.cx;
                PlainPage.this.selectstopy = PlainPage.this.cy;
                if (PlainPage.this.cy == PlainPage.this.sy && PlainPage.this.cy > 0) {
                    --PlainPage.this.sy;
                    return true;
                }
                if (PlainPage.this.cy >= PlainPage.this.sy + PlainPage.this.showLineCnt - 1 && PlainPage.this.sy + 1 + PlainPage.this.showLineCnt / 2 < PlainPage.this.pageData.roLines.getLinesize() - 1) {
                    ++PlainPage.this.sy;
                    return true;
                }
            } else {
                this.cancelSelect();
            }
            return false;
        }

        public void selectAll() {
            PlainPage.this.selectstartx = 0;
            PlainPage.this.selectstarty = 0;
            PlainPage.this.selectstopy = PlainPage.this.pageData.roLines.getLinesize() - 1;
            if (PlainPage.this.selectstopy < 0) {
                PlainPage.this.selectstopy = 0;
            }
            PlainPage.this.selectstopx = PlainPage.this.pageData.roLines.getline(PlainPage.this.selectstopy).length();
        }

        public void selectLength(int n, int n2, int n3) {
            PlainPage.this.cx = n;
            PlainPage.this.cy = n2;
            PlainPage.this.selectstartx = PlainPage.this.cx;
            PlainPage.this.selectstarty = PlainPage.this.cy;
            PlainPage.this.selectstopx = PlainPage.this.cx + n3;
            PlainPage.this.selectstopy = PlainPage.this.cy;
            PlainPage.this.adjustCursor();
            PlainPage.this.savingFromSelectionCancel = true;
        }

        public void selectLine() {
            PlainPage.this.selectstartx = 0;
            PlainPage.this.selectstarty = PlainPage.this.cy;
            PlainPage.this.selectstopy = PlainPage.this.cy;
            if (PlainPage.this.selectstopy < 0) {
                PlainPage.this.selectstopy = 0;
            }
            PlainPage.this.selectstopx = PlainPage.this.pageData.roLines.getline(PlainPage.this.selectstopy).length();
            this.copySelected();
        }
    }

    public class Paint {
        @Deprecated
        public boolean shrinkWord;
        BufferedImage aboutImg;
        boolean aboutOn;
        int aboutY;
        boolean closed = false;
        Color colorBg;
        Color colorComment;
        Color colorComment2;
        Color colorCurrentLineBg;
        Color colorDigit;
        Color colorGutLine;
        Color colorGutNumber;
        Color colorKeyword;
        Color colorGutMark1;
        Color colorGutMark2;
        Color colorReturnMark;
        int colorMode;
        int[][] ColorModes = null;
        Color colorNormal = Color.BLACK;
        PairMark pairMarker = new PairMark();
        CommandPanel.CommandPanelPaint cp = new CommandPanel.CommandPanelPaint(PlainPage.this);
        Dimension dim;
        final int gutterWidth = 40;
        int lineGap = 5;
        int lineHeight;
        long MSG_VANISH_TIME = 3000L;
        List<Object[]> msgs = new ArrayList<Object[]>();
        boolean noise = false;
        int noisesleep = 500;
        float scalev = 1.0f;
        private int nextXToolBar;
        private boolean fpsOn = false;
        private boolean inComment;
        private String commentClose;
        private String commentStart;

        int getMaxW() {
            return this.dim.width - 40;
        }

        int getMaxW2() {
            return (int)((float)(this.dim.width - 40) / this.scalev);
        }

        Paint() {
            try {
                U.TAB_WIDTH = Conf.readTabWidth();
                int n = Conf.getDefaultColorMode();
                this.applyColorMode(n);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void applyColorMode(int n) throws IOException {
            if (this.ColorModes == null) {
                this.ColorModes = Conf.loadColorModes();
            }
            if (n >= this.ColorModes.length) {
                n = 0;
            }
            this.colorMode = n;
            int[] nArray = this.ColorModes[n];
            this.colorBg = new Color(nArray[0]);
            this.colorNormal = new Color(nArray[1]);
            this.colorKeyword = new Color(nArray[2]);
            this.colorDigit = new Color(nArray[3]);
            this.colorComment = new Color(nArray[4]);
            this.colorGutNumber = new Color(nArray[5]);
            this.colorGutLine = new Color(nArray[6]);
            this.colorCurrentLineBg = new Color(nArray[7]);
            this.colorComment2 = new Color(nArray[8]);
            this.colorGutMark1 = new Color(nArray[9]);
            this.colorGutMark2 = new Color(nArray[10]);
            this.colorReturnMark = new Color(nArray[11]);
        }

        void drawGutter(Graphics2D graphics2D) {
            if (this.scalev < 1.0f) {
                Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
                graphics2D2.scale(this.scalev, this.scalev);
                graphics2D2.setColor(this.colorGutNumber);
                for (int i = 0; i < PlainPage.this.showLineCnt && PlainPage.this.sy + i + 1 <= PlainPage.this.pageData.roLines.getLinesize(); ++i) {
                    U.drawStringShrink(graphics2D2, PlainPage.this.fontList, "" + (PlainPage.this.sy + i + 1), 0, this.lineHeight + (this.lineHeight + this.lineGap) * i, 40.0f / this.scalev);
                }
                graphics2D2.dispose();
            } else {
                graphics2D.setColor(this.colorGutNumber);
                for (int i = 0; i < PlainPage.this.showLineCnt && PlainPage.this.sy + i + 1 <= PlainPage.this.pageData.roLines.getLinesize(); ++i) {
                    U.drawStringShrink(graphics2D, PlainPage.this.fontList, "" + (PlainPage.this.sy + i + 1), 0, (int)(this.scalev * (float)(this.lineHeight + (this.lineHeight + this.lineGap) * i)), 40.0f);
                }
            }
        }

        void drawNextToolbarText(Graphics2D graphics2D, String string) {
            graphics2D.setColor(this.colorGutMark2);
            this.nextXToolBar += 10 + U.drawString(graphics2D, PlainPage.this.fontList, string, 10 + this.nextXToolBar, this.lineHeight, this.getMaxW());
        }

        void drawReturn(Graphics2D graphics2D, int n, int n2) {
            graphics2D.setColor(this.colorReturnMark);
            graphics2D.drawLine(n, n2 - this.lineHeight + PlainPage.this.fontList.getlineHeight(), n + 3, n2 - this.lineHeight + PlainPage.this.fontList.getlineHeight());
        }

        void drawSelect(Graphics2D graphics2D, int n, int n2, int n3) {
            int n4 = n - PlainPage.this.sy;
            if (n4 < PlainPage.this.showLineCnt) {
                CharSequence charSequence = PlainPage.this.pageData.roLines.getline(n);
                if (PlainPage.this.sx > charSequence.length()) {
                    return;
                }
                n2 = Math.min(n2, charSequence.length());
                boolean bl = n3 > charSequence.length();
                n3 = Math.min(n3, charSequence.length());
                int n5 = this.getMaxW2();
                if (n2 == n3) {
                    int n6 = n2 <= PlainPage.this.sx ? 0 : this.drawLineOrTest(graphics2D, PlainPage.this.fontList, n, -1, n == PlainPage.this.cy, null, false, n5, n2 - PlainPage.this.sx);
                    graphics2D.fillRect(n6, n4 * (this.lineHeight + this.lineGap), 3, this.lineHeight + this.lineGap);
                } else {
                    int n7;
                    int n8 = n2 <= PlainPage.this.sx ? 0 : (n7 = this.drawLineOrTest(graphics2D, PlainPage.this.fontList, n, -1, n == PlainPage.this.cy, null, false, n5, n2 - PlainPage.this.sx));
                    int n9 = bl ? this.getMaxW2() : (n3 <= PlainPage.this.sx ? 0 : this.drawLineOrTest(graphics2D, PlainPage.this.fontList, n, -1, n == PlainPage.this.cy, null, false, n5, n3 - PlainPage.this.sx));
                    graphics2D.fillRect(n7, n4 * (this.lineHeight + this.lineGap), n9 - n7, this.lineHeight + this.lineGap);
                }
            }
        }

        void drawSelectLine(Graphics2D graphics2D, int n, int n2) {
            int n3 = U.between(n - PlainPage.this.sy, 0, PlainPage.this.showLineCnt);
            int n4 = U.between(n2 - PlainPage.this.sy, 0, PlainPage.this.showLineCnt);
            if (n < n2) {
                graphics2D.fillRect(0, n3 * (this.lineHeight + this.lineGap), this.getMaxW2(), (this.lineHeight + this.lineGap) * (n4 - n3));
            }
        }

        private void drawSelfDispMessages(Graphics2D graphics2D) {
            int n;
            long l = System.currentTimeMillis();
            for (n = 0; n < this.msgs.size(); ++n) {
                Object[] objectArray = this.msgs.get(n);
                long l2 = (Long)objectArray[1];
                if (l2 >= l) continue;
                this.msgs.remove(n);
                --n;
            }
            if (!this.msgs.isEmpty()) {
                n = U.maxWidth(this.msgs, graphics2D, PlainPage.this.fontList, this.getMaxW()) + 100;
                int n2 = 30 * this.msgs.size() + 60;
                graphics2D.setXORMode(Color.BLACK);
                graphics2D.setPaintMode();
                graphics2D.setColor(Color.decode("0xFFCCFF"));
                graphics2D.fillRoundRect((this.dim.width - n) / 2, (this.dim.height - n2) / 2, n, n2, 3, 3);
                graphics2D.setColor(Color.BLACK);
                int n3 = this.getMaxW();
                for (int i = 0; i < this.msgs.size(); ++i) {
                    Object[] objectArray = this.msgs.get(i);
                    int n4 = (Integer)objectArray[2];
                    U.drawString(graphics2D, PlainPage.this.fontList, objectArray[0].toString(), (this.dim.width - n4) / 2, 10 + this.dim.height / 2 + 30 * (i - this.msgs.size() / 2), n3);
                }
            }
        }

        int drawLineOrTest(Graphics2D graphics2D, FontList fontList, int n, int n2, boolean bl, int[] nArray, boolean bl2, int n3, int n4) {
            int n5;
            int[] nArray2;
            if (n4 == 0) {
                return 0;
            }
            CharSequence charSequence = PlainPage.this.pageData.roLines.getline(n);
            CharSequence charSequence2 = U.subs(charSequence, PlainPage.this.sx, PlainPage.this.sx + n3 / 4);
            if (n4 > charSequence2.length()) {
                n4 = -1;
            }
            if (n4 > 0) {
                int[] nArray3 = new int[1];
                nArray2 = nArray3;
                nArray3[0] = n4;
            } else {
                nArray2 = null;
            }
            int[] nArray4 = nArray2;
            int n6 = 0;
            if (this.inComment) {
                int n7 = FindAndReplace.indexOfSeq(charSequence2, this.commentClose, 0, false);
                if (n7 >= 0) {
                    this.inComment = false;
                    CharSequence charSequence3 = charSequence2.subSequence(0, n7 + this.commentClose.length());
                    CharSequence charSequence4 = charSequence2.subSequence(n7 + this.commentClose.length(), charSequence2.length());
                    int n8 = this.drawText(graphics2D, fontList, charSequence3, n6, n2, true, bl, nArray, bl2, n3, nArray4);
                    if (this.watchChar(nArray4)) {
                        return n8;
                    }
                    n5 = n8 + this.drawText(graphics2D, fontList, charSequence4, n6 + n8, n2, false, bl, nArray, bl2, n3, nArray4);
                } else {
                    n5 = this.drawText(graphics2D, fontList, charSequence2, n6, n2, true, bl, nArray, bl2, n3, nArray4);
                }
            } else {
                int n9 = this.getCommentPos(charSequence2);
                if (n9 >= 0) {
                    CharSequence charSequence5 = charSequence2.subSequence(0, n9);
                    CharSequence charSequence6 = charSequence2.subSequence(n9, charSequence2.length());
                    if (this.inComment) {
                        int n10 = FindAndReplace.indexOfSeq(charSequence6, this.commentClose, this.commentStart.length(), false);
                        if (n10 >= 0) {
                            CharSequence charSequence7 = charSequence6.subSequence(0, n10 + this.commentClose.length());
                            CharSequence charSequence8 = charSequence6.subSequence(n10 + this.commentClose.length(), charSequence6.length());
                            int n11 = this.drawText(graphics2D, fontList, charSequence5, n6, n2, false, bl, nArray, bl2, n3, nArray4);
                            if (this.watchChar(nArray4)) {
                                return n11;
                            }
                            int n12 = n11 + this.drawText(graphics2D, fontList, charSequence7, n6 + n11, n2, true, bl, nArray, bl2, n3, nArray4);
                            if (this.watchChar(nArray4)) {
                                return n12;
                            }
                            n5 = n12 + this.drawText(graphics2D, fontList, charSequence8, n6 + n12, n2, false, bl, nArray, bl2, n3, nArray4);
                            this.inComment = false;
                        } else {
                            int n13 = this.drawText(graphics2D, fontList, charSequence5, n6, n2, false, bl, nArray, bl2, n3, nArray4);
                            if (this.watchChar(nArray4)) {
                                return n13;
                            }
                            n5 = n13 + this.drawText(graphics2D, fontList, charSequence6, n6 + n13, n2, true, bl, nArray, bl2, n3, nArray4);
                        }
                    } else {
                        int n14 = this.drawText(graphics2D, fontList, charSequence5, n6, n2, false, bl, nArray, bl2, n3, nArray4);
                        if (this.watchChar(nArray4)) {
                            return n14;
                        }
                        n5 = n14 + this.drawText(graphics2D, fontList, charSequence6, n6 + n14, n2, true, bl, nArray, bl2, n3, nArray4);
                    }
                } else {
                    n5 = this.drawText(graphics2D, fontList, charSequence2, n6, n2, false, bl, nArray, bl2, n3, nArray4);
                }
            }
            return n5;
        }

        private boolean watchChar(int[] nArray) {
            if (nArray == null) {
                return false;
            }
            return nArray[0] <= 0;
        }

        int drawText(Graphics2D graphics2D, FontList fontList, CharSequence charSequence, int n, int n2, boolean bl, boolean bl2, int[] nArray, boolean bl3, int n3, int[] nArray2) {
            int n4 = 0;
            if (n + n4 >= n3) {
                return n4;
            }
            List<CharSequence> list = U.splitToken(charSequence);
            for (CharSequence charSequence2 : list) {
                int n5;
                String string = charSequence2.toString();
                if (string.equals("\t")) {
                    if (bl3) {
                        graphics2D.drawImage(U.tabImg, n + n4, n2 - this.lineHeight, null);
                    }
                    if (nArray != null && n + (n4 += U.TAB_WIDTH) < n3) {
                        nArray[0] = nArray[0] + 1;
                    }
                    if (nArray2 != null) {
                        nArray2[0] = nArray2[0] - 1;
                    }
                } else if (bl) {
                    n5 = U.drawTwoColor(graphics2D, fontList, string, n + n4, n2, this.colorComment, this.colorComment2, 1, n3, bl3);
                    if (nArray != null) {
                        nArray[0] = n + n4 + n5 <= n3 ? nArray[0] + string.length() : nArray[0] + U.exactRemainChar(graphics2D, fontList, string, n3 - n - n4);
                    }
                    if (nArray2 != null) {
                        if (nArray2[0] >= string.length()) {
                            nArray2[0] = nArray2[0] - string.length();
                        } else {
                            n5 = U.exactRemainCharWidth(graphics2D, fontList, string, nArray2[0]);
                            nArray2[0] = 0;
                        }
                    }
                    n4 += n5;
                } else {
                    if (bl3) {
                        U.getHighLightID(string, graphics2D, this.colorKeyword, this.colorDigit, this.colorNormal);
                    }
                    n5 = U.drawString(graphics2D, PlainPage.this.fontList, string, n + n4, n2, n3, bl3);
                    if (nArray != null) {
                        nArray[0] = n + n4 + n5 <= n3 ? nArray[0] + string.length() : nArray[0] + U.exactRemainChar(graphics2D, fontList, string, n3 - n - n4);
                    }
                    if (nArray2 != null) {
                        if (nArray2[0] >= string.length()) {
                            nArray2[0] = nArray2[0] - string.length();
                        } else {
                            n5 = U.exactRemainCharWidth(graphics2D, fontList, string, nArray2[0]);
                            nArray2[0] = 0;
                        }
                    }
                    n4 += n5;
                }
                if ((nArray2 == null || nArray2[0] > 0) && n + n4 < n3) continue;
                break;
            }
            return n4;
        }

        void drawTextLines(Graphics2D graphics2D, FontList fontList, int n) {
            int n2 = PlainPage.this.sy;
            int n3 = this.lineHeight;
            for (int i = 0; i < PlainPage.this.showLineCnt && n2 < PlainPage.this.pageData.roLines.getLinesize(); ++i) {
                CharSequence charSequence = PlainPage.this.pageData.roLines.getline(n2);
                if (PlainPage.this.sx < charSequence.length()) {
                    graphics2D.setColor(this.colorNormal);
                    int n4 = this.drawLineOrTest(graphics2D, fontList, n2, n3, n2 == PlainPage.this.cy, null, true, n, -1);
                    this.drawReturn(graphics2D, n4, n3);
                } else {
                    this.drawReturn(graphics2D, 0, n3);
                }
                ++n2;
                n3 += this.lineHeight + this.lineGap;
            }
        }

        void drawToolbar(Graphics2D graphics2D) {
            Ime.ImeInterface imeInterface = Ime.getCurrentIme();
            ReadonlyLines readonlyLines = PlainPage.this.pageData.roLines;
            int n = PlainPage.this.pageData.roLines.getLinesize();
            int n2 = 0;
            if (n > 20) {
                n2 = 100 * PlainPage.this.cy / n;
            }
            String string = String.format("%s %s %s%s L:%s%d X:%d undo:%d%s %s%s%s%s <F1>:Help%s", PlainPage.this.pageData.changedOutside ? " [ChangedOutside!]" : "", PlainPage.this.pageData.encoding == null ? "" : PlainPage.this.pageData.encoding, PlainPage.this.pageData.lineSep.equals("\n") ? "U" : "W", PlainPage.this.rectSelectMode ? " R " : "", n2 == 0 ? "" : n2 + "%", n, PlainPage.this.cx + 1, PlainPage.this.pageData.history.size(), imeInterface == null ? "" : " " + imeInterface.getImeName(), PlainPage.this.pageData.title, PlainPage.this.readonly ? " ro" : "", PlainPage.this.pageData.gzip ? " Z" : "", PlainPage.this.pageData.fileLoaded ? "" : " WD:" + PlainPage.this.workPath, PlainPage.this.console == null ? "" : " " + String.valueOf(readonlyLines.getline(n - 1)));
            graphics2D.setColor(this.colorGutMark1);
            U.drawString(graphics2D, PlainPage.this.fontList, string, 2, this.lineHeight + 2, this.dim.width);
            graphics2D.setColor(this.colorGutMark2);
            this.nextXToolBar = 2 + U.drawString(graphics2D, PlainPage.this.fontList, string, 1, this.lineHeight + 1, this.dim.width);
            if (PlainPage.this.msg != null) {
                if (System.currentTimeMillis() - PlainPage.this.msgtime > this.MSG_VANISH_TIME) {
                    PlainPage.this.msg = null;
                } else {
                    int n3 = U.stringWidth(graphics2D, PlainPage.this.fontList, PlainPage.this.msg, this.dim.width);
                    graphics2D.setColor(new Color(0xEE6666));
                    graphics2D.fillRect(this.dim.width - n3, 0, this.dim.width, this.lineHeight + this.lineGap);
                    graphics2D.setColor(Color.YELLOW);
                    U.drawString(graphics2D, PlainPage.this.fontList, PlainPage.this.msg, this.dim.width - n3, this.lineHeight, this.dim.width);
                }
            }
        }

        private int getCommentPos(CharSequence charSequence) {
            if (PlainPage.this.pageData.comment == null) {
                this.inComment = false;
                return -1;
            }
            for (String string : PlainPage.this.pageData.comment) {
                int n = FindAndReplace.indexOfSeq(charSequence, string, 0, false);
                if (n < 0) continue;
                if ("/*".equals(string)) {
                    this.inComment = true;
                    this.commentClose = "*/";
                    this.commentStart = string;
                } else if ("<!--".equals(string)) {
                    this.inComment = true;
                    this.commentClose = "-->";
                    this.commentStart = string;
                }
                return n;
            }
            this.inComment = false;
            return -1;
        }

        public void message(String string) {
            PlainPage.this.msg = string;
            PlainPage.this.msgtime = System.currentTimeMillis();
            PlainPage.this.repaint();
            U.repaintAfter(this.MSG_VANISH_TIME, PlainPage.this.uiComp);
            System.out.println(string);
        }

        void setNextColorMode() {
            if (++this.colorMode >= this.ColorModes.length) {
                this.colorMode = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        void xpaint(Graphics var1_1, Dimension var2_2) {
            block49: {
                block50: {
                    this.inComment = false;
                    var3_3 = System.currentTimeMillis();
                    var5_4 = (Graphics2D)var1_1;
                    PlainPage.this.uiComp.config;
                    var5_4.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, EditorPanelConfig.VALUE_TEXT_ANTIALIAS);
                    if (PlainPage.this.fontList == null) {
                        PlainPage.this.fontList = Conf.defaultFontList;
                    }
                    this.lineHeight = PlainPage.this.fontList.getlineHeight();
                    this.dim = var2_2;
                    var6_5 = null;
                    if (this.fpsOn) {
                        var6_5 = (Graphics2D)var5_4.create();
                    }
                    var7_6 = false;
                    if (!PlainPage.this.ui.cp.showCommandPanel) break block49;
                    this.cp.xpaint((Graphics2D)var1_1, var2_2);
                    if (!this.fpsOn) break block50;
                    var8_7 = System.currentTimeMillis();
                    var10_12 = (int)(var8_7 - var3_3);
                    if (var10_12 == 0) {
                        this.drawNextToolbarText(var6_5, "\u21bb\u221e");
                    } else {
                        var11_15 = 1000.0f / (float)var10_12;
                        if (var11_15 >= 1.0f) {
                            this.drawNextToolbarText(var6_5, "\u21bb" + (int)var11_15);
                        } else {
                            this.drawNextToolbarText(var6_5, String.format("\u21bb%.3f", new Object[]{Float.valueOf(var11_15)}));
                        }
                    }
                    if (var6_5 != null) {
                        var6_5.dispose();
                    }
                }
                return;
            }
            try {
                if (!PlainPage.this.pageData.isCommentChecked) {
                    PlainPage.this.pageData.isCommentChecked = true;
                    U.startDaemonThread(new Thread(){

                        @Override
                        public void run() {
                            U.guessComment(PlainPage.this);
                        }
                    });
                }
                PlainPage.this.showLineCnt = (int)Math.ceil((float)(var2_2.height - PlainPage.this.toolbarHeight) / ((float)(this.lineHeight + this.lineGap) * this.scalev));
                PlainPage.this.showLineCnt2 = (int)Math.floor((float)(var2_2.height - PlainPage.this.toolbarHeight) / ((float)(this.lineHeight + this.lineGap) * this.scalev));
                if (PlainPage.this.showLineCnt2 <= 0) {
                    PlainPage.this.showLineCnt2 = 1;
                }
                var8_8 = this.dim.width - 40;
                var9_19 = (int)((float)var8_8 / this.scalev);
                if (PlainPage.this.cy >= PlainPage.this.pageData.roLines.getLinesize()) {
                    PlainPage.this.cy = Math.max(0, PlainPage.this.pageData.roLines.getLinesize() - 1);
                }
                var5_4.setColor(this.colorBg);
                var5_4.fillRect(0, 0, var2_2.width, var2_2.height);
                if (this.noise) {
                    U.paintNoise(var5_4, this.dim);
                }
                this.drawToolbar(var5_4);
                var5_4.translate(0, PlainPage.this.toolbarHeight);
                var5_4.setColor(this.colorGutLine);
                var5_4.drawRect(40, -1, this.dim.width - 40, this.dim.height - PlainPage.this.toolbarHeight);
                this.drawGutter(var5_4);
                var5_4.scale(this.scalev, this.scalev);
                var10_13 = (int)(40.0f / this.scalev);
                var5_4.translate(var10_13, 0);
                var5_4.setClip(-var10_13, 0, var9_19 + var10_13, (int)((float)this.dim.height / this.scalev));
                var11_16 = (Graphics2D)var5_4.create();
                var11_16.setClip(0, 0, 0, 0);
                if (PlainPage.this.ptSelection.isRectSelecting()) {
                    PlainPage.this.ptEdit.setLength(PlainPage.this.cy, PlainPage.this.cx);
                } else {
                    PlainPage.this.cx = Math.min(PlainPage.this.pageData.roLines.getline(PlainPage.this.cy).length(), PlainPage.this.cx);
                }
                this.adjustSx(var11_16, var9_19);
                var12_20 = false;
                if ((PlainPage.this.my <= 0 || PlainPage.this.my >= PlainPage.this.toolbarHeight) && PlainPage.this.my > 0 && PlainPage.this.mx >= 40 && PlainPage.this.my >= PlainPage.this.toolbarHeight) {
                    PlainPage.this.mx -= 40;
                    PlainPage.this.my -= PlainPage.this.toolbarHeight;
                    PlainPage.this.mx = (int)((float)PlainPage.this.mx / this.scalev);
                    PlainPage.this.my = (int)((float)PlainPage.this.my / this.scalev);
                    PlainPage.this.cy = PlainPage.this.sy + PlainPage.this.my / (this.lineHeight + this.lineGap);
                    if (PlainPage.this.cy >= PlainPage.this.pageData.roLines.getLinesize()) {
                        if (!PlainPage.this.readonly && PlainPage.this.pageData.roLines.getline(PlainPage.this.pageData.roLines.getLinesize() - 1).length() > 0) {
                            PlainPage.this.pageData.editRec.insertEmptyLine(PlainPage.this.cy);
                        }
                        PlainPage.this.cy = PlainPage.this.pageData.roLines.getLinesize() - 1;
                    }
                    var12_20 = true;
                }
                if ((var13_21 = PlainPage.this.cy - PlainPage.this.sy) >= '\u0000' && var13_21 < PlainPage.this.showLineCnt) {
                    var5_4.setColor(this.colorCurrentLineBg);
                    var5_4.fillRect(0, var13_21 * (this.lineHeight + this.lineGap), var9_19, this.lineHeight + this.lineGap - 1);
                }
                if (var12_20) {
                    var13_22 = PlainPage.this.pageData.roLines.getline(PlainPage.this.cy);
                    var14_23 = new int[1];
                    this.drawLineOrTest(var11_16, PlainPage.this.fontList, PlainPage.this.cy, -1, true, (int[])var14_23, false, PlainPage.this.mx, -1);
                    PlainPage.this.cx = PlainPage.this.sx + var14_23[0];
                    PlainPage.this.my = 0;
                    var7_6 = PlainPage.this.ptSelection.mouseSelection(var13_22);
                }
                this.drawSelectionBackground(var5_4);
                var5_4.setColor(this.colorNormal);
                this.drawTextLines(var5_4, PlainPage.this.fontList, (int)((float)var8_8 / this.scalev));
                if (PlainPage.this.cx - 1 < PlainPage.this.pageData.roLines.getline(PlainPage.this.cy).length() && PlainPage.this.cx - 1 >= 0 && (var15_25 = (var14_23 = (Object)"(){}[]<>").indexOf(var13_21 = (char)PlainPage.this.pageData.roLines.getline(PlainPage.this.cy).charAt(PlainPage.this.cx - 1))) >= 0) {
                    if (var15_25 % 2 == 0) {
                        this.pairMarker.pairMark(var5_4, PlainPage.this.cx - 1, PlainPage.this.cy, var14_23.charAt(var15_25 + 1), var13_21, 1);
                    } else {
                        this.pairMarker.pairMark(var5_4, PlainPage.this.cx - 1, PlainPage.this.cy, var14_23.charAt(var15_25 - 1), var13_21, -1);
                    }
                }
                if (PlainPage.this.cy >= PlainPage.this.sy && PlainPage.this.cy <= PlainPage.this.sy + PlainPage.this.showLineCnt) {
                    var13_21 = this.drawLineOrTest(var11_16, PlainPage.this.fontList, PlainPage.this.cy, -1, true, null, false, var9_19, PlainPage.this.cx - PlainPage.this.sx);
                    var14_24 = (PlainPage.this.cy - PlainPage.this.sy) * (this.lineHeight + this.lineGap);
                    var5_4.setXORMode(new Color(0x30F0F0));
                    var5_4.fillRect(var13_21, var14_24, 2, this.lineHeight + 3);
                    var15_26 = Ime.getCurrentIme();
                    if (PlainPage.access$100(PlainPage.this) != null && PlainPage.access$100(PlainPage.this).length() > 0 && var15_26 != null && !var15_26.longTextMode()) {
                        var5_4.setPaintMode();
                        var5_4.setColor(new Color(0xAAAA00));
                        var16_27 = U.stringWidth(var5_4, PlainPage.this.fontList, PlainPage.access$100(PlainPage.this), var9_19);
                        var5_4.fillRect(var13_21, var14_24, var16_27 + 4, this.lineHeight + this.lineGap);
                        var5_4.setColor(new Color(170));
                        U.drawString(var5_4, PlainPage.this.fontList, PlainPage.access$100(PlainPage.this), var13_21 + 2, var14_24 + this.lineHeight, var9_19);
                    }
                    if (var15_26 != null) {
                        var16_28 = var5_4.getClipBounds();
                        System.out.println("bs=" + String.valueOf(var16_28));
                        var15_26.paint(var5_4, PlainPage.this.fontList, var13_21, var14_24 + this.lineHeight + this.lineGap, var16_28);
                    }
                }
                if (this.aboutOn) {
                    var5_4.setPaintMode();
                    var5_4.drawImage((Image)this.aboutImg, 0, this.aboutY, null);
                }
                this.drawSelfDispMessages(var5_4);
                var11_16.dispose();
                ** if (!this.fpsOn) goto lbl-1000
            }
            catch (Throwable var8_10) {
                try {
                    var8_10.printStackTrace();
                    PlainPage.this.ui.message("Bug when xpaint():" + String.valueOf(var8_10));
                    ** if (!this.fpsOn) goto lbl-1000
                }
                catch (Throwable var17_29) {
                    if (this.fpsOn) {
                        var18_30 = System.currentTimeMillis();
                        var20_31 = (int)(var18_30 - var3_3);
                        if (var20_31 == 0) {
                            this.drawNextToolbarText(var6_5, "\u21bb\u221e");
                        } else {
                            var21_32 = 1000.0f / (float)var20_31;
                            if (var21_32 >= 1.0f) {
                                this.drawNextToolbarText(var6_5, "\u21bb" + (int)var21_32);
                            } else {
                                this.drawNextToolbarText(var6_5, String.format("\u21bb%.3f", new Object[]{Float.valueOf(var21_32)}));
                            }
                        }
                        if (var6_5 != null) {
                            var6_5.dispose();
                        }
                    }
                    throw var17_29;
                }
lbl-1000:
                // 1 sources

                {
                    var8_11 = System.currentTimeMillis();
                    var10_14 = (int)(var8_11 - var3_3);
                    if (var10_14 == 0) {
                        this.drawNextToolbarText(var6_5, "\u21bb\u221e");
                    } else {
                        var11_18 = 1000.0f / (float)var10_14;
                        if (var11_18 >= 1.0f) {
                            this.drawNextToolbarText(var6_5, "\u21bb" + (int)var11_18);
                        } else {
                            this.drawNextToolbarText(var6_5, String.format("\u21bb%.3f", new Object[]{Float.valueOf(var11_18)}));
                        }
                    }
                    if (var6_5 != null) {
                        var6_5.dispose();
                    }
                }
lbl-1000:
                // 4 sources

                {
                }
            }
lbl-1000:
            // 1 sources

            {
                var8_9 = System.currentTimeMillis();
                var10_13 = (int)(var8_9 - var3_3);
                if (var10_13 == 0) {
                    this.drawNextToolbarText(var6_5, "\u21bb\u221e");
                } else {
                    var11_17 = 1000.0f / (float)var10_13;
                    if (var11_17 >= 1.0f) {
                        this.drawNextToolbarText(var6_5, "\u21bb" + (int)var11_17);
                    } else {
                        this.drawNextToolbarText(var6_5, String.format("\u21bb%.3f", new Object[]{Float.valueOf(var11_17)}));
                    }
                }
                if (var6_5 != null) {
                    var6_5.dispose();
                }
            }
lbl-1000:
            // 4 sources

            {
            }
            if (var7_6) {
                PlainPage.this.repaint();
            }
        }

        private void adjustSx(Graphics2D graphics2D, int n) {
            if (PlainPage.this.sx + 6 > PlainPage.this.cx && PlainPage.this.sx > 0) {
                PlainPage.this.sx = Math.max(0, PlainPage.this.cx - 6);
            } else {
                int[] nArray = new int[1];
                this.drawLineOrTest(graphics2D, PlainPage.this.fontList, PlainPage.this.cy, -1, true, nArray, false, n, -1);
                int n2 = nArray[0];
                CharSequence charSequence = PlainPage.this.pageData.roLines.getline(PlainPage.this.cy);
                if (PlainPage.this.sx + n2 < charSequence.length() && PlainPage.this.cx + 6 > PlainPage.this.sx + n2) {
                    PlainPage.this.sx = U.between(PlainPage.this.cx - n2 + 6, 0, charSequence.length() - 1);
                }
            }
        }

        private void drawSelectionBackground(Graphics2D graphics2D) {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            TexturePaint texturePaint = this.getFillImagePaint();
            graphics2D2.setPaint(texturePaint);
            if (PlainPage.this.rectSelectMode) {
                Rectangle rectangle = PlainPage.this.ptSelection.getSelectRect();
                int n = rectangle.x;
                int n2 = rectangle.y;
                int n3 = rectangle.width;
                int n4 = rectangle.height;
                int n5 = Math.max(PlainPage.this.sy, n2);
                int n6 = Math.min(PlainPage.this.sy + PlainPage.this.showLineCnt + 1, n4);
                for (int i = n5; i <= n6; ++i) {
                    this.drawSelect(graphics2D2, i, n, n3);
                }
            } else {
                Rectangle rectangle = PlainPage.this.ptSelection.getSelectRect();
                int n = rectangle.x;
                int n7 = rectangle.y;
                int n8 = rectangle.width;
                int n9 = rectangle.height;
                if (n7 == n9 && n < n8) {
                    this.drawSelect(graphics2D2, n7, n, n8);
                } else if (n7 < n9) {
                    this.drawSelect(graphics2D2, n7, n, Integer.MAX_VALUE);
                    int n10 = Math.max(PlainPage.this.sy, n7 + 1);
                    int n11 = Math.min(PlainPage.this.sy + PlainPage.this.showLineCnt + 1, n9);
                    this.drawSelectLine(graphics2D2, n10, n11);
                    this.drawSelect(graphics2D2, n9, 0, n8);
                }
            }
            graphics2D2.dispose();
        }

        private TexturePaint getFillImagePaint() {
            int n = 13;
            BufferedImage bufferedImage = new BufferedImage(n, n, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(this.colorBg);
            graphics2D.fillRect(0, 0, n, n);
            graphics2D.setColor(this.dissRed(this.colorBg));
            int n2 = n - 1;
            int n3 = 0;
            int n4 = n2 - n3;
            graphics2D.drawLine(n3, n3, n4, n4);
            graphics2D.drawLine(n3, n4, n4, n3);
            graphics2D.dispose();
            return new TexturePaint(bufferedImage, new Rectangle(0, 0, n, n));
        }

        private Color dissRed(Color color) {
            int n = color.getRed();
            n = n < 100 ? 220 : 30;
            return new Color(n, color.getGreen(), color.getBlue());
        }

        class PairMark {
            PairMark() {
            }

            void markBox(Graphics2D graphics2D, int n, int n2) {
                if (n2 >= PlainPage.this.sy && n2 <= PlainPage.this.sy + PlainPage.this.showLineCnt && n >= PlainPage.this.sx) {
                    int n3 = Paint.this.getMaxW();
                    CharSequence charSequence = PlainPage.this.pageData.roLines.getline(n2);
                    int n4 = Paint.this.drawLineOrTest(graphics2D, PlainPage.this.fontList, n2, -1, false, null, false, n3, n - PlainPage.this.sx);
                    String string = charSequence.subSequence(n, n + 1).toString();
                    int n5 = graphics2D.getFontMetrics().stringWidth(string);
                    int n6 = Paint.this.lineHeight + Paint.this.lineGap;
                    graphics2D.setColor(Color.WHITE);
                    graphics2D.drawRect(n4 - 1, (n2 - PlainPage.this.sy) * n6 - 1, n5, n6);
                    graphics2D.setColor(Paint.this.colorNormal);
                    graphics2D.drawRect(n4, (n2 - PlainPage.this.sy) * n6, n5, n6);
                    U.drawString(graphics2D, PlainPage.this.fontList, string, n4, Paint.this.lineHeight + (n2 - PlainPage.this.sy) * n6, n3);
                }
            }

            void markGutLine(Graphics2D graphics2D, int n, int n2) {
                int n3;
                if (n > n2) {
                    n3 = n;
                    n = n2;
                    n2 = n3;
                }
                n3 = n;
                int n4 = n2;
                n = Math.min(Math.max(n, PlainPage.this.sy), PlainPage.this.sy + PlainPage.this.showLineCnt);
                n2 = Math.min(Math.max(n2, PlainPage.this.sy), PlainPage.this.sy + PlainPage.this.showLineCnt);
                int n5 = 5 + (n - PlainPage.this.sy) * (Paint.this.lineHeight + Paint.this.lineGap);
                int n6 = -8 + (n2 + 1 - PlainPage.this.sy) * (Paint.this.lineHeight + Paint.this.lineGap);
                graphics2D.setColor(Paint.this.colorGutMark1);
                graphics2D.drawLine(-6, n5 - 1, -6, n6 - 1);
                if (n3 == n) {
                    graphics2D.setColor(Paint.this.colorGutMark1);
                    graphics2D.drawLine(-6, n5 - 1, -1, n5 - 1);
                }
                if (n4 == n2) {
                    graphics2D.setColor(Paint.this.colorGutMark1);
                    graphics2D.drawLine(-6, n6 - 1, -1, n6 - 1);
                }
                graphics2D.setColor(Paint.this.colorGutMark2);
                graphics2D.drawLine(-5, n5, -5, n6);
                if (n3 == n) {
                    graphics2D.setColor(Paint.this.colorGutMark2);
                    graphics2D.drawLine(-5, n5, 0, n5);
                }
                if (n4 == n2) {
                    graphics2D.setColor(Paint.this.colorGutMark2);
                    graphics2D.drawLine(-5, n6, 0, n6);
                }
            }

            void findchar(PlainPage plainPage, char c, int n, int[] nArray, char c2) {
                int n2 = nArray[0];
                int n3 = nArray[1];
                CharSequence charSequence = plainPage.pageData.roLines.getline(n3);
                int n4 = 1;
                while (true) {
                    char c3;
                    if (n == -1) {
                        if (--n2 < 0) {
                            if (--n3 < 0) {
                                nArray[0] = -1;
                                nArray[1] = -1;
                                return;
                            }
                            charSequence = plainPage.pageData.roLines.getline(n3);
                            n2 = charSequence.length() - 1;
                            if (n2 < 0) continue;
                        }
                        if ((c3 = charSequence.charAt(n2)) == c2) {
                            ++n4;
                            continue;
                        }
                        if (c3 != c || --n4 != 0) continue;
                        nArray[0] = n2;
                        nArray[1] = n3;
                        return;
                    }
                    if (++n2 >= charSequence.length()) {
                        if (++n3 >= plainPage.pageData.roLines.getLinesize()) {
                            nArray[0] = -1;
                            nArray[1] = -1;
                            return;
                        }
                        n2 = 0;
                        charSequence = plainPage.pageData.roLines.getline(n3);
                        if (n2 >= charSequence.length()) continue;
                    }
                    if ((c3 = charSequence.charAt(n2)) == c2) {
                        ++n4;
                        continue;
                    }
                    if (c3 == c && --n4 == 0) break;
                }
                nArray[0] = n2;
                nArray[1] = n3;
            }

            void moveToPairMark(int n, int n2, char c, char c2, int n3) {
                int[] nArray = new int[]{n, n2};
                this.findchar(PlainPage.this, c, n3, nArray, c2);
                if (nArray[0] >= 0) {
                    PlainPage.this.cx = nArray[0] + 1;
                    int n4 = Math.abs(PlainPage.this.cy - nArray[1]);
                    if (n4 >= 10) {
                        PlainPage.this.ui.message(String.format("moved across %,d lines", n4));
                    }
                    PlainPage.this.cy = nArray[1];
                    PlainPage.this.focusCursor();
                }
            }

            void pairMark(Graphics2D graphics2D, int n, int n2, char c, char c2, int n3) {
                int[] nArray = new int[]{n, n2};
                this.findchar(PlainPage.this, c, n3, nArray, c2);
                if (nArray[0] >= 0) {
                    this.markBox(graphics2D, n, n2);
                    this.markBox(graphics2D, nArray[0], nArray[1]);
                    if (n2 != nArray[1]) {
                        this.markGutLine(graphics2D, n2, nArray[1]);
                    }
                }
            }
        }
    }
}

