/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import neoe.ne.Plugin;
import neoe.ne.U;
import neoe.ne.Version;
import neoe.ne.util.FileIterator;

public class PicView {
    private File currentFile;
    private int cutx;
    private int cuty;
    private int cutx2;
    private int cuty2;
    private boolean savingCut;
    Slideshow ss;
    PicViewPanel picviewpanel;
    static TexturePaint tp1;

    public static void main(String[] stringArray) throws Exception {
        new PicView().show(new File(stringArray[0]));
    }

    public void copyFilename() {
        if (this.currentFile != null) {
            U.setClipBoard(this.currentFile.getAbsolutePath());
        }
    }

    public BufferedImage loadImage(File file) throws Exception {
        if (file.getName().endsWith(".webp")) {
            return (BufferedImage)Plugin.call("webp", file);
        }
        return ImageIO.read(file);
    }

    private void sortCutPoints() {
        int n;
        if (this.cutx > this.cutx2) {
            n = this.cutx;
            this.cutx = this.cutx2;
            this.cutx2 = n;
        }
        if (this.cuty > this.cuty2) {
            n = this.cuty;
            this.cuty = this.cuty2;
            this.cuty2 = n;
        }
    }

    public void resetCut() {
        this.cuty2 = -1;
        this.cutx2 = -1;
        this.cuty = -1;
        this.cutx = -1;
    }

    private void installSlideshow(JFrame jFrame, PicViewPanel picViewPanel) {
        this.ss = new Slideshow(picViewPanel);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                PicView.this.ss.exited = true;
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                PicView.this.ss.iconed = false;
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                PicView.this.ss.iconed = true;
            }
        });
        new Thread(() -> {
            while (!this.ss.exited) {
                this.ss.next();
            }
        }).start();
    }

    public void show(File file) throws Exception {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(2);
        jFrame.setIconImage(U.getAppIcon("e3.jpg"));
        this.picviewpanel = new PicViewPanel(jFrame, file);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add(this.picviewpanel);
        jFrame.setVisible(true);
        U.saveFileHistory(file.getAbsolutePath(), 0);
        this.installSlideshow(jFrame, this.picviewpanel);
        this.resetCut();
    }

    private static TexturePaint getFillImagePaint() {
        if (tp1 != null) {
            return tp1;
        }
        int n = 10;
        BufferedImage bufferedImage = new BufferedImage(n + n, n + n, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n);
        graphics2D.fillRect(n, n, n, n);
        graphics2D.setColor(Color.lightGray);
        graphics2D.fillRect(n, 0, n, n);
        graphics2D.fillRect(0, n, n, n);
        graphics2D.dispose();
        tp1 = new TexturePaint(bufferedImage, new Rectangle(0, 0, n + n, n + n));
        return tp1;
    }

    private class Slideshow {
        boolean exited;
        boolean iconed;
        int delay = 0;
        private PicViewPanel p;

        public Slideshow(PicViewPanel picViewPanel) {
            this.p = picViewPanel;
        }

        public void decDelay() {
            this.delay = this.delay > 0 ? --this.delay : 0;
        }

        public void incDelay() {
            this.delay = this.delay <= 0 ? 5 : ++this.delay;
        }

        public void next() {
            try {
                Thread.sleep(this.delay <= 0 ? 1000L : (long)(1000 * this.delay));
                if (this.delay > 0 && !this.iconed && !this.exited) {
                    this.p.viewFile(1);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void stop() {
            this.delay = 0;
        }
    }

    public class PicViewPanel
    extends JPanel
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    KeyListener {
        private static final long serialVersionUID = -74255011004476996L;
        private File f;
        int fi;
        List<File> files;
        private JFrame frame;
        private BufferedImage img;
        private int mx;
        private int my;
        private int ph;
        private int pw;
        double rate = 1.0;
        private boolean small = true;
        private double vx;
        private double vx1;
        private double vy;
        private double vy1;
        Rectangle maxWindow;
        boolean superMode = false;
        private Iterator<File> sfi;
        List<File> superModeHistory = new LinkedList<File>();
        int superModeHistoryPointer = 0;
        boolean needRepaint;
        int rx;
        int ry;
        boolean drawMousePos = true;
        private int direction;

        public PicViewPanel(JFrame jFrame, File file) throws Exception {
            this.frame = jFrame;
            long l = System.currentTimeMillis();
            this.f = file;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.maxWindow = graphicsEnvironment.getMaximumWindowBounds();
            this.img = PicView.this.loadImage(file);
            this.small = this.img.getWidth() > this.maxWindow.width || this.img.getHeight() > this.maxWindow.height;
            System.out.println("read in " + (System.currentTimeMillis() - l));
            this.files = this.listImgs();
            this.setTitleWithSize(file, this.fi, this.files.size());
            this.setSize(this.img);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.addKeyListener(this);
            this.setFocusable(true);
            Thread thread = new Thread(() -> {
                while (true) {
                    if (this.needRepaint) {
                        this.needRepaint = false;
                        this.repaint();
                        this.needRepaint = false;
                    }
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        continue;
                    }
                    break;
                }
            });
            thread.setDaemon(true);
            thread.start();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            try {
                if (keyEvent.isControlDown()) {
                    if (n == 87) {
                        this.frame.dispose();
                    } else if (n == 83) {
                        this.saveCut();
                    } else if (n == 67) {
                        PicView.this.copyFilename();
                    }
                } else if (n == 112 || n == 9) {
                    this.small = !this.small;
                    this.repaint1();
                } else if (n == 37 || n == 8) {
                    this.viewFile(-1);
                } else if (n == 39 || n == 32) {
                    this.viewFile(1);
                } else if (n == 38) {
                    this.rotate(1);
                } else if (n == 40) {
                    this.rotate(-1);
                } else if (n == 80) {
                    PicView.this.ss.stop();
                } else if (n == 83) {
                    this.toggleSuperMode();
                } else if (n == 91) {
                    PicView.this.ss.decDelay();
                } else if (n == 93) {
                    PicView.this.ss.incDelay();
                } else if (n == 48) {
                    this.rate = 1.0;
                    this.vx = 0.0;
                    this.vy = 0.0;
                    this.repaint1();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        private List<File> listImgs() {
            File[] fileArray;
            ArrayList<File> arrayList = new ArrayList<File>();
            for (File file : fileArray = this.f.getAbsoluteFile().getParentFile().listFiles()) {
                if (!U.isImageFile(file)) continue;
                arrayList.add(file);
            }
            Collections.sort(arrayList, new DigitFilenameCompare());
            this.fi = arrayList.indexOf(this.f);
            if (this.fi < 0) {
                this.fi = 0;
                System.out.println("what?not found file name in list");
            } else {
                System.out.println("list image files count " + arrayList.size());
            }
            return arrayList;
        }

        private void setRate(int n, int n2, double d) {
            this.vx = d / this.rate * (this.vx - (double)n) + (double)n;
            this.vy = d / this.rate * (this.vy - (double)n2) + (double)n2;
            this.rate = d;
        }

        public void startCut(int n, int n2) {
            PicView.this.cutx2 = (PicView.this.cutx = n);
            PicView.this.cuty2 = (PicView.this.cuty = n2);
            this.repaint1();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveCut() throws IOException {
            if (PicView.this.cutx == PicView.this.cutx2 || PicView.this.cuty == PicView.this.cuty2) {
                return;
            }
            PicView.this.savingCut = true;
            Graphics graphics = null;
            try {
                boolean bl;
                BufferedImage bufferedImage = new BufferedImage(PicView.this.picviewpanel.getWidth(), PicView.this.picviewpanel.getHeight(), 1);
                graphics = bufferedImage.createGraphics();
                this.paintComponent(graphics);
                PicView.this.sortCutPoints();
                int n = PicView.this.cutx2 - PicView.this.cutx;
                int n2 = PicView.this.cuty2 - PicView.this.cuty;
                BufferedImage bufferedImage2 = bufferedImage.getSubimage(PicView.this.cutx, PicView.this.cuty, n, n2);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage2, "JPG", byteArrayOutputStream2);
                ImageIO.write((RenderedImage)bufferedImage2, "PNG", byteArrayOutputStream);
                byteArrayOutputStream.close();
                byteArrayOutputStream2.close();
                if (byteArrayOutputStream2.size() == 0 && byteArrayOutputStream.size() == 0) {
                    JOptionPane.showMessageDialog(null, "no JPG or PNG support in ImageIO");
                    return;
                }
                boolean bl2 = bl = byteArrayOutputStream.size() < byteArrayOutputStream2.size();
                bl = byteArrayOutputStream2.size() == 0 ? true : byteArrayOutputStream.size() < byteArrayOutputStream2.size();
                System.out.printf("size png(%,d) vs jpg(%,d)\n", byteArrayOutputStream.size(), byteArrayOutputStream2.size());
                String string = this.f.getName();
                int n3 = string.lastIndexOf(46);
                if (n3 > 0) {
                    string = string.substring(0, n3);
                }
                String string2 = String.format("%s_%dx%d%s", string, n, n2, bl ? ".png" : ".jpg");
                this.saveCut(string2, bl, bl ? byteArrayOutputStream : byteArrayOutputStream2);
            }
            finally {
                PicView.this.savingCut = false;
                if (graphics != null) {
                    graphics.dispose();
                }
            }
        }

        private void saveCut(String string, boolean bl, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
            JFileChooser jFileChooser = new JFileChooser(this.f.getAbsoluteFile());
            jFileChooser.setSelectedFile(new File(this.f.getParentFile(), string));
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                FileOutputStream fileOutputStream = new FileOutputStream(jFileChooser.getSelectedFile());
                byteArrayOutputStream.writeTo(fileOutputStream);
                fileOutputStream.close();
                U.saveFileHistory(string2, 0);
                JOptionPane.showMessageDialog(this, String.format("saved %s(%,d bytes)", string, byteArrayOutputStream.size()));
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (mouseEvent.isControlDown()) {
                if (!mouseEvent.isShiftDown()) {
                    this.startCut(n, n2);
                }
            } else if (mouseEvent.getClickCount() == 2) {
                this.setRate(n, n2, 1.0);
                this.repaint1();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (mouseEvent.isControlDown()) {
                if (PicView.this.cutx == -1) {
                    this.startCut(n, n2);
                } else {
                    PicView.this.cutx2 = n;
                    PicView.this.cuty2 = n2;
                }
                this.repaint1();
            } else if (this.inSmall(n, n2)) {
                this.setPosSmall(n, n2);
            } else {
                int n3 = mouseEvent.getX() - this.mx;
                int n4 = mouseEvent.getY() - this.my;
                this.vx = (int)(this.vx1 + (double)n3);
                this.vy = (int)(this.vy1 + (double)n4);
                this.repaint1();
            }
        }

        private boolean inSmall(int n, int n2) {
            int[] nArray = this.getSwh();
            return n > nArray[2] - nArray[0] && n2 > nArray[3] - nArray[1] && this.small;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.rx = mouseEvent.getX();
            this.ry = mouseEvent.getY();
            this.repaint1();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.mx = mouseEvent.getX();
            this.my = mouseEvent.getY();
            if (this.inSmall(n, n2)) {
                this.setPosSmall(n, n2);
            } else {
                this.vx1 = this.vx;
                this.vy1 = this.vy;
            }
        }

        private void setPosSmall(int n, int n2) {
            int[] nArray = this.getSwh();
            int n3 = nArray[2];
            int n4 = nArray[3];
            int n5 = nArray[0];
            int n6 = nArray[1];
            double d = (double)(this.pw * (n - (n3 - n5))) / (double)n5;
            double d2 = (double)(this.ph * (n2 - (n4 - n6))) / (double)n6;
            this.vx = -(d - (double)n3 / this.rate / 2.0) * this.rate;
            this.vy = -(d2 - (double)n4 / this.rate / 2.0) * this.rate;
            this.repaint1();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n = mouseWheelEvent.getWheelRotation() * mouseWheelEvent.getScrollAmount();
            int n2 = mouseWheelEvent.getX();
            int n3 = mouseWheelEvent.getY();
            if (n > 0) {
                this.setRate(n2, n3, this.rate / 1.1);
            } else {
                this.setRate(n2, n3, this.rate * 1.1);
            }
            this.repaint1();
        }

        private File nextSpFile() {
            while (this.sfi.hasNext()) {
                File file = this.sfi.next();
                if (!U.isImageFile(file)) continue;
                this.superModeHistory.add(file);
                this.superModeHistoryPointer = this.superModeHistory.size();
                if (this.superModeHistoryPointer > 500) {
                    this.superModeHistory.remove(0);
                    --this.superModeHistoryPointer;
                }
                return file;
            }
            return null;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int[] nArray = this.getSwh();
            int n = nArray[2];
            int n2 = nArray[3];
            int n3 = nArray[0];
            int n4 = nArray[1];
            graphics.setPaintMode();
            this.fillbg((Graphics2D)graphics, n, n2);
            graphics.drawImage(this.img, (int)this.vx, (int)this.vy, (int)((double)this.pw * this.rate), (int)((double)this.ph * this.rate), null);
            if (this.small) {
                graphics.drawImage(this.img, n - n3, n2 - n4, n, n2, 0, 0, this.pw, this.ph, null);
                graphics.setColor(Color.WHITE);
                graphics.drawRect(n - n3, n2 - n4, n3, n4);
                graphics.setColor(Color.RED);
                int n5 = (int)((double)(n - n3) - (double)n3 * (this.vx / this.rate / (double)this.pw));
                int n6 = (int)((double)(n2 - n4) - (double)n4 * (this.vy / this.rate / (double)this.ph));
                int n7 = (int)((double)(n3 * n) / this.rate / (double)this.pw);
                int n8 = (int)((double)(n4 * n2) / this.rate / (double)this.ph);
                graphics.drawRect(n5, n6, n7, n8);
            }
            if (this.drawMousePos) {
                double d;
                double d2;
                if (this.inSmall(this.rx, this.ry)) {
                    d2 = (this.rx - (n - n3)) * this.pw / n3;
                    d = (this.ry - (n2 - n4)) * this.ph / n4;
                } else {
                    d2 = (int)((-this.vx + (double)this.rx) / this.rate);
                    d = (int)((-this.vy + (double)this.ry) / this.rate);
                }
                String string = String.format("%d,%d", (int)d2, (int)d);
                int n9 = graphics.getFontMetrics().stringWidth(string);
                int n10 = graphics.getFont().getSize();
                int n11 = this.rx;
                int n12 = this.ry;
                if (n11 + n9 > n) {
                    n11 = n - n9;
                }
                if (n12 < n10) {
                    n12 = n10;
                }
                graphics.setColor(Color.BLACK);
                graphics.drawString(string, n11 + 1, n12 + 1);
                graphics.setColor(Color.WHITE);
                graphics.drawString(string, n11, n12);
            }
            this.drawCut((Graphics2D)graphics);
            graphics.dispose();
        }

        private void fillbg(Graphics2D graphics2D, int n, int n2) {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.setPaint(PicView.getFillImagePaint());
            graphics2D2.fillRect(0, 0, n, n2);
            graphics2D2.dispose();
        }

        private int[] getSwh() {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = n / 4;
            int n4 = n2 / 4;
            if (this.ph / this.pw > n2 / n) {
                n3 = n4 * this.pw / this.ph;
            } else {
                n4 = n3 * this.ph / this.pw;
            }
            return new int[]{n3, n4, n, n2};
        }

        private void drawCut(Graphics2D graphics2D) {
            if (PicView.this.cutx == PicView.this.cutx2 || PicView.this.cuty == PicView.this.cuty2) {
                return;
            }
            if (PicView.this.savingCut) {
                return;
            }
            PicView.this.sortCutPoints();
            graphics2D.setColor(Color.red);
            float[] fArray = new float[]{2.0f, 2.0f};
            BasicStroke basicStroke = new BasicStroke(2.0f, 0, 0, 1.0f, fArray, 2.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.drawRect(PicView.this.cutx, PicView.this.cuty, PicView.this.cutx2 - PicView.this.cutx, PicView.this.cuty2 - PicView.this.cuty);
            graphics2D.drawString(String.format("%dx%d", PicView.this.cutx2 - PicView.this.cutx, PicView.this.cuty2 - PicView.this.cuty), PicView.this.cutx, PicView.this.cuty);
            graphics2D.drawString(String.format("%dx%d", PicView.this.cutx2 - PicView.this.cutx, PicView.this.cuty2 - PicView.this.cuty), PicView.this.cutx2, PicView.this.cuty2);
        }

        public void repaint1() {
            this.needRepaint = true;
        }

        public void rotate(int n) {
            int n2;
            this.direction = n;
            int n3 = n * 90;
            int n4 = this.img.getWidth();
            int n5 = n2 = this.img.getHeight();
            int n6 = n4;
            BufferedImage bufferedImage = new BufferedImage(n5, n6, this.img.getType());
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.translate((n5 - n4) / 2, (n6 - n2) / 2);
            graphics2D.rotate(Math.toRadians(n3), n4 / 2, n2 / 2);
            graphics2D.drawRenderedImage(this.img, null);
            graphics2D.dispose();
            this.img = bufferedImage;
            this.setSize(this.img);
            this.repaint1();
        }

        private void setSize(BufferedImage bufferedImage) {
            this.pw = bufferedImage.getWidth() + 20;
            this.ph = bufferedImage.getHeight() + 20;
            Dimension dimension = new Dimension(this.pw, this.ph);
            dimension.width = Math.min(this.maxWindow.width, Math.max(200, dimension.width));
            dimension.height = Math.min(this.maxWindow.height, Math.max(200, dimension.height));
            Dimension dimension2 = this.frame.getSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = Math.max(dimension.height, dimension2.height);
            this.frame.setSize(dimension);
        }

        private void setTitleWithSize(File file, int n, int n2) {
            PicView.this.currentFile = file;
            String string = "";
            if (PicView.this.ss != null) {
                string = PicView.this.ss.delay > 0 ? " slide:" + PicView.this.ss.delay + " sec" : "";
            }
            this.frame.setTitle(String.format("PicView %s [%dx%d] %s %,d BS%s %s - neoeedit %s", file.getName(), this.img.getWidth(), this.img.getHeight(), this.superMode ? "SP" : String.format("(%d/%d)", n + 1, n2), file.length(), string, file.getAbsoluteFile().getParent(), Version.REV));
            this.setSize(this.img);
        }

        private void superModeViewFile(int n) {
            if (n > 0) {
                if (this.superModeHistoryPointer < this.superModeHistory.size()) {
                    this.viewFile(this.superModeHistory.get(this.superModeHistoryPointer++));
                } else {
                    File file = this.nextSpFile();
                    if (file != null) {
                        this.viewFile(file);
                    }
                }
            } else if (n < 0 && this.superModeHistoryPointer > 0 && this.superModeHistoryPointer <= this.superModeHistory.size()) {
                this.viewFile(this.superModeHistory.get(--this.superModeHistoryPointer));
            }
        }

        public void toggleSuperMode() {
            File file;
            boolean bl = this.superMode = !this.superMode;
            if (this.superMode && this.sfi == null && (file = this.f.getParentFile()) != null) {
                this.sfi = new FileIterator(file.getAbsolutePath()).iterator();
            }
        }

        private void viewFile(File file) {
            try {
                this.img = PicView.this.loadImage(file);
                this.f = file;
                if (this.direction != 0 && this.img.getWidth() < this.img.getHeight()) {
                    this.rotate(this.direction);
                }
                this.setTitleWithSize(file, this.fi, this.files.size());
                PicView.this.resetCut();
                this.repaint1();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void viewFile(int n) {
            if (this.superMode && this.sfi != null) {
                this.superModeViewFile(n);
                return;
            }
            if (this.files == null) {
                this.files = this.listImgs();
            }
            if (this.files.size() <= 0) {
                return;
            }
            this.fi += n;
            if (this.fi < 0) {
                this.fi = this.files.size() - 1;
            } else if (this.fi >= this.files.size()) {
                this.fi = 0;
            }
            File file = this.files.get(this.fi);
            this.viewFile(file);
        }
    }

    public static class DigitFilenameCompare
    implements Comparator {
        private Map<File, String> cache = new HashMap<File, String>();

        DigitFilenameCompare() {
        }

        public int compare(Object object, Object object2) {
            File file = (File)object;
            File file2 = (File)object2;
            return this.dfn(file).compareTo(this.dfn(file2));
        }

        private String dfn(File file) {
            String string = this.cache.get(file);
            if (string == null) {
                string = this.dfn_get(file);
                this.cache.put(file, string);
            }
            return string;
        }

        private String dfn_get(File file) {
            String string = file.getName();
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isDigit(c)) {
                    stringBuilder2.append(c);
                    if (!bl) {
                        bl = true;
                    }
                } else {
                    if (bl) {
                        this.submit(stringBuilder2, stringBuilder);
                        bl = false;
                    }
                    stringBuilder.append(c);
                }
                if (stringBuilder2.length() < 4) continue;
                this.submit(stringBuilder2, stringBuilder);
                bl = false;
            }
            this.submit(stringBuilder2, stringBuilder);
            return stringBuilder.toString();
        }

        private void submit(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
            if (stringBuilder.length() <= 0) {
                return;
            }
            int n = Integer.parseInt(stringBuilder.toString());
            stringBuilder.setLength(0);
            stringBuilder2.append((char)n);
        }
    }
}

