/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import neoe.ne.BasicEdit;
import neoe.ne.History;
import neoe.ne.ReadonlyLines;
import neoe.ne.U;

public class PageData {
    static Map<String, PageData> dataPool = new HashMap<String, PageData>();
    public boolean changedOutside;
    public BasicEdit editNoRec = new BasicEdit(false, this);
    public BasicEdit editRec = new BasicEdit(true, this);
    String encoding;
    long fileLastModified;
    boolean fileLoaded;
    public History history;
    boolean isCommentChecked;
    String[] comment = null;
    public List<CharSequence> lines;
    public String lineSep = "\n";
    public String searchResultOf;
    public int ref;
    public ReadonlyLines roLines = new ReadonlyLines(this);
    public String title;
    public boolean gzip;
    public byte[] bs;

    public static PageData newUntitled() {
        U.gc();
        return PageData.fromTitle("[Untitled]#" + U.randomID());
    }

    public static PageData fromTitle(String string) {
        PageData pageData = dataPool.get(string);
        if (pageData != null) {
            return pageData;
        }
        pageData = new PageData();
        pageData.title = string;
        pageData.lines = new ArrayList<CharSequence>();
        pageData.lines.add(U.EMPTY);
        dataPool.put(string, pageData);
        return pageData;
    }

    public static PageData fromFile(String string) throws IOException {
        PageData pageData = dataPool.get(string);
        if (pageData != null) {
            return pageData;
        }
        pageData = new PageData();
        PageData.readFile(pageData, string);
        dataPool.put(string, pageData);
        U.saveFileHistory(string, 0);
        return pageData;
    }

    private PageData() {
        this.history = new History(this);
    }

    public void close() {
        dataPool.remove(this.title);
        this.lines.clear();
        this.lines = null;
    }

    private static void readFile(PageData pageData, String string) {
        File file = new File(string);
        if (string.endsWith(".gz")) {
            pageData.gzip = U.tryGzip(string, pageData);
        }
        pageData.isCommentChecked = false;
        if (pageData.encoding == null) {
            pageData.encoding = U.guessEncodingForEditor(string, pageData);
        }
        pageData.lineSep = U.guessLineSepForEditor(string, pageData);
        pageData.lines = null;
        pageData.history.clear();
        pageData.resetLines(U.readFileForEditor(string, pageData.encoding, pageData));
        pageData.fileLastModified = file.lastModified();
        pageData.changedOutside = false;
        pageData.title = string;
        pageData.fileLoaded = true;
    }

    public void reloadFile() {
        if (this.fileLoaded) {
            PageData.readFile(this, this.title);
        }
    }

    void renameTo(String string) {
        dataPool.remove(this.title);
        this.title = string;
        dataPool.put(string, this);
    }

    public void resetLines(List<CharSequence> list) {
        this.lines = list;
        this.history.clear();
    }

    public void setText(String string) {
        List<CharSequence> list = U.removeTailR(U.split(string, '\n'));
        if (list.isEmpty()) {
            list.add(U.EMPTY);
        }
        this.resetLines(list);
    }
}

