/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne;

import java.math.BigDecimal;
import java.math.BigInteger;
import neoe.ne.U;

public class MathExprParser {
    int pos = -1;
    int c;
    private String str;

    public MathExprParser(String string) {
        this.str = string;
    }

    void eatChar() {
        this.c = ++this.pos < this.str.length() ? (int)this.str.charAt(this.pos) : -1;
    }

    void eatSpace() {
        while (Character.isWhitespace(this.c)) {
            this.eatChar();
        }
    }

    public BigDecimal parse() {
        this.eatChar();
        BigDecimal bigDecimal = this.parseExpression();
        if (this.c != -1) {
            throw new RuntimeException("Unexpected: " + (char)this.c);
        }
        return bigDecimal;
    }

    BigDecimal parseExpression() {
        BigDecimal bigDecimal = this.parseTerm();
        while (true) {
            this.eatSpace();
            if (this.c == 43) {
                this.eatChar();
                bigDecimal = bigDecimal.add(this.parseTerm());
                continue;
            }
            if (this.c != 45) break;
            this.eatChar();
            bigDecimal = bigDecimal.subtract(this.parseTerm());
        }
        return bigDecimal;
    }

    BigDecimal parseTerm() {
        BigDecimal bigDecimal = this.parseFactor();
        while (true) {
            this.eatSpace();
            if (this.c == 47) {
                this.eatChar();
                bigDecimal = bigDecimal.divide(this.parseFactor(), 8, 4);
                continue;
            }
            if (this.c == 37) {
                this.eatChar();
                bigDecimal = new BigDecimal(bigDecimal.longValue() % this.parseFactor().longValue());
                continue;
            }
            if (this.c != 42 && this.c != 40) break;
            if (this.c == 42) {
                this.eatChar();
            }
            bigDecimal = bigDecimal.multiply(this.parseFactor());
        }
        return bigDecimal;
    }

    BigDecimal parseFactor() {
        BigDecimal bigDecimal;
        boolean bl = false;
        this.eatSpace();
        if (this.c == 43 || this.c == 45) {
            bl = this.c == 45;
            this.eatChar();
            this.eatSpace();
        }
        if (this.c == 40) {
            this.eatChar();
            bigDecimal = this.parseExpression();
            if (this.c == 41) {
                this.eatChar();
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            while (U.isMathExprNumberChar(this.c)) {
                stringBuilder.append((char)this.c);
                this.eatChar();
            }
            if (stringBuilder.length() == 0) {
                throw new RuntimeException("Unexpected: " + (char)this.c);
            }
            bigDecimal = stringBuilder.length() >= 2 && stringBuilder.substring(0, 2).equals("0x") ? new BigDecimal(new BigInteger(stringBuilder.substring(2), 16)) : (stringBuilder.length() >= 2 && stringBuilder.substring(0, 2).equals("0b") ? new BigDecimal(new BigInteger(stringBuilder.substring(2), 2)) : new BigDecimal(this.removeComma(stringBuilder).toString()));
        }
        this.eatSpace();
        if (this.c == 94) {
            this.eatChar();
            bigDecimal = BigDecimal.valueOf(Math.pow(bigDecimal.doubleValue(), this.parseFactor().doubleValue()));
        }
        if (bl) {
            bigDecimal = bigDecimal.negate();
        }
        return bigDecimal;
    }

    private StringBuilder removeComma(StringBuilder stringBuilder) {
        int n;
        while ((n = stringBuilder.indexOf(",")) >= 0) {
            stringBuilder.deleteCharAt(n);
        }
        return stringBuilder;
    }
}

