/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne;

import java.util.List;
import neoe.ne.BasicAction;
import neoe.ne.BasicEdit;
import neoe.ne.PlainPage;
import neoe.ne.ReadonlyLines;

public class HistoryCell {
    BasicAction action;
    Object s1;
    int x1;
    int x2;
    int y1;
    int y2;

    public HistoryCell(BasicAction basicAction, int n, int n2, int n3, int n4, Object object) {
        this.s1 = object;
        this.x1 = n;
        this.x2 = n2;
        this.y1 = n3;
        this.y2 = n4;
        this.action = basicAction;
    }

    public boolean canAppend(HistoryCell historyCell) {
        return historyCell.action == BasicAction.Delete && this.action == BasicAction.Delete && (historyCell.x1 == this.x1 || historyCell.x1 == this.x2) && historyCell.y1 == this.y1 || historyCell.action == BasicAction.Insert && this.action == BasicAction.Insert && (historyCell.x1 == this.x1 || historyCell.x2 == this.x1) && historyCell.y1 == this.y1;
    }

    public void redo(PlainPage plainPage) {
        BasicEdit basicEdit = plainPage.pageData.editNoRec;
        ReadonlyLines readonlyLines = plainPage.pageData.roLines;
        switch (this.action) {
            case Delete: {
                this.s1 = readonlyLines.getInLine(this.y1, this.x1, this.x2).toString();
                basicEdit.deleteInLine(this.y1, this.x1, this.x2);
                plainPage.cursor.setSafePos(this.x1, this.y1);
                break;
            }
            case DeleteLines: {
                basicEdit.deleteLines(this.x1, this.x2);
                plainPage.cursor.setSafePos(0, this.x1);
                break;
            }
            case Insert: {
                String string = (String)this.s1;
                basicEdit.insertInLine(this.y1, this.x1, string);
                plainPage.cursor.setSafePos(this.x1 + string.length(), this.y1);
                string = null;
                break;
            }
            case InsertEmptyLine: {
                basicEdit.insertEmptyLine(this.y1);
                plainPage.cursor.setSafePos(0, this.y1 + 1);
                break;
            }
            case MergeLine: {
                basicEdit.mergeLine(this.y1);
                plainPage.cursor.setSafePos(this.x1, this.y1);
                break;
            }
            default: {
                throw new RuntimeException("unkown action " + String.valueOf((Object)this.action));
            }
        }
    }

    public String toString() {
        return "HistoryInfo [action=" + String.valueOf((Object)this.action) + ", x1=" + this.x1 + ", x2=" + this.x2 + ", y1=" + this.y1 + ", y2=" + this.y2 + ", s1=" + String.valueOf(this.s1) + "]\n";
    }

    public void undo(PlainPage plainPage) {
        BasicEdit basicEdit = plainPage.pageData.editNoRec;
        ReadonlyLines readonlyLines = plainPage.pageData.roLines;
        switch (this.action) {
            case Delete: {
                String string = (String)this.s1;
                basicEdit.insertInLine(this.y1, this.x1, string);
                plainPage.cursor.setSafePos(this.x1 + string.length(), this.y1);
                string = null;
                break;
            }
            case DeleteLines: {
                basicEdit.insertLines(this.x1, (List)this.s1);
                plainPage.cursor.setSafePos(0, this.x2);
                break;
            }
            case Insert: {
                this.s1 = readonlyLines.getInLine(this.y1, this.x1, this.x2).toString();
                basicEdit.deleteInLine(this.y1, this.x1, this.x2);
                plainPage.cursor.setSafePos(0, this.y1);
                break;
            }
            case InsertEmptyLine: {
                basicEdit.deleteLines(this.y1, this.y1 + 1);
                plainPage.cursor.setSafePos(0, this.y1);
                break;
            }
            case MergeLine: {
                String string = readonlyLines.getInLine(this.y1, this.x1, Integer.MAX_VALUE).toString();
                basicEdit.deleteInLine(this.y1, this.x1, Integer.MAX_VALUE);
                basicEdit.insertEmptyLine(this.y1 + 1);
                basicEdit.insertInLine(this.y1 + 1, 0, string);
                plainPage.cursor.setSafePos(0, this.y1 + 1);
                break;
            }
            default: {
                throw new RuntimeException("unkown action " + String.valueOf((Object)this.action));
            }
        }
    }
}

