/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.io.File;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import neoe.ne.Conf;
import neoe.ne.EditorPanelConfig;
import neoe.ne.Main;
import neoe.ne.PageData;
import neoe.ne.PicView;
import neoe.ne.PlainPage;
import neoe.ne.U;
import neoe.ne.UserFunc;
import neoe.ne.Version;

public class EditorPanel
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener {
    private Dimension dim;
    private Point loc;
    private int myCursor;
    boolean newWindow;
    int mx;
    int my;
    public static int openedWindows;
    static final String WINDOW_NAME;
    public RootPaneContainer frame;
    PlainPage lastPage;
    U.LocationHistory<String> pageHis = new U.LocationHistory();
    public PlainPage page;
    List<PlainPage> pageSet = new ArrayList<PlainPage>();
    EditorPanelConfig config;
    JDesktopPane desktopPane;
    JFrame realJFrame;
    private static final EditorPanelConfig DEFAULT;
    boolean inWindowMove;
    boolean inWindowResize;
    public UserFunc userfunc;
    static List<EditorPanel> insts;

    boolean findAndShowPage(String string, int n, boolean bl) throws Exception {
        if (string == null) {
            return false;
        }
        Object object = new File(string);
        if (((File)object).isFile() && U.isImageFile((File)object)) {
            new PicView().show((File)object);
            return true;
        }
        object = this.findPage(string);
        if (object != null) {
            if (this.newWindow) {
                this.openInNewWindow(string, n);
                return true;
            }
            this.setPage((PlainPage)object, bl);
            if (n > 0) {
                ((PlainPage)object).cursor.setSafePos(0, n - 1);
            }
            ((PlainPage)object).adjustCursor();
            U.checkChangedOutside((PlainPage)object);
            SwingUtilities.invokeLater(() -> this.repaint());
            return true;
        }
        if (string.startsWith("[")) {
            PageData pageData = PageData.dataPool.get(string);
            if (pageData != null) {
                if (this.newWindow) {
                    this.openInNewWindow(string, n);
                    return true;
                }
                PlainPage plainPage = new PlainPage(this, pageData, this.page);
                if (n > 0) {
                    plainPage.cursor.setSafePos(0, n - 1);
                }
                plainPage.adjustCursor();
                U.checkChangedOutside(plainPage);
                SwingUtilities.invokeLater(() -> this.repaint());
                return true;
            }
            return false;
        }
        File file = new File(string);
        if (!file.isFile()) {
            file = new File(this.page.workPath, string);
        }
        if (!file.isFile()) {
            return false;
        }
        string = file.getCanonicalPath();
        if (this.newWindow) {
            this.openInNewWindow(string, n);
            return true;
        }
        object = new PlainPage(this, PageData.fromFile(string), this.page);
        if (n > 0) {
            ((PlainPage)object).cursor.setSafePos(0, n - 1);
        }
        ((PlainPage)object).adjustCursor();
        return true;
    }

    private PlainPage findPage(String string) {
        for (int i = 0; i < this.pageSet.size(); ++i) {
            PlainPage plainPage = this.pageSet.get(i);
            if (!plainPage.pageData.title.equals(string)) continue;
            return plainPage;
        }
        return null;
    }

    private void openInNewWindow(String string, int n) throws Exception {
        EditorPanel editorPanel = new EditorPanel(this.config);
        editorPanel.openWindow();
        PlainPage plainPage = new PlainPage(editorPanel, PageData.fromFile(string), this.page);
        if (n > 0) {
            plainPage.cursor.setSafePos(0, n - 1);
        }
        plainPage.adjustCursor();
    }

    private boolean inRangeOfWindowMove(MouseEvent mouseEvent) {
        if (this.page == null || this.realJFrame == null) {
            return false;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        return n <= this.page.toolbarHeight && n2 <= this.page.toolbarHeight;
    }

    private boolean inRangeOfWindowResize(MouseEvent mouseEvent) {
        if (this.page == null || this.realJFrame == null) {
            return false;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Dimension dimension = this.getSize();
        return n >= dimension.width - this.page.toolbarHeight && n2 >= dimension.height - this.page.toolbarHeight;
    }

    private void startWindowMove(MouseEvent mouseEvent) {
        this.mx = mouseEvent.getXOnScreen();
        this.my = mouseEvent.getYOnScreen();
        this.loc = this.getLocationOnScreen();
        if (this.frame != null) {
            if (this.frame instanceof JFrame) {
                this.loc = ((JFrame)this.frame).getLocationOnScreen();
            } else if (this.frame instanceof JInternalFrame) {
                this.loc = ((JInternalFrame)this.frame).getLocationOnScreen();
            }
        } else {
            this.loc = new Point();
        }
        this.inWindowMove = true;
    }

    private void startWindowResize(MouseEvent mouseEvent) {
        this.mx = mouseEvent.getXOnScreen();
        this.my = mouseEvent.getYOnScreen();
        if (this.frame != null) {
            if (this.frame instanceof JFrame) {
                this.dim = ((JFrame)this.frame).getSize();
            } else if (this.frame instanceof JInternalFrame) {
                this.dim = ((JInternalFrame)this.frame).getSize();
            }
        } else {
            this.dim = new Dimension();
        }
        this.inWindowResize = true;
    }

    private void windowMove(MouseEvent mouseEvent) {
        int n = mouseEvent.getXOnScreen();
        int n2 = mouseEvent.getYOnScreen();
        if (this.loc == null) {
            this.startWindowMove(mouseEvent);
            return;
        }
        Point point = new Point(this.loc);
        point.x += n - this.mx;
        point.y += n2 - this.my;
        if (this.frame != null) {
            if (this.frame instanceof JFrame) {
                ((JFrame)this.frame).setLocation(point);
            } else if (this.frame instanceof JInternalFrame) {
                ((JInternalFrame)this.frame).setLocation(point);
            }
        }
    }

    private void windowResize(MouseEvent mouseEvent) {
        int n = mouseEvent.getXOnScreen();
        int n2 = mouseEvent.getYOnScreen();
        if (this.dim == null) {
            this.startWindowResize(mouseEvent);
            return;
        }
        Dimension dimension = new Dimension(this.dim);
        dimension.width += n - this.mx;
        dimension.height += n2 - this.my;
        if (this.frame != null) {
            if (this.frame instanceof JFrame) {
                ((JFrame)this.frame).setSize(dimension);
            } else if (this.frame instanceof JInternalFrame) {
                ((JInternalFrame)this.frame).setSize(dimension);
            }
        }
    }

    public EditorPanel() throws Exception {
        this(DEFAULT);
    }

    public EditorPanel(EditorPanelConfig editorPanelConfig) throws Exception {
        this.config = editorPanelConfig;
        Main.doinit();
        Conf.loadOtherConfig(editorPanelConfig);
        this.enableEvents(2056L);
        this.setBackground(Conf.getDefaultBgColor());
        this.setFocusable(true);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
                System.out.println("if you see this, tell neoeedit's author what system you are using. caretPositionChanged=" + inputMethodEvent.paramString());
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
                if (EditorPanel.this.page == null) {
                    return;
                }
                AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
                if (attributedCharacterIterator == null) {
                    EditorPanel.this.page.preedit("", 0);
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                int n = inputMethodEvent.getCommittedCharacterCount();
                char c = attributedCharacterIterator.first();
                while (c != '\uffff') {
                    stringBuilder.append(c);
                    c = attributedCharacterIterator.next();
                }
                String string = stringBuilder.toString();
                EditorPanel.this.page.preedit(string, n);
            }
        });
        this.setOpaque(false);
        this.setMyCursor(2);
        this.setFocusTraversalKeysEnabled(false);
        PlainPage plainPage = new PlainPage(this, PageData.newUntitled(), null);
        plainPage.ptSelection.selectAll();
    }

    void setMyCursor(int n) {
        this.myCursor = n;
        this.setCursor(new Cursor(this.myCursor));
    }

    void changeTitle() {
        if (this.frame == null) {
            return;
        }
        String string = " (" + this.pageSet.size() + ") - " + WINDOW_NAME + U.suNotice();
        String string2 = U.TitleName;
        String string3 = this.page.pageData.title;
        String string4 = this.page.console != null ? string2 + "(exec)" + this.page.console.cmd + string : (this.page.pageData.fileLoaded ? string2 + new File(string3).getName() + " " + new File(string3).getParent() + string : string2 + string3 + string);
        if (string4 != null) {
            if (this.frame instanceof JFrame) {
                ((JFrame)this.frame).setTitle(string4);
            } else if (this.frame instanceof JInternalFrame) {
                ((JInternalFrame)this.frame).setTitle(string4);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        try {
            this.page.keyPressed(keyEvent);
        }
        catch (Throwable throwable) {
            this.page.ui.message("err:" + String.valueOf(throwable));
            throwable.printStackTrace();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        try {
            this.page.keyReleased(keyEvent);
        }
        catch (Throwable throwable) {
            this.page.ui.message("err:" + String.valueOf(throwable));
            throwable.printStackTrace();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        try {
            if (U.hardwareFailWorkaroundFilterOut(keyEvent)) {
                return;
            }
            this.page.keyTyped(keyEvent);
        }
        catch (Throwable throwable) {
            this.page.ui.message("err:" + String.valueOf(throwable));
            throwable.printStackTrace();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            this.page.mouseClicked(mouseEvent);
            this.grabFocus();
        }
        catch (Throwable throwable) {
            this.page.ui.message("err:" + String.valueOf(throwable));
            throwable.printStackTrace();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        try {
            if (this.inWindowMove) {
                this.windowMove(mouseEvent);
                return;
            }
            if (this.inWindowResize) {
                this.windowResize(mouseEvent);
                return;
            }
            this.page.mouseDragged(mouseEvent);
        }
        catch (Throwable throwable) {
            this.page.ui.message("err:" + String.valueOf(throwable));
            throwable.printStackTrace();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.inRangeOfWindowMove(mouseEvent)) {
            this.setMyCursor(13);
            return;
        }
        if (this.inRangeOfWindowResize(mouseEvent)) {
            this.setMyCursor(5);
            return;
        }
        if (this.myCursor != 2) {
            this.setMyCursor(2);
        }
        try {
            this.page.mouseMoved(mouseEvent);
        }
        catch (Throwable throwable) {
            this.page.ui.message("err:" + String.valueOf(throwable));
            throwable.printStackTrace();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        try {
            if (this.inRangeOfWindowMove(mouseEvent)) {
                this.startWindowMove(mouseEvent);
                return;
            }
            if (this.inRangeOfWindowResize(mouseEvent)) {
                this.startWindowResize(mouseEvent);
                return;
            }
            this.page.mousePressed(mouseEvent);
        }
        catch (Throwable throwable) {
            this.page.ui.message("err:" + String.valueOf(throwable));
            throwable.printStackTrace();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.inWindowMove = false;
        this.inWindowResize = false;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        try {
            this.page.mouseWheelMoved(mouseWheelEvent);
        }
        catch (Throwable throwable) {
            this.page.ui.message("err:" + String.valueOf(throwable));
            throwable.printStackTrace();
        }
    }

    public void openWindow() throws IOException {
        if (this.frame != null) {
            return;
        }
        ++openedWindows;
        insts.add(this);
        JFrame jFrame = new JFrame(WINDOW_NAME);
        this.openWindow("e.jpg", jFrame, jFrame, null);
        this.installWindowListener(jFrame);
        this.grabFocus();
    }

    public void openWindow(String string, RootPaneContainer rootPaneContainer, JFrame jFrame, JDesktopPane jDesktopPane) throws IOException {
        this.frame = rootPaneContainer;
        this.desktopPane = jDesktopPane;
        if (string == null) {
            string = "e.jpg";
        }
        if (this.frame instanceof JFrame) {
            this.initJFrame(string, (JFrame)this.frame);
        } else if (this.frame instanceof JInternalFrame) {
            JInternalFrame jInternalFrame = (JInternalFrame)this.frame;
            jInternalFrame.add(this);
        }
        this.realJFrame = jFrame;
        this.changeTitle();
        this.repaint();
    }

    public void installWindowListener(JFrame jFrame) {
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                if (EditorPanel.this.page != null) {
                    U.checkChangedOutside(EditorPanel.this.page);
                }
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                System.out.println("closed");
                --openedWindows;
                insts.remove(EditorPanel.this);
                try {
                    U.appendEpFileHistory(EditorPanel.this);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
    }

    private void initJFrame(String string, JFrame jFrame) throws IOException {
        if (string != null) {
            jFrame.setIconImage(U.getAppIcon(string));
        }
        jFrame.setDefaultCloseOperation(2);
        U.setFrameSize(jFrame);
        jFrame.setTransferHandler(new U.TH(this));
        jFrame.add(this);
        jFrame.setVisible(true);
    }

    @Override
    public void paint(Graphics graphics) {
        try {
            if (this.page != null) {
                this.page.xpaint(graphics, this.getSize());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public EditorPanel setPage(PlainPage plainPage, boolean bl) {
        this.lastPage = this.page;
        this.page = plainPage;
        if (bl) {
            this.pageHis.add(U.getLocString(plainPage), U.getLocString(this.lastPage));
        }
        this.changeTitle();
        return plainPage.uiComp;
    }

    static {
        WINDOW_NAME = "neoeedit " + Version.REV;
        DEFAULT = new EditorPanelConfig();
        insts = new ArrayList<EditorPanel>();
    }

    class MyInputMethodRequestsHandler
    implements InputMethodRequests {
        Rectangle rect = new Rectangle(200, 200, 0, 10);

        MyInputMethodRequestsHandler() {
        }

        @Override
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            System.out.println("cancelLatestCommittedText=" + Arrays.deepToString(attributeArray));
            return null;
        }

        @Override
        public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
            System.out.printf("getCommittedText %d, %d, %s\n", n, n2, Arrays.deepToString(attributeArray));
            return null;
        }

        @Override
        public int getCommittedTextLength() {
            System.out.println("getCommittedTextLength");
            return 0;
        }

        @Override
        public int getInsertPositionOffset() {
            System.out.println("getInsertPositionOffset");
            return 0;
        }

        @Override
        public TextHitInfo getLocationOffset(int n, int n2) {
            System.out.println("getLocationOffset");
            return null;
        }

        @Override
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            System.out.println("getSelectedText=" + Arrays.deepToString(attributeArray));
            return null;
        }

        @Override
        public Rectangle getTextLocation(TextHitInfo textHitInfo) {
            System.out.println("getTextLocation");
            return null;
        }
    }
}

