/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class DumpToString {
    private static final int MAX_DUMP_ARR = 99;

    DumpToString() {
    }

    private static boolean definedToString(Class clazz) {
        try {
            Method method = clazz.getDeclaredMethod("toString", new Class[0]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String dump(Object object, int n) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "utf8"));
        bufferedWriter.write("dump[");
        DumpToString.dump(object, bufferedWriter, 0, n, new HashSet());
        bufferedWriter.write("\n]");
        ((Writer)bufferedWriter).close();
        return byteArrayOutputStream.toString();
    }

    public static void dump(Object object, Writer writer, int n, int n2, Set set) throws Exception {
        if (object == null) {
            return;
        }
        String string = object.getClass().getName();
        if (DumpToString.isPrimitive(string, object)) {
            writer.write(object.toString());
        } else {
            if (set.contains(object)) {
                writer.write(object.getClass().getName() + "@" + Integer.toHexString(object.hashCode()) + "...");
                return;
            }
            set.add(object);
            if (n >= n2 && n2 > 0) {
                return;
            }
            if (object.getClass().isArray()) {
                writer.write("arr[");
                for (int i = 0; i < Array.getLength(object); ++i) {
                    if (i > 99) {
                        writer.write("\n");
                        DumpToString.indent(n + 1, writer);
                        writer.write(",...(more as " + Array.getLength(object) + ")");
                        break;
                    }
                    if (i > 0) {
                        writer.write("\n");
                        DumpToString.indent(n + 1, writer);
                        writer.write(",");
                    }
                    DumpToString.dump(Array.get(object, i), writer, n + 1, n2, set);
                }
                writer.write("]");
            } else if (object instanceof Iterable) {
                Iterator iterator = ((Iterable)object).iterator();
                writer.write(String.valueOf(object.getClass()) + "[");
                int n3 = 0;
                while (iterator.hasNext()) {
                    if (n3 > 0) {
                        writer.write("\n");
                        DumpToString.indent(n, writer);
                        writer.write(",");
                    }
                    DumpToString.dump(iterator.next(), writer, n + 1, n2, set);
                    ++n3;
                }
                writer.write("\n");
                DumpToString.indent(n, writer);
                writer.write("]");
            } else if (object instanceof Map) {
                Map map = (Map)object;
                writer.write(object.getClass().getName() + "{");
                int n4 = 0;
                for (Object k : map.keySet()) {
                    if (n4 > 0) {
                        writer.write("\n");
                        DumpToString.indent(n + 1, writer);
                        writer.write(",");
                    }
                    DumpToString.dump(k, writer, n + 1, n2, set);
                    writer.write(":");
                    DumpToString.dump(map.get(k), writer, n + 1, n2, set);
                    ++n4;
                }
                writer.write("}");
            } else {
                writer.write(string);
                writer.write("{\n");
                DumpToString.indent(n + 1, writer);
                int n5 = 0;
                for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    if (DumpToString.isPrimitive(clazz.getName(), object) || DumpToString.definedToString(clazz)) {
                        if (n5 > 0) {
                            writer.write("\n");
                            DumpToString.indent(n + 1, writer);
                            writer.write(",");
                        } else {
                            ++n5;
                        }
                        writer.write("toString()=" + object.toString());
                        break;
                    }
                    Field[] fieldArray = clazz.getDeclaredFields();
                    for (int i = 0; i < fieldArray.length; ++i) {
                        Object object2;
                        fieldArray[i].setAccessible(true);
                        int n6 = fieldArray[i].getModifiers();
                        if (Modifier.isStatic(n6) && Modifier.isFinal(n6) || (object2 = fieldArray[i].get(object)) == null) continue;
                        if (n5 > 0) {
                            writer.write("\n");
                            DumpToString.indent(n + 1, writer);
                            writer.write(",");
                        } else {
                            ++n5;
                        }
                        writer.write(fieldArray[i].getName());
                        writer.write("=");
                        DumpToString.dump(object2, writer, n + 1, n2, set);
                    }
                }
                writer.write("\n");
                DumpToString.indent(n, writer);
                writer.write("}");
            }
        }
    }

    private static void indent(int n, Writer writer) throws IOException {
        while (n > 0) {
            writer.write("\t");
            --n;
        }
    }

    private static boolean isPrimitive(String string, Object object) {
        if (object.getClass().isArray() || object instanceof Iterable || object instanceof Map) {
            return false;
        }
        return string.startsWith("java.lang.") || string.indexOf(".") < 0;
    }
}

