/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import neoe.ne.Conf;
import neoe.ne.EditorPanel;
import neoe.ne.PageData;
import neoe.ne.PlainPage;
import neoe.ne.U;

public class Console {
    public String cmd;
    private boolean finished;
    boolean follow;
    OutputStream out;
    InputStream stdout;
    InputStream stderr;
    Process proc;
    private PlainPage pp;
    private EditorPanel parentUI;
    private File dir;

    public Console(String string, OutputStream outputStream, InputStream inputStream, InputStream inputStream2, Process process, EditorPanel editorPanel, File file, boolean bl) {
        this.cmd = string;
        this.out = outputStream;
        this.stdout = inputStream;
        this.stderr = inputStream2;
        this.proc = process;
        this.parentUI = editorPanel;
        this.dir = file;
        this.follow = bl;
    }

    public void start() throws Exception {
        long l = System.currentTimeMillis();
        this.finished = false;
        EditorPanel editorPanel = this.parentUI;
        this.pp = this.parentUI.page;
        if (this.pp.fontList == null || this.pp.fontList == Conf.defaultFontList) {
            this.pp.fontList = Conf.defaultConsoleFonts;
        }
        this.pp.console = this;
        editorPanel.changeTitle();
        String string = String.format("[%s] %s\n", this.dir.getAbsolutePath(), this.cmd);
        PageData pageData = this.pp.pageData;
        pageData.encoding = "UTF8";
        if (pageData.encoding == null) {
            pageData.encoding = "UTF8";
        }
        if (this.dir != null) {
            this.pp.workPath = this.dir.getAbsolutePath();
        }
        this.pp.ptEdit.append(string);
        U.attach(this.pp, this.stdout, "stdout");
        U.attach(this.pp, this.stderr, "stderr");
        new Thread(() -> {
            try {
                this.proc.waitFor();
                this.finished = true;
                long l2 = System.currentTimeMillis() - l;
                Thread.sleep(100L);
                this.pp.pageData.editRec.appendLines(Arrays.asList(String.format("\nExit(%s) in about %,d ms for\n%s", this.proc.exitValue(), l2, string).split("\n")));
                this.pp.pageData.editRec.appendLine("");
                this.pp.cursor.setSafePos(0, Integer.MAX_VALUE);
                this.pp.adjustCursor();
                this.pp.uiComp.repaint();
            }
            catch (InterruptedException interruptedException) {
                this.pp.pageData.editRec.appendLine("Interrupted:" + String.valueOf(interruptedException));
            }
        }).start();
    }

    public static String filterSimpleTTY(String object) {
        int n;
        String string;
        int n2;
        while ((n2 = ((String)object).indexOf(string = "\u001b[")) >= 0 && (n = ((String)object).indexOf("m", n2 + string.length())) >= 0) {
            object = ((String)object).substring(0, n2) + ((String)object).substring(n + 1);
        }
        return object;
    }
}

