/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import neoe.ne.Commands;
import neoe.ne.EditorPanelConfig;
import neoe.ne.FontList;
import neoe.ne.Plugin;
import neoe.ne.U;
import neoe.ne.Version;
import neoe.ne.util.PyData;

public class Conf {
    static Map conf;
    static List<String> localFonts;
    static FontList defaultConsoleFonts;
    static FontList defaultFontList;

    public static Map getConfig() {
        if (conf != null) {
            return conf;
        }
        try {
            System.out.println("load " + Version.CONFIG_FN);
            BufferedReader bufferedReader = new BufferedReader(U.getInstalledReader(Version.CONFIG_FN));
            conf = (Map)new PyData().parseAll(bufferedReader);
            return conf;
        }
        catch (Exception exception) {
            throw new RuntimeException("fatal: cannot read conf " + Version.CONFIG_FN, exception);
        }
    }

    public static Color getDefaultBgColor() {
        Map map = Conf.getConfig();
        Map map2 = (Map)map.get("color");
        String string = String.valueOf(map2.get("defaultBackgroundColor"));
        Color color = Color.WHITE;
        color = string.startsWith("0x") ? Color.decode(string) : Color.getColor(string, color);
        return color;
    }

    public static int getDefaultColorMode() {
        Map map = Conf.getConfig();
        String string = (String)((Map)map.get("color")).get("defaultMode");
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static void loadOtherConfig(EditorPanelConfig editorPanelConfig) {
        Map map = Conf.getConfig();
        String string = String.valueOf(map.get("KEY_TEXT_ANTIALIASING"));
        if (string.length() == 0 || "null".equals(string)) {
            return;
        }
        try {
            Field field = RenderingHints.class.getDeclaredField(string);
            Object object = field.get(null);
            if (object != null) {
                EditorPanelConfig.VALUE_TEXT_ANTIALIAS = object;
            }
        }
        catch (Exception exception) {
            System.out.println("cannot find in RenderingHints:" + string);
        }
    }

    public static FontList getFont(Font[] fontArray) {
        try {
            Map map = Conf.getConfig();
            Map map2 = (Map)map.get("font");
            Font font = null;
            List<Object> list = (List)map2.get("console");
            if (list != null) {
                font = Conf.getFontFromDesc(list);
            }
            if ((list = map2.get("list")) == null || "null".equals(list)) {
                return new FontList(fontArray);
            }
            if (localFonts == null) {
                localFonts = Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
            }
            ArrayList<Font> arrayList = new ArrayList<Font>();
            for (Object object : list) {
                List list2 = (List)object;
                Font font2 = Conf.getFontFromDesc(list2);
                if (font2 == null) continue;
                arrayList.add(font2);
            }
            for (Font font2 : fontArray) {
                arrayList.add(font2);
            }
            FontList fontList = new FontList(arrayList.toArray(new Font[arrayList.size()]));
            if (font == null) {
                defaultConsoleFonts = fontList;
            } else {
                arrayList.add(0, font);
                defaultConsoleFonts = new FontList(arrayList.toArray(new Font[arrayList.size()]));
            }
            return fontList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new FontList(fontArray);
        }
    }

    static void initKeys() throws Exception {
        List list;
        Map map = Conf.getConfig();
        U.originKeys = list = (List)map.get("keys");
        U.keys = new HashMap<String, Commands>();
        U.pluginKeys = new HashMap<String, Plugin.PluginAction>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Object e : list) {
            List list2 = (List)e;
            String string = list2.get(0).toString();
            Object e2 = list2.get(1);
            if (e2 instanceof List) {
                for (Object e3 : (List)e2) {
                    String string2 = e3.toString().toUpperCase();
                    Conf.addOneKey(string2, string, hashSet);
                }
                continue;
            }
            String string3 = list2.get(1).toString().toUpperCase();
            Conf.addOneKey(string3, string, hashSet);
        }
    }

    private static void addOneKey(String string, String string2, Set<String> set) {
        if (set.contains(string)) {
            System.err.println("Error: duplicated key:" + string);
            return;
        }
        set.add(string);
        try {
            U.addKey(U.keys, string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static int[][] loadColorModes() throws IOException {
        Map map = Conf.getConfig();
        List list = (List)((Map)map.get("color")).get("modes");
        int n = 12;
        int[][] nArray = new int[list.size()][n];
        for (int i = 0; i < list.size(); ++i) {
            List list2 = (List)list.get(i);
            for (int j = 1; j <= n; ++j) {
                int n2;
                Object e = list2.get(j);
                nArray[i][j - 1] = n2 = U.parseInt(e.toString());
            }
        }
        return nArray;
    }

    public static Dimension readFrameSize() {
        Map map = Conf.getConfig();
        List list = (List)map.get("frameSize");
        if (list != null) {
            return new Dimension(U.parseInt(list.get(0)), U.parseInt(list.get(1)));
        }
        return new Dimension(800, 600);
    }

    public static int readTabWidth() {
        try {
            Map map = Conf.getConfig();
            return Integer.parseInt(map.get("tabWidthInPixel").toString());
        }
        catch (NumberFormatException numberFormatException) {
            return 40;
        }
    }

    public static void setDefaultBKColor() throws IOException {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(k instanceof String) || !((String)k).contains("background") || !(uIDefaults.get(k) instanceof Color)) continue;
            uIDefaults.put(k, Conf.getDefaultBgColor());
            UIManager.put(k, Conf.getDefaultBgColor());
        }
    }

    public static void setDefaultLookAndFeel() throws IOException {
        Map map = Conf.getConfig();
        String string = String.valueOf(map.get("lookAndFeel"));
        if (string.length() == 0 || "null".equals(string)) {
            return;
        }
        try {
            Class.forName(string);
            try {
                UIManager.setLookAndFeel(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("not found lookAndFeel:" + String.valueOf(classNotFoundException));
        }
    }

    public static Object get(String string, Object object) throws IOException {
        Object object2 = Conf.get(Conf.getConfig(), string);
        if (object2 == null) {
            return object;
        }
        return object2;
    }

    public static Object get(Map map, String string) {
        String[] stringArray = string.split("\\.");
        Map map2 = map;
        Object object = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (map2 == null) {
                return null;
            }
            String string2 = stringArray[i];
            if (string2.startsWith("[") && string2.endsWith("]")) {
                int n = Integer.parseInt(string2.substring(1, string2.length() - 1));
                object = map2 instanceof Map ? map2.values().toArray()[n] : (Object)((List)((Object)map2)).get(n);
            } else {
                object = map2.get(string2);
            }
            map2 = object;
        }
        return object;
    }

    private static Font getFontFromDesc(List list) throws Exception {
        String string = (String)list.get(0);
        File file = new File(string);
        Font font = null;
        int n = Integer.parseInt(list.get(1).toString());
        if (file.exists() && file.isFile()) {
            font = Font.createFont(0, file);
            if (font == null) {
                System.out.println("cannot load truetype font:" + string);
                return null;
            }
            System.out.println("load font file:" + string + ",name=" + font.getFontName());
        } else {
            if (localFonts == null) {
                localFonts = Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
            }
            if (localFonts.contains(string)) {
                font = new Font(string, 0, 12);
            } else {
                System.out.println("font file not exists:" + string);
            }
        }
        if (font != null) {
            font = list.size() > 2 && list.get(2).equals("BOLD") ? font.deriveFont(1, n) : (list.size() > 2 && list.get(2).equals("ITALIC") ? font.deriveFont(2, n) : font.deriveFont(0, n));
        }
        return font;
    }

    static {
        defaultFontList = Conf.getFont(new Font[]{new Font("Monospaced", 0, 12), new Font("Simsun", 0, 12)});
    }
}

