/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne;

import java.util.ArrayList;
import java.util.List;
import neoe.ne.BasicAction;
import neoe.ne.FindAndReplace;
import neoe.ne.History;
import neoe.ne.HistoryCell;
import neoe.ne.PageData;

public class BasicEdit {
    PageData pd;
    boolean record;

    BasicEdit(boolean bl, PageData pageData) {
        this.record = bl;
        this.pd = pageData;
    }

    public void insertEmptyLine(int n) {
        if (n > this.lines().size()) {
            n = this.lines().size();
        }
        this.lines().add(n, new StringBuilder());
        if (this.record) {
            this.history().addOne(new HistoryCell(BasicAction.InsertEmptyLine, -1, -1, n, -1, null));
        }
    }

    public void deleteLines(int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 0) {
            return;
        }
        if (this.lines().isEmpty()) {
            return;
        }
        List<CharSequence> list = this.lines().subList(n, n2);
        if (this.record) {
            this.history().addOne(new HistoryCell(BasicAction.DeleteLines, n, n2, 0, 0, new ArrayList<CharSequence>(list)));
        }
        list.clear();
    }

    StringBuilder getLineSb(int n) {
        if (this.lines().size() == 0) {
            this.insertEmptyLine(n);
        }
        if (n < 0 || n >= this.lines().size()) {
            return null;
        }
        CharSequence charSequence = this.lines().get(n);
        if (charSequence instanceof StringBuilder) {
            return (StringBuilder)charSequence;
        }
        if (charSequence instanceof String) {
            String string = (String)charSequence;
            StringBuilder stringBuilder = new StringBuilder(string);
            this.lines().set(n, stringBuilder);
            return stringBuilder;
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence);
        this.lines().set(n, stringBuilder);
        return stringBuilder;
    }

    void deleteInLine(int n, int n2, int n3) {
        StringBuilder stringBuilder = this.getLineSb(n);
        if (stringBuilder == null) {
            return;
        }
        if (n2 >= stringBuilder.length()) {
            return;
        }
        String string = stringBuilder.substring(n2, n3 = Math.min(n3, stringBuilder.length()));
        if (string.length() > 0) {
            stringBuilder.delete(n2, n3);
            if (this.record) {
                this.history().addOne(new HistoryCell(BasicAction.Delete, n2, n3, n, -1, string));
            }
        }
    }

    History history() {
        return this.pd.history;
    }

    void insertInLine(int n, int n2, CharSequence charSequence) {
        StringBuilder stringBuilder;
        if (FindAndReplace.indexOfSeq(charSequence, '\n') >= 0 || FindAndReplace.indexOfSeq(charSequence, '\r') >= 0) {
            throw new RuntimeException("cannot contains line-seperator:[" + String.valueOf(charSequence) + "]" + FindAndReplace.indexOfSeq(charSequence, '\n'));
        }
        if (n == this.pd.roLines.getLinesize()) {
            this.pd.editRec.insertEmptyLine(n);
        }
        if (n2 > (stringBuilder = this.getLineSb(n)).length()) {
            stringBuilder.setLength(n2);
        }
        stringBuilder.insert(n2, charSequence);
        if (this.record) {
            this.history().addOne(new HistoryCell(BasicAction.Insert, n2, n2 + charSequence.length(), n, -1, null));
        }
    }

    List<CharSequence> lines() {
        return this.pd.lines;
    }

    void mergeLine(int n) {
        StringBuilder stringBuilder = this.getLineSb(n);
        CharSequence charSequence = this.lines().get(n + 1);
        int n2 = stringBuilder.length();
        stringBuilder.append(charSequence);
        this.lines().remove(n + 1);
        if (this.record) {
            this.history().addOne(new HistoryCell(BasicAction.MergeLine, n2, -1, n, -1, null));
        }
    }

    void insertLines(int n, List<CharSequence> list) {
        this.lines().addAll(n, list);
    }

    void appendLines(List<CharSequence> list) {
        this.lines().addAll(list);
    }

    void appendLine(CharSequence charSequence) {
        this.lines().add(charSequence);
    }
}

