/*
 * Decompiled with CFR 0.152.
 */
package neoe.ime.spi;

import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodContext;
import java.text.AttributedString;
import java.util.Locale;
import neoe.ime.Ime;
import neoe.ime.ImeImpB;
import neoe.ime.spi.Const;
import neoe.ime.spi.LookupPanel;

public class NeoeInputMethod
implements InputMethod {
    private boolean active;
    private InputMethodContext context;
    private boolean ctrlDown;
    private Ime ime;
    private StringBuffer imein;
    private Locale locale;
    public LookupPanel lookup;
    Window lookupWindow;
    private boolean shiftDown;

    public NeoeInputMethod() {
        System.out.println("new NeoeInputMethod()");
        try {
            this.log("NeoeInputMethod():" + String.valueOf(this));
            this.ime = new ImeImpB(this);
            this.imein = new StringBuffer();
        }
        catch (Exception exception) {
            this.log("", exception);
            exception.printStackTrace();
        }
    }

    @Override
    public void activate() {
        this.log("activate()");
        this.active = true;
        this.openLookupWindow();
    }

    private void closeLookupWindow() {
        if (this.lookupWindow != null) {
            this.lookupWindow.setVisible(false);
        }
    }

    @Override
    public void deactivate(boolean bl) {
        this.log("deactivate(" + bl + ")");
        this.active = false;
        this.closeLookupWindow();
    }

    @Override
    public void dispatchEvent(AWTEvent aWTEvent) {
        this.log("dispatchEvent(" + aWTEvent.getClass().getName() + ")");
        int n = aWTEvent.getID();
        if (n == 402) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            int n2 = keyEvent.getKeyCode();
            if (n2 == 16 && this.shiftDown) {
                if (this.active) {
                    this.deactivate(true);
                } else {
                    this.activate();
                }
            }
            if (!this.active) {
                return;
            }
            if (n2 == 17 && this.ctrlDown && this.lookup != null) {
                if (this.lookup.jcn.isSelected()) {
                    this.lookup.jjp.setSelected(true);
                } else {
                    this.lookup.jcn.setSelected(true);
                }
            }
            if (n2 == 8 && this.active && this.imein.length() > 0) {
                keyEvent.consume();
            }
        } else if (this.active && n == 400) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            if (this.handleCharacter(keyEvent.getKeyChar())) {
                keyEvent.consume();
            } else if (this.imein.length() > 0) {
                keyEvent.consume();
            }
        } else if (this.active && n == 401) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            int n3 = keyEvent.getKeyCode();
            this.shiftDown = n3 == 16;
            this.ctrlDown = n3 == 17;
            if (n3 == 8 && this.active && this.imein.length() > 0) {
                keyEvent.consume();
            }
        }
    }

    @Override
    public void dispose() {
        this.log("dispose()");
        this.closeLookupWindow();
    }

    @Override
    public void endComposition() {
        this.log("endComposition()");
        if (this.imein.length() != 0) {
            String string = this.imein.toString();
            this.sendText(string, string.length());
            this.imein.setLength(0);
        }
        this.closeLookupWindow();
    }

    @Override
    public Object getControlObject() {
        this.log("getControlObject()");
        return null;
    }

    @Override
    public Locale getLocale() {
        this.log("getLocale()");
        return this.locale;
    }

    private boolean handleCharacter(char c) {
        this.log("handleCharacter(" + c + ")");
        int n = this.ime.getCount();
        boolean bl = this.lookup.jcn.isSelected();
        if (this.active) {
            if (c == '\b') {
                int n2 = this.imein.length();
                if (n2 > 0) {
                    this.imein.setLength(n2 - 1);
                    String string = this.imein.toString();
                    this.lookup.jimein.setText(string);
                    this.ime.find(string);
                }
            } else if (bl && c == '-' || c == '[') {
                if (n == 0) {
                    return false;
                }
                this.ime.prev();
            } else if (bl && c == '=' || c == ']') {
                if (n == 0) {
                    return false;
                }
                this.ime.next();
            } else if (c >= '0' && c <= '9' || c == ' ') {
                if (n == 0) {
                    return false;
                }
                int n3 = c - 48;
                if (n3 == 0) {
                    n3 = 10;
                }
                --n3;
                if (c == ' ') {
                    n3 = 0;
                }
                int n4 = this.ime.getCurrentPy().length();
                String string = this.ime.select(n3);
                int n5 = n4 - this.ime.getCurrentPy().length();
                this.sendText(string, n5);
                this.imein.setLength(0);
                String string2 = this.ime.getCurrentPy();
                this.imein.append(string2);
                this.lookup.jimein.setText(string2);
            } else if (c >= 'a' && c <= 'z' || !bl && c == '-') {
                this.imein.append(c);
                String string = this.imein.toString();
                this.lookup.jimein.setText(string);
                this.ime.find(string);
            } else {
                return false;
            }
            String string = this.ime.out();
            this.lookup.jbt1.setText("" + this.ime.getCount());
            this.lookup.jimeselect.setText(string);
            return true;
        }
        return false;
    }

    @Override
    public void hideWindows() {
        this.log("hideWindows()");
        this.closeLookupWindow();
    }

    private void initLookupWindow() {
        try {
            this.lookupWindow = (Window)Const.createInputMethodJFrameMethod.invoke((Object)this.context, "neoeime", Boolean.FALSE);
            this.lookup = new LookupPanel(this, this.context);
            this.lookupWindow.add(this.lookup);
            this.lookupWindow.pack();
            this.log("initLookupWindow():" + this.lookupWindow.hashCode());
        }
        catch (Exception exception) {
            this.log("", exception);
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isCompositionEnabled() {
        this.log("isCompositionEnabled()");
        return true;
    }

    private void log(String string) {
        System.out.println(string);
    }

    private void log(String string, Exception exception) {
        System.out.println(string + String.valueOf(exception));
    }

    @Override
    public void notifyClientWindowChange(Rectangle rectangle) {
        this.log("notifyClientWindowChange(" + String.valueOf(rectangle) + ")");
    }

    private void openLookupWindow() {
        if (this.lookupWindow == null) {
            this.initLookupWindow();
        }
        this.lookupWindow.setVisible(true);
    }

    @Override
    public void reconvert() {
        this.log("reconvert()");
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNotify() {
        this.log("removeNotify()");
    }

    private void sendText(String string, int n) {
        this.log("send " + string + "," + n);
        TextHitInfo textHitInfo = null;
        n = string.length();
        this.context.dispatchInputMethodEvent(1100, new AttributedString(string).getIterator(), n, textHitInfo, null);
    }

    @Override
    public void setCharacterSubsets(Character.Subset[] subsetArray) {
        this.log("setCharacterSubsets(" + String.valueOf(subsetArray) + ")");
    }

    @Override
    public void setCompositionEnabled(boolean bl) {
        this.log("setCompositionEnabled(" + bl + ")");
    }

    @Override
    public void setInputMethodContext(InputMethodContext inputMethodContext) {
        this.log("setInputMethodContext(" + String.valueOf(inputMethodContext) + ")");
        this.context = inputMethodContext;
        inputMethodContext.enableClientWindowNotification(this, false);
    }

    @Override
    public boolean setLocale(Locale locale) {
        this.locale = locale;
        return true;
    }
}

