/*
 * Decompiled with CFR 0.152.
 */
package neoe.ime.neoeedit;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import neoe.ime.ImeLib;
import neoe.ime.ImeUnit;
import neoe.ime.NoDupList;
import neoe.ne.FontList;
import neoe.ne.Ime;
import neoe.ne.U;

public abstract class GeneralIme
implements Ime.ImeInterface {
    protected static ImeLib jpWord;
    protected static ImeLib enWord;
    protected static ImeLib cnenDict;
    protected static ImeLib jpChar;
    protected static ImeLib cnChar;
    protected static ImeLib cnWord;
    protected static Object initLock;
    protected List<ImeLib> libs;
    boolean initStarted = false;
    boolean initFinished = false;
    int pagesize1 = 9;
    int pagesize2 = 5;
    protected boolean toLowCase = false;
    StringBuffer sb = new StringBuffer();
    Color c0 = Color.decode("0xaaaaff");
    Color c1 = Color.decode("0x005500");
    Color c2 = Color.decode("0x222222");
    protected List res = Collections.EMPTY_LIST;
    int start = 0;

    public void init() {
        if (this.initStarted) {
            return;
        }
        this.initStarted = true;
        try {
            this.initLibs();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initFinished = true;
    }

    public List find(String string) {
        if (!this.initStarted) {
            this.init();
        }
        if (!this.initFinished) {
            return Collections.EMPTY_LIST;
        }
        int n = string.length();
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        NoDupList noDupList = new NoDupList();
        for (int i = n; i > 0; --i) {
            String string2 = string.substring(0, i).toLowerCase();
            Iterator<ImeLib> iterator = this.libs.iterator();
            while (iterator.hasNext()) {
                ImeLib imeLib;
                ImeLib imeLib2 = imeLib = iterator.next();
                noDupList.addAll(imeLib2.find(string2));
            }
        }
        return noDupList.data;
    }

    abstract void initLibs() throws Exception;

    public void keyPressed(int n, Ime.Out out) {
        int n2;
        int n3 = n;
        if (this.sb.length() > 0 && n3 == 27) {
            this.sb.setLength(0);
            out.consumed = true;
            return;
        }
        int n4 = n2 = this.longTextMode() ? this.pagesize2 : this.pagesize1;
        if (this.sb.length() > 0 && this.res.size() > 0 && n3 == 33) {
            if (this.start >= n2) {
                this.start -= n2;
            }
            out.consumed = true;
        } else if (this.sb.length() > 0 && this.res.size() > 0 && n3 == 34) {
            if (this.start + n2 < this.res.size()) {
                this.start += n2;
            }
            out.consumed = true;
        }
    }

    public void keyTyped(char c, Ime.Out out) {
        int n;
        char c2 = c;
        int n2 = n = this.longTextMode() ? this.pagesize2 : this.pagesize1;
        if (c2 == '\b') {
            int n3 = this.sb.length();
            if (n3 > 0) {
                this.sb.setLength(n3 - 1);
                this.consumePreedit(out);
            }
        } else if (Character.isDigit(c2)) {
            if (this.sb.length() == 0 || this.res.isEmpty()) {
                return;
            }
            int n4 = c2 - 48 + this.start;
            if (n4 > 0 && n4 <= this.res.size()) {
                this.consumeYield(n4 - 1, out);
            }
        } else if (c2 == ' ') {
            if (this.sb.length() > 0 && this.res.isEmpty()) {
                out.yield = this.sb.toString();
                out.consumed = true;
                this.sb.setLength(0);
                return;
            }
            if (this.sb.length() == 0 || this.res.isEmpty()) {
                return;
            }
            this.consumeYield(this.start, out);
        } else if (c2 == '\n') {
            if (this.sb.length() == 0) {
                return;
            }
            out.yield = this.sb.toString();
            out.consumed = true;
            out.preedit = "";
            this.sb.setLength(0);
            this.res.clear();
        } else if (c2 == '[' && this.res.size() > 0) {
            if (this.start >= n) {
                this.start -= n;
            }
            out.consumed = true;
        } else if (c2 == ']' && this.res.size() > 0) {
            if (this.start + n < this.res.size()) {
                this.start += n;
            }
            out.consumed = true;
        } else {
            if (this.isIgnoreKey(c2)) {
                return;
            }
            this.sb.append(c2);
            this.consumePreedit(out);
        }
    }

    boolean isIgnoreKey(char c) {
        if (Character.isAlphabetic(c)) {
            return false;
        }
        return ",.\\-".indexOf(c) < 0;
    }

    public void setEnabled(boolean bl) {
        if (!this.initStarted) {
            new Thread(){

                @Override
                public void run() {
                    GeneralIme.this.init();
                }
            }.start();
        }
        this.sb.setLength(0);
    }

    public abstract String getImeName();

    public void paint(Graphics2D graphics2D, FontList fontList, int n, int n2, Rectangle rectangle) {
        int n3;
        int n4;
        if (this.res.isEmpty() || this.sb.length() == 0) {
            return;
        }
        if (this.longTextMode()) {
            this.paint2(graphics2D, fontList, n, n2, rectangle);
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setPaintMode();
        int n5 = this.res.size();
        int n6 = this.start + this.pagesize1 - 1;
        if (n6 >= n5) {
            n6 = n5 - 1;
        }
        if (this.start > n6) {
            this.start = n6;
        }
        int n7 = 1;
        int n8 = 0;
        int n9 = 0;
        for (n4 = this.start; n4 <= n6; ++n4) {
            ImeUnit imeUnit = (ImeUnit)this.res.get(n4);
            n3 = U.stringWidth((Graphics2D)graphics2D2, (FontList)fontList, (String)(n7 + ":" + imeUnit.txt));
            n9 += n3;
            if (++n7 % 3 != 1) continue;
            if (n9 > n8) {
                n8 = n9;
            }
            n9 = 0;
        }
        if (n7 % 3 != 1 && n9 > n8) {
            n8 = n9;
        }
        n4 = 1 + (n6 - this.start) / 3;
        n8 += U.charWidth((Graphics2D)graphics2D2, (FontList)fontList, (char)' ') * 2;
        n8 = Math.max(n8, U.stringWidth((Graphics2D)graphics2D2, (FontList)fontList, (String)this.sb.toString()));
        int n10 = fontList.getlineHeight();
        n3 = n10 * (n4 + 1) + 5;
        Rectangle rectangle2 = new Rectangle(n, n2, n8 += 5, n3);
        if (n + n8 - rectangle.x > rectangle.width) {
            rectangle2.x = rectangle.width + rectangle.x - n8;
        }
        if (n2 + n3 - rectangle.y > rectangle.height) {
            rectangle2.y = n2 - n3 - graphics2D2.getFont().getSize() - 8;
        }
        if (rectangle2.x < 0) {
            rectangle2.x = 0;
        }
        if (rectangle2.y < 0) {
            rectangle2.y = 0;
        }
        graphics2D2.setColor(this.c0);
        graphics2D2.fill(rectangle2);
        graphics2D2.setColor(this.c1);
        int n11 = rectangle2.x + 2;
        int n12 = rectangle2.y + 2 + n10;
        U.drawString((Graphics2D)graphics2D2, (FontList)fontList, (String)this.sb.toString(), (int)n11, (int)n12);
        n7 = 1;
        for (int i = this.start; i <= n6; ++i) {
            if (n7 % 3 == 1) {
                n12 += n10;
                n11 = rectangle2.x + 2;
            }
            ImeUnit imeUnit = (ImeUnit)this.res.get(i);
            graphics2D2.setColor(this.c1);
            int n13 = U.drawString((Graphics2D)graphics2D2, (FontList)fontList, (String)(n7 + ":"), (int)n11, (int)n12);
            n11 += n13;
            graphics2D2.setColor(this.c2);
            n11 += U.drawString((Graphics2D)graphics2D2, (FontList)fontList, (String)(imeUnit.txt + " "), (int)n11, (int)n12);
            ++n7;
        }
        graphics2D2.dispose();
    }

    public void paint2(Graphics2D graphics2D, FontList fontList, int n, int n2, Rectangle rectangle) {
        int n3;
        int n4;
        if (this.res.isEmpty() || this.sb.length() == 0) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setPaintMode();
        int n5 = this.res.size();
        int n6 = this.start + this.pagesize2 - 1;
        if (n6 >= n5) {
            n6 = n5 - 1;
        }
        if (this.start > n6) {
            this.start = n6;
        }
        int n7 = 1;
        int n8 = 0;
        int n9 = 0;
        for (n4 = this.start; n4 <= n6; ++n4) {
            ImeUnit imeUnit = (ImeUnit)this.res.get(n4);
            n3 = U.stringWidth((Graphics2D)graphics2D2, (FontList)fontList, (String)(n7 + ":" + imeUnit.txt.replace('\t', ' ')));
            ++n7;
            if ((n9 += n3) > n8) {
                n8 = n9;
            }
            n9 = 0;
        }
        n4 = n6 - this.start + 1;
        int n10 = fontList.getlineHeight();
        n3 = n10 * (n4 + 1) + 5;
        Rectangle rectangle2 = new Rectangle(n, n2, n8 += 5, n3);
        if (n + n8 - rectangle.x > rectangle.width) {
            rectangle2.x = rectangle.width + rectangle.x - n8;
        }
        if (n2 + n3 - rectangle.y > rectangle.height) {
            rectangle2.y = rectangle.height + rectangle.y - n3;
        }
        if (rectangle2.x < 0) {
            rectangle2.x = 0;
        }
        if (rectangle2.y < 0) {
            rectangle2.y = 0;
        }
        graphics2D2.setColor(this.c0);
        graphics2D2.fill(rectangle2);
        graphics2D2.setColor(this.c1);
        int n11 = rectangle2.x + 2;
        int n12 = rectangle2.y + 2 + n10;
        U.drawString((Graphics2D)graphics2D2, (FontList)fontList, (String)this.sb.toString(), (int)n11, (int)n12);
        n7 = 1;
        for (int i = this.start; i <= n6; ++i) {
            n11 = rectangle2.x + 2;
            ImeUnit imeUnit = (ImeUnit)this.res.get(i);
            graphics2D2.setColor(this.c1);
            int n13 = U.drawString((Graphics2D)graphics2D2, (FontList)fontList, (String)(n7 + ":"), (int)n11, (int)(n12 += n10));
            n11 += n13;
            graphics2D2.setColor(this.c2);
            n11 += U.drawString((Graphics2D)graphics2D2, (FontList)fontList, (String)imeUnit.txt.replace('\t', ' '), (int)n11, (int)n12);
            ++n7;
        }
        graphics2D2.dispose();
    }

    protected void consumePreedit(Ime.Out out) {
        out.consumed = true;
        this.res = this.find(this.sb.toString());
        this.start = 0;
        if (!this.res.isEmpty()) {
            ImeUnit imeUnit = (ImeUnit)this.res.get(0);
            out.preedit = imeUnit.txt;
        } else {
            out.preedit = this.sb.toString();
        }
    }

    protected void consumeYield(int n, Ime.Out out) {
        if (!this.res.isEmpty()) {
            ImeUnit imeUnit = (ImeUnit)this.res.get(n);
            out.yield = imeUnit.txt;
            out.consumed = true;
            this.sb.delete(0, Math.min(this.sb.length(), imeUnit.pylen));
            out.preedit = this.sb.toString();
            this.res = this.sb.length() > 0 ? this.find(this.sb.toString()) : Collections.EMPTY_LIST;
            this.start = 0;
        } else {
            out.yield = this.sb.toString();
            out.consumed = true;
            this.sb.setLength(0);
            this.res = Collections.EMPTY_LIST;
        }
    }

    static {
        initLock = new Object();
    }
}

