/*
 * Decompiled with CFR 0.152.
 */
package neoe.ime.fix;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WordSort {
    private BufferedWriter abondOut;
    private int debugLine;
    String regChars;
    Map vote = new HashMap();
    List words;

    public static void main(String[] stringArray) throws IOException {
        long l = System.currentTimeMillis();
        new WordSort().run();
        System.out.println("use time " + (System.currentTimeMillis() - l) + " ms.");
        System.out.println("program end " + String.valueOf(new Date()));
    }

    private void abond(String string) throws IOException {
        this.abondOut.write(string + "\n");
    }

    private void closeLogFile() throws IOException {
        this.abondOut.close();
    }

    private void debug(Object object) {
        System.out.println("[d]" + String.valueOf(object));
    }

    private boolean find(String string) {
        if (this.words.contains(string)) {
            return true;
        }
        int n = this.words.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.words.get(i);
            if (!string2.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    private void inc(String string) {
        Integer n = (Integer)this.vote.get(string);
        int n2 = n == null ? 0 : n;
        this.vote.put(string, ++n2);
    }

    private void initLogFile() throws IOException {
        this.abondOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("abond.txt"), "utf8"));
    }

    private boolean isRegChar(char c) {
        return this.regChars.indexOf(c) >= 0;
    }

    private void learn(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            String string2 = string.substring(0, n - i);
            if (!this.words.contains(string2)) continue;
            this.inc(string2);
            if (i > 0) {
                String string3 = string.substring(n - i, n);
                this.learn(string3);
            }
            return;
        }
        this.abond(string);
    }

    private void learnFromDir(String string, String string2) throws IOException {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            this.debug(file2);
            this.learnFromFile(file2, string2);
        }
    }

    private void learnFromFile(File file, String string) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = bufferedReader.read()) != -1) {
            char c = (char)n;
            if (!this.isRegChar(c)) continue;
            stringBuffer.append(c);
            if (this.find(stringBuffer.toString())) continue;
            if (stringBuffer.length() == 1) {
                this.debug("skip " + String.valueOf(stringBuffer));
                continue;
            }
            this.learn(stringBuffer.substring(0, stringBuffer.length() - 1));
            String string2 = stringBuffer.substring(stringBuffer.length() - 1);
            stringBuffer.setLength(0);
            stringBuffer.append(string2);
        }
    }

    private void readChars() throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("py.tab.txt"), "UTF8"));
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = bufferedReader.read()) != -1) {
            char c = (char)n;
            if (c == ' ' || c >= 'a' && c <= 'z' || c == '\r' || c == '\n') continue;
            stringBuffer.append(c);
        }
        bufferedReader.close();
        this.regChars = stringBuffer.toString();
        this.debug(this.regChars);
    }

    private void readWords() throws IOException {
        String string;
        this.debug("read words...");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("cn_dict"), "UTF8"));
        this.words = new ArrayList();
        while ((string = bufferedReader.readLine()) != null) {
            this.words.add(string.trim());
        }
        bufferedReader.close();
        this.debug("read words OK");
    }

    private void run() throws IOException {
        this.initLogFile();
        this.readChars();
        this.readWords();
        String string = "D:/mass2/0916/wolf/main";
        this.learnFromDir(string, "gbk");
        this.saveWords();
        this.closeLogFile();
    }

    private void saveWords() throws IOException {
        this.debug("active words " + this.vote.size());
        this.debug("sort...");
        Collections.sort(this.words, new Comparator(){

            public int compare(Object object, Object object2) {
                Integer n = (Integer)WordSort.this.vote.get(object);
                Integer n2 = (Integer)WordSort.this.vote.get(object2);
                int n3 = n == null ? 0 : n;
                int n4 = n2 == null ? 0 : n2;
                return n4 - n3;
            }
        });
        this.debug("write...");
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("w2.txt"), "UTF8"));
        for (int i = 0; i < this.words.size(); ++i) {
            bufferedWriter.write(String.valueOf(this.words.get(i)) + "\n");
        }
        bufferedWriter.close();
        this.debug("OK");
    }
}

