/*
 * Decompiled with CFR 0.152.
 */
package neoe.ime.cnen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import neoe.ime.ImeLib;
import neoe.ime.ImeUnit;
import neoe.ime.U;
import neoe.ime.cn.CnCharLib;

public class CnEnDict
implements ImeLib {
    private Thread initThread;
    private CnCharLib cnChar;
    public List<Object[]> lines;
    int maxCandi = 19;

    public CnEnDict(final CnCharLib cnCharLib) {
        this.cnChar = cnCharLib;
        this.initThread = new Thread(){

            @Override
            public void run() {
                try {
                    cnCharLib.getInitThread().join();
                    CnEnDict.this.doInit();
                    System.out.println("Pinyin-English init size=" + CnEnDict.this.lines.size());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        this.initThread.start();
    }

    private void doInit() throws IOException {
        String string;
        if (this.lines != null) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(U.getInstalledInputStream("encn.dict"), "utf8"));
        this.lines = new ArrayList<Object[]>();
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf(9);
            if (n <= 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            String string4 = this.getPinyinIndex(string3);
            this.lines.add(new Object[]{string2, string3, string4, string2.toLowerCase()});
        }
        bufferedReader.close();
    }

    private String getPinyinIndex(String string) {
        int n;
        int n2 = string.length();
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < n2; ++n) {
            String string2;
            char c = string.charAt(n);
            if (c < '\u00ff') {
                if (bl) continue;
                stringBuilder.append(" ");
                bl = false;
                continue;
            }
            if (!bl) {
                stringBuilder.append(' ');
            }
            if ((string2 = CnCharLib.reverse(c)) != null) {
                stringBuilder.append(string2);
                bl = true;
                continue;
            }
            stringBuilder.append(' ');
            bl = false;
        }
        for (n = 0; n < stringBuilder.length() && stringBuilder.charAt(n) == ' '; ++n) {
        }
        String string3 = stringBuilder.substring(n);
        return string3;
    }

    @Override
    public List find(String string) {
        ArrayList arrayList = new ArrayList();
        for (Object[] object : this.lines) {
            String string2 = (String)object[2];
            int objectArray = this.getValue(string2, string);
            if (objectArray <= 0) continue;
            this.addToList(arrayList, objectArray, object);
        }
        if (arrayList.isEmpty()) {
            return arrayList;
        }
        ArrayList arrayList2 = new ArrayList();
        for (String string2 : arrayList) {
            Object[] objectArray = (Object[])string2;
            Object[] objectArray2 = (Object[])objectArray[0];
            ImeUnit imeUnit = new ImeUnit(String.valueOf(objectArray2[0]) + "\t" + String.valueOf(objectArray2[1]), string.length());
            arrayList2.add(imeUnit);
        }
        return arrayList2;
    }

    private void addToList(List list, int n, Object[] objectArray) {
        int n2;
        boolean bl = false;
        int n3 = n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Object[] objectArray2 = (Object[])list.get(i);
            if (n <= (Integer)objectArray2[1]) continue;
            n3 = i;
            break;
        }
        if (n3 < this.maxCandi) {
            list.add(n3, new Object[]{objectArray, n});
            while (list.size() > this.maxCandi) {
                list.remove(list.size() - 1);
            }
        }
    }

    private int getValue(String string, String string2) {
        if (string2.length() == 0) {
            return 0;
        }
        boolean bl = false;
        int n = string.length();
        int n2 = 0;
        int n3 = string2.length();
        int n4 = string.length() - string2.length();
        for (int i = 0; i <= n4; ++i) {
            int n5;
            for (n5 = 0; n5 < n3 && string2.charAt(n5) == string.charAt(i + n5); ++n5) {
            }
            if (n5 == n3) {
                return this.pack(i, n5);
            }
            if (n5 <= n2) continue;
            n2 = n5;
            n = i;
        }
        return this.pack(n, n2);
    }

    private int pack(int n, int n2) {
        return n2 << 16 | 65535 - n;
    }

    @Override
    public Thread getInitThread() {
        return this.initThread;
    }
}

