/*
 * Decompiled with CFR 0.152.
 */
package neoe.ime;

import java.util.ArrayList;
import java.util.List;
import neoe.ime.Ime;
import neoe.ime.ImeLib;
import neoe.ime.ImeUnit;
import neoe.ime.NoDupList;
import neoe.ime.cn.CnCharLib;
import neoe.ime.cn.CnWordLib;
import neoe.ime.cnen.CnEnDict;
import neoe.ime.en.EnWord;
import neoe.ime.jp.JpCharLib;
import neoe.ime.jp.JpWordLib;
import neoe.ime.spi.NeoeInputMethod;

public class ImeImpB
implements Ime {
    private static boolean initFinished = false;
    private static boolean initStarted = false;
    private static ImeLib jpWord;
    private static ImeLib enWord;
    private static ImeLib cnenDict;
    private static ImeLib jpChar;
    private static ImeLib cnChar;
    private static ImeLib cnWord;
    private static final int CN = 1;
    private static final int JP = 2;
    private static final int EN = 3;
    private static final int CNEN = 4;
    private static final int MAX_OUT_LEN = 30;
    private static final int MAX_SELECTION = 10;
    private int c;
    private String cur = "";
    private NeoeInputMethod method;
    private List result = new ArrayList();
    private int start;
    int imeType;

    public static void main(String[] stringArray) throws Exception {
        ImeImpB imeImpB = new ImeImpB(null);
        imeImpB.imeType = 2;
        while (true) {
            if (initFinished) break;
            Thread.sleep(1000L);
        }
        imeImpB.find(",");
        do {
            System.out.println(imeImpB.out());
            System.out.println("s=" + imeImpB.select(0));
            System.out.println("r=" + imeImpB.cur);
        } while (imeImpB.getCount() != 0);
    }

    public ImeImpB(NeoeInputMethod neoeInputMethod) {
        this.method = neoeInputMethod;
        this.imeType = 1;
        if (!initStarted) {
            initStarted = true;
            this.init();
        }
    }

    @Override
    public void find(String string) {
        int n = string.length();
        this.cur = string;
        NoDupList noDupList = new NoDupList();
        for (int i = n; i > 0; --i) {
            String string2 = string.substring(0, i);
            if (this.imeType == 1) {
                noDupList.addAll(cnWord.find(string2));
                noDupList.addAll(cnChar.find(string2));
                continue;
            }
            if (this.imeType == 2) {
                noDupList.addAll(jpChar.find(string2));
                noDupList.addAll(jpWord.find(string2));
                continue;
            }
            if (this.imeType == 3) {
                noDupList.addAll(enWord.find(string2));
                continue;
            }
            if (this.imeType != 4) continue;
            noDupList.addAll(cnenDict.find(string2));
        }
        this.result = noDupList.data;
        this.start = 0;
    }

    @Override
    public int getCount() {
        return this.result.size();
    }

    @Override
    public String getCurrentPy() {
        return this.cur;
    }

    private String getTxt(int n) {
        if (n >= 0 && n < this.result.size()) {
            return ((ImeUnit)this.result.get((int)n)).txt;
        }
        return "NULL";
    }

    private void init() {
        try {
            ImeLib[] imeLibArray;
            cnChar = new CnCharLib();
            cnWord = new CnWordLib((CnCharLib)cnChar);
            jpChar = new JpCharLib();
            jpWord = new JpWordLib((JpCharLib)jpChar);
            cnenDict = new CnEnDict((CnCharLib)cnChar);
            enWord = new EnWord((CnEnDict)cnenDict);
            for (ImeLib imeLib : imeLibArray = new ImeLib[]{cnChar, cnWord, jpChar, jpWord, enWord, cnenDict}) {
                Thread thread = imeLib.getInitThread();
                if (thread == null) continue;
                thread.join();
            }
            System.out.println("ime(s) init ok");
            initFinished = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void next() {
        StringBuffer stringBuffer = new StringBuffer();
        this.c = 0;
        while (this.start + this.c < this.result.size()) {
            Object object = this.getTxt(this.start + this.c);
            String string = this.c == 9 ? "0" : "" + (this.c + 1);
            object = string + (String)object + " ";
            ++this.c;
            if (stringBuffer.length() + ((String)object).length() >= 30) {
                --this.c;
                break;
            }
            stringBuffer.append((String)object);
            if (this.c < 10) continue;
            break;
        }
        if (this.start + this.c < this.result.size()) {
            this.start += this.c;
        }
    }

    @Override
    public String out() {
        StringBuffer stringBuffer = new StringBuffer();
        this.c = 0;
        while (this.start + this.c < this.result.size()) {
            Object object = this.getTxt(this.start + this.c);
            String string = this.c == 9 ? "0" : "" + (this.c + 1);
            object = string + (String)object + " ";
            ++this.c;
            if (stringBuffer.length() + ((String)object).length() >= 30) {
                --this.c;
                break;
            }
            stringBuffer.append((String)object);
            if (this.c < 10) continue;
            break;
        }
        if (this.start > 0) {
            stringBuffer.append("<< ");
        }
        if (this.start + this.c < this.result.size()) {
            stringBuffer.append(">> ");
        }
        return stringBuffer.toString();
    }

    @Override
    public void prev() {
        StringBuffer stringBuffer = new StringBuffer();
        this.c = 0;
        while (this.start - this.c >= 0) {
            Object object = this.getTxt(this.start - this.c);
            String string = this.c == 9 ? "0" : "" + (this.c + 1);
            object = string + (String)object + " ";
            ++this.c;
            if (stringBuffer.length() + ((String)object).length() >= 30) {
                --this.c;
                break;
            }
            stringBuffer.append((String)object);
            if (this.c < 10) continue;
            break;
        }
        if (this.start - this.c >= 0) {
            this.start -= this.c;
        }
    }

    @Override
    public String select(int n) {
        if (n < 0 || n > this.c - 1) {
            return "";
        }
        String string = "";
        ImeUnit imeUnit = (ImeUnit)this.result.get(n += this.start);
        string = imeUnit.txt;
        int n2 = this.cur.length() - imeUnit.pylen;
        if (n2 > 0) {
            this.cur = this.cur.substring(this.cur.length() - n2);
            this.find(this.cur);
        } else {
            this.find("");
        }
        return string;
    }
}

