## What does it do?

Please include a summary of the change and which issue is fixed. Please also include relevant motivation and context. List any dependencies that are required for this change.

## Fixes # (issue)

Please mention in the format "Fixes #issueNumber" or "Closes #issueNumber".
This is important for semantic-release to correctly generate release tags and update issues.

## Type of change

Please delete options that are not relevant.

- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] This change requires a documentation update

## Checklist:

- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] Updated documentation (if applicable)
- [ ] Added tests that prove my fix is effective or that my feature works
- [ ] Make sure app compiles in both dev and prod mode by running `yarn dev` and `yarn build`
- [ ] New and existing unit, integration and e2e tests pass locally with my changes
- [ ] My changes generate no new warnings (browser console and Node.js terminal)
- [ ] There are no new linting `yarn lint` and typing `yarn types` errors
- [ ] Make sure code is formatted by running `yarn format`
