export const toastSuccess = ({ title, body, dispatch, id }) => (
  <div
    id="toast"
    className="space-x group pointer-events-auto relative mb-4 flex w-full max-w-xs items-center justify-start rounded-lg bg-white p-4 text-slate-500 shadow-lg dark:bg-gray-800 dark:text-slate-400"
    role="alert"
  >
    <div className="inline-flex h-10 w-10 flex-shrink-0 items-center justify-center rounded-lg bg-emerald-100 dark:bg-emerald-800">
      <svg
        className="h-8 w-8 text-emerald-500 dark:text-emerald-600"
        fill="none"
        aria-hidden="true"
        data-name="badge-check"
        stroke="currentColor"
        viewBox="0 0 24 24"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={2}
          d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"
        />
      </svg>
    </div>
    <div className="flex flex-col items-start justify-start">
      <div className="truncate text-ellipsis break-all pl-4 text-base font-normal">
        {title}
      </div>
      {body && (
        <div className="block max-w-[240px] truncate pl-4 text-xs font-normal">
          {body}
        </div>
      )}
    </div>
    <div
      onClick={() => dispatch({ type: 'DELETE_TOAST', id })}
      className="absolute top-2 right-2 opacity-0 transition hover:cursor-pointer group-hover:opacity-100"
    >
      <svg
        className="h-6 w-6 text-slate-300"
        fill="none"
        stroke="currentColor"
        viewBox="0 0 24 24"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={2}
          d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"
        />
      </svg>
    </div>
  </div>
)

export const toastError = ({ title, body, dispatch, id }) => (
  <div
    id="toast"
    className="space-x group pointer-events-auto relative mb-4 flex w-full max-w-xs items-center justify-start rounded-lg bg-white p-4 text-slate-500 shadow-lg dark:bg-gray-800 dark:text-slate-400"
    role="alert"
  >
    <div className="inline-flex h-10 w-10 flex-shrink-0 items-center justify-center rounded-lg bg-red-100 dark:bg-red-800">
      <svg
        className="h-8 w-8 text-red-600 dark:text-red-500"
        aria-hidden="true"
        data-name="exclamation-circle"
        fill="none"
        stroke="currentColor"
        viewBox="0 0 24 24"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={2}
          d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
        />
      </svg>
    </div>
    <div className="flex flex-col items-start justify-start">
      <div className="pl-4 text-base font-normal">{title}</div>
      {body && (
        <div className="block max-w-[240px] truncate pl-4 text-xs font-normal">
          {body}
        </div>
      )}
    </div>
    <div
      onClick={() => dispatch({ type: 'DELETE_TOAST', id })}
      className="absolute top-2 right-2 hidden hover:cursor-pointer group-hover:block"
    >
      <svg
        className="h-6 w-6 text-slate-200"
        fill="none"
        stroke="currentColor"
        viewBox="0 0 24 24"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={2}
          d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"
        />
      </svg>
    </div>
  </div>
)

export const toastWarning = ({ title, body, dispatch, id }) => (
  <div
    id="toast"
    className="space-x group pointer-events-auto relative mb-4 flex w-full max-w-xs items-center justify-start rounded-lg bg-white p-4 text-slate-500 shadow-lg dark:bg-gray-800 dark:text-slate-400"
    role="alert"
  >
    <div className="inline-flex h-10 w-10 flex-shrink-0 items-center justify-center rounded-lg bg-yellow-50 dark:bg-yellow-800">
      <svg
        className="h-8 w-8 text-yellow-400 dark:text-yellow-700"
        fill="none"
        aria-hidden="true"
        data-name="exclamation-shield"
        stroke="currentColor"
        viewBox="0 0 24 24"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={2}
          d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"
        />
      </svg>
    </div>
    <div className="flex flex-col items-start justify-start">
      <div className="pl-4 text-base font-normal">{title}</div>
      {body && (
        <div className="block max-w-[240px] truncate pl-4 text-xs font-normal">
          {body}
        </div>
      )}
    </div>
    <div
      onClick={() => dispatch({ type: 'DELETE_TOAST', id })}
      className="absolute top-2 right-2 hidden hover:cursor-pointer group-hover:block"
    >
      <svg
        className="h-6 w-6 text-slate-200"
        fill="none"
        stroke="currentColor"
        viewBox="0 0 24 24"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={2}
          d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"
        />
      </svg>
    </div>
  </div>
)
