### 꼼꼼한 딥러닝 논문 리뷰와 코드 실습: Deep Learning Paper Review and Practice

* 꼼꼼한 딥러닝 논문 리뷰와 코드 실습을 위한 저장소입니다.
* 최신 논문 위주로, 많은 인기를 끌고 있는 다양한 딥러닝 논문을 소개합니다.
* 질문 사항은 본 저장소의 <b>[이슈(Issues)](https://github.com/ndb796/Deep-Learning-Paper-Review-and-Practice/issues)</b> 탭에 남겨주세요.

#### Image Recognition (이미지 인식)

* End-to-End Object Detection with Transformers (ECCV 2020)
    * [Original Paper Link](https://arxiv.org/abs/2005.12872) / [Paper Review Video](https://www.youtube.com/watch?v=hCWUTvVrG7E) / [Summary PDF](/lecture_notes/DETR.pdf) / Code Practice
* Searching for MobileNetV3 (ICCV 2019)
    * [Original Paper Link](https://arxiv.org/abs/1905.02244) / Paper Review Video / Summary PDF / Code Practice
* Deep Residual Learning for Image Recognition (CVPR 2016)
    * [Original Paper Link](https://arxiv.org/abs/1512.03385) / [Paper Review Video](https://www.youtube.com/watch?v=671BsKl8d0E) / [Summary PDF](/lecture_notes/ResNet.pdf) / [MNIST](/code_practices/ResNet18_MNIST_Train.ipynb) / [CIFAR-10](/code_practices/ResNet18_CIFAR10_Train.ipynb) / [ImageNet](/code_practices/Pretrained_ResNet18_ImageNet_Test.ipynb)
* Arbitrary Style Transfer in Real-time with Adaptive Instance Normalization (ICCV 2017)
    * [Original Paper Link](https://arxiv.org/abs/1703.06868) / [Paper Review Video](https://www.youtube.com/watch?v=OM-6zYYRYfg) / [Summary PDF](/lecture_notes/AdaIN_Style_Transfer.pdf) / [Code Practice](/code_practices/AdaIN_Style_Transfer_Tutorial.ipynb)
* Image Style Transfer Using Convolutional Neural Networks (CVPR 2016)
    * [Original Paper Link](https://www.cv-foundation.org/openaccess/content_cvpr_2016/papers/Gatys_Image_Style_Transfer_CVPR_2016_paper.pdf) / [Paper Review Video](https://www.youtube.com/watch?v=va3e2c4uKJk) / [Summary PDF](/lecture_notes/Style%20Transfer.pdf) / [Code Practice](/code_practices/Style_Transfer_Tutorial.ipynb)
* Faster R-CNN: Towards Real-Time Object Detection with Region Proposal Networks (NIPS 2015)
    * [Original Paper Link](https://arxiv.org/abs/1506.01497) / Paper Review Video / [Summary PDF](/lecture_notes/Faster_R-CNN.pdf) / Code Practice

#### Natural Language Processing (자연어 처리)

* Single Headed Attention RNN: Stop Thinking With Your Head (2020)
    * [Original Paper Link](https://arxiv.org/abs/1911.11423) / Paper Review Video / Summary PDF / Code Practice
* BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding (NAACL 2019)
    * [Original Paper Link](https://arxiv.org/abs/1810.04805) / Paper Review Video / Summary PDF / Code Practice
* Attention is All You Need (NIPS 2017)
    * [Original Paper Link](https://arxiv.org/abs/1706.03762) / [Paper Review Video](https://www.youtube.com/watch?v=AA621UofTUA) / [Summary PDF](/lecture_notes/Transformer.pdf) / [Code Practice](/code_practices/Attention_is_All_You_Need_Tutorial_(German_English).ipynb)
* Neural Machine Translation by Jointly Learning to Align and Translate (ICLR 2015 Oral)
    * [Original Paper Link](https://arxiv.org/abs/1409.0473) / Paper Review Video / Summary PDF / [Code Practice](/code_practices/Sequence_to_Sequence_with_Attention_Tutorial.ipynb)
* Show and Tell: A Neural Image Caption Generator (CVPR 2015)
    * [Original Paper Link](https://arxiv.org/abs/1411.4555) / Paper Review Video / Summary PDF / [Code Practice](/code_practices/Neural_Image_Captioning_(NIC)_Using_ResNet_101.ipynb)
* Sequence to Sequence Learning with Neural Networks (NIPS 2014)
    * [Original Paper Link](https://arxiv.org/abs/1409.3215) / [Paper Review Video](https://www.youtube.com/watch?v=4DzKM0vgG1Y) / [Summary PDF](/lecture_notes/Seq2Seq.pdf) / [Code Practice](/code_practices/Sequence_to_Sequence_with_LSTM_Tutorial.ipynb)

#### Generative Model & Super Resolution (생성 모델 & 해상도 복원)

* Meta-Transfer Learning for Zero-Shot Super-Resolution (CVPR 2020)
    * [Original Paper Link](https://arxiv.org/abs/2002.12213) / [Paper Review Video](https://www.youtube.com/watch?v=PUtFz4vqXHQ) / [Summary PDF](/lecture_notes/MZSR.pdf) / Code Practice
* SinGAN: Learning a Generative Model from a Single Natural Image (ICCV 2019)
    * [Original Paper Link](https://arxiv.org/abs/1905.01164) / Paper Review Video / Summary PDF / Code Practice
* A Style-Based Generator Architecture for Generative Adversarial Networks (CVPR 2019)
    * [Original Paper Link](https://arxiv.org/abs/1812.04948) / Paper Review Video / [Summary PDF](/lecture_notes/StyleGAN.pdf) / Code Practice
* StarGAN: Unified Generative Adversarial Networks for Multi-Domain Image-to-Image Translation (CVPR 2018 Oral)
    * [Original Paper Link](https://arxiv.org/abs/1711.09020) / [Paper Review Video](https://www.youtube.com/watch?v=-r9M4Cj9o_8) / [Summary PDF](/lecture_notes/StarGAN.pdf) / [Code Practice](/code_practices/StarGAN_Tutorial.ipynb)
* Image-to-Image Translation with Conditional Adversarial Networks (CVPR 2017)
    * [Original Paper Link](https://arxiv.org/abs/1611.07004) / [Paper Review Video](https://www.youtube.com/watch?v=ImiD4npRj7k) / [Summary PDF](/lecture_notes/Pix2Pix.pdf) / [Code Practice](/code_practices/Pix2Pix_for_Facades.ipynb)
* Generative Adversarial Nets (NIPS 2014)
    * [Original Paper Link](https://arxiv.org/abs/1406.2661) / [Paper Review Video](https://www.youtube.com/watch?v=AVvlDmhHgC4) / [Summary PDF](/lecture_notes/GAN.pdf) / [Code Practice](/code_practices/GAN_for_MNIST_Tutorial.ipynb)

#### Modeling & Optimization (모델링 & 최적화)

* Bag of Tricks for Image Classification (CVPR 2019)
    * [Original Paper Link](https://arxiv.org/abs/1812.01187) / Paper Review Video / [Summary PDF](/lecture_notes/Bag_of_Tricks_for_Image_Classification.pdf)
    * [CIFAR-10](/code_practices/ResNet18_CIFAR10_Basic_Training.ipynb) / [CIFAR-10 with Label Smoothing](/code_practices/ResNet18_CIFAR10_Training_with_Label_Smoothing.ipynb) / [CIFAR-10 with Input Mixup](/code_practices/ResNet18_CIFAR10_Training_with_Input_Mixup.ipynb) / [CIFAR-10 with Label Smoothing and Input Mixup](/code_practices/ResNet18_CIFAR10_Training_with_Input_Mixup_and_Label_Smoothing.ipynb)
* Deep Compression: Compressing Deep Neural Networks with Pruning, Trained Quantization and Huffman Coding (ICLR 2016 Oral)
    * [Original Paper Link](https://arxiv.org/abs/1510.00149) / Paper Review Video / Summary PDF / Code Practice
* Batch normalization: Accelerating deep network training by reducing internal covariate shift (PMLR 2015)
    * [Original Paper Link](https://arxiv.org/abs/1502.03167) / [Paper Review Video](https://www.youtube.com/watch?v=58fuWVu5DVU) / [Summary PDF](/lecture_notes/Batch_Normalization.pdf) / [Code Practice](/code_practices/Batch_Normalization_Evaluation_(with_Residual_Connection).ipynb)

#### Adversarial Examples & Backdoor Attacks (적대적 예제 & 백도어 공격)

* HopSkipJumpAttack: A Query-Efficient Decision-Based Attack (S&P 2020)
    * [Original Paper Link](https://arxiv.org/abs/1904.02144) / Paper Review Video/ Summary PDF / [Targeted Attack](/code_practices/Targeted_HopSkipJumpAttack_Using_CIFAR10.ipynb) / [Untargeted Attack](/code_practices/Untargeted_HopSkipJumpAttack_Using_CIFAR10.ipynb)
* Breaking certified defenses: Semantic adversarial examples with spoofed robustness certificates (ICLR 2020)
    * [Original Paper Link](https://arxiv.org/abs/2003.08937) / [Paper Review Video](https://www.youtube.com/watch?v=D1j3QiXPRag) / [Summary PDF](/lecture_notes/Shadow_Attack.pdf) / [Code Practice](/code_practices/Shadow_Attack_Tutorial.ipynb)
* Sign-OPT: A Query-Efficient Hard-label Adversarial Attack (ICLR 2020)
    * [Original Paper Link](https://arxiv.org/abs/1909.10773) / Paper Review Video / Summary PDF / [MNIST](/code_practices/Sign_OPT_Attack_for_MNIST.ipynb) / [CIFAR-10](/code_practices/Sign_OPT_Attack_for_CIFAR_10.ipynb)
* Is BERT Really Robust? A Strong Baseline for Natural Language Attack on Text Classification and Entailment (AAAI 2020 Oral)
    * [Original Paper Link](https://arxiv.org/abs/1907.11932) / [Paper Review Video](https://www.youtube.com/watch?v=EF-IYFTKZiE) / [Summary PDF](/lecture_notes/TextFooler.pdf) / [Code Practice](/code_practices/TextFooler_Tutorial.ipynb)
* Query-Efficient Hard-label Black-box Attack: An Optimization-based Approach (ICLR 2019)
    * [Original Paper Link](https://arxiv.org/abs/1807.04457) / Paper Review Video / [Summary PDF](/lecture_notes/OPT_Attack.pdf) / [MNIST](/code_practices/Opt_Attack_for_MNIST.ipynb) / [CIFAR-10](/code_practices/Opt_Attack_for_CIFAR_10.ipynb)
* Boosting Adversarial Attacks with Momentum (CVPR 2018 Spotlight)
    * [Original Paper Link](https://arxiv.org/abs/1710.06081) / Paper Review Video / [Summary PDF](/lecture_notes/Boosting_Adversarial_Attacks_with_Momentum.pdf) / [CIFAR-10](/code_practices/MI_FGSM_Attack_for_CIFAR_10.ipynb) / [ImageNet](/code_practices/MI_FGSM_Attack_for_ImageNet.ipynb)
* Poison Frogs! Targeted Clean-Label Poisoning Attacks on Neural Networks (NIPS 2018)
    * [Original Paper Link](https://arxiv.org/abs/1804.00792) / Paper Review Video / [Summary PDF](/lecture_notes/Poison_Frogs.pdf) / [ResNet](/code_practices/One_Shot_Kill_Poison_Attack_ResNet.ipynb) / [AlexNet](/code_practices/One_Shot_Kill_Poison_Attack_AlexNet.ipynb)
* Decision-Based Adversarial Attacks: Reliable Attacks Against Black-Box Machine Learning Models (ICLR 2018)
    * [Original Paper Link](https://arxiv.org/abs/1712.04248) / [Paper Review Video](https://www.youtube.com/watch?v=3dX_SsO2mis) / [Summary PDF](/lecture_notes/Boundary_Attack.pdf) / Code Practice

### 지난 논문 리뷰 콘텐츠

* Explaining and Harnessing Adversarial Examples (ICLR 2015)
    * [Original Paper Link](https://arxiv.org/abs/1412.6572) / [Paper Review Video](https://www.youtube.com/watch?v=99uxhAjNwps)
* Towards Evaluating the Robustness of Neural Networks (S&P 2017)
    * [Original Paper Link](https://arxiv.org/abs/1608.04644) / [Paper Review Video](https://www.youtube.com/watch?v=9kRWHKPyfwQ)
* Towards Deep Learning Models Resistant to Adversarial Attacks (ICLR 2018)
    * [Original Paper Link](https://arxiv.org/abs/1706.06083) / [Paper Review Video](https://www.youtube.com/watch?v=6RBpdAC9nwY)
* Adversarial Examples Are Not Bugs, They Are Features (NIPS 2019)
    * [Original Paper Link](https://arxiv.org/abs/1905.02175) / [Paper Review Video](https://www.youtube.com/watch?v=Y7O47Kq8pmU)
* Certified Robustness to Adversarial Examples with Differential Privacy (S&P 2019)
    * [Original Paper Link](https://arxiv.org/abs/1802.03471) / [Paper Review Video](https://www.youtube.com/watch?v=ySJUlEVlXfk)
* Obfuscated Gradients Give a False Sense of Security (ICML 2018)
    * [Original Paper Link](https://arxiv.org/abs/1802.00420) / [Paper Review Video](https://www.youtube.com/watch?v=0O_Bxln9bTw)
* Constructing Unrestricted Adversarial Examples with Generative Models (NIPS 2018)
    * [Original Paper Link](https://arxiv.org/abs/1805.07894) / [Paper Review Video](https://www.youtube.com/watch?v=IDtaVjJoV4g)
* Adversarial Patch (NIPS 2018)
    * [Original Paper Link](https://arxiv.org/abs/1712.09665) / [Paper Review Video](https://www.youtube.com/watch?v=pOlPlTCfCQE)
