/** @type {import('next').NextConfig} */

const nextConfig = {
    reactStrictMode: false,
    rewrites: async () => {
        return [
          {
            source: "/api/:path*",
            destination:
              process.env.NODE_ENV === "development"
                ? "http://127.0.0.1:8000/api/:path*"
                : "/api/",
          },
          {
            source: "/docs",
            destination:
              process.env.NODE_ENV === "development"
                ? "http://127.0.0.1:8000/docs"
                : "/api/docs",
          },
          {
            source: "/openapi.json",
            destination:
              process.env.NODE_ENV === "development"
                ? "http://127.0.0.1:8000/openapi.json"
                : "/api/openapi.json",
          },
        ];
      },
    experimental: {
        ppr: 'incremental',
      },
    // output: "standalone"
};


export default nextConfig;
