import { useQueryClient } from "@tanstack/react-query";
import {
  getOrganizationsGetQueryKey,
  getOrganizationsListQueryKey,
  useOrganizationsUpdate
} from "../../../api/index-generated";

export function useRenameOrganizationMutation() {
  const queryClient = useQueryClient();

  const mutation = useOrganizationsUpdate({
    mutation: {
      onSuccess: (_, variables) => {
        return Promise.all([
          queryClient.invalidateQueries({
            queryKey: getOrganizationsGetQueryKey(variables.organizationId)
          }),
          queryClient.invalidateQueries({
            queryKey: getOrganizationsListQueryKey()
          })
        ]);
      }
    }
  });

  return mutation;
}
