/**
 * Generated by orval v6.31.0 🍺
 * Do not edit manually.
 * Navtrack.Api
 * OpenAPI spec version: 1.0.0
 */
import { useMutation, useQuery } from "@tanstack/react-query";
import type {
  MutationFunction,
  QueryFunction,
  QueryKey,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult
} from "@tanstack/react-query";
import type {
  Asset,
  AssetStatList,
  AssetsMessagesGetListParams,
  AssetsReportsGetTimeDistanceReportParams,
  AssetsTripsGetListParams,
  ChangePasswordModel,
  CreateAccount,
  CreateAsset,
  CreateAssetUser,
  CreateOrUpdateAssetDevice,
  CreateOrganization,
  CreateOrganizationUser,
  CreateTeam,
  CreateTeamAsset,
  CreateTeamUser,
  CurrentUser,
  DistanceReportList,
  Entity,
  Error,
  ForgotPassword,
  ListOfAsset,
  ListOfAssetUser,
  ListOfDevice,
  ListOfDeviceType,
  ListOfOrganization,
  ListOfOrganizationUser,
  ListOfProtocol,
  ListOfTeam,
  ListOfTeamAsset,
  ListOfTeamUser,
  MessageList,
  Organization,
  ProblemDetails,
  ResetPassword,
  Team,
  TripList,
  UpdateAsset,
  UpdateOrganizationModel,
  UpdateOrganizationUser,
  UpdateTeam,
  UpdateTeamUser,
  UpdateUserModel
} from "./model/generated";
import { authAxiosInstance } from "./authAxiosInstance";

type AwaitedInput<T> = PromiseLike<T> | T;

type Awaited<O> = O extends AwaitedInput<infer T> ? T : never;

export const accountCreateAccount = (createAccount: CreateAccount) => {
  return authAxiosInstance<void>({
    url: `/account`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: createAccount
  });
};

export const getAccountCreateAccountMutationOptions = <
  TError = Error,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof accountCreateAccount>>,
    TError,
    { data: CreateAccount },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof accountCreateAccount>>,
  TError,
  { data: CreateAccount },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof accountCreateAccount>>,
    { data: CreateAccount }
  > = (props) => {
    const { data } = props ?? {};

    return accountCreateAccount(data);
  };

  return { mutationFn, ...mutationOptions };
};

export type AccountCreateAccountMutationResult = NonNullable<
  Awaited<ReturnType<typeof accountCreateAccount>>
>;
export type AccountCreateAccountMutationBody = CreateAccount;
export type AccountCreateAccountMutationError = Error;

export const useAccountCreateAccount = <
  TError = Error,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof accountCreateAccount>>,
    TError,
    { data: CreateAccount },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof accountCreateAccount>>,
  TError,
  { data: CreateAccount },
  TContext
> => {
  const mutationOptions = getAccountCreateAccountMutationOptions(options);

  return useMutation(mutationOptions);
};

export const accountForgotPassword = (forgotPassword: ForgotPassword) => {
  return authAxiosInstance<void>({
    url: `/account/forgot-password`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: forgotPassword
  });
};

export const getAccountForgotPasswordMutationOptions = <
  TError = Error,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof accountForgotPassword>>,
    TError,
    { data: ForgotPassword },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof accountForgotPassword>>,
  TError,
  { data: ForgotPassword },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof accountForgotPassword>>,
    { data: ForgotPassword }
  > = (props) => {
    const { data } = props ?? {};

    return accountForgotPassword(data);
  };

  return { mutationFn, ...mutationOptions };
};

export type AccountForgotPasswordMutationResult = NonNullable<
  Awaited<ReturnType<typeof accountForgotPassword>>
>;
export type AccountForgotPasswordMutationBody = ForgotPassword;
export type AccountForgotPasswordMutationError = Error;

export const useAccountForgotPassword = <
  TError = Error,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof accountForgotPassword>>,
    TError,
    { data: ForgotPassword },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof accountForgotPassword>>,
  TError,
  { data: ForgotPassword },
  TContext
> => {
  const mutationOptions = getAccountForgotPasswordMutationOptions(options);

  return useMutation(mutationOptions);
};

export const accountResetPassword = (resetPassword: ResetPassword) => {
  return authAxiosInstance<void>({
    url: `/account/reset-password`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: resetPassword
  });
};

export const getAccountResetPasswordMutationOptions = <
  TError = Error,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof accountResetPassword>>,
    TError,
    { data: ResetPassword },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof accountResetPassword>>,
  TError,
  { data: ResetPassword },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof accountResetPassword>>,
    { data: ResetPassword }
  > = (props) => {
    const { data } = props ?? {};

    return accountResetPassword(data);
  };

  return { mutationFn, ...mutationOptions };
};

export type AccountResetPasswordMutationResult = NonNullable<
  Awaited<ReturnType<typeof accountResetPassword>>
>;
export type AccountResetPasswordMutationBody = ResetPassword;
export type AccountResetPasswordMutationError = Error;

export const useAccountResetPassword = <
  TError = Error,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof accountResetPassword>>,
    TError,
    { data: ResetPassword },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof accountResetPassword>>,
  TError,
  { data: ResetPassword },
  TContext
> => {
  const mutationOptions = getAccountResetPasswordMutationOptions(options);

  return useMutation(mutationOptions);
};

export const assetsGetList = (organizationId: string, signal?: AbortSignal) => {
  return authAxiosInstance<ListOfAsset>({
    url: `/organizations/${organizationId}/assets`,
    method: "GET",
    signal
  });
};

export const getAssetsGetListQueryKey = (organizationId: string) => {
  return [`/organizations/${organizationId}/assets`] as const;
};

export const getAssetsGetListQueryOptions = <
  TData = Awaited<ReturnType<typeof assetsGetList>>,
  TError = unknown
>(
  organizationId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsGetList>>,
      TError,
      TData
    >;
  }
) => {
  const { query: queryOptions } = options ?? {};

  const queryKey =
    queryOptions?.queryKey ?? getAssetsGetListQueryKey(organizationId);

  const queryFn: QueryFunction<Awaited<ReturnType<typeof assetsGetList>>> = ({
    signal
  }) => assetsGetList(organizationId, signal);

  return {
    queryKey,
    queryFn,
    enabled: !!organizationId,
    ...queryOptions
  } as UseQueryOptions<
    Awaited<ReturnType<typeof assetsGetList>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type AssetsGetListQueryResult = NonNullable<
  Awaited<ReturnType<typeof assetsGetList>>
>;
export type AssetsGetListQueryError = unknown;

export const useAssetsGetList = <
  TData = Awaited<ReturnType<typeof assetsGetList>>,
  TError = unknown
>(
  organizationId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsGetList>>,
      TError,
      TData
    >;
  }
): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getAssetsGetListQueryOptions(organizationId, options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const assetsCreate = (
  organizationId: string,
  createAsset: CreateAsset
) => {
  return authAxiosInstance<Entity>({
    url: `/organizations/${organizationId}/assets`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: createAsset
  });
};

export const getAssetsCreateMutationOptions = <
  TError = Error,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof assetsCreate>>,
    TError,
    { organizationId: string; data: CreateAsset },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof assetsCreate>>,
  TError,
  { organizationId: string; data: CreateAsset },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof assetsCreate>>,
    { organizationId: string; data: CreateAsset }
  > = (props) => {
    const { organizationId, data } = props ?? {};

    return assetsCreate(organizationId, data);
  };

  return { mutationFn, ...mutationOptions };
};

export type AssetsCreateMutationResult = NonNullable<
  Awaited<ReturnType<typeof assetsCreate>>
>;
export type AssetsCreateMutationBody = CreateAsset;
export type AssetsCreateMutationError = Error;

export const useAssetsCreate = <TError = Error, TContext = unknown>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof assetsCreate>>,
    TError,
    { organizationId: string; data: CreateAsset },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof assetsCreate>>,
  TError,
  { organizationId: string; data: CreateAsset },
  TContext
> => {
  const mutationOptions = getAssetsCreateMutationOptions(options);

  return useMutation(mutationOptions);
};

export const assetsGet = (assetId: string, signal?: AbortSignal) => {
  return authAxiosInstance<Asset>({
    url: `/assets/${assetId}`,
    method: "GET",
    signal
  });
};

export const getAssetsGetQueryKey = (assetId: string) => {
  return [`/assets/${assetId}`] as const;
};

export const getAssetsGetQueryOptions = <
  TData = Awaited<ReturnType<typeof assetsGet>>,
  TError = ProblemDetails
>(
  assetId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsGet>>,
      TError,
      TData
    >;
  }
) => {
  const { query: queryOptions } = options ?? {};

  const queryKey = queryOptions?.queryKey ?? getAssetsGetQueryKey(assetId);

  const queryFn: QueryFunction<Awaited<ReturnType<typeof assetsGet>>> = ({
    signal
  }) => assetsGet(assetId, signal);

  return {
    queryKey,
    queryFn,
    enabled: !!assetId,
    ...queryOptions
  } as UseQueryOptions<Awaited<ReturnType<typeof assetsGet>>, TError, TData> & {
    queryKey: QueryKey;
  };
};

export type AssetsGetQueryResult = NonNullable<
  Awaited<ReturnType<typeof assetsGet>>
>;
export type AssetsGetQueryError = ProblemDetails;

export const useAssetsGet = <
  TData = Awaited<ReturnType<typeof assetsGet>>,
  TError = ProblemDetails
>(
  assetId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsGet>>,
      TError,
      TData
    >;
  }
): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getAssetsGetQueryOptions(assetId, options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const assetsUpdate = (assetId: string, updateAsset: UpdateAsset) => {
  return authAxiosInstance<void>({
    url: `/assets/${assetId}`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: updateAsset
  });
};

export const getAssetsUpdateMutationOptions = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof assetsUpdate>>,
    TError,
    { assetId: string; data: UpdateAsset },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof assetsUpdate>>,
  TError,
  { assetId: string; data: UpdateAsset },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof assetsUpdate>>,
    { assetId: string; data: UpdateAsset }
  > = (props) => {
    const { assetId, data } = props ?? {};

    return assetsUpdate(assetId, data);
  };

  return { mutationFn, ...mutationOptions };
};

export type AssetsUpdateMutationResult = NonNullable<
  Awaited<ReturnType<typeof assetsUpdate>>
>;
export type AssetsUpdateMutationBody = UpdateAsset;
export type AssetsUpdateMutationError = Error | ProblemDetails;

export const useAssetsUpdate = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof assetsUpdate>>,
    TError,
    { assetId: string; data: UpdateAsset },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof assetsUpdate>>,
  TError,
  { assetId: string; data: UpdateAsset },
  TContext
> => {
  const mutationOptions = getAssetsUpdateMutationOptions(options);

  return useMutation(mutationOptions);
};

export const assetsDelete = (assetId: string) => {
  return authAxiosInstance<void>({
    url: `/assets/${assetId}`,
    method: "DELETE"
  });
};

export const getAssetsDeleteMutationOptions = <
  TError = ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof assetsDelete>>,
    TError,
    { assetId: string },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof assetsDelete>>,
  TError,
  { assetId: string },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof assetsDelete>>,
    { assetId: string }
  > = (props) => {
    const { assetId } = props ?? {};

    return assetsDelete(assetId);
  };

  return { mutationFn, ...mutationOptions };
};

export type AssetsDeleteMutationResult = NonNullable<
  Awaited<ReturnType<typeof assetsDelete>>
>;

export type AssetsDeleteMutationError = ProblemDetails;

export const useAssetsDelete = <
  TError = ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof assetsDelete>>,
    TError,
    { assetId: string },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof assetsDelete>>,
  TError,
  { assetId: string },
  TContext
> => {
  const mutationOptions = getAssetsDeleteMutationOptions(options);

  return useMutation(mutationOptions);
};

export const assetsDevicesGetList = (assetId: string, signal?: AbortSignal) => {
  return authAxiosInstance<ListOfDevice>({
    url: `/assets/${assetId}/devices`,
    method: "GET",
    signal
  });
};

export const getAssetsDevicesGetListQueryKey = (assetId: string) => {
  return [`/assets/${assetId}/devices`] as const;
};

export const getAssetsDevicesGetListQueryOptions = <
  TData = Awaited<ReturnType<typeof assetsDevicesGetList>>,
  TError = ProblemDetails
>(
  assetId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsDevicesGetList>>,
      TError,
      TData
    >;
  }
) => {
  const { query: queryOptions } = options ?? {};

  const queryKey =
    queryOptions?.queryKey ?? getAssetsDevicesGetListQueryKey(assetId);

  const queryFn: QueryFunction<
    Awaited<ReturnType<typeof assetsDevicesGetList>>
  > = ({ signal }) => assetsDevicesGetList(assetId, signal);

  return {
    queryKey,
    queryFn,
    enabled: !!assetId,
    ...queryOptions
  } as UseQueryOptions<
    Awaited<ReturnType<typeof assetsDevicesGetList>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type AssetsDevicesGetListQueryResult = NonNullable<
  Awaited<ReturnType<typeof assetsDevicesGetList>>
>;
export type AssetsDevicesGetListQueryError = ProblemDetails;

export const useAssetsDevicesGetList = <
  TData = Awaited<ReturnType<typeof assetsDevicesGetList>>,
  TError = ProblemDetails
>(
  assetId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsDevicesGetList>>,
      TError,
      TData
    >;
  }
): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getAssetsDevicesGetListQueryOptions(assetId, options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const assetsDevicesCreateOrUpdate = (
  assetId: string,
  createOrUpdateAssetDevice: CreateOrUpdateAssetDevice
) => {
  return authAxiosInstance<void>({
    url: `/assets/${assetId}/devices`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: createOrUpdateAssetDevice
  });
};

export const getAssetsDevicesCreateOrUpdateMutationOptions = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof assetsDevicesCreateOrUpdate>>,
    TError,
    { assetId: string; data: CreateOrUpdateAssetDevice },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof assetsDevicesCreateOrUpdate>>,
  TError,
  { assetId: string; data: CreateOrUpdateAssetDevice },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof assetsDevicesCreateOrUpdate>>,
    { assetId: string; data: CreateOrUpdateAssetDevice }
  > = (props) => {
    const { assetId, data } = props ?? {};

    return assetsDevicesCreateOrUpdate(assetId, data);
  };

  return { mutationFn, ...mutationOptions };
};

export type AssetsDevicesCreateOrUpdateMutationResult = NonNullable<
  Awaited<ReturnType<typeof assetsDevicesCreateOrUpdate>>
>;
export type AssetsDevicesCreateOrUpdateMutationBody = CreateOrUpdateAssetDevice;
export type AssetsDevicesCreateOrUpdateMutationError = Error | ProblemDetails;

export const useAssetsDevicesCreateOrUpdate = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof assetsDevicesCreateOrUpdate>>,
    TError,
    { assetId: string; data: CreateOrUpdateAssetDevice },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof assetsDevicesCreateOrUpdate>>,
  TError,
  { assetId: string; data: CreateOrUpdateAssetDevice },
  TContext
> => {
  const mutationOptions =
    getAssetsDevicesCreateOrUpdateMutationOptions(options);

  return useMutation(mutationOptions);
};

export const assetsDevicesDelete = (assetId: string, deviceId: string) => {
  return authAxiosInstance<void>({
    url: `/assets/${assetId}/devices/${deviceId}`,
    method: "DELETE"
  });
};

export const getAssetsDevicesDeleteMutationOptions = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof assetsDevicesDelete>>,
    TError,
    { assetId: string; deviceId: string },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof assetsDevicesDelete>>,
  TError,
  { assetId: string; deviceId: string },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof assetsDevicesDelete>>,
    { assetId: string; deviceId: string }
  > = (props) => {
    const { assetId, deviceId } = props ?? {};

    return assetsDevicesDelete(assetId, deviceId);
  };

  return { mutationFn, ...mutationOptions };
};

export type AssetsDevicesDeleteMutationResult = NonNullable<
  Awaited<ReturnType<typeof assetsDevicesDelete>>
>;

export type AssetsDevicesDeleteMutationError = Error | ProblemDetails;

export const useAssetsDevicesDelete = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof assetsDevicesDelete>>,
    TError,
    { assetId: string; deviceId: string },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof assetsDevicesDelete>>,
  TError,
  { assetId: string; deviceId: string },
  TContext
> => {
  const mutationOptions = getAssetsDevicesDeleteMutationOptions(options);

  return useMutation(mutationOptions);
};

export const assetsMessagesGetList = (
  assetId: string,
  params?: AssetsMessagesGetListParams,
  signal?: AbortSignal
) => {
  return authAxiosInstance<MessageList>({
    url: `/assets/${assetId}/messages`,
    method: "GET",
    params,
    signal
  });
};

export const getAssetsMessagesGetListQueryKey = (
  assetId: string,
  params?: AssetsMessagesGetListParams
) => {
  return [`/assets/${assetId}/messages`, ...(params ? [params] : [])] as const;
};

export const getAssetsMessagesGetListQueryOptions = <
  TData = Awaited<ReturnType<typeof assetsMessagesGetList>>,
  TError = ProblemDetails
>(
  assetId: string,
  params?: AssetsMessagesGetListParams,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsMessagesGetList>>,
      TError,
      TData
    >;
  }
) => {
  const { query: queryOptions } = options ?? {};

  const queryKey =
    queryOptions?.queryKey ?? getAssetsMessagesGetListQueryKey(assetId, params);

  const queryFn: QueryFunction<
    Awaited<ReturnType<typeof assetsMessagesGetList>>
  > = ({ signal }) => assetsMessagesGetList(assetId, params, signal);

  return {
    queryKey,
    queryFn,
    enabled: !!assetId,
    ...queryOptions
  } as UseQueryOptions<
    Awaited<ReturnType<typeof assetsMessagesGetList>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type AssetsMessagesGetListQueryResult = NonNullable<
  Awaited<ReturnType<typeof assetsMessagesGetList>>
>;
export type AssetsMessagesGetListQueryError = ProblemDetails;

export const useAssetsMessagesGetList = <
  TData = Awaited<ReturnType<typeof assetsMessagesGetList>>,
  TError = ProblemDetails
>(
  assetId: string,
  params?: AssetsMessagesGetListParams,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsMessagesGetList>>,
      TError,
      TData
    >;
  }
): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getAssetsMessagesGetListQueryOptions(
    assetId,
    params,
    options
  );

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const assetsReportsGetTimeDistanceReport = (
  assetId: string,
  params?: AssetsReportsGetTimeDistanceReportParams,
  signal?: AbortSignal
) => {
  return authAxiosInstance<DistanceReportList>({
    url: `/assets/${assetId}/reports/time-distance`,
    method: "GET",
    params,
    signal
  });
};

export const getAssetsReportsGetTimeDistanceReportQueryKey = (
  assetId: string,
  params?: AssetsReportsGetTimeDistanceReportParams
) => {
  return [
    `/assets/${assetId}/reports/time-distance`,
    ...(params ? [params] : [])
  ] as const;
};

export const getAssetsReportsGetTimeDistanceReportQueryOptions = <
  TData = Awaited<ReturnType<typeof assetsReportsGetTimeDistanceReport>>,
  TError = ProblemDetails
>(
  assetId: string,
  params?: AssetsReportsGetTimeDistanceReportParams,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsReportsGetTimeDistanceReport>>,
      TError,
      TData
    >;
  }
) => {
  const { query: queryOptions } = options ?? {};

  const queryKey =
    queryOptions?.queryKey ??
    getAssetsReportsGetTimeDistanceReportQueryKey(assetId, params);

  const queryFn: QueryFunction<
    Awaited<ReturnType<typeof assetsReportsGetTimeDistanceReport>>
  > = ({ signal }) =>
    assetsReportsGetTimeDistanceReport(assetId, params, signal);

  return {
    queryKey,
    queryFn,
    enabled: !!assetId,
    ...queryOptions
  } as UseQueryOptions<
    Awaited<ReturnType<typeof assetsReportsGetTimeDistanceReport>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type AssetsReportsGetTimeDistanceReportQueryResult = NonNullable<
  Awaited<ReturnType<typeof assetsReportsGetTimeDistanceReport>>
>;
export type AssetsReportsGetTimeDistanceReportQueryError = ProblemDetails;

export const useAssetsReportsGetTimeDistanceReport = <
  TData = Awaited<ReturnType<typeof assetsReportsGetTimeDistanceReport>>,
  TError = ProblemDetails
>(
  assetId: string,
  params?: AssetsReportsGetTimeDistanceReportParams,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsReportsGetTimeDistanceReport>>,
      TError,
      TData
    >;
  }
): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getAssetsReportsGetTimeDistanceReportQueryOptions(
    assetId,
    params,
    options
  );

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const assetsStatsGet = (assetId: string, signal?: AbortSignal) => {
  return authAxiosInstance<AssetStatList>({
    url: `/assets/${assetId}/stats`,
    method: "GET",
    signal
  });
};

export const getAssetsStatsGetQueryKey = (assetId: string) => {
  return [`/assets/${assetId}/stats`] as const;
};

export const getAssetsStatsGetQueryOptions = <
  TData = Awaited<ReturnType<typeof assetsStatsGet>>,
  TError = ProblemDetails
>(
  assetId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsStatsGet>>,
      TError,
      TData
    >;
  }
) => {
  const { query: queryOptions } = options ?? {};

  const queryKey = queryOptions?.queryKey ?? getAssetsStatsGetQueryKey(assetId);

  const queryFn: QueryFunction<Awaited<ReturnType<typeof assetsStatsGet>>> = ({
    signal
  }) => assetsStatsGet(assetId, signal);

  return {
    queryKey,
    queryFn,
    enabled: !!assetId,
    ...queryOptions
  } as UseQueryOptions<
    Awaited<ReturnType<typeof assetsStatsGet>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type AssetsStatsGetQueryResult = NonNullable<
  Awaited<ReturnType<typeof assetsStatsGet>>
>;
export type AssetsStatsGetQueryError = ProblemDetails;

export const useAssetsStatsGet = <
  TData = Awaited<ReturnType<typeof assetsStatsGet>>,
  TError = ProblemDetails
>(
  assetId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsStatsGet>>,
      TError,
      TData
    >;
  }
): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getAssetsStatsGetQueryOptions(assetId, options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const assetsTripsGetList = (
  assetId: string,
  params?: AssetsTripsGetListParams,
  signal?: AbortSignal
) => {
  return authAxiosInstance<TripList>({
    url: `/assets/${assetId}/trips`,
    method: "GET",
    params,
    signal
  });
};

export const getAssetsTripsGetListQueryKey = (
  assetId: string,
  params?: AssetsTripsGetListParams
) => {
  return [`/assets/${assetId}/trips`, ...(params ? [params] : [])] as const;
};

export const getAssetsTripsGetListQueryOptions = <
  TData = Awaited<ReturnType<typeof assetsTripsGetList>>,
  TError = ProblemDetails
>(
  assetId: string,
  params?: AssetsTripsGetListParams,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsTripsGetList>>,
      TError,
      TData
    >;
  }
) => {
  const { query: queryOptions } = options ?? {};

  const queryKey =
    queryOptions?.queryKey ?? getAssetsTripsGetListQueryKey(assetId, params);

  const queryFn: QueryFunction<
    Awaited<ReturnType<typeof assetsTripsGetList>>
  > = ({ signal }) => assetsTripsGetList(assetId, params, signal);

  return {
    queryKey,
    queryFn,
    enabled: !!assetId,
    ...queryOptions
  } as UseQueryOptions<
    Awaited<ReturnType<typeof assetsTripsGetList>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type AssetsTripsGetListQueryResult = NonNullable<
  Awaited<ReturnType<typeof assetsTripsGetList>>
>;
export type AssetsTripsGetListQueryError = ProblemDetails;

export const useAssetsTripsGetList = <
  TData = Awaited<ReturnType<typeof assetsTripsGetList>>,
  TError = ProblemDetails
>(
  assetId: string,
  params?: AssetsTripsGetListParams,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsTripsGetList>>,
      TError,
      TData
    >;
  }
): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getAssetsTripsGetListQueryOptions(
    assetId,
    params,
    options
  );

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const assetsUsersGetList = (assetId: string, signal?: AbortSignal) => {
  return authAxiosInstance<ListOfAssetUser>({
    url: `/assets/${assetId}/users`,
    method: "GET",
    signal
  });
};

export const getAssetsUsersGetListQueryKey = (assetId: string) => {
  return [`/assets/${assetId}/users`] as const;
};

export const getAssetsUsersGetListQueryOptions = <
  TData = Awaited<ReturnType<typeof assetsUsersGetList>>,
  TError = ProblemDetails
>(
  assetId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsUsersGetList>>,
      TError,
      TData
    >;
  }
) => {
  const { query: queryOptions } = options ?? {};

  const queryKey =
    queryOptions?.queryKey ?? getAssetsUsersGetListQueryKey(assetId);

  const queryFn: QueryFunction<
    Awaited<ReturnType<typeof assetsUsersGetList>>
  > = ({ signal }) => assetsUsersGetList(assetId, signal);

  return {
    queryKey,
    queryFn,
    enabled: !!assetId,
    ...queryOptions
  } as UseQueryOptions<
    Awaited<ReturnType<typeof assetsUsersGetList>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type AssetsUsersGetListQueryResult = NonNullable<
  Awaited<ReturnType<typeof assetsUsersGetList>>
>;
export type AssetsUsersGetListQueryError = ProblemDetails;

export const useAssetsUsersGetList = <
  TData = Awaited<ReturnType<typeof assetsUsersGetList>>,
  TError = ProblemDetails
>(
  assetId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof assetsUsersGetList>>,
      TError,
      TData
    >;
  }
): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getAssetsUsersGetListQueryOptions(assetId, options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const assetsUsersCreate = (
  assetId: string,
  createAssetUser: CreateAssetUser
) => {
  return authAxiosInstance<void>({
    url: `/assets/${assetId}/users`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: createAssetUser
  });
};

export const getAssetsUsersCreateMutationOptions = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof assetsUsersCreate>>,
    TError,
    { assetId: string; data: CreateAssetUser },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof assetsUsersCreate>>,
  TError,
  { assetId: string; data: CreateAssetUser },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof assetsUsersCreate>>,
    { assetId: string; data: CreateAssetUser }
  > = (props) => {
    const { assetId, data } = props ?? {};

    return assetsUsersCreate(assetId, data);
  };

  return { mutationFn, ...mutationOptions };
};

export type AssetsUsersCreateMutationResult = NonNullable<
  Awaited<ReturnType<typeof assetsUsersCreate>>
>;
export type AssetsUsersCreateMutationBody = CreateAssetUser;
export type AssetsUsersCreateMutationError = Error | ProblemDetails;

export const useAssetsUsersCreate = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof assetsUsersCreate>>,
    TError,
    { assetId: string; data: CreateAssetUser },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof assetsUsersCreate>>,
  TError,
  { assetId: string; data: CreateAssetUser },
  TContext
> => {
  const mutationOptions = getAssetsUsersCreateMutationOptions(options);

  return useMutation(mutationOptions);
};

export const assetsUsersDelete = (assetId: string, userId: string) => {
  return authAxiosInstance<void>({
    url: `/assets/${assetId}/users/${userId}`,
    method: "DELETE"
  });
};

export const getAssetsUsersDeleteMutationOptions = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof assetsUsersDelete>>,
    TError,
    { assetId: string; userId: string },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof assetsUsersDelete>>,
  TError,
  { assetId: string; userId: string },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof assetsUsersDelete>>,
    { assetId: string; userId: string }
  > = (props) => {
    const { assetId, userId } = props ?? {};

    return assetsUsersDelete(assetId, userId);
  };

  return { mutationFn, ...mutationOptions };
};

export type AssetsUsersDeleteMutationResult = NonNullable<
  Awaited<ReturnType<typeof assetsUsersDelete>>
>;

export type AssetsUsersDeleteMutationError = Error | ProblemDetails;

export const useAssetsUsersDelete = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof assetsUsersDelete>>,
    TError,
    { assetId: string; userId: string },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof assetsUsersDelete>>,
  TError,
  { assetId: string; userId: string },
  TContext
> => {
  const mutationOptions = getAssetsUsersDeleteMutationOptions(options);

  return useMutation(mutationOptions);
};

export const devicesGetList = (signal?: AbortSignal) => {
  return authAxiosInstance<ListOfDeviceType>({
    url: `/devices/types`,
    method: "GET",
    signal
  });
};

export const getDevicesGetListQueryKey = () => {
  return [`/devices/types`] as const;
};

export const getDevicesGetListQueryOptions = <
  TData = Awaited<ReturnType<typeof devicesGetList>>,
  TError = unknown
>(options?: {
  query?: UseQueryOptions<
    Awaited<ReturnType<typeof devicesGetList>>,
    TError,
    TData
  >;
}) => {
  const { query: queryOptions } = options ?? {};

  const queryKey = queryOptions?.queryKey ?? getDevicesGetListQueryKey();

  const queryFn: QueryFunction<Awaited<ReturnType<typeof devicesGetList>>> = ({
    signal
  }) => devicesGetList(signal);

  return { queryKey, queryFn, ...queryOptions } as UseQueryOptions<
    Awaited<ReturnType<typeof devicesGetList>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type DevicesGetListQueryResult = NonNullable<
  Awaited<ReturnType<typeof devicesGetList>>
>;
export type DevicesGetListQueryError = unknown;

export const useDevicesGetList = <
  TData = Awaited<ReturnType<typeof devicesGetList>>,
  TError = unknown
>(options?: {
  query?: UseQueryOptions<
    Awaited<ReturnType<typeof devicesGetList>>,
    TError,
    TData
  >;
}): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getDevicesGetListQueryOptions(options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const healthGet = (signal?: AbortSignal) => {
  return authAxiosInstance<void>({ url: `/health`, method: "GET", signal });
};

export const getHealthGetQueryKey = () => {
  return [`/health`] as const;
};

export const getHealthGetQueryOptions = <
  TData = Awaited<ReturnType<typeof healthGet>>,
  TError = unknown
>(options?: {
  query?: UseQueryOptions<Awaited<ReturnType<typeof healthGet>>, TError, TData>;
}) => {
  const { query: queryOptions } = options ?? {};

  const queryKey = queryOptions?.queryKey ?? getHealthGetQueryKey();

  const queryFn: QueryFunction<Awaited<ReturnType<typeof healthGet>>> = ({
    signal
  }) => healthGet(signal);

  return { queryKey, queryFn, ...queryOptions } as UseQueryOptions<
    Awaited<ReturnType<typeof healthGet>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type HealthGetQueryResult = NonNullable<
  Awaited<ReturnType<typeof healthGet>>
>;
export type HealthGetQueryError = unknown;

export const useHealthGet = <
  TData = Awaited<ReturnType<typeof healthGet>>,
  TError = unknown
>(options?: {
  query?: UseQueryOptions<Awaited<ReturnType<typeof healthGet>>, TError, TData>;
}): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getHealthGetQueryOptions(options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const organizationsList = (signal?: AbortSignal) => {
  return authAxiosInstance<ListOfOrganization>({
    url: `/organizations`,
    method: "GET",
    signal
  });
};

export const getOrganizationsListQueryKey = () => {
  return [`/organizations`] as const;
};

export const getOrganizationsListQueryOptions = <
  TData = Awaited<ReturnType<typeof organizationsList>>,
  TError = ProblemDetails
>(options?: {
  query?: UseQueryOptions<
    Awaited<ReturnType<typeof organizationsList>>,
    TError,
    TData
  >;
}) => {
  const { query: queryOptions } = options ?? {};

  const queryKey = queryOptions?.queryKey ?? getOrganizationsListQueryKey();

  const queryFn: QueryFunction<
    Awaited<ReturnType<typeof organizationsList>>
  > = ({ signal }) => organizationsList(signal);

  return { queryKey, queryFn, ...queryOptions } as UseQueryOptions<
    Awaited<ReturnType<typeof organizationsList>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type OrganizationsListQueryResult = NonNullable<
  Awaited<ReturnType<typeof organizationsList>>
>;
export type OrganizationsListQueryError = ProblemDetails;

export const useOrganizationsList = <
  TData = Awaited<ReturnType<typeof organizationsList>>,
  TError = ProblemDetails
>(options?: {
  query?: UseQueryOptions<
    Awaited<ReturnType<typeof organizationsList>>,
    TError,
    TData
  >;
}): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getOrganizationsListQueryOptions(options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const organizationsCreate = (createOrganization: CreateOrganization) => {
  return authAxiosInstance<Entity>({
    url: `/organizations`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: createOrganization
  });
};

export const getOrganizationsCreateMutationOptions = <
  TError = Error,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof organizationsCreate>>,
    TError,
    { data: CreateOrganization },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof organizationsCreate>>,
  TError,
  { data: CreateOrganization },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof organizationsCreate>>,
    { data: CreateOrganization }
  > = (props) => {
    const { data } = props ?? {};

    return organizationsCreate(data);
  };

  return { mutationFn, ...mutationOptions };
};

export type OrganizationsCreateMutationResult = NonNullable<
  Awaited<ReturnType<typeof organizationsCreate>>
>;
export type OrganizationsCreateMutationBody = CreateOrganization;
export type OrganizationsCreateMutationError = Error;

export const useOrganizationsCreate = <
  TError = Error,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof organizationsCreate>>,
    TError,
    { data: CreateOrganization },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof organizationsCreate>>,
  TError,
  { data: CreateOrganization },
  TContext
> => {
  const mutationOptions = getOrganizationsCreateMutationOptions(options);

  return useMutation(mutationOptions);
};

export const organizationsGet = (
  organizationId: string,
  signal?: AbortSignal
) => {
  return authAxiosInstance<Organization>({
    url: `/organizations/${organizationId}`,
    method: "GET",
    signal
  });
};

export const getOrganizationsGetQueryKey = (organizationId: string) => {
  return [`/organizations/${organizationId}`] as const;
};

export const getOrganizationsGetQueryOptions = <
  TData = Awaited<ReturnType<typeof organizationsGet>>,
  TError = ProblemDetails
>(
  organizationId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof organizationsGet>>,
      TError,
      TData
    >;
  }
) => {
  const { query: queryOptions } = options ?? {};

  const queryKey =
    queryOptions?.queryKey ?? getOrganizationsGetQueryKey(organizationId);

  const queryFn: QueryFunction<
    Awaited<ReturnType<typeof organizationsGet>>
  > = ({ signal }) => organizationsGet(organizationId, signal);

  return {
    queryKey,
    queryFn,
    enabled: !!organizationId,
    ...queryOptions
  } as UseQueryOptions<
    Awaited<ReturnType<typeof organizationsGet>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type OrganizationsGetQueryResult = NonNullable<
  Awaited<ReturnType<typeof organizationsGet>>
>;
export type OrganizationsGetQueryError = ProblemDetails;

export const useOrganizationsGet = <
  TData = Awaited<ReturnType<typeof organizationsGet>>,
  TError = ProblemDetails
>(
  organizationId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof organizationsGet>>,
      TError,
      TData
    >;
  }
): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getOrganizationsGetQueryOptions(organizationId, options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const organizationsUpdate = (
  organizationId: string,
  updateOrganizationModel: UpdateOrganizationModel
) => {
  return authAxiosInstance<void>({
    url: `/organizations/${organizationId}`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: updateOrganizationModel
  });
};

export const getOrganizationsUpdateMutationOptions = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof organizationsUpdate>>,
    TError,
    { organizationId: string; data: UpdateOrganizationModel },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof organizationsUpdate>>,
  TError,
  { organizationId: string; data: UpdateOrganizationModel },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof organizationsUpdate>>,
    { organizationId: string; data: UpdateOrganizationModel }
  > = (props) => {
    const { organizationId, data } = props ?? {};

    return organizationsUpdate(organizationId, data);
  };

  return { mutationFn, ...mutationOptions };
};

export type OrganizationsUpdateMutationResult = NonNullable<
  Awaited<ReturnType<typeof organizationsUpdate>>
>;
export type OrganizationsUpdateMutationBody = UpdateOrganizationModel;
export type OrganizationsUpdateMutationError = Error | ProblemDetails;

export const useOrganizationsUpdate = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof organizationsUpdate>>,
    TError,
    { organizationId: string; data: UpdateOrganizationModel },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof organizationsUpdate>>,
  TError,
  { organizationId: string; data: UpdateOrganizationModel },
  TContext
> => {
  const mutationOptions = getOrganizationsUpdateMutationOptions(options);

  return useMutation(mutationOptions);
};

export const organizationsDelete = (organizationId: string) => {
  return authAxiosInstance<void>({
    url: `/organizations/${organizationId}`,
    method: "DELETE"
  });
};

export const getOrganizationsDeleteMutationOptions = <
  TError = ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof organizationsDelete>>,
    TError,
    { organizationId: string },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof organizationsDelete>>,
  TError,
  { organizationId: string },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof organizationsDelete>>,
    { organizationId: string }
  > = (props) => {
    const { organizationId } = props ?? {};

    return organizationsDelete(organizationId);
  };

  return { mutationFn, ...mutationOptions };
};

export type OrganizationsDeleteMutationResult = NonNullable<
  Awaited<ReturnType<typeof organizationsDelete>>
>;

export type OrganizationsDeleteMutationError = ProblemDetails;

export const useOrganizationsDelete = <
  TError = ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof organizationsDelete>>,
    TError,
    { organizationId: string },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof organizationsDelete>>,
  TError,
  { organizationId: string },
  TContext
> => {
  const mutationOptions = getOrganizationsDeleteMutationOptions(options);

  return useMutation(mutationOptions);
};

export const protocolsGetList = (signal?: AbortSignal) => {
  return authAxiosInstance<ListOfProtocol>({
    url: `/protocols`,
    method: "GET",
    signal
  });
};

export const getProtocolsGetListQueryKey = () => {
  return [`/protocols`] as const;
};

export const getProtocolsGetListQueryOptions = <
  TData = Awaited<ReturnType<typeof protocolsGetList>>,
  TError = unknown
>(options?: {
  query?: UseQueryOptions<
    Awaited<ReturnType<typeof protocolsGetList>>,
    TError,
    TData
  >;
}) => {
  const { query: queryOptions } = options ?? {};

  const queryKey = queryOptions?.queryKey ?? getProtocolsGetListQueryKey();

  const queryFn: QueryFunction<
    Awaited<ReturnType<typeof protocolsGetList>>
  > = ({ signal }) => protocolsGetList(signal);

  return { queryKey, queryFn, ...queryOptions } as UseQueryOptions<
    Awaited<ReturnType<typeof protocolsGetList>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type ProtocolsGetListQueryResult = NonNullable<
  Awaited<ReturnType<typeof protocolsGetList>>
>;
export type ProtocolsGetListQueryError = unknown;

export const useProtocolsGetList = <
  TData = Awaited<ReturnType<typeof protocolsGetList>>,
  TError = unknown
>(options?: {
  query?: UseQueryOptions<
    Awaited<ReturnType<typeof protocolsGetList>>,
    TError,
    TData
  >;
}): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getProtocolsGetListQueryOptions(options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const teamsAssetsList = (teamId: string, signal?: AbortSignal) => {
  return authAxiosInstance<ListOfTeamAsset>({
    url: `/teams/${teamId}/assets`,
    method: "GET",
    signal
  });
};

export const getTeamsAssetsListQueryKey = (teamId: string) => {
  return [`/teams/${teamId}/assets`] as const;
};

export const getTeamsAssetsListQueryOptions = <
  TData = Awaited<ReturnType<typeof teamsAssetsList>>,
  TError = ProblemDetails
>(
  teamId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof teamsAssetsList>>,
      TError,
      TData
    >;
  }
) => {
  const { query: queryOptions } = options ?? {};

  const queryKey = queryOptions?.queryKey ?? getTeamsAssetsListQueryKey(teamId);

  const queryFn: QueryFunction<Awaited<ReturnType<typeof teamsAssetsList>>> = ({
    signal
  }) => teamsAssetsList(teamId, signal);

  return {
    queryKey,
    queryFn,
    enabled: !!teamId,
    ...queryOptions
  } as UseQueryOptions<
    Awaited<ReturnType<typeof teamsAssetsList>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type TeamsAssetsListQueryResult = NonNullable<
  Awaited<ReturnType<typeof teamsAssetsList>>
>;
export type TeamsAssetsListQueryError = ProblemDetails;

export const useTeamsAssetsList = <
  TData = Awaited<ReturnType<typeof teamsAssetsList>>,
  TError = ProblemDetails
>(
  teamId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof teamsAssetsList>>,
      TError,
      TData
    >;
  }
): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getTeamsAssetsListQueryOptions(teamId, options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const teamsAssetsCreate = (
  teamId: string,
  createTeamAsset: CreateTeamAsset
) => {
  return authAxiosInstance<void>({
    url: `/teams/${teamId}/assets`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: createTeamAsset
  });
};

export const getTeamsAssetsCreateMutationOptions = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsAssetsCreate>>,
    TError,
    { teamId: string; data: CreateTeamAsset },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof teamsAssetsCreate>>,
  TError,
  { teamId: string; data: CreateTeamAsset },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof teamsAssetsCreate>>,
    { teamId: string; data: CreateTeamAsset }
  > = (props) => {
    const { teamId, data } = props ?? {};

    return teamsAssetsCreate(teamId, data);
  };

  return { mutationFn, ...mutationOptions };
};

export type TeamsAssetsCreateMutationResult = NonNullable<
  Awaited<ReturnType<typeof teamsAssetsCreate>>
>;
export type TeamsAssetsCreateMutationBody = CreateTeamAsset;
export type TeamsAssetsCreateMutationError = Error | ProblemDetails;

export const useTeamsAssetsCreate = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsAssetsCreate>>,
    TError,
    { teamId: string; data: CreateTeamAsset },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof teamsAssetsCreate>>,
  TError,
  { teamId: string; data: CreateTeamAsset },
  TContext
> => {
  const mutationOptions = getTeamsAssetsCreateMutationOptions(options);

  return useMutation(mutationOptions);
};

export const teamsAssetsDelete = (teamId: string, assetId: string) => {
  return authAxiosInstance<void>({
    url: `/teams/${teamId}/assets/${assetId}`,
    method: "DELETE"
  });
};

export const getTeamsAssetsDeleteMutationOptions = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsAssetsDelete>>,
    TError,
    { teamId: string; assetId: string },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof teamsAssetsDelete>>,
  TError,
  { teamId: string; assetId: string },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof teamsAssetsDelete>>,
    { teamId: string; assetId: string }
  > = (props) => {
    const { teamId, assetId } = props ?? {};

    return teamsAssetsDelete(teamId, assetId);
  };

  return { mutationFn, ...mutationOptions };
};

export type TeamsAssetsDeleteMutationResult = NonNullable<
  Awaited<ReturnType<typeof teamsAssetsDelete>>
>;

export type TeamsAssetsDeleteMutationError = Error | ProblemDetails;

export const useTeamsAssetsDelete = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsAssetsDelete>>,
    TError,
    { teamId: string; assetId: string },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof teamsAssetsDelete>>,
  TError,
  { teamId: string; assetId: string },
  TContext
> => {
  const mutationOptions = getTeamsAssetsDeleteMutationOptions(options);

  return useMutation(mutationOptions);
};

export const teamsGetList = (organizationId: string, signal?: AbortSignal) => {
  return authAxiosInstance<ListOfTeam>({
    url: `/organizations/${organizationId}/teams`,
    method: "GET",
    signal
  });
};

export const getTeamsGetListQueryKey = (organizationId: string) => {
  return [`/organizations/${organizationId}/teams`] as const;
};

export const getTeamsGetListQueryOptions = <
  TData = Awaited<ReturnType<typeof teamsGetList>>,
  TError = unknown
>(
  organizationId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof teamsGetList>>,
      TError,
      TData
    >;
  }
) => {
  const { query: queryOptions } = options ?? {};

  const queryKey =
    queryOptions?.queryKey ?? getTeamsGetListQueryKey(organizationId);

  const queryFn: QueryFunction<Awaited<ReturnType<typeof teamsGetList>>> = ({
    signal
  }) => teamsGetList(organizationId, signal);

  return {
    queryKey,
    queryFn,
    enabled: !!organizationId,
    ...queryOptions
  } as UseQueryOptions<
    Awaited<ReturnType<typeof teamsGetList>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type TeamsGetListQueryResult = NonNullable<
  Awaited<ReturnType<typeof teamsGetList>>
>;
export type TeamsGetListQueryError = unknown;

export const useTeamsGetList = <
  TData = Awaited<ReturnType<typeof teamsGetList>>,
  TError = unknown
>(
  organizationId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof teamsGetList>>,
      TError,
      TData
    >;
  }
): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getTeamsGetListQueryOptions(organizationId, options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const teamsCreate = (organizationId: string, createTeam: CreateTeam) => {
  return authAxiosInstance<Team>({
    url: `/organizations/${organizationId}/teams`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: createTeam
  });
};

export const getTeamsCreateMutationOptions = <
  TError = unknown,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsCreate>>,
    TError,
    { organizationId: string; data: CreateTeam },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof teamsCreate>>,
  TError,
  { organizationId: string; data: CreateTeam },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof teamsCreate>>,
    { organizationId: string; data: CreateTeam }
  > = (props) => {
    const { organizationId, data } = props ?? {};

    return teamsCreate(organizationId, data);
  };

  return { mutationFn, ...mutationOptions };
};

export type TeamsCreateMutationResult = NonNullable<
  Awaited<ReturnType<typeof teamsCreate>>
>;
export type TeamsCreateMutationBody = CreateTeam;
export type TeamsCreateMutationError = unknown;

export const useTeamsCreate = <TError = unknown, TContext = unknown>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsCreate>>,
    TError,
    { organizationId: string; data: CreateTeam },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof teamsCreate>>,
  TError,
  { organizationId: string; data: CreateTeam },
  TContext
> => {
  const mutationOptions = getTeamsCreateMutationOptions(options);

  return useMutation(mutationOptions);
};

export const teamsGet = (teamId: string, signal?: AbortSignal) => {
  return authAxiosInstance<Team>({
    url: `/teams/${teamId}`,
    method: "GET",
    signal
  });
};

export const getTeamsGetQueryKey = (teamId: string) => {
  return [`/teams/${teamId}`] as const;
};

export const getTeamsGetQueryOptions = <
  TData = Awaited<ReturnType<typeof teamsGet>>,
  TError = unknown
>(
  teamId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof teamsGet>>,
      TError,
      TData
    >;
  }
) => {
  const { query: queryOptions } = options ?? {};

  const queryKey = queryOptions?.queryKey ?? getTeamsGetQueryKey(teamId);

  const queryFn: QueryFunction<Awaited<ReturnType<typeof teamsGet>>> = ({
    signal
  }) => teamsGet(teamId, signal);

  return {
    queryKey,
    queryFn,
    enabled: !!teamId,
    ...queryOptions
  } as UseQueryOptions<Awaited<ReturnType<typeof teamsGet>>, TError, TData> & {
    queryKey: QueryKey;
  };
};

export type TeamsGetQueryResult = NonNullable<
  Awaited<ReturnType<typeof teamsGet>>
>;
export type TeamsGetQueryError = unknown;

export const useTeamsGet = <
  TData = Awaited<ReturnType<typeof teamsGet>>,
  TError = unknown
>(
  teamId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof teamsGet>>,
      TError,
      TData
    >;
  }
): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getTeamsGetQueryOptions(teamId, options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const teamsUpdate = (teamId: string, updateTeam: UpdateTeam) => {
  return authAxiosInstance<Blob>({
    url: `/teams/${teamId}`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: updateTeam,
    responseType: "blob"
  });
};

export const getTeamsUpdateMutationOptions = <
  TError = unknown,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsUpdate>>,
    TError,
    { teamId: string; data: UpdateTeam },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof teamsUpdate>>,
  TError,
  { teamId: string; data: UpdateTeam },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof teamsUpdate>>,
    { teamId: string; data: UpdateTeam }
  > = (props) => {
    const { teamId, data } = props ?? {};

    return teamsUpdate(teamId, data);
  };

  return { mutationFn, ...mutationOptions };
};

export type TeamsUpdateMutationResult = NonNullable<
  Awaited<ReturnType<typeof teamsUpdate>>
>;
export type TeamsUpdateMutationBody = UpdateTeam;
export type TeamsUpdateMutationError = unknown;

export const useTeamsUpdate = <TError = unknown, TContext = unknown>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsUpdate>>,
    TError,
    { teamId: string; data: UpdateTeam },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof teamsUpdate>>,
  TError,
  { teamId: string; data: UpdateTeam },
  TContext
> => {
  const mutationOptions = getTeamsUpdateMutationOptions(options);

  return useMutation(mutationOptions);
};

export const teamsDelete = (teamId: string) => {
  return authAxiosInstance<void>({ url: `/teams/${teamId}`, method: "DELETE" });
};

export const getTeamsDeleteMutationOptions = <
  TError = ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsDelete>>,
    TError,
    { teamId: string },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof teamsDelete>>,
  TError,
  { teamId: string },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof teamsDelete>>,
    { teamId: string }
  > = (props) => {
    const { teamId } = props ?? {};

    return teamsDelete(teamId);
  };

  return { mutationFn, ...mutationOptions };
};

export type TeamsDeleteMutationResult = NonNullable<
  Awaited<ReturnType<typeof teamsDelete>>
>;

export type TeamsDeleteMutationError = ProblemDetails;

export const useTeamsDelete = <
  TError = ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsDelete>>,
    TError,
    { teamId: string },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof teamsDelete>>,
  TError,
  { teamId: string },
  TContext
> => {
  const mutationOptions = getTeamsDeleteMutationOptions(options);

  return useMutation(mutationOptions);
};

export const teamsUsersList = (teamId: string, signal?: AbortSignal) => {
  return authAxiosInstance<ListOfTeamUser>({
    url: `/teams/${teamId}/users`,
    method: "GET",
    signal
  });
};

export const getTeamsUsersListQueryKey = (teamId: string) => {
  return [`/teams/${teamId}/users`] as const;
};

export const getTeamsUsersListQueryOptions = <
  TData = Awaited<ReturnType<typeof teamsUsersList>>,
  TError = ProblemDetails
>(
  teamId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof teamsUsersList>>,
      TError,
      TData
    >;
  }
) => {
  const { query: queryOptions } = options ?? {};

  const queryKey = queryOptions?.queryKey ?? getTeamsUsersListQueryKey(teamId);

  const queryFn: QueryFunction<Awaited<ReturnType<typeof teamsUsersList>>> = ({
    signal
  }) => teamsUsersList(teamId, signal);

  return {
    queryKey,
    queryFn,
    enabled: !!teamId,
    ...queryOptions
  } as UseQueryOptions<
    Awaited<ReturnType<typeof teamsUsersList>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type TeamsUsersListQueryResult = NonNullable<
  Awaited<ReturnType<typeof teamsUsersList>>
>;
export type TeamsUsersListQueryError = ProblemDetails;

export const useTeamsUsersList = <
  TData = Awaited<ReturnType<typeof teamsUsersList>>,
  TError = ProblemDetails
>(
  teamId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof teamsUsersList>>,
      TError,
      TData
    >;
  }
): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getTeamsUsersListQueryOptions(teamId, options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const teamsUsersCreate = (
  teamId: string,
  createTeamUser: CreateTeamUser
) => {
  return authAxiosInstance<void>({
    url: `/teams/${teamId}/users`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: createTeamUser
  });
};

export const getTeamsUsersCreateMutationOptions = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsUsersCreate>>,
    TError,
    { teamId: string; data: CreateTeamUser },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof teamsUsersCreate>>,
  TError,
  { teamId: string; data: CreateTeamUser },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof teamsUsersCreate>>,
    { teamId: string; data: CreateTeamUser }
  > = (props) => {
    const { teamId, data } = props ?? {};

    return teamsUsersCreate(teamId, data);
  };

  return { mutationFn, ...mutationOptions };
};

export type TeamsUsersCreateMutationResult = NonNullable<
  Awaited<ReturnType<typeof teamsUsersCreate>>
>;
export type TeamsUsersCreateMutationBody = CreateTeamUser;
export type TeamsUsersCreateMutationError = Error | ProblemDetails;

export const useTeamsUsersCreate = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsUsersCreate>>,
    TError,
    { teamId: string; data: CreateTeamUser },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof teamsUsersCreate>>,
  TError,
  { teamId: string; data: CreateTeamUser },
  TContext
> => {
  const mutationOptions = getTeamsUsersCreateMutationOptions(options);

  return useMutation(mutationOptions);
};

export const teamsUsersUpdate = (
  teamId: string,
  userId: string,
  updateTeamUser: UpdateTeamUser
) => {
  return authAxiosInstance<void>({
    url: `/teams/${teamId}/users/${userId}`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: updateTeamUser
  });
};

export const getTeamsUsersUpdateMutationOptions = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsUsersUpdate>>,
    TError,
    { teamId: string; userId: string; data: UpdateTeamUser },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof teamsUsersUpdate>>,
  TError,
  { teamId: string; userId: string; data: UpdateTeamUser },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof teamsUsersUpdate>>,
    { teamId: string; userId: string; data: UpdateTeamUser }
  > = (props) => {
    const { teamId, userId, data } = props ?? {};

    return teamsUsersUpdate(teamId, userId, data);
  };

  return { mutationFn, ...mutationOptions };
};

export type TeamsUsersUpdateMutationResult = NonNullable<
  Awaited<ReturnType<typeof teamsUsersUpdate>>
>;
export type TeamsUsersUpdateMutationBody = UpdateTeamUser;
export type TeamsUsersUpdateMutationError = Error | ProblemDetails;

export const useTeamsUsersUpdate = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsUsersUpdate>>,
    TError,
    { teamId: string; userId: string; data: UpdateTeamUser },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof teamsUsersUpdate>>,
  TError,
  { teamId: string; userId: string; data: UpdateTeamUser },
  TContext
> => {
  const mutationOptions = getTeamsUsersUpdateMutationOptions(options);

  return useMutation(mutationOptions);
};

export const teamsUsersDelete = (teamId: string, userId: string) => {
  return authAxiosInstance<void>({
    url: `/teams/${teamId}/users/${userId}`,
    method: "DELETE"
  });
};

export const getTeamsUsersDeleteMutationOptions = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsUsersDelete>>,
    TError,
    { teamId: string; userId: string },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof teamsUsersDelete>>,
  TError,
  { teamId: string; userId: string },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof teamsUsersDelete>>,
    { teamId: string; userId: string }
  > = (props) => {
    const { teamId, userId } = props ?? {};

    return teamsUsersDelete(teamId, userId);
  };

  return { mutationFn, ...mutationOptions };
};

export type TeamsUsersDeleteMutationResult = NonNullable<
  Awaited<ReturnType<typeof teamsUsersDelete>>
>;

export type TeamsUsersDeleteMutationError = Error | ProblemDetails;

export const useTeamsUsersDelete = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof teamsUsersDelete>>,
    TError,
    { teamId: string; userId: string },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof teamsUsersDelete>>,
  TError,
  { teamId: string; userId: string },
  TContext
> => {
  const mutationOptions = getTeamsUsersDeleteMutationOptions(options);

  return useMutation(mutationOptions);
};

export const userGet = (signal?: AbortSignal) => {
  return authAxiosInstance<CurrentUser>({
    url: `/user`,
    method: "GET",
    signal
  });
};

export const getUserGetQueryKey = () => {
  return [`/user`] as const;
};

export const getUserGetQueryOptions = <
  TData = Awaited<ReturnType<typeof userGet>>,
  TError = unknown
>(options?: {
  query?: UseQueryOptions<Awaited<ReturnType<typeof userGet>>, TError, TData>;
}) => {
  const { query: queryOptions } = options ?? {};

  const queryKey = queryOptions?.queryKey ?? getUserGetQueryKey();

  const queryFn: QueryFunction<Awaited<ReturnType<typeof userGet>>> = ({
    signal
  }) => userGet(signal);

  return { queryKey, queryFn, ...queryOptions } as UseQueryOptions<
    Awaited<ReturnType<typeof userGet>>,
    TError,
    TData
  > & { queryKey: QueryKey };
};

export type UserGetQueryResult = NonNullable<
  Awaited<ReturnType<typeof userGet>>
>;
export type UserGetQueryError = unknown;

export const useUserGet = <
  TData = Awaited<ReturnType<typeof userGet>>,
  TError = unknown
>(options?: {
  query?: UseQueryOptions<Awaited<ReturnType<typeof userGet>>, TError, TData>;
}): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getUserGetQueryOptions(options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const userUpdate = (updateUserModel: UpdateUserModel) => {
  return authAxiosInstance<void>({
    url: `/user`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: updateUserModel
  });
};

export const getUserUpdateMutationOptions = <
  TError = Error,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof userUpdate>>,
    TError,
    { data: UpdateUserModel },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof userUpdate>>,
  TError,
  { data: UpdateUserModel },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof userUpdate>>,
    { data: UpdateUserModel }
  > = (props) => {
    const { data } = props ?? {};

    return userUpdate(data);
  };

  return { mutationFn, ...mutationOptions };
};

export type UserUpdateMutationResult = NonNullable<
  Awaited<ReturnType<typeof userUpdate>>
>;
export type UserUpdateMutationBody = UpdateUserModel;
export type UserUpdateMutationError = Error;

export const useUserUpdate = <TError = Error, TContext = unknown>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof userUpdate>>,
    TError,
    { data: UpdateUserModel },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof userUpdate>>,
  TError,
  { data: UpdateUserModel },
  TContext
> => {
  const mutationOptions = getUserUpdateMutationOptions(options);

  return useMutation(mutationOptions);
};

export const userChangePassword = (
  changePasswordModel: ChangePasswordModel
) => {
  return authAxiosInstance<void>({
    url: `/user/change-password`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: changePasswordModel
  });
};

export const getUserChangePasswordMutationOptions = <
  TError = Error,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof userChangePassword>>,
    TError,
    { data: ChangePasswordModel },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof userChangePassword>>,
  TError,
  { data: ChangePasswordModel },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof userChangePassword>>,
    { data: ChangePasswordModel }
  > = (props) => {
    const { data } = props ?? {};

    return userChangePassword(data);
  };

  return { mutationFn, ...mutationOptions };
};

export type UserChangePasswordMutationResult = NonNullable<
  Awaited<ReturnType<typeof userChangePassword>>
>;
export type UserChangePasswordMutationBody = ChangePasswordModel;
export type UserChangePasswordMutationError = Error;

export const useUserChangePassword = <
  TError = Error,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof userChangePassword>>,
    TError,
    { data: ChangePasswordModel },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof userChangePassword>>,
  TError,
  { data: ChangePasswordModel },
  TContext
> => {
  const mutationOptions = getUserChangePasswordMutationOptions(options);

  return useMutation(mutationOptions);
};

export const usersList = (organizationId: string, signal?: AbortSignal) => {
  return authAxiosInstance<ListOfOrganizationUser>({
    url: `/organizations/${organizationId}/users`,
    method: "GET",
    signal
  });
};

export const getUsersListQueryKey = (organizationId: string) => {
  return [`/organizations/${organizationId}/users`] as const;
};

export const getUsersListQueryOptions = <
  TData = Awaited<ReturnType<typeof usersList>>,
  TError = unknown
>(
  organizationId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof usersList>>,
      TError,
      TData
    >;
  }
) => {
  const { query: queryOptions } = options ?? {};

  const queryKey =
    queryOptions?.queryKey ?? getUsersListQueryKey(organizationId);

  const queryFn: QueryFunction<Awaited<ReturnType<typeof usersList>>> = ({
    signal
  }) => usersList(organizationId, signal);

  return {
    queryKey,
    queryFn,
    enabled: !!organizationId,
    ...queryOptions
  } as UseQueryOptions<Awaited<ReturnType<typeof usersList>>, TError, TData> & {
    queryKey: QueryKey;
  };
};

export type UsersListQueryResult = NonNullable<
  Awaited<ReturnType<typeof usersList>>
>;
export type UsersListQueryError = unknown;

export const useUsersList = <
  TData = Awaited<ReturnType<typeof usersList>>,
  TError = unknown
>(
  organizationId: string,
  options?: {
    query?: UseQueryOptions<
      Awaited<ReturnType<typeof usersList>>,
      TError,
      TData
    >;
  }
): UseQueryResult<TData, TError> & { queryKey: QueryKey } => {
  const queryOptions = getUsersListQueryOptions(organizationId, options);

  const query = useQuery(queryOptions) as UseQueryResult<TData, TError> & {
    queryKey: QueryKey;
  };

  query.queryKey = queryOptions.queryKey;

  return query;
};

export const usersCreate = (
  organizationId: string,
  createOrganizationUser: CreateOrganizationUser
) => {
  return authAxiosInstance<void>({
    url: `/organizations/${organizationId}/users`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: createOrganizationUser
  });
};

export const getUsersCreateMutationOptions = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof usersCreate>>,
    TError,
    { organizationId: string; data: CreateOrganizationUser },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof usersCreate>>,
  TError,
  { organizationId: string; data: CreateOrganizationUser },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof usersCreate>>,
    { organizationId: string; data: CreateOrganizationUser }
  > = (props) => {
    const { organizationId, data } = props ?? {};

    return usersCreate(organizationId, data);
  };

  return { mutationFn, ...mutationOptions };
};

export type UsersCreateMutationResult = NonNullable<
  Awaited<ReturnType<typeof usersCreate>>
>;
export type UsersCreateMutationBody = CreateOrganizationUser;
export type UsersCreateMutationError = Error | ProblemDetails;

export const useUsersCreate = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof usersCreate>>,
    TError,
    { organizationId: string; data: CreateOrganizationUser },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof usersCreate>>,
  TError,
  { organizationId: string; data: CreateOrganizationUser },
  TContext
> => {
  const mutationOptions = getUsersCreateMutationOptions(options);

  return useMutation(mutationOptions);
};

export const usersUpdate = (
  organizationId: string,
  userId: string,
  updateOrganizationUser: UpdateOrganizationUser
) => {
  return authAxiosInstance<void>({
    url: `/organizations/${organizationId}/users/${userId}`,
    method: "POST",
    headers: { "Content-Type": "application/json" },
    data: updateOrganizationUser
  });
};

export const getUsersUpdateMutationOptions = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof usersUpdate>>,
    TError,
    { organizationId: string; userId: string; data: UpdateOrganizationUser },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof usersUpdate>>,
  TError,
  { organizationId: string; userId: string; data: UpdateOrganizationUser },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof usersUpdate>>,
    { organizationId: string; userId: string; data: UpdateOrganizationUser }
  > = (props) => {
    const { organizationId, userId, data } = props ?? {};

    return usersUpdate(organizationId, userId, data);
  };

  return { mutationFn, ...mutationOptions };
};

export type UsersUpdateMutationResult = NonNullable<
  Awaited<ReturnType<typeof usersUpdate>>
>;
export type UsersUpdateMutationBody = UpdateOrganizationUser;
export type UsersUpdateMutationError = Error | ProblemDetails;

export const useUsersUpdate = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof usersUpdate>>,
    TError,
    { organizationId: string; userId: string; data: UpdateOrganizationUser },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof usersUpdate>>,
  TError,
  { organizationId: string; userId: string; data: UpdateOrganizationUser },
  TContext
> => {
  const mutationOptions = getUsersUpdateMutationOptions(options);

  return useMutation(mutationOptions);
};

export const usersDelete = (organizationId: string, userId: string) => {
  return authAxiosInstance<void>({
    url: `/organizations/${organizationId}/users/${userId}`,
    method: "DELETE"
  });
};

export const getUsersDeleteMutationOptions = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof usersDelete>>,
    TError,
    { organizationId: string; userId: string },
    TContext
  >;
}): UseMutationOptions<
  Awaited<ReturnType<typeof usersDelete>>,
  TError,
  { organizationId: string; userId: string },
  TContext
> => {
  const { mutation: mutationOptions } = options ?? {};

  const mutationFn: MutationFunction<
    Awaited<ReturnType<typeof usersDelete>>,
    { organizationId: string; userId: string }
  > = (props) => {
    const { organizationId, userId } = props ?? {};

    return usersDelete(organizationId, userId);
  };

  return { mutationFn, ...mutationOptions };
};

export type UsersDeleteMutationResult = NonNullable<
  Awaited<ReturnType<typeof usersDelete>>
>;

export type UsersDeleteMutationError = Error | ProblemDetails;

export const useUsersDelete = <
  TError = Error | ProblemDetails,
  TContext = unknown
>(options?: {
  mutation?: UseMutationOptions<
    Awaited<ReturnType<typeof usersDelete>>,
    TError,
    { organizationId: string; userId: string },
    TContext
  >;
}): UseMutationResult<
  Awaited<ReturnType<typeof usersDelete>>,
  TError,
  { organizationId: string; userId: string },
  TContext
> => {
  const mutationOptions = getUsersDeleteMutationOptions(options);

  return useMutation(mutationOptions);
};
