using System.Collections.Generic;
using System.Linq;

namespace Navtrack.Listener.Protocols.Galileosky;

public static class GalileoskyProtocolTags
{
    public static int? GetTagLength(byte tag)
    {
        foreach (KeyValuePair<int, IEnumerable<byte>> pair in TagDictionary.Where(pair =>
                     pair.Value.Any(x => tag == x)))
        {
            return pair.Key;
        }

        return null;
    }

    // Key: Tag length (number of bytes)
    // Value: List of tags
    private static readonly Dictionary<int, IEnumerable<byte>> TagDictionary = new()
    {
        {
            1,
            new byte[]
            {
                0x01, 0x02, 0x35, 0x43, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
                0xD0, 0xD1, 0xD2, 0xD5, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6,
                0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF
            }
        },
        {
            2,
            new byte[]
            {
                0x04, 0x10, 0x34, 0x40, 0x41, 0x42, 0x45, 0x46, 0x50, 0x51, 0x52, 0x53, 0x58, 0x59, 0x70, 0x71,
                0x72, 0x73, 0x74, 0x75, 0x76, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0x54, 0x55, 0x56, 0x57, 0x60, 0x61, 
                0x62, 0x78, 0x79, 0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0x77
            }
        },
        {
            3,
            new byte[]
            {
                0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A,
                0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x5D
            }
        },
        {
            4,
            new byte[]
            {
                0x20, 0x33, 0x44, 0x90, 0xC0, 0xC1, 0xC2, 0xC3, 0xD3, 0xD4, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF, 0xF0,
                0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0x5A, 0x47, 0xE2, 0xE9, 0xE0
            }
        },
        {7, new byte[] {0x5B}},
        {9, new byte[] {0x30}},

        {15, new byte[] {0x03}},
        {68, new byte[] {0x5C}}
    };
}